/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.websphere.sdo.mediator.jdbc.metadata.Column;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Key;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Relationship;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.impl.MetadataImpl;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.sdo.EChangeSummarySetting;

public class ValueMapper {
    private DataObject dataObject;
    private Metadata metadata;
    private EClass eClass;

    public ValueMapper(Metadata metadata2, DataObject dataObject) {
        this.metadata = metadata2;
        this.dataObject = dataObject;
        this.eClass = ((EObject)dataObject).eClass();
    }

    public Map fieldValues() {
        EList eList = this.eClass.getEAllAttributes();
        Iterator iterator = eList.iterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            EAttribute eAttribute = (EAttribute)iterator.next();
            String string = eAttribute.getName();
            Object object = this.valueForFieldName(string);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public Map residentFieldValues() {
        EList eList = this.eClass.getEAllAttributes();
        Iterator iterator = eList.iterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            EAttribute eAttribute = (EAttribute)iterator.next();
            String string = eAttribute.getName();
            Object object = this.valueForFieldName(string);
            if (object == null) {
                object = this.dataObject.get(string);
            }
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private Object valueForFieldName(String string) {
        if (this.isFKField(string)) {
            if (this.metadata.useForeignKeyFields()) {
                Column column = this.getFKColumn(string);
                if (column != null && this.isReferenceChanged(column)) {
                    return this.valueForFKFieldName(string);
                }
            } else {
                return this.valueForFKFieldName(string);
            }
        }
        return this.dataObject.get(string);
    }

    private Column getFKColumn(String string) {
        Table table = this.metadata.getTableByPropertyName(this.eClass.getName());
        Iterator iterator = table.getForeignKeys().iterator();
        while (iterator.hasNext()) {
            Key key = (Key)iterator.next();
            Iterator iterator2 = key.getColumns().iterator();
            while (iterator2.hasNext()) {
                Column column = (Column)iterator2.next();
                if (!string.equals(column.getPropertyName())) continue;
                return column;
            }
        }
        return null;
    }

    public boolean isReferenceChanged(Column column) {
        if (this.dataObject.getDataGraph() != null) {
            List list = this.dataObject.getDataGraph().getChangeSummary().getOldValues(this.dataObject);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EChangeSummarySetting eChangeSummarySetting = (EChangeSummarySetting)iterator.next();
                if (!this.isReferenceChange(eChangeSummarySetting, column)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isReferenceChange(EChangeSummarySetting eChangeSummarySetting, Column column) {
        EReference eReference = null;
        if (eChangeSummarySetting.getFeature() instanceof EAttribute) {
            return false;
        }
        eReference = (EReference)eChangeSummarySetting.getFeature();
        MetadataImpl metadataImpl = (MetadataImpl)this.metadata;
        Relationship relationship = metadataImpl.getRelationship(eReference);
        Iterator iterator = relationship.getChildKey().getColumns().iterator();
        while (iterator.hasNext()) {
            if (!column.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private Object valueForFKFieldName(String string) {
        DataObject dataObject = this.getParent(string);
        if (dataObject == null) {
            return null;
        }
        String string2 = this.getRelatedParentFieldName(string);
        return dataObject.get(string2);
    }

    private boolean isFKField(String string) {
        Table table = this.metadata.getTableByPropertyName(this.eClass.getName());
        Iterator iterator = table.getForeignKeys().iterator();
        while (iterator.hasNext()) {
            Key key = (Key)iterator.next();
            Iterator iterator2 = key.getColumns().iterator();
            while (iterator2.hasNext()) {
                Column column = (Column)iterator2.next();
                if (!string.equals(column.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    private DataObject getParent(String string) {
        Key key = this.getFK(string);
        Relationship relationship = this.getRelationship(key);
        String string2 = relationship.getOppositeName();
        return (DataObject)this.dataObject.get(string2);
    }

    private Relationship getRelationship(Key key) {
        Iterator iterator = this.metadata.getRelationships().iterator();
        while (iterator.hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            if (!relationship.getChildKey().equals(key)) continue;
            return relationship;
        }
        return null;
    }

    private Key getFK(String string) {
        Table table = this.metadata.getTableByPropertyName(this.eClass.getName());
        Iterator iterator = table.getForeignKeys().iterator();
        while (iterator.hasNext()) {
            Key key = (Key)iterator.next();
            Iterator iterator2 = key.getColumns().iterator();
            while (iterator2.hasNext()) {
                Column column = (Column)iterator2.next();
                if (!string.equals(column.getPropertyName())) continue;
                return key;
            }
        }
        return null;
    }

    private String getRelatedParentFieldName(String string) {
        Key key = this.getFK(string);
        Relationship relationship = this.getRelationship(key);
        Key key2 = relationship.getParentKey();
        Iterator iterator = key.getColumns().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (column.getPropertyName().equals(string)) {
                return ((Column)key2.getColumns().get(n)).getPropertyName();
            }
            ++n;
        }
        return null;
    }
}

