/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.PredicateWithVariables;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlStatementWithSingleTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlStatementWithWhereClause;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableName;
import java.util.ArrayList;
import java.util.List;

public abstract class WriteQueryBuilder
extends QueryBuilder {
    private RDBTable fTable;
    private List fPredicateColumns;

    public WriteQueryBuilder(RDBTable rDBTable) {
        this.setTable(rDBTable);
    }

    public void addOidFilter() throws QueryEngineException {
        PredicateWithVariables predicateWithVariables = this.newSearchCondition();
        predicateWithVariables.createEquiFilter(this.key());
        ((SqlStatementWithWhereClause)((Object)this.statement())).and(predicateWithVariables);
    }

    public void addPredicateFilter() throws QueryEngineException {
        if (this.predicateColumns().isEmpty()) {
            return;
        }
        PredicateWithVariables predicateWithVariables = this.newSearchCondition();
        predicateWithVariables.createEquiFilter(this.predicateColumns());
        ((SqlStatementWithWhereClause)((Object)this.statement())).and(predicateWithVariables);
    }

    public String[] getPredicateColumnNames() {
        int n = this.predicateColumns().size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            ColumnName columnName = new ColumnName((RDBColumn)this.predicateColumns().get(i));
            columnName.doNotQualify();
            stringArray[i] = columnName.evaluate();
        }
        return stringArray;
    }

    public boolean isOverqualified() {
        return !this.predicateColumns().isEmpty();
    }

    public boolean isWriteQuery() {
        return true;
    }

    public List key() {
        return this.getTable().getPrimaryKey().getMembers();
    }

    public List predicateColumns() {
        if (this.fPredicateColumns == null) {
            this.fPredicateColumns = new ArrayList();
        }
        return this.fPredicateColumns;
    }

    public void predicateColumns(List list) {
        this.fPredicateColumns = list;
    }

    public boolean references(RDBTable rDBTable) throws QueryEngineException {
        return this.table().equals(rDBTable);
    }

    public boolean references(TableName tableName) throws QueryEngineException {
        return this.references(tableName.table());
    }

    public void reset() {
        super.reset();
    }

    public TableName table() throws QueryEngineException {
        if (this.isInitialized()) {
            return ((SqlStatementWithSingleTable)((Object)this.statement())).table();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append("(");
        if (this.getTable() != null) {
            stringBuffer.append(this.getTable().getWDOTable().getName());
        } else {
            stringBuffer.append("<no tableName>");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public RDBTable getTable() {
        return this.fTable;
    }

    public void setTable(RDBTable rDBTable) {
        this.fTable = rDBTable;
    }
}

