/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.schema;

import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Column;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Relationship;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBEntity;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBReferenceByKey;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RDBSchema
extends RDBEntity {
    public static final char NL = '\n';
    private List fTables;
    private List fForeignKeys;
    private RDBTable fRoot;
    private RDBTable fUniqueKeyTable;

    public RDBSchema(Metadata metadata2) {
        this.initializeTables((List)metadata2.getTables());
        this.initializeFKs((List)metadata2.getRelationships());
        this.root(this.findTable(metadata2.getRootTable()));
        if (metadata2.getUniqueKeyTable() != null) {
            this.uniqueKeyTable(new RDBTable(metadata2.getUniqueKeyTable()));
        }
    }

    public List getTables() {
        if (this.fTables == null) {
            this.fTables = new ArrayList();
        }
        return this.fTables;
    }

    public List getNonexternalTables() {
        Iterator iterator = this.getTables().iterator();
        ArrayList<RDBTable> arrayList = new ArrayList<RDBTable>();
        while (iterator.hasNext()) {
            RDBTable rDBTable = (RDBTable)iterator.next();
            if (rDBTable.getWDOTable().isExternal()) continue;
            arrayList.add(rDBTable);
        }
        return arrayList;
    }

    public void add(RDBTable rDBTable) {
        this.getTables().add(rDBTable);
    }

    public void add(RDBReferenceByKey rDBReferenceByKey) {
        this.getForeignKeys().add(rDBReferenceByKey);
    }

    public void initializeTables(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.add(new RDBTable((Table)iterator.next()));
        }
    }

    public void initializeFKs(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            RDBTable rDBTable = this.findTable(relationship.getChildKey().getTable());
            RDBTable rDBTable2 = this.findTable(relationship.getParentKey().getTable());
            RDBReferenceByKey rDBReferenceByKey = new RDBReferenceByKey(relationship, rDBTable2, rDBTable);
            rDBTable.add(rDBReferenceByKey);
            rDBTable2.add(rDBReferenceByKey);
        }
    }

    public String getName() {
        return "<none>";
    }

    public RDBTable findTable(Table table) {
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            RDBTable rDBTable = (RDBTable)iterator.next();
            if (!rDBTable.getName().equals(table.getName())) continue;
            return rDBTable;
        }
        return null;
    }

    public RDBTable findTableByName(String string) {
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            RDBTable rDBTable = (RDBTable)iterator.next();
            if (!rDBTable.getWDOTable().getPropertyName().equalsIgnoreCase(string)) continue;
            return rDBTable;
        }
        return null;
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        Iterator iterator = this.getTables().iterator();
        stringBuffer.append(ClassShortName.name(this));
        while (iterator.hasNext()) {
            stringBuffer.append(((RDBTable)iterator.next()).getName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }

    public String schemaInfoString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Schema - ").append(this.getName()).append('\n');
        this.schemaInfoStringOn(stringBuffer, this.getTables());
        return stringBuffer.toString();
    }

    public void schemaInfoStringOn(StringBuffer stringBuffer) {
        stringBuffer.append("Database type - ").append(QueryEngineInfo.singleton().targetDatabase()).append('\n').append('\n');
        stringBuffer.append("Schema - ").append(this.getName()).append('\n');
        Iterator iterator = this.getTables().iterator();
        TableInfo tableInfo = new TableInfo();
        while (iterator.hasNext()) {
            tableInfo.table((RDBTable)iterator.next());
            tableInfo.infoStringOn(stringBuffer);
            stringBuffer.append('\n');
        }
    }

    public void schemaInfoStringOn(StringBuffer stringBuffer, List list) {
        Iterator iterator = list.iterator();
        TableInfo tableInfo = new TableInfo();
        while (iterator.hasNext()) {
            tableInfo.table((RDBTable)iterator.next());
            tableInfo.infoStringOn(stringBuffer);
            stringBuffer.append('\n');
        }
    }

    public RDBColumn findColumn(Column column) {
        return this.findTable(column.getTable()).findColumn(column);
    }

    public List getForeignKeys() {
        if (this.fForeignKeys == null) {
            this.fForeignKeys = new ArrayList();
        }
        return this.fForeignKeys;
    }

    public List foreignKeyReferences(RDBTable rDBTable) {
        ArrayList<RDBReferenceByKey> arrayList = new ArrayList<RDBReferenceByKey>();
        Iterator iterator = this.getForeignKeys().iterator();
        while (iterator.hasNext()) {
            RDBReferenceByKey rDBReferenceByKey = (RDBReferenceByKey)iterator.next();
            if (!rDBReferenceByKey.references(rDBTable)) continue;
            arrayList.add(rDBReferenceByKey);
        }
        return arrayList;
    }

    public RDBTable root() {
        return this.fRoot;
    }

    public void root(RDBTable rDBTable) {
        this.fRoot = rDBTable;
    }

    public void uniqueKeyTable(RDBTable rDBTable) {
        this.fUniqueKeyTable = rDBTable;
    }

    public RDBTable uniqueKeyTable() {
        return this.fUniqueKeyTable;
    }

    public boolean hasUniqueKeyTable() {
        return this.fUniqueKeyTable != null;
    }

    public boolean isSingleTable() {
        return this.getTables().size() == 1;
    }

    public List getNonRootTables() {
        List list = this.getNonexternalTables();
        list.remove(this.root());
        return list;
    }
}

