/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBPredefinedType;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Expression;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Function;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.OrderByClause;
import java.util.Iterator;
import java.util.List;

public class DenseRankFunction
extends Function {
    private static final long serialVersionUID = 931470745099805313L;
    public static final String NAME = "DENSE_RANK";
    public static final String OVER = " OVER (";
    private OrderByClause fOrderByClause;

    public DenseRankFunction() {
        super(NAME);
    }

    public DenseRankFunction(List list) {
        super(NAME);
        this.orderByAll(list);
    }

    public OrderByClause orderBy() {
        return this.fOrderByClause;
    }

    public List children() {
        return this.orderBy().children();
    }

    public void orderBy(Expression expression) {
        this.orderBy(expression, true);
    }

    public void orderBy(Expression expression, boolean bl) {
        this.addOrderByClause();
        this.orderBy().add(expression, bl);
    }

    public void orderBy(Association association) {
        this.orderBy((Expression)association.key(), (Boolean)association.value());
    }

    public void addOrderByClause() {
        if (this.fOrderByClause == null) {
            this.fOrderByClause = new OrderByClause();
        }
    }

    public boolean hasOrderBy() {
        return this.fOrderByClause != null;
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        super.evaluateOn(stringBuffer);
        if (this.hasOrderBy()) {
            stringBuffer.append(OVER);
            this.orderBy().evaluateOn(stringBuffer);
            stringBuffer.append(")");
        }
    }

    public void orderByAll(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.orderBy((Association)iterator.next());
        }
    }

    public RDBPredefinedType defaultType() {
        return new RDBPredefinedType(6);
    }
}

