/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.BooleanFunction;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractNegatablePredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.BasicPredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Expression;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ExpressionList;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.FullSelect;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Variable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InPredicate
extends AbstractNegatablePredicate {
    private static final long serialVersionUID = 5152862629231884575L;
    private ExpressionList leftExprList = new ExpressionList();
    private ExpressionList rightExprList = new ExpressionList();

    public InPredicate() {
    }

    public InPredicate(Expression expression, Expression expression2) {
        this.lhsAdd(expression);
        this.rhsAdd(expression2);
    }

    public InPredicate(Expression expression, FullSelect fullSelect) {
        this.lhsAdd(expression);
        this.rhsAdd(fullSelect);
    }

    public InPredicate(Expression expression, List list) {
        this.lhsAdd(expression);
        this.rhsAddAll(list);
    }

    public List children() {
        ArrayList<ExpressionList> arrayList = new ArrayList<ExpressionList>();
        arrayList.add(this.rightHandSide());
        arrayList.add(this.leftHandSide());
        return arrayList;
    }

    public void evaluateAsOrOn(StringBuffer stringBuffer) {
        BasicPredicate.equality(this.leftHandSide().first(), this.rightHandSide().first()).evaluateOn(stringBuffer);
    }

    public void evaluateListOn(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).evaluateOn(stringBuffer);
            if (!iterator.hasNext()) continue;
            if (this.useExtraSpaces()) {
                stringBuffer.append(", ");
                continue;
            }
            stringBuffer.append(",");
        }
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.isEquality()) {
            this.evaluateAsOrOn(stringBuffer);
            return;
        }
        if (this.leftHandSide().size() == 1) {
            this.leftHandSide().evaluateListOnNoParens(stringBuffer);
        } else {
            this.leftHandSide().evaluateOn(stringBuffer);
        }
        if (this.isNot()) {
            stringBuffer.append(" NOT");
        }
        stringBuffer.append(" IN ");
        this.rightHandSide().evaluateOn(stringBuffer);
    }

    public void gatherVariableColumnsInOrderOn(List list) {
        if (this.leftHandSide().size() == 1 && this.isRhsAllVariables()) {
            list.add(this.leftHandSide().first());
        }
    }

    public void gatherVariablesInOrderOn(List list) {
        this.leftHandSide().gatherVariablesInOrderOn(list);
        this.rightHandSide().gatherVariablesInOrderOn(list);
    }

    public boolean isEmpty() {
        return this.leftExprList == null && this.rightExprList == null;
    }

    public boolean isEquality() {
        return this.leftHandSide().size() == 1 && this.rightHandSide().size() == 1 && !(this.rightHandSide().first() instanceof FullSelect);
    }

    public boolean isLhsAllColumns() {
        BooleanFunction booleanFunction = new BooleanFunction(){

            public boolean value(Object object) {
                return object instanceof Expression;
            }
        };
        return this.leftHandSide().conform(booleanFunction);
    }

    public boolean isRhsAllVariables() {
        BooleanFunction booleanFunction = new BooleanFunction(){

            public boolean value(Object object) {
                return object instanceof Variable;
            }
        };
        return this.rightHandSide().conform(booleanFunction);
    }

    public ExpressionList leftHandSide() {
        return this.leftExprList;
    }

    public void lhsAdd(Expression expression) {
        this.leftHandSide().add(expression);
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        if (this.isNot()) {
            stringBuffer.append("not ");
        }
        stringBuffer.append("in");
    }

    public void rhsAdd(Expression expression) {
        this.rightHandSide().add(expression);
    }

    public void rhsAdd(FullSelect fullSelect) {
        this.rightHandSide().add(fullSelect);
    }

    public void rhsAddAll(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Expression expression = e2 instanceof Expression ? (Expression)e2 : this.asLiteral(e2);
            this.rhsAdd(expression);
        }
    }

    public ExpressionList rightHandSide() {
        return this.rightExprList;
    }
}

