/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.IteratorWithIndex;
import com.ibm.ObjectQuery.crud.util.MultiIterator;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ObjectQuery.crud.util.TreeNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.JoinMap;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.Connection;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractLiteral;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractPredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.BasicPredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.BetweenPredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Expression;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Function;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.InPredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Variable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PredicateWithVariables
extends AbstractPredicate {
    private static final long serialVersionUID = 2634715397887205543L;
    private Predicate fPredicate;

    public PredicateWithVariables() {
    }

    public PredicateWithVariables(Predicate predicate) {
        this.predicate(predicate);
    }

    public Predicate and(Predicate predicate) {
        if (predicate instanceof PredicateWithVariables) {
            return this.and((PredicateWithVariables)predicate);
        }
        if (this.predicate() == null) {
            this.predicate(predicate);
        } else {
            this.predicate(this.predicate().and(predicate));
        }
        return this;
    }

    public Predicate and(PredicateWithVariables predicateWithVariables) {
        this.and(predicateWithVariables.predicate());
        return this;
    }

    public Predicate andInPredicate(RDBColumn rDBColumn) {
        if (this.predicate() == null) {
            this.predicate(this.createInPredicate(this.asColumnName(rDBColumn)));
        } else {
            this.predicate(this.predicate().and(this.createInPredicate(this.asColumnName(rDBColumn))));
        }
        return this;
    }

    public Predicate andInPredicate(RDBColumn rDBColumn, List list) {
        if (this.predicate() == null) {
            this.predicate(this.createInPredicate(this.asColumnName(rDBColumn), list));
        } else {
            this.predicate(this.predicate().and(this.createInPredicate(this.asColumnName(rDBColumn), list)));
        }
        return this;
    }

    public List children() {
        if (this.predicate() == null) {
            return new ArrayList();
        }
        return this.predicate().children();
    }

    private void createConjunctiveTree(List list) {
        Predicate predicate = null;
        IteratorWithIndex iteratorWithIndex = new IteratorWithIndex(list);
        while (iteratorWithIndex.hasNext()) {
            if (iteratorWithIndex.isFirst()) {
                predicate = (Predicate)iteratorWithIndex.next();
                continue;
            }
            predicate = predicate.and((Predicate)iteratorWithIndex.next());
        }
        this.predicate(predicate);
    }

    private List createEqualityPredicates(List list) {
        ArrayList<BasicPredicate> arrayList = new ArrayList<BasicPredicate>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            ColumnName columnName = (ColumnName)this.asLiteral(rDBColumn);
            BasicPredicate basicPredicate = (BasicPredicate)this.newEqualityPredicate(columnName, new Variable());
            arrayList.add(basicPredicate);
        }
        return arrayList;
    }

    private List createEqualityPredicates(List list, List list2) {
        MultiIterator multiIterator = new MultiIterator(list, list2);
        ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
        while (multiIterator.hasNext()) {
            Object[] objectArray = (Object[])multiIterator.next();
            arrayList.add(this.newEqualityPredicate(this.asLiteral(objectArray[0]), this.asLiteral(objectArray[1])));
        }
        return arrayList;
    }

    public void createEquiFilter(RDBColumn rDBColumn) {
        ArrayList<RDBColumn> arrayList = new ArrayList<RDBColumn>();
        arrayList.add(rDBColumn);
        this.createEquiFilter(arrayList);
    }

    public void createEquiFilter(ColumnName columnName, Object object) {
        ArrayList<ColumnName> arrayList = new ArrayList<ColumnName>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList.add(columnName);
        arrayList2.add(object);
        this.createEquiFilter(arrayList, arrayList2);
    }

    public void createEquiFilter(List list) {
        this.createConjunctiveTree(this.createEqualityPredicates(list));
    }

    public void createEquiFilter(List list, List list2) {
        this.createConjunctiveTree(this.createEqualityPredicates(list, list2));
    }

    private void createEquiFilterFrom(List list) {
        this.createConjunctiveTree(this.createEqualityPredicates(list));
    }

    public void createEquiJoinFilter(JoinMap joinMap) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((TreeNode)((Object)joinMap)).iterator();
        while (iterator.hasNext()) {
            JoinMap joinMap2 = (JoinMap)iterator.next();
            if (joinMap2.isRoot()) continue;
            arrayList.addAll(this.createEqualityPredicates(joinMap2.parentSideJoinColumns(), joinMap2.childSideJoinColumns()));
        }
        this.createConjunctiveTree(arrayList);
    }

    public void createEquiJoinFilter(Connection connection) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.createEqualityPredicates(connection.parentKeyColumns(), connection.memberKeyColumns()));
        this.createConjunctiveTree(arrayList);
    }

    public void createEquiJoinFilter(List list) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            arrayList.addAll(connection.parentKeyColumns());
            arrayList2.addAll(connection.memberKeyColumns());
        }
        this.createEquiFilter(arrayList, arrayList2);
    }

    public void createEquiJoinFilterOnPath(JoinMap joinMap) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((TreeNode)((Object)joinMap)).withAncestors().iterator();
        while (iterator.hasNext()) {
            JoinMap joinMap2 = (JoinMap)iterator.next();
            if (joinMap2.isRoot()) continue;
            arrayList.addAll(this.createEqualityPredicates(joinMap2.parentSideJoinColumns(), joinMap2.childSideJoinColumns()));
        }
        this.createConjunctiveTree(arrayList);
    }

    public void createInFilter(RDBColumn rDBColumn) {
        this.createInFilter(this.asColumnName(rDBColumn));
    }

    public void createInFilter(RDBColumn rDBColumn, List list) {
        this.predicate(this.createInPredicate(rDBColumn, list));
    }

    public void createInFilter(ColumnName columnName) {
        this.predicate(this.createInPredicate(columnName));
    }

    public void createInFilter(ColumnName columnName, List list) {
        this.predicate(this.createInPredicate(columnName, list));
    }

    public void createInFilter(List list) {
        this.createConjunctiveTree(this.createInPredicate(list));
    }

    public void createInFilter(List list, List list2) {
        this.createConjunctiveTree(this.createInPredicate(list, list2));
    }

    private Predicate createInPredicate(RDBColumn rDBColumn, List list) {
        return new InPredicate((Expression)((ColumnName)this.asLiteral(rDBColumn)), list);
    }

    private Predicate createInPredicate(ColumnName columnName) {
        Variable variable = new Variable();
        Predicate predicate = this.newInPredicate(columnName, variable);
        return predicate;
    }

    private Predicate createInPredicate(ColumnName columnName, List list) {
        return new InPredicate((Expression)columnName, list);
    }

    private List createInPredicate(List list) {
        ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ColumnName columnName = (ColumnName)this.asLiteral(iterator.next());
            arrayList.add(this.createInPredicate(columnName));
        }
        return arrayList;
    }

    private List createInPredicate(List list, List list2) {
        MultiIterator multiIterator = new MultiIterator(list, list2);
        ArrayList<InPredicate> arrayList = new ArrayList<InPredicate>();
        while (multiIterator.hasNext()) {
            Object[] objectArray = (Object[])multiIterator.next();
            arrayList.add(new InPredicate((Expression)((ColumnName)this.asLiteral(objectArray[0])), (List)objectArray[1]));
        }
        return arrayList;
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.predicate() == null) {
            return;
        }
        this.predicate().evaluateOn(stringBuffer);
    }

    public void evaluateOn(StringBuffer stringBuffer, List list) {
        if (this.predicate() == null) {
            return;
        }
        this.predicate().evaluateOn(stringBuffer);
    }

    public PredicateWithVariables expressionForTable(TableName tableName) {
        return this;
    }

    public void gatherVariableColumnsInOrderOn(List list) {
        if (this.predicate() != null) {
            this.predicate().gatherVariableColumnsInOrderOn(list);
        }
    }

    public void gatherVariablesInOrderOn(List list) {
        if (this.predicate() != null) {
            this.predicate().gatherVariablesInOrderOn(list);
        }
    }

    public boolean isEmpty() {
        return this.fPredicate == null;
    }

    private Predicate newEqualityPredicate(RDBColumn rDBColumn, RDBColumn rDBColumn2) {
        return BasicPredicate.equality(this.asColumnName(rDBColumn), this.asColumnName(rDBColumn2));
    }

    private Predicate newEqualityPredicate(RDBColumn rDBColumn, Function function) {
        return BasicPredicate.equality(this.asColumnName(rDBColumn), function);
    }

    private Predicate newEqualityPredicate(RDBColumn rDBColumn, Variable variable) {
        return BasicPredicate.equality(this.asColumnName(rDBColumn), variable);
    }

    private Predicate newEqualityPredicate(AbstractLiteral abstractLiteral, AbstractLiteral abstractLiteral2) {
        return BasicPredicate.equality(abstractLiteral, abstractLiteral2);
    }

    private Predicate newEqualityPredicate(ColumnName columnName, ColumnName columnName2) {
        return BasicPredicate.equality(columnName, columnName2);
    }

    private Predicate newEqualityPredicate(ColumnName columnName, Variable variable) {
        return BasicPredicate.equality(columnName, variable);
    }

    private Predicate newInPredicate(RDBColumn rDBColumn, Variable variable) {
        return new InPredicate((Expression)((ColumnName)this.asLiteral(rDBColumn)), variable);
    }

    private Predicate newInPredicate(RDBColumn rDBColumn, List list) {
        return this.newInPredicate(this.asColumnName(rDBColumn), list);
    }

    private Predicate newInPredicate(ColumnName columnName, Variable variable) {
        return new InPredicate((Expression)columnName, variable);
    }

    private Predicate newInPredicate(ColumnName columnName, List list) {
        return new InPredicate((Expression)columnName, list);
    }

    public Predicate not() {
        if (this.predicate() != null) {
            this.predicate(this.predicate().not());
        }
        return this;
    }

    public Predicate or(Predicate predicate) {
        if (this.predicate() == null) {
            this.predicate(predicate);
        } else {
            this.predicate(this.predicate().or(predicate));
        }
        return this;
    }

    public Predicate or(PredicateWithVariables predicateWithVariables) {
        if (this.predicate() == null) {
            this.predicate(predicateWithVariables.predicate());
        } else {
            this.predicate(this.predicate().or(predicateWithVariables.predicate()));
        }
        return this;
    }

    public Predicate predicate() {
        return this.fPredicate;
    }

    public void predicate(Predicate predicate) {
        this.fPredicate = predicate;
    }

    public List tables() {
        Iterator iterator = this.gatherColumns().iterator();
        StSet stSet = new StSet();
        while (iterator.hasNext()) {
            stSet.addNonNull(((ColumnName)iterator.next()).table());
        }
        return stSet.asList();
    }

    public int predicateSize() {
        return this.gatherColumnsInOrder().size();
    }

    public Predicate createBetweenPredicate(Expression expression) {
        Variable variable = new Variable();
        Variable variable2 = new Variable();
        BetweenPredicate betweenPredicate = new BetweenPredicate(expression, variable, variable2);
        return betweenPredicate;
    }

    public void createBetweenFilter(Expression expression) {
        this.predicate(this.createBetweenPredicate(expression));
    }
}

