/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.MultiIterator;
import com.ibm.ObjectQuery.crud.util.UnderConstruction;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractNullCastSpec;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractSqlStatementClause;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.CorrelationAliasTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.FullOrSubSelect;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ResultSetElement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ResultSetExpression;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableReference;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Variable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SelectClause
extends AbstractSqlStatementClause {
    private static final long serialVersionUID = -345754780600955076L;
    public static final String DISTINCT = "DISTINCT ";
    public static final String STAR = "*";
    public static final String INTO = " INTO ";
    public static final String C = "C";
    private List fHostVariables;
    private boolean fIntoFlag = false;
    private boolean distinctFlag = false;
    private List fResultSet;
    private FullOrSubSelect fParentStatement;
    private List fArgNamesAndColumns;

    public SelectClause(FullOrSubSelect fullOrSubSelect) {
        this.parent(fullOrSubSelect);
    }

    public SelectClause(FullOrSubSelect fullOrSubSelect, List list) {
        this.parent(fullOrSubSelect);
        this.addColumns(list);
    }

    public FullOrSubSelect parent() {
        return this.fParentStatement;
    }

    public void parent(FullOrSubSelect fullOrSubSelect) {
        this.fParentStatement = fullOrSubSelect;
    }

    public void addColumn(RDBColumn rDBColumn) {
        this.addColumn(new ColumnName(rDBColumn));
    }

    public void addColumn(ColumnName columnName) {
        this.getResultSetElements().add(columnName);
        if (this.isSelectInto()) {
            this.hostVariables().add(new Variable());
        }
    }

    public void addColumn(ResultSetElement resultSetElement) {
        this.getResultSetElements().add(resultSetElement);
        if (this.isSelectInto()) {
            this.hostVariables().add(new Variable());
        }
    }

    public void addColumn(ResultSetExpression resultSetExpression) {
        this.getResultSetElements().add(resultSetExpression);
        if (this.isSelectInto()) {
            this.hostVariables().add(new Variable());
        }
    }

    public void addColumnFirst(ResultSetElement resultSetElement) {
        ArrayList<ResultSetElement> arrayList = new ArrayList<ResultSetElement>();
        arrayList.add(resultSetElement);
        arrayList.addAll(this.getResultSetElements());
        this.setResultSet(arrayList);
        if (this.isSelectInto()) {
            this.hostVariables().add(new Variable());
        }
    }

    public void addColumns(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addColumn((ColumnName)this.asLiteral(iterator.next()));
        }
    }

    public void addColumns(TableReference tableReference) {
        throw new UnderConstruction();
    }

    public List children() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getResultSetElements().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public void distinct() {
        this.distinctFlag = true;
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.isDistinct()) {
            stringBuffer.append(DISTINCT);
        }
        if (this.getResultSetElements().isEmpty()) {
            stringBuffer.append(STAR);
            return;
        }
        Iterator iterator = this.getResultSetElements().iterator();
        while (iterator.hasNext()) {
            ((ResultSetElement)iterator.next()).evaluateOn(stringBuffer);
            if (!iterator.hasNext()) continue;
            if (this.useExtraSpaces()) {
                stringBuffer.append(", ");
                continue;
            }
            stringBuffer.append(",");
        }
        if (this.isSQLJ() && this.isSelectInto()) {
            this.generateOutputVariableNames();
            stringBuffer.append(INTO);
            iterator = this.hostVariables().iterator();
            while (iterator.hasNext()) {
                ((Variable)iterator.next()).evaluateOn(stringBuffer);
                if (!iterator.hasNext()) continue;
                if (this.useExtraSpaces()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(",");
            }
        }
    }

    public void generateOutputVariableNames() {
        this.resetVariableGeneration();
        List list = this.hostVariables();
        List list2 = this.getResultSetElements();
        MultiIterator multiIterator = new MultiIterator(list, list2);
        int n = 1;
        while (multiIterator.hasNext()) {
            Object[] objectArray = (Object[])multiIterator.next();
            ResultSetElement resultSetElement = (ResultSetElement)objectArray[1];
            String string = this.nextVariableName(resultSetElement, n++);
            ((Variable)objectArray[0]).name(string);
            this.outputArgNamesAndColumns().add(new Association(resultSetElement.column(), string));
        }
    }

    public List getResultSetElements() {
        if (this.fResultSet == null) {
            this.fResultSet = new ArrayList();
        }
        return this.fResultSet;
    }

    public boolean includes(RDBColumn rDBColumn) {
        Iterator iterator = this.getResultSetElements().iterator();
        while (iterator.hasNext()) {
            ResultSetElement resultSetElement = (ResultSetElement)iterator.next();
            if (!(resultSetElement instanceof ColumnName) || !((ColumnName)resultSetElement).same(rDBColumn)) continue;
            return true;
        }
        return false;
    }

    public List getColumns() {
        Iterator iterator = this.getResultSetElements().iterator();
        ArrayList<RDBColumn> arrayList = new ArrayList<RDBColumn>();
        while (iterator.hasNext()) {
            ResultSetElement resultSetElement = (ResultSetElement)iterator.next();
            if (!(resultSetElement instanceof ColumnName)) continue;
            arrayList.add(((ColumnName)resultSetElement).column());
        }
        return arrayList;
    }

    public boolean isDistinct() {
        return this.distinctFlag;
    }

    public void setAliasesFrom(List list) {
        Iterator iterator = this.getResultSetElements().iterator();
        while (iterator.hasNext()) {
            ResultSetElement resultSetElement = (ResultSetElement)iterator.next();
            resultSetElement.tableAlias(this.firstAlias(list, resultSetElement.table()));
        }
    }

    public String firstAlias(List list, RDBTable rDBTable) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CorrelationAliasTable correlationAliasTable = (CorrelationAliasTable)iterator.next();
            String string = correlationAliasTable.aliasAt(rDBTable);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public void setResultSet(List list) {
        this.fResultSet = list;
    }

    public boolean isSelectInto() {
        return this.fIntoFlag;
    }

    public void setToSelectInto() {
        this.fIntoFlag = true;
    }

    public void normalSelectClause() {
        this.fIntoFlag = false;
        this.fHostVariables = null;
    }

    public List hostVariables() {
        if (this.fHostVariables == null) {
            this.fHostVariables = new ArrayList();
        }
        return this.fHostVariables;
    }

    private void resetVariableGeneration() {
        this.fArgNamesAndColumns = new ArrayList();
    }

    private String nextVariableName(ResultSetElement resultSetElement, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.argIndicator());
        if (this.isUsingColumnNames()) {
            if (resultSetElement instanceof AbstractNullCastSpec) {
                stringBuffer.append(((AbstractNullCastSpec)resultSetElement).column().getName());
            } else {
                stringBuffer.append(((ColumnName)resultSetElement).name());
            }
        } else {
            stringBuffer.append(this.outputVariablePrefix());
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public List outputArgNamesAndColumns() {
        return this.fArgNamesAndColumns;
    }

    public void toResultSetExpressions() {
        int n = 1;
        ArrayList<ResultSetExpression> arrayList = new ArrayList<ResultSetExpression>();
        Iterator iterator = this.getResultSetElements().iterator();
        while (iterator.hasNext()) {
            arrayList.add(new ResultSetExpression(iterator.next(), this.createName(n++)));
        }
        this.setResultSet(arrayList);
    }

    public String createName(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(C).append(n);
        return stringBuffer.toString();
    }

    public List getColumnsAndExpressions() {
        Iterator iterator = this.getResultSetElements().iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            ResultSetElement resultSetElement = (ResultSetElement)iterator.next();
            if (resultSetElement instanceof ColumnName) {
                arrayList.add(((ColumnName)resultSetElement).value());
                continue;
            }
            if (!(resultSetElement instanceof ResultSetExpression)) continue;
            ResultSetExpression resultSetExpression = (ResultSetExpression)resultSetElement;
            if (resultSetExpression.isNewName()) {
                arrayList.add(resultSetExpression.toIdentifier());
                continue;
            }
            if (resultSetExpression.isColumn()) {
                arrayList.add(resultSetExpression.column());
                continue;
            }
            arrayList.add(resultSetExpression.function());
        }
        return arrayList;
    }
}

