/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.Connection;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBReferenceByKey;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TableInfo {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final char NL = '\n';
    private static final String NULLID = "NULLID";
    private RDBTable fTable;

    public TableInfo() {
    }

    public TableInfo(RDBTable rDBTable) {
        this.table(rDBTable);
    }

    public TableInfo(TableName tableName) {
        this.table(tableName.table());
    }

    public RDBColumn columnNamed(String string) {
        Iterator iterator = this.table().getColumns().iterator();
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            if (!rDBColumn.getName().equals(string)) continue;
            return rDBColumn;
        }
        return null;
    }

    public List primaryKey() {
        return this.table().getPrimaryKey().getMembers();
    }

    public List allForeignKeyColumns() {
        Iterator iterator = this.table().getForeignKeys().iterator();
        Connection connection = new Connection();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            connection.reference((RDBReferenceByKey)iterator.next());
            if (connection.memberTable().equals(this.table())) {
                arrayList.addAll(connection.memberKeyColumns());
                continue;
            }
            arrayList.addAll(connection.parentKeyColumns());
        }
        return arrayList;
    }

    public List nonPKColumns() {
        StSet stSet = StSet.setOn(this.primaryKey());
        Iterator iterator = this.table().getColumns().iterator();
        ArrayList<RDBColumn> arrayList = new ArrayList<RDBColumn>();
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            if (stSet.contains(rDBColumn)) continue;
            arrayList.add(rDBColumn);
        }
        return arrayList;
    }

    public List columns() {
        Iterator iterator = this.table().getColumns().iterator();
        ArrayList<RDBColumn> arrayList = new ArrayList<RDBColumn>();
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            arrayList.add(rDBColumn);
        }
        return arrayList;
    }

    public RDBColumn someSimpleColumn() {
        StSet stSet = StSet.setOn(this.primaryKey());
        stSet.addAll((Collection)this.allForeignKeyColumns());
        Iterator iterator = this.table().getColumns().iterator();
        ArrayList arrayList = new ArrayList();
        ColumnInfo columnInfo = new ColumnInfo();
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            columnInfo.column(rDBColumn);
            if (stSet.contains(rDBColumn) || columnInfo.isCharacterLargeObjectType() || columnInfo.isBlob()) continue;
            return rDBColumn;
        }
        return null;
    }

    public String getQualifiedName() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getQualifier();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(".");
        }
        stringBuffer.append(this.table().getName());
        return stringBuffer.toString();
    }

    public String getQualifier() {
        if (this.table().getSchemaName() == null) {
            return null;
        }
        String string = this.table().getSchemaName();
        if (string == null || string.equals(NULLID)) {
            return null;
        }
        if ((string = string.trim()).length() > 0) {
            return string;
        }
        return null;
    }

    public void infoStringOn(StringBuffer stringBuffer) {
        Iterator iterator;
        stringBuffer.append("\tTable - ").append(this.table().getName());
        stringBuffer.append("  pk(");
        if (this.table().getPrimaryKey() != null) {
            iterator = this.table().getPrimaryKey().getMembers().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((RDBColumn)iterator.next()).getName());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(")");
        iterator = this.table().getColumns().iterator();
        ColumnInfo columnInfo = new ColumnInfo();
        while (iterator.hasNext()) {
            stringBuffer.append('\n');
            columnInfo.column((RDBColumn)iterator.next());
            columnInfo.infoStringOn(stringBuffer);
        }
        stringBuffer.append('\n');
        iterator = this.table().getForeignKeys().iterator();
        Connection connection = new Connection();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof RDBReferenceByKey)) continue;
            stringBuffer.append("\t\tfk - ");
            connection.reference((RDBReferenceByKey)e2);
            connection.infoStringOn(stringBuffer);
            stringBuffer.append('\n');
        }
    }

    public boolean isAliasDefined() {
        return false;
    }

    public String name() {
        return this.table().getName();
    }

    public void printColumnDdlOn(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        ColumnInfo columnInfo = new ColumnInfo();
        if (iterator.hasNext()) {
            stringBuffer.append('\n');
        }
        while (iterator.hasNext()) {
            columnInfo.column((RDBColumn)iterator.next());
            columnInfo.printDdlOn(stringBuffer);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ").append('\n');
        }
    }

    public void printCreateDdlOn(List list, List list2, StringBuffer stringBuffer) {
        stringBuffer.append("\nCREATE TABLE ");
        stringBuffer.append(this.table().getName());
        stringBuffer.append(" (");
        this.printColumnDdlOn(list, stringBuffer);
        this.printPKColumnDdlOn(list2, stringBuffer);
        stringBuffer.append(")");
    }

    public void printPKColumnDdlOn(List list, StringBuffer stringBuffer) {
        if (!list.isEmpty()) {
            stringBuffer.append(", \n");
            stringBuffer.append("PRIMARY KEY (");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((RDBColumn)iterator.next()).getName());
            }
            stringBuffer.append(")");
        }
    }

    public RDBTable table() {
        return this.fTable;
    }

    public void table(RDBTable rDBTable) {
        this.fTable = rDBTable;
    }
}

