/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.websphere.models.config.rolebasedauthz.impl.RolebasedauthzFactoryImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class AddToAdminAuthz
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(AddToAdminAuthz.class, "AddToAdminAuthz", "com.ibm.ws.security.admintask");
    private String adminUser = null;
    private String registryType = null;
    ConfigService cs = null;
    Session session = null;
    static final String ldapUR = "LDAPUserRegistry";
    static final String wimUR = "WIMUserRegistry";
    static final String customUR = "CustomUserRegistry";
    static final String localOSUR = "LocalOSUserRegistry";

    public AddToAdminAuthz(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public AddToAdminAuthz(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return MessageFormatHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    private AuthorizationTableExt getAuthTable(Session session, String string, WorkSpace workSpace) throws WorkSpaceException, Exception {
        String string2 = "";
        string2 = "admin-authz.xml";
        AuthorizationTableExt authorizationTableExt = null;
        RepositoryContext repositoryContext = AppUtils.findContext("cells", string, null, null, workSpace, true);
        repositoryContext.extract(string2, false);
        Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)string2));
        resource.load(new HashMap());
        EList eList = resource.getContents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext() && !(authorizationTableExt = (AuthorizationTableExt)iterator.next()).getContext().equals("domain")) {
        }
        return authorizationTableExt;
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.adminUser = (String)this.getParameter("adminUser");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        ObjectName objectName;
        ObjectName objectName2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectName3 = null;
        String string = null;
        WorkSpace workSpace = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "unsuccessful at getting TaskCommandResultImpl afterStepsExecuted");
            }
            return;
        }
        try {
            objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            this.session = this.getConfigSession();
            objectName = configService.resolve(this.session, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + objectName.toString());
            }
            if (objectName != null) {
                objectName3 = configService.queryConfigObjects(this.session, objectName, objectName2, null)[0];
            }
            int n = objectName.toString().indexOf("_Websphere_Config_Data_Display_Name");
            string = objectName.toString().substring(n);
            int n2 = string.indexOf(",");
            string = string.substring(0, n2);
            int n3 = string.indexOf("=");
            string = string.substring(n3 + 1);
            workSpace = WorkspaceHelper.getWorkspace(this.session);
        }
        catch (Throwable throwable) {
            String string2 = this.getMsg(resBundle, "security.admintask.FailAccesstoSecWS", null);
            taskCommandResultImpl.addWarnings(string2);
            taskCommandResultImpl.setResult(new Boolean(false));
            taskCommandResultImpl.setException(new CommandException(string2));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        objectName2 = new RolebasedauthzFactoryImpl();
        boolean bl = false;
        try {
            objectName = this.getAuthTable(this.session, string, workSpace);
            if (objectName != null) {
                EList eList;
                SecurityRoleExt securityRoleExt;
                EList eList2 = objectName.getAuthorizations();
                Object object = eList2.iterator();
                while (object.hasNext()) {
                    RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)object.next();
                    if (roleAssignmentExt == null || !(securityRoleExt = roleAssignmentExt.getRole()).getRoleName().equals("administrator")) continue;
                    eList = roleAssignmentExt.getUsers();
                    Iterator iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        UserExt userExt = (UserExt)iterator.next();
                        if (!userExt.getName().equals(this.adminUser)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found user " + this.adminUser + " in admin-authz.xml");
                        }
                        bl = true;
                        taskCommandResultImpl.setResult(new Boolean(true));
                    }
                }
                if (!bl) {
                    object = eList2.iterator();
                    while (object.hasNext()) {
                        RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)object.next();
                        if (roleAssignmentExt == null) continue;
                        securityRoleExt = roleAssignmentExt.getRole();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "role.getRoleName = " + securityRoleExt.getRoleName());
                        }
                        if (securityRoleExt.getRoleName().equals("administrator")) {
                            eList = objectName2.createUserExt();
                            eList.setName(this.adminUser);
                            roleAssignmentExt.getUsers().add((Object)eList);
                            continue;
                        }
                        if (!securityRoleExt.getRoleName().equals("adminsecuritymanager")) continue;
                        eList = objectName2.createUserExt();
                        eList.setName(this.adminUser);
                        roleAssignmentExt.getUsers().add((Object)eList);
                    }
                }
                object = AppUtils.findContext("cells", string, null, null, workSpace, true);
                String string3 = "";
                string3 = "admin-authz.xml";
                securityRoleExt = object.getResourceSet().getResource(URI.createURI((String)string3), false);
                securityRoleExt.save(new HashMap());
            }
        }
        catch (WorkSpaceException workSpaceException) {
            workSpaceException.printStackTrace();
            String string4 = this.getMsg(resBundle, "security.admintask.WorkSpaceFailAddUsertoAdminAuthz", null);
            taskCommandResultImpl.setException(new CommandException(workSpaceException, string4));
            taskCommandResultImpl.setResult(new Boolean(false));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string5 = this.getMsg(resBundle, "security.admintask.FailAddUsertoAdminAuthz", null);
            taskCommandResultImpl.setException(new CommandException(exception, string5));
            taskCommandResultImpl.setResult(new Boolean(false));
            return;
        }
        taskCommandResultImpl.setResult(new Boolean(true));
    }
}

