/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.security.Result;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.wim.registry.util.UserRegistryValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ApplyWizardSettings
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ApplyWizardSettings.class, "ApplyWizardSettings", "com.ibm.ws.security.admintasks");
    Boolean secureAdmin = new Boolean(true);
    Boolean secureApps = new Boolean(false);
    Boolean secureLocalResources = new Boolean(false);
    String defaultPort = "389";
    String ltpaPassword = null;
    String userRegistryType = null;
    String customRegistryClass = null;
    String[] customPropName = new String[10];
    String[] customPropValue = new String[10];
    String[] customPropReq = new String[10];
    int numberCustomProps = 0;
    String ldapServerType = null;
    String ldapHostName = null;
    String ldapPort = null;
    String ldapBaseDN = null;
    String ldapBindDN = null;
    String ldapBindPassword = null;
    String adminName = null;
    String adminPassword = null;
    Boolean ignoreCase = null;
    static final String ldapUR = "LDAPUserRegistry";
    static final String wimUR = "WIMUserRegistry";
    static final String customUR = "CustomUserRegistry";
    static final String localOSUR = "LocalOSUserRegistry";
    static String ldapPropsFile = "/com/ibm/websphere/security/ldap/LdapConfig.properties";

    public ApplyWizardSettings(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ApplyWizardSettings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return MessageFormatHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    public boolean validUserRegType(String string) {
        return string.equalsIgnoreCase(ldapUR) || string.equalsIgnoreCase(wimUR) || string.equalsIgnoreCase(customUR) || string.equalsIgnoreCase(localOSUR);
    }

    public boolean validLdapServerType(String string) {
        return string.equalsIgnoreCase("IBM_DIRECTORY_SERVER") || string.equalsIgnoreCase("IPLANET") || string.equalsIgnoreCase("NETSCAPE") || string.equalsIgnoreCase("NDS") || string.equalsIgnoreCase("DOMINO502") || string.equalsIgnoreCase("SECUREWAY") || string.equalsIgnoreCase("ACTIVE_DIRECTORY") || string.equalsIgnoreCase("CUSTOM");
    }

    public boolean validateNoOtherWIMFlavorsExist() {
        block8: {
            try {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand adminCommand = commandMgr.createCommand("getIdMgrDefaultRealm");
                adminCommand.setConfigSession(session);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    if (commandResult.getResult() != null) {
                        String string = commandResult.getResult().toString();
                        adminCommand = commandMgr.createCommand("getIdMgrRepositoriesForRealm");
                        adminCommand.setParameter("name", string);
                        adminCommand.setConfigSession(session);
                        adminCommand.execute();
                        commandResult = adminCommand.getCommandResult();
                        if (commandResult.isSuccessful()) {
                            List list = (List)commandResult.getResult();
                            if (list.size() != 1) {
                                return false;
                            }
                            Object e2 = list.get(0);
                            if (e2.toString().indexOf("InternalFileRepository") == -1) {
                                return false;
                            }
                        }
                    }
                    break block8;
                }
                return false;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, throwable.toString());
                    Tr.debug(tc, throwable.getMessage());
                }
                return false;
            }
        }
        return true;
    }

    public void validate() throws CommandValidationException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        this.secureApps = (Boolean)this.getParameter("secureApps");
        this.secureLocalResources = (Boolean)this.getParameter("secureLocalResources");
        this.userRegistryType = (String)this.getParameter("userRegistryType");
        if (!this.validUserRegType(this.userRegistryType)) {
            String string = this.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
            throw new CommandValidationException(string);
        }
        if (this.userRegistryType.equals(wimUR) && !this.validateNoOtherWIMFlavorsExist()) {
            String string = this.getMsg(resBundle, "security.admintask.FoundOtherWIMFlavors", null);
            throw new CommandValidationException(string);
        }
        this.customRegistryClass = (String)this.getParameter("customRegistryClass");
        String string = (String)this.getParameter("customProps");
        if (string != null) {
            object = new StringTokenizer(string, ";= ");
            int n = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                this.customPropName[n] = ((StringTokenizer)object).nextToken();
                this.customPropValue[n] = ((StringTokenizer)object).nextToken();
                ++n;
            }
            this.numberCustomProps = n;
            if (tc.isDebugEnabled()) {
                for (int i = 0; i < n; ++i) {
                    Tr.debug(tc, "customPropName[" + i + "] = " + this.customPropName[i]);
                    Tr.debug(tc, "customPropValue[" + i + "] = " + this.customPropValue[i]);
                }
            }
        }
        this.ldapServerType = (String)this.getParameter("ldapServerType");
        if (this.ldapServerType != null && !this.validLdapServerType(this.ldapServerType)) {
            object = this.getMsg(resBundle, "security.admintask.InvalidLDAPServerType", null);
            throw new CommandValidationException((String)object);
        }
        this.ldapHostName = (String)this.getParameter("ldapHostName");
        this.ldapPort = (String)this.getParameter("ldapPort");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "port=begin" + this.ldapPort + "end");
        }
        if (this.ldapPort == null || this.ldapPort == "" || this.ldapPort.length() == 0) {
            this.ldapPort = this.defaultPort;
        }
        this.ldapBaseDN = (String)this.getParameter("ldapBaseDN");
        this.ldapBindDN = (String)this.getParameter("ldapBindDN");
        this.ldapBindPassword = (String)this.getParameter("ldapBindPassword");
        this.adminName = (String)this.getParameter("adminName");
        this.adminPassword = (String)this.getParameter("adminPassword");
        this.ignoreCase = (Boolean)this.getParameter("ignoreCase");
        if (this.ignoreCase == null) {
            this.ignoreCase = new Boolean(false);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "secureApps: " + this.secureApps.toString());
            Tr.debug(tc, "secureLocalResources: " + this.secureLocalResources.toString());
            Tr.debug(tc, "userRegistryType: " + this.userRegistryType);
            if (this.customRegistryClass != null) {
                Tr.debug(tc, "customRegistryClass: " + this.customRegistryClass);
            }
            if (this.ldapServerType != null) {
                Tr.debug(tc, "ldapServerType: " + this.ldapServerType);
            }
            if (this.ldapHostName != null) {
                Tr.debug(tc, "ldapHostName: " + this.ldapHostName);
            }
            if (this.ldapPort != null) {
                Tr.debug(tc, "ldapPort: " + this.ldapPort);
            }
            if (this.ldapBaseDN != null) {
                Tr.debug(tc, "ldapBaseDN: " + this.ldapBaseDN);
            }
            if (this.ldapBindDN != null) {
                Tr.debug(tc, "ldapBindDN: " + this.ldapBindDN);
            }
            if (this.ldapBindPassword != null) {
                Tr.debug(tc, "ldapBindPassword: XXXXXXX");
            }
            Tr.debug(tc, "adminName: " + this.adminName);
            if (this.adminPassword != null) {
                Tr.debug(tc, "adminPassword: XXXXXXX");
            }
            if (this.ignoreCase != null && (this.ignoreCase.booleanValue() || !this.ignoreCase.booleanValue())) {
                Tr.debug(tc, "ignoreCase: " + this.ignoreCase.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void afterStepsExecuted() {
        var2_1 = null;
        var3_2 = null;
        if (ApplyWizardSettings.tc.isEntryEnabled()) {
            Tr.entry(ApplyWizardSettings.tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        var4_3 = null;
        var5_4 = null;
        var6_5 = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!var6_5.isSuccessful()) {
            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
            }
            return;
        }
        var7_6 = ConfigServiceFactory.getConfigService();
        var8_7 = this.getConfigSession();
        var9_8 = new Properties();
        try {
            block140: {
                block141: {
                    var10_9 = ConfigServiceHelper.createObjectName(null, "Security");
                    var11_11 = ConfigServiceHelper.createObjectName(null, "properties");
                    var12_13 = var7_6.resolve(var8_7, "Cell=")[0];
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "cell = " + var12_13.toString());
                    }
                    if (var12_13 != null) {
                        var4_3 = var7_6.queryConfigObjects(var8_7, var12_13, var10_9, null)[0];
                    }
                    if (!this.userRegistryType.equals("LDAPUserRegistry")) break block141;
                    var13_14 = CommandMgr.getCommandMgr();
                    var14_15 = var13_14.createCommand("validateLDAPConnection");
                    var14_15.setParameter("hostname", this.ldapHostName);
                    var14_15.setParameter("port", new Integer(Integer.parseInt(this.ldapPort)));
                    var14_15.setParameter("sslEnabled", new Boolean(false));
                    var14_15.setParameter("type", this.ldapServerType);
                    var14_15.setParameter("baseDN", this.ldapBaseDN);
                    if (this.ldapBindDN != null) {
                        var14_15.setParameter("bindDN", this.ldapBindDN);
                    }
                    if (this.ldapBindPassword != null) {
                        var14_15.setParameter("bindPassword", this.ldapBindPassword);
                    }
                    var14_15.setConfigSession(var8_7);
                    var14_15.execute();
                    var15_16 = var14_15.getCommandResult();
                    if (!var15_16.isSuccessful()) ** GOTO lbl53
                    if (((Boolean)var15_16.getResult()).booleanValue()) {
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "Successfully connected to LDAP Server");
                        }
                    } else {
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "Could not successfully connect to LDAP");
                        }
                        var16_17 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionLDAPConnect", null);
                        var6_5.addWarnings(var16_17);
                        var6_5.setResult(new Boolean(false));
                        var6_5.setException(new CommandException(var16_17));
                        if (ApplyWizardSettings.tc.isEntryEnabled()) {
                            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                        }
                        return;
lbl53:
                        // 1 sources

                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "Could not successfully connect to LDAP");
                        }
                        var16_18 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionLDAPConnect", null);
                        var16_18 = var16_18.concat(": ");
                        if (var15_16.getMessages().size() > 0) {
                            var17_20 = var15_16.getMessages().toArray();
                            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                Tr.debug(ApplyWizardSettings.tc, " msgs size = " + var17_20.length);
                            }
                            var16_18 = var16_18.concat((String)var17_20[1]);
                        }
                        var6_5.addWarnings(var16_18);
                        var6_5.setResult(new Boolean(false));
                        var6_5.setException(new CommandException(var16_18));
                        if (ApplyWizardSettings.tc.isEntryEnabled()) {
                            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                        }
                        return;
                    }
                }
                var13_14 = new AttributeList();
                var14_15 = new AttributeList();
                var15_16 = new AttributeList();
                var16_19 = new AttributeList();
                var17_21 = new AttributeList();
                var18_22 = new AttributeList();
                var19_23 = null;
                var20_24 = null;
                var21_25 = null;
                var22_26 = null;
                var23_27 = new String[]{"properties"};
                var24_28 = new Properties();
                var25_29 = (ArrayList)var7_6.getAttribute(var8_7, var4_3, "authMechanisms");
                for (var26_30 = 0; var26_30 < var25_29.size(); ++var26_30) {
                    var27_32 = (AttributeList)var25_29.get(var26_30);
                    var28_47 = ConfigServiceHelper.getAttributeValue(var27_32, "_Websphere_Config_Data_Type");
                    if (!var28_47.toString().equals("LTPA")) continue;
                    var13_14.add(new Attribute("password", this.ltpaPassword));
                    var20_24 = var7_6.queryConfigObjects(var8_7, null, ConfigServiceHelper.createObjectName(var27_32), null);
                }
                var14_15.add(new Attribute("enabled", this.secureAdmin));
                var14_15.add(new Attribute("appEnabled", this.secureApps));
                var14_15.add(new Attribute("enforceJava2Security", this.secureLocalResources));
                var26_31 = (ArrayList)var7_6.getAttribute(var8_7, var4_3, "userRegistries");
                for (var27_33 = 0; var27_33 < var26_31.size(); ++var27_33) {
                    var28_47 = (AttributeList)var26_31.get(var27_33);
                    var29_54 = ConfigServiceHelper.getAttributeValue((AttributeList)var28_47, "_Websphere_Config_Data_Type");
                    if (!var29_54.toString().equals(this.userRegistryType)) continue;
                    var21_25 = var7_6.queryConfigObjects(var8_7, null, ConfigServiceHelper.createObjectName((AttributeList)var28_47), null);
                    var14_15.add(new Attribute("activeUserRegistry", var21_25[0]));
                }
                if (this.userRegistryType.equals("LDAPUserRegistry")) {
                    var24_28.setProperty("security.registry.ldap.reuseConn", "true");
                    var24_28.put("sslEnabled", Boolean.FALSE);
                    var24_28.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
                    var24_28.setProperty("certificate.map.mode", "exactDNMode");
                    var27_34 = "ldap://";
                    var28_47 = new StringBuffer();
                    var29_54 = new Integer(389);
                    if (this.ldapPort != null) {
                        var29_54 = new Integer(this.ldapPort);
                    }
                    if (this.ldapHostName.indexOf(":") != -1) {
                        var28_47.append(var27_34).append("[" + this.ldapHostName + "]");
                    } else {
                        var28_47.append(var27_34).append(this.ldapHostName);
                    }
                    if (var29_54 != null && var29_54.intValue() > 0) {
                        var28_47.append(":" + var29_54.intValue());
                    }
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "ldapUrl = " + var28_47.toString());
                    }
                    var24_28.setProperty("java.naming.provider.url", var28_47.toString());
                    if (this.ldapServerType != null) {
                        var15_16.add(new Attribute("type", this.ldapServerType));
                        var24_28.setProperty("dirType", this.ldapServerType);
                    }
                    if (this.ldapBaseDN != null) {
                        var15_16.add(new Attribute("baseDN", this.ldapBaseDN));
                        var24_28.setProperty("ldap.basedn", this.ldapBaseDN);
                    }
                    if (this.ldapBindDN != null) {
                        var15_16.add(new Attribute("bindDN", this.ldapBindDN));
                        var24_28.setProperty("java.naming.security.principal", this.ldapBindDN);
                    }
                    if (this.ldapBindPassword != null) {
                        var15_16.add(new Attribute("bindPassword", this.ldapBindPassword));
                        var24_28.setProperty("java.naming.security.credentials", this.ldapBindPassword);
                    }
                    if (this.ldapHostName != null && this.ldapPort != null) {
                        var30_60 = new String(this.ldapHostName + ":" + this.ldapPort);
                        var15_16.add(new Attribute("realm", var30_60));
                        var24_28.setProperty("LDAP.server.realm", (String)var30_60);
                        var31_63 = (ArrayList)var7_6.getAttribute(var8_7, var21_25[0], "hosts");
                        for (var32_64 = 0; var32_64 < var31_63.size(); ++var32_64) {
                            var16_19 = (AttributeList)var31_63.get(var32_64);
                            ConfigServiceHelper.setAttributeValue(var16_19, "host", this.ldapHostName);
                            ConfigServiceHelper.setAttributeValue(var16_19, "port", new Integer(this.ldapPort));
                            var22_26 = var7_6.queryConfigObjects(var8_7, null, ConfigServiceHelper.createObjectName(var16_19), null);
                        }
                    }
                } else {
                    if (this.userRegistryType.equals("LocalOSUserRegistry")) {
                        var24_28.setProperty("security.activeUserRegistryType", "LOCALOS");
                        try {
                            var27_35 = AdminServiceFactory.getAdminService().getProcessName();
                            var28_47 = new ObjectName("WebSphere:type=SecurityAdmin,process=" + var27_35 + ",*");
                            var29_54 = AdminServiceFactory.getAdminService().queryNames((ObjectName)var28_47, null).iterator();
                            if (!var29_54.hasNext()) {
                                Tr.error(ApplyWizardSettings.tc, "security.ctr.nombean.error");
                                var30_61 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                                var6_5.addWarnings(var30_61);
                                var6_5.setResult(new Boolean(false));
                                var6_5.setException(new CommandException(var30_61));
                                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                                }
                                return;
                            }
                            var28_47 = (ObjectName)var29_54.next();
                            var30_60 = (String)AdminServiceFactory.getAdminService().invoke((ObjectName)var28_47, "getRealm", new Object[]{var24_28}, new String[]{"java.util.Properties"});
                            var15_16.add(new Attribute("realm", var30_60));
                        }
                        catch (Exception var27_36) {
                            Tr.error(ApplyWizardSettings.tc, "security.ctr.mbean.exception", new Object[]{var27_36});
                            var28_47 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                            var6_5.addWarnings((String)var28_47);
                            var6_5.setResult(new Boolean(false));
                            var6_5.setException(new CommandException((String)var28_47));
                            if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                            }
                            return;
                        }
                    }
                    if (this.userRegistryType.equals("WIMUserRegistry")) {
                        var15_16.add(new Attribute("realm", "defaultWIMFileBasedRealm"));
                    } else if (this.userRegistryType.equals("CustomUserRegistry")) {
                        if (this.customRegistryClass != null) {
                            var15_16.add(new Attribute("customRegistryClassName", this.customRegistryClass));
                        }
                        try {
                            var27_37 = AdminServiceFactory.getAdminService().getProcessName();
                            var28_47 = new ObjectName("WebSphere:type=SecurityAdmin,process=" + var27_37 + ",*");
                            var29_54 = AdminServiceFactory.getAdminService().queryNames((ObjectName)var28_47, null).iterator();
                            if (!var29_54.hasNext()) {
                                Tr.error(ApplyWizardSettings.tc, "security.ctr.nombean.error");
                                var30_62 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                                var6_5.addWarnings(var30_62);
                                var6_5.setResult(new Boolean(false));
                                var6_5.setException(new CommandException(var30_62));
                                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                                }
                                return;
                            }
                            var28_47 = (ObjectName)var29_54.next();
                            var30_60 = (String)AdminServiceFactory.getAdminService().invoke((ObjectName)var28_47, "getRealm", new Object[]{var9_8}, new String[]{"java.util.Properties"});
                            var15_16.add(new Attribute("realm", var30_60));
                            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                Tr.debug(ApplyWizardSettings.tc, "realm = " + (String)var30_60);
                            }
                        }
                        catch (Exception var27_38) {
                            Tr.error(ApplyWizardSettings.tc, "security.ctr.mbean.exception", new Object[]{var27_38});
                            var28_47 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                            var6_5.addWarnings((String)var28_47);
                            var6_5.setResult(new Boolean(false));
                            var6_5.setException(new CommandException((String)var28_47));
                            if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                            }
                            return;
                        }
                        var15_16.add(new Attribute("ignoreCase", this.ignoreCase));
                    }
                }
                if (this.userRegistryType.equals("LDAPUserRegistry")) {
                    var18_22 = (AttributeList)var7_6.getAttribute(var8_7, var21_25[0], "searchFilter");
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "searchFilterAttrList = " + var18_22.toString());
                    }
                    var27_39 = null;
                    try {
                        var28_47 = this.getClass().getResourceAsStream(ApplyWizardSettings.ldapPropsFile);
                        var27_39 = new Properties();
                        var27_39.load((InputStream)var28_47);
                    }
                    catch (IOException var28_48) {
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "IOException opening ldapPropsFile");
                        }
                        var28_48.printStackTrace();
                        var6_5.setResult(new Boolean(false));
                        var29_54 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                        var6_5.setException(new CommandException(var28_48, (String)var29_54));
                        return;
                    }
                    if (var27_39 != null) {
                        var28_49 = 0;
                        if (this.ldapServerType.equalsIgnoreCase("IBM_DIRECTORY_SERVER")) {
                            var28_49 = 0;
                        } else if (this.ldapServerType.equalsIgnoreCase("SECUREWAY")) {
                            var28_49 = 1;
                        } else if (this.ldapServerType.equalsIgnoreCase("IPLANET")) {
                            var28_49 = 2;
                        } else if (this.ldapServerType.equalsIgnoreCase("NETSCAPE")) {
                            var28_49 = 3;
                        } else if (this.ldapServerType.equalsIgnoreCase("DOMINO502")) {
                            var28_49 = 4;
                        } else if (this.ldapServerType.equalsIgnoreCase("NDS")) {
                            var28_49 = 5;
                        } else if (this.ldapServerType.equalsIgnoreCase("ACTIVE_DIRECTORY")) {
                            var28_49 = 6;
                        } else if (this.ldapServerType.equalsIgnoreCase("CUSTOM")) {
                            var28_49 = 7;
                        }
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "ldapServerTypeValue = " + var28_49);
                        }
                        switch (var28_49) {
                            case 0: {
                                ConfigServiceHelper.setAttributeValue(var18_22, "userFilter", var27_39.getProperty("ibm_dir_server.user.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupFilter", var27_39.getProperty("ibm_dir_server.group.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "userIdMap", var27_39.getProperty("ibm_dir_server.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupIdMap", var27_39.getProperty("ibm_dir_server.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupMemberIdMap", var27_39.getProperty("ibm_dir_server.groupmember.idmap"));
                                var24_28.setProperty("user.filter", var27_39.getProperty("ibm_dir_server.user.filter"));
                                var24_28.setProperty("group.filter", var27_39.getProperty("ibm_dir_server.group.filter"));
                                var24_28.setProperty("user.idmap", var27_39.getProperty("ibm_dir_server.user.idmap"));
                                var24_28.setProperty("group.idmap", var27_39.getProperty("ibm_dir_server.group.idmap"));
                                var24_28.setProperty("groupmember.idmap", var27_39.getProperty("ibm_dir_server.groupmember.idmap"));
                                break;
                            }
                            case 1: {
                                ConfigServiceHelper.setAttributeValue(var18_22, "userFilter", var27_39.getProperty("secureway.user.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupFilter", var27_39.getProperty("secureway.group.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "userIdMap", var27_39.getProperty("secureway.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupIdMap", var27_39.getProperty("secureway.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupMemberIdMap", var27_39.getProperty("secureway.groupmember.idmap"));
                                var24_28.setProperty("user.filter", var27_39.getProperty("secureway.user.filter"));
                                var24_28.setProperty("group.filter", var27_39.getProperty("secureway.group.filter"));
                                var24_28.setProperty("user.idmap", var27_39.getProperty("secureway.user.idmap"));
                                var24_28.setProperty("group.idmap", var27_39.getProperty("secureway.group.idmap"));
                                var24_28.setProperty("groupmember.idmap", var27_39.getProperty("secureway.groupmember.idmap"));
                                break;
                            }
                            case 2: {
                                ConfigServiceHelper.setAttributeValue(var18_22, "userFilter", var27_39.getProperty("iplanet.user.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupFilter", var27_39.getProperty("iplanet.group.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "userIdMap", var27_39.getProperty("iplanet.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupIdMap", var27_39.getProperty("iplanet.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupMemberIdMap", var27_39.getProperty("iplanet.groupmember.idmap"));
                                var24_28.setProperty("user.filter", var27_39.getProperty("iplanet.user.filter"));
                                var24_28.setProperty("group.filter", var27_39.getProperty("iplanet.group.filter"));
                                var24_28.setProperty("user.idmap", var27_39.getProperty("iplanet.user.idmap"));
                                var24_28.setProperty("group.idmap", var27_39.getProperty("iplanet.group.idmap"));
                                var24_28.setProperty("groupmember.idmap", var27_39.getProperty("iplanet.groupmember.idmap"));
                                break;
                            }
                            case 3: {
                                ConfigServiceHelper.setAttributeValue(var18_22, "userFilter", var27_39.getProperty("netscape.user.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupFilter", var27_39.getProperty("netscape.group.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "userIdMap", var27_39.getProperty("netscape.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupIdMap", var27_39.getProperty("netscape.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupMemberIdMap", var27_39.getProperty("netscape.groupmember.idmap"));
                                var24_28.setProperty("user.filter", var27_39.getProperty("netscape.user.filter"));
                                var24_28.setProperty("group.filter", var27_39.getProperty("netscape.group.filter"));
                                var24_28.setProperty("user.idmap", var27_39.getProperty("netscape.user.idmap"));
                                var24_28.setProperty("group.idmap", var27_39.getProperty("netscape.group.idmap"));
                                var24_28.setProperty("groupmember.idmap", var27_39.getProperty("netscape.groupmember.idmap"));
                                break;
                            }
                            case 4: {
                                ConfigServiceHelper.setAttributeValue(var18_22, "userFilter", var27_39.getProperty("domino50.user.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupFilter", var27_39.getProperty("domino50.group.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "userIdMap", var27_39.getProperty("domino50.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupIdMap", var27_39.getProperty("domino50.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupMemberIdMap", var27_39.getProperty("domino50.groupmember.idmap"));
                                var24_28.setProperty("user.filter", var27_39.getProperty("domino50.user.filter"));
                                var24_28.setProperty("group.filter", var27_39.getProperty("domino50.group.filter"));
                                var24_28.setProperty("user.idmap", var27_39.getProperty("domino50.user.idmap"));
                                var24_28.setProperty("group.idmap", var27_39.getProperty("domino50.group.idmap"));
                                var24_28.setProperty("groupmember.idmap", var27_39.getProperty("domino50.groupmember.idmap"));
                                break;
                            }
                            case 6: {
                                ConfigServiceHelper.setAttributeValue(var18_22, "userFilter", var27_39.getProperty("actived.user.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupFilter", var27_39.getProperty("actived.group.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "userIdMap", var27_39.getProperty("actived.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupIdMap", var27_39.getProperty("actived.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupMemberIdMap", var27_39.getProperty("actived.groupmember.idmap"));
                                var24_28.setProperty("user.filter", var27_39.getProperty("actived.user.filter"));
                                var24_28.setProperty("group.filter", var27_39.getProperty("actived.group.filter"));
                                var24_28.setProperty("user.idmap", var27_39.getProperty("actived.user.idmap"));
                                var24_28.setProperty("group.idmap", var27_39.getProperty("actived.group.idmap"));
                                var24_28.setProperty("groupmember.idmap", var27_39.getProperty("actived.groupmember.idmap"));
                                break;
                            }
                            case 5: {
                                ConfigServiceHelper.setAttributeValue(var18_22, "userFilter", var27_39.getProperty("edirectory.user.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupFilter", var27_39.getProperty("edirectory.group.filter"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "userIdMap", var27_39.getProperty("edirectory.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupIdMap", var27_39.getProperty("edirectory.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(var18_22, "groupMemberIdMap", var27_39.getProperty("edirectory.groupmember.idmap"));
                                var24_28.setProperty("user.filter", var27_39.getProperty("edirectory.user.filter"));
                                var24_28.setProperty("group.filter", var27_39.getProperty("edirectory.group.filter"));
                                var24_28.setProperty("user.idmap", var27_39.getProperty("edirectory.user.idmap"));
                                var24_28.setProperty("group.idmap", var27_39.getProperty("edirectory.group.idmap"));
                                var24_28.setProperty("groupmember.idmap", var27_39.getProperty("edirectory.groupmember.idmap"));
                                break;
                            }
                        }
                    }
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "searchFilterAttrList = " + var18_22.toString());
                    }
                    var19_23 = var7_6.queryConfigObjects(var8_7, null, ConfigServiceHelper.createObjectName(var18_22), null);
                }
                if (var24_28 != null && ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "props = " + var24_28.toString());
                }
                if (this.userRegistryType.equals("CustomUserRegistry")) {
                    for (var27_40 = 0; var27_40 < this.numberCustomProps; ++var27_40) {
                        var9_8.put(this.customPropName[var27_40], this.customPropValue[var27_40]);
                    }
                    var9_8.put("CustUserRegImplClass", this.customRegistryClass);
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "cProps = " + var9_8.toString());
                    }
                    var27_40 = 0;
                    var28_50 = "getUsers";
                    try {
                        var29_54 = AdminServiceFactory.getAdminService().getProcessName();
                        var30_60 = new ObjectName("WebSphere:type=SecurityAdmin,process=" + (String)var29_54 + ",*");
                        var31_63 = AdminServiceFactory.getAdminService().queryNames((ObjectName)var30_60, null).iterator();
                        if (!var31_63.hasNext()) {
                            var6_5.setResult(new Boolean(false));
                            var32_65 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.AdminNotFoundInReg", null);
                            var6_5.addWarnings(var32_65);
                            var6_5.setResult(new Boolean(false));
                            var6_5.setException(new CommandException(var32_65));
                            if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                            }
                            return;
                        }
                        var30_60 = (ObjectName)var31_63.next();
                        var32_66 = (Result)AdminServiceFactory.getAdminService().invoke((ObjectName)var30_60, (String)var28_50, new Object[]{this.adminName, new Integer(100), var9_8}, new String[]{"java.lang.String", "java.lang.Integer", "java.util.Properties"});
                        var27_40 = var32_66.getList().size();
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "count = " + var27_40);
                        }
                        if (var27_40 == 0) {
                            var33_70 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.AdminNotFoundInReg", null);
                            var6_5.addWarnings(var33_70);
                            var6_5.setResult(new Boolean(false));
                            var6_5.setException(new CommandException(var33_70));
                            if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                            }
                            return;
                        }
                        break block140;
                    }
                    catch (Exception var29_55) {
                        var30_60 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.AdminNotFoundInReg", null);
                        var6_5.addWarnings((String)var30_60);
                        var6_5.setResult(new Boolean(false));
                        var6_5.setException(new CommandException((String)var30_60));
                        if (ApplyWizardSettings.tc.isEntryEnabled()) {
                            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                        }
                        return;
                    }
                }
                if (this.userRegistryType.equals("WIMUserRegistry")) {
                    try {
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "sessionId = " + var8_7.toString());
                        }
                        if ((var28_50 = (var27_41 = new UserRegistryValidator(var8_7.toString())).getUsers(this.adminName, 100)).getList().isEmpty()) {
                            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                Tr.debug(ApplyWizardSettings.tc, "user " + this.adminName + " not found in WIM UR");
                            }
                            try {
                                var29_54 = CommandMgr.getCommandMgr();
                                var30_60 = var29_54.createCommand("addFileRegistryAccount");
                                var30_60.setConfigSession(var8_7);
                                var30_60.setParameter("userId", this.adminName);
                                var30_60.setParameter("password", this.adminPassword);
                                var30_60.execute();
                                var31_63 = var30_60.getCommandResult();
                                if (var31_63.isSuccessful()) {
                                    if (!ApplyWizardSettings.tc.isDebugEnabled()) ** GOTO lbl518
                                    Tr.debug(ApplyWizardSettings.tc, "user " + this.adminName + " added to WIM UR");
                                }
                                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                    Tr.debug(ApplyWizardSettings.tc, "(1) user " + this.adminName + " not added toWIM UR");
                                }
                                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                    Tr.debug(ApplyWizardSettings.tc, "cmdResult.getException().getMessage() = " + var31_63.getException().getMessage());
                                }
                                if (var31_63.getException() == null || var31_63.getException().getMessage() == null || var31_63.getException().getMessage().indexOf("CWWIM4501E") != -1) ** GOTO lbl518
                                var32_67 = this.getMsg(ApplyWizardSettings.resBundle, "security.profiletask.failAddingAdminToWim", null);
                                var6_5.addWarnings(var32_67);
                                var6_5.setResult(new Boolean(false));
                                var6_5.setException(new CommandException(var32_67));
                                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                                }
                                return;
                            }
                            catch (Exception var29_56) {
                                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                    Tr.debug(ApplyWizardSettings.tc, "exception = " + var29_56.getMessage().toString());
                                }
                                var6_5.setResult(new Boolean(false));
                                var30_60 = this.getMsg(ApplyWizardSettings.resBundle, "security.profiletask.failAddingAdminToWim", null);
                                var6_5.setException(new CommandException(var29_56, (String)var30_60));
                                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                                }
                                return;
                            }
                        }
                        if (!ApplyWizardSettings.tc.isDebugEnabled()) ** GOTO lbl518
                        Tr.debug(ApplyWizardSettings.tc, "user " + this.adminName + " found in WIM UR");
                    }
                    catch (Exception var27_42) {
                        var27_42.printStackTrace();
                        var6_5.setResult(new Boolean(false));
                        var28_51 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionValidAdminName", null);
                        var6_5.setException(new CommandException(var27_42, var28_51));
                        return;
                    }
                } else {
                    var27_43 = 0;
                    var28_50 = "getUsers";
                    try {
                        var29_54 = AdminServiceFactory.getAdminService().getProcessName();
                        var30_60 = new ObjectName("WebSphere:type=SecurityAdmin,process=" + var29_54 + ",*");
                        var31_63 = AdminServiceFactory.getAdminService().queryNames((ObjectName)var30_60, null).iterator();
                        if (!var31_63.hasNext()) {
                            var6_5.setResult(new Boolean(false));
                            return;
                        }
                        var30_60 = (ObjectName)var31_63.next();
                        var32_68 = (Result)AdminServiceFactory.getAdminService().invoke((ObjectName)var30_60, (String)var28_50, new Object[]{this.adminName, new Integer(100), var24_28}, new String[]{"java.lang.String", "java.lang.Integer", "java.util.Properties"});
                        if (var32_68 != null && var32_68.getList() != null) {
                            var27_43 = var32_68.getList().size();
                            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                Tr.debug(ApplyWizardSettings.tc, "count = " + var27_43);
                            }
                        } else if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "results or results.getList() was null");
                        }
                    }
                    catch (Exception var29_57) {
                        var29_57.printStackTrace();
                        var6_5.setResult(new Boolean(false));
                        var30_60 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionValidAdminName", null);
                        var6_5.setException(new CommandException(var29_57, (String)var30_60));
                        return;
                    }
                    if (var27_43 == 0) {
                        var29_54 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.AdminNotFoundInReg", null);
                        var6_5.addWarnings((String)var29_54);
                        var6_5.setResult(new Boolean(false));
                        var6_5.setException(new CommandException((String)var29_54));
                        if (ApplyWizardSettings.tc.isEntryEnabled()) {
                            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                        }
                        return;
                    }
                }
            }
            if (System.getProperty("os.name").equalsIgnoreCase("z/os")) {
                var27_44 = (ArrayList)var7_6.getAttribute(var8_7, var4_3, "properties");
                var28_50 = new AttributeList();
                if (ApplyWizardSettings.tc.isDebugEnabled() && var27_44 != null) {
                    Tr.debug(ApplyWizardSettings.tc, "propertiesList.size = " + var27_44.size());
                }
                for (var29_58 = 0; var29_58 < var27_44.size(); ++var29_58) {
                    var30_60 = (AttributeList)var27_44.get(var29_58);
                    var31_63 = ConfigServiceHelper.getAttributeValue((AttributeList)var30_60, "_Websphere_Config_Data_Type");
                    var32_69 = ConfigServiceHelper.getAttributeValue((AttributeList)var30_60, "name");
                    var33_71 = ConfigServiceHelper.getAttributeValue((AttributeList)var30_60, "value");
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "propNameObj = " + var32_69.toString());
                        Tr.debug(ApplyWizardSettings.tc, "propObj = " + var31_63.toString());
                    }
                    if (!var32_69.toString().equals("com.ibm.security.SAF.authorization")) continue;
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "found SAF auth");
                    }
                    var34_72 = var7_6.queryConfigObjects(var8_7, null, ConfigServiceHelper.createObjectName((AttributeList)var30_60), null);
                    for (var35_73 = 0; var35_73 < var34_72.length; ++var35_73) {
                        if (!ApplyWizardSettings.tc.isDebugEnabled()) continue;
                        Tr.debug(ApplyWizardSettings.tc, "matchesSAFProp = " + var34_72[var35_73].toString());
                    }
                    ConfigServiceHelper.setAttributeValue((AttributeList)var30_60, "name", var32_69);
                    ConfigServiceHelper.setAttributeValue((AttributeList)var30_60, "value", "false");
                    var7_6.setAttributes(var8_7, var34_72[0], (AttributeList)var30_60);
                    break;
                }
            }
            var7_6.setAttributes(var8_7, var20_24[0], (AttributeList)var13_14);
            var7_6.setAttributes(var8_7, var4_3, (AttributeList)var14_15);
            if (this.userRegistryType.equals("LDAPUserRegistry")) {
                var7_6.setAttributes(var8_7, (ObjectName)var22_26[0], var16_19);
                var7_6.setAttributes(var8_7, var19_23[0], var18_22);
            }
            if (this.userRegistryType.equals("CustomUserRegistry") && this.numberCustomProps != 0) {
                var27_45 = (ArrayList)var7_6.getAttribute(var8_7, var21_25[0], "properties");
                var7_6.unsetAttributes(var8_7, var21_25[0], var23_27);
                for (var28_52 = 0; var28_52 < this.numberCustomProps; ++var28_52) {
                    ConfigServiceHelper.setAttributeValue(var17_21, "name", this.customPropName[var28_52]);
                    ConfigServiceHelper.setAttributeValue(var17_21, "value", this.customPropValue[var28_52]);
                    var7_6.addElement(var8_7, var21_25[0], "properties", var17_21, -1);
                }
            }
            var7_6.setAttributes(var8_7, var21_25[0], (AttributeList)var15_16);
            var27_46 = CommandMgr.getCommandMgr();
            var28_53 = var27_46.createCommand("setUseRegistryServerId");
            var28_53.setConfigSession(var8_7);
            var28_53.setParameter("userRegistryType", this.userRegistryType);
            var28_53.setParameter("useRegistryServerId", new Boolean(false));
            var28_53.execute();
            var29_59 = var28_53.getCommandResult();
            if (!var29_59.isSuccessful()) ** GOTO lbl580
            if (((Boolean)var29_59.getResult()).booleanValue()) {
                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Successfully set useRegistryServerId to false");
                }
            } else {
                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Could not successfully set useRegistryServerId to false");
                }
                var30_60 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionUseRegistryServerId", null);
                var6_5.addWarnings((String)var30_60);
                var6_5.setResult(new Boolean(false));
                var6_5.setException(new CommandException((String)var30_60));
                var7_6.discard(var8_7);
                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                }
                return;
lbl580:
                // 1 sources

                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Could not successfully set useRegistryServerId to false");
                }
                var30_60 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionUseRegistryServerId", null);
                var6_5.addWarnings((String)var30_60);
                var6_5.setResult(new Boolean(false));
                var6_5.setException(new CommandException((String)var30_60));
                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                }
                return;
            }
            var28_53 = var27_46.createCommand("addAdminIdToUserRegObj");
            var28_53.setConfigSession(var8_7);
            var28_53.setParameter("adminUser", this.adminName);
            var28_53.setParameter("registryType", this.userRegistryType);
            var28_53.execute();
            var29_59 = var28_53.getCommandResult();
            if (!var29_59.isSuccessful()) ** GOTO lbl606
            if (((Boolean)var29_59.getResult()).booleanValue()) {
                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Successfully set adminId in user registry object");
                }
            } else {
                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Could not successfully set adminId in user registry object");
                }
                var30_60 = this.getMsg(ApplyWizardSettings.resBundle, "security.profiletask.FailedAddAdminId", null);
                var6_5.addWarnings((String)var30_60);
                var6_5.setResult(new Boolean(false));
                return;
lbl606:
                // 1 sources

                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Could not successfully set adminId in user registry object");
                }
                var30_60 = this.getMsg(ApplyWizardSettings.resBundle, "security.profiletask.FailedAddAdminId", null);
                var6_5.addWarnings((String)var30_60);
                var6_5.setResult(new Boolean(false));
                return;
            }
            var6_5.setResult(new Boolean(true));
        }
        catch (Throwable var10_10) {
            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                Tr.debug(ApplyWizardSettings.tc, var10_10.toString());
                Tr.debug(ApplyWizardSettings.tc, var10_10.getMessage());
            }
            var11_12 = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
            var11_12 = var11_12.concat(": ");
            var11_12 = var11_12.concat(var10_10.getMessage());
            var6_5.addWarnings(var11_12);
            var6_5.setResult(new Boolean(false));
            var6_5.setException(new CommandException(var11_12));
        }
        if (ApplyWizardSettings.tc.isEntryEnabled()) {
            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
        }
    }
}

