/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.ldap.Filter;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class SetLdapConfig
extends Properties {
    private static final TraceComponent tc = Tr.register(SetLdapConfig.class, null, "com.ibm.ejs.resources.security");
    private static Properties defaults;
    public static final String LDAP_BASEDN = "ldap.basedn";
    public static final String LDAP_TYPE = "dirType";
    public static final String ROOT_DSE = "root.dse";
    public static final String SUN_LDAP_SPI = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String SSL = "ssl";
    public static final String SSL_ENABLED = "sslEnabled";
    public static final String SSL_CONFIG = "sslConfig";
    public static final String INITIAL_CTX_FACTORY = "java.naming.factory.initial";
    public static Properties ldapProperties;

    public SetLdapConfig() {
    }

    public SetLdapConfig(Properties properties) {
        String string;
        Object object;
        this.setLdapProperties(properties);
        this.put(INITIAL_CTX_FACTORY, SUN_LDAP_SPI);
        this.put("com.ibm.websphere.security.ldap.recursiveSearch", "false");
        Boolean bl = this.getSSLEnabled();
        this.put("com.sun.jndi.ldap.connect.timeout", "60000");
        Object object2 = properties.keys();
        while (object2.hasMoreElements()) {
            String string2;
            object = object2.nextElement();
            if (object.equals("java.naming.security.credentials")) {
                string2 = null;
                string = (String)properties.get(object);
                try {
                    string2 = PasswordUtil.decode(string);
                }
                catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                    string2 = string;
                }
                catch (Exception exception) {
                    string2 = string;
                }
                this.put(object, string2);
                continue;
            }
            if (object.equals(LDAP_BASEDN)) {
                string2 = (String)properties.get(object);
                if (string2 != null && string2.length() > 2) {
                    string2 = RegistryUtil.removeDNSpace(string2, 0);
                }
                this.put(object, string2);
                continue;
            }
            this.put(object, properties.get(object));
        }
        this.configureSSL();
        object2 = this.getDirectoryUrl();
        object = "://";
        int n = ((String)object2).lastIndexOf((String)object);
        n += ((String)object).length();
        n = ((String)object2).indexOf(47, n);
        string = "";
        if (n != -1) {
            string = ((String)object2).substring(n + 1);
            object2 = ((String)object2).substring(0, n + 1);
        }
        if (object2 != null && (((String)object2).endsWith(":0") || ((String)object2).endsWith(":0/"))) {
            int n2 = ((String)object2).lastIndexOf(":0");
            object2 = ((String)object2).substring(0, n2);
        }
        this.put("java.naming.provider.url", object2);
        this.setAuthenticationCredentials(this.getAuthenticationCredentials());
    }

    private void configureSSL() {
        Boolean bl = this.getSSLEnabled();
        if (bl != null && bl.booleanValue()) {
            this.remove("com.sun.jndi.ldap.connect.timeout");
            this.put("java.naming.ldap.factory.socket", "com.ibm.ws.security.registry.ldap.ValidateLdapSSLSocketFactory");
            this.put("java.naming.security.protocol", SSL);
        }
    }

    public synchronized Object get(Object object) {
        Object object2 = super.get(object);
        return object2 == null && defaults != null ? defaults.get(object) : object2;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 != null) {
            return super.put(object, object2);
        }
        Object object3 = this.get(object);
        this.remove(object);
        return object3;
    }

    public String getDirectoryUrl() {
        return this.getProperty("java.naming.provider.url");
    }

    public void setDirectoryUrl(String string) {
        if (string != null) {
            this.put("java.naming.provider.url", string);
        }
    }

    public String getBaseDn() {
        String string = this.getProperty(LDAP_BASEDN);
        if (string != null) {
            return string;
        }
        return "";
    }

    public String getAuthenticationPrincipal() {
        return this.getProperty("java.naming.security.principal");
    }

    public Boolean getSSLEnabled() {
        Object object = this.get(SSL_ENABLED);
        Boolean bl = null;
        if (object != null) {
            if (object.toString().equals("true") || object.toString().equals("false")) {
                bl = new Boolean(object.toString());
            }
        } else {
            bl = new Boolean(false);
        }
        return bl;
    }

    public Properties getSSLConfig() {
        Properties properties = (Properties)this.get(SSL_CONFIG);
        return properties;
    }

    public void setAuthenticationPrincipal(String string) {
        if (string != null) {
            this.put("java.naming.security.principal", string);
        } else {
            this.remove("java.naming.security.principal");
            this.setAuthenticationCredentials(null);
        }
    }

    public String getAuthenticationCredentials() {
        return this.getProperty("java.naming.security.credentials");
    }

    public void setAuthenticationCredentials(String string) {
        if (string != null) {
            this.put("java.naming.security.authentication", "simple");
            this.put("java.naming.security.credentials", string);
        } else {
            this.put("java.naming.security.authentication", "none");
            this.remove("java.naming.security.credentials");
        }
    }

    public String getDirectoryType() {
        return this.getProperty(LDAP_TYPE);
    }

    public void setDirectoryType(String string) {
        this.put(LDAP_TYPE, string);
    }

    public String getDirectoryFactory() {
        return this.getProperty(INITIAL_CTX_FACTORY);
    }

    public boolean isRecursiveSearchEnabled() {
        String string = this.getProperty("com.ibm.websphere.security.ldap.recursiveSearch");
        return string != null && string.equalsIgnoreCase("true");
    }

    public void setDirectoryFactory(String string) {
        this.put(INITIAL_CTX_FACTORY, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext getRootDSE() throws NamingException {
        InitialDirContext initialDirContext = (InitialDirContext)this.get(ROOT_DSE);
        if (initialDirContext == null) {
            SetLdapConfig setLdapConfig = this;
            synchronized (setLdapConfig) {
                if (initialDirContext == null) {
                    initialDirContext = new InitialDirContext(this);
                    this.setRootDSE(initialDirContext);
                }
            }
        }
        return initialDirContext;
    }

    private synchronized void setRootDSE(DirContext dirContext) {
        DirContext dirContext2 = (DirContext)(dirContext != null ? this.put(ROOT_DSE, dirContext) : this.remove(ROOT_DSE));
        if (dirContext2 != null) {
            try {
                dirContext2.close();
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.security.registry.ldap.LdapConfig.setRootDSE", "251", this);
            }
        }
    }

    public void disconnect() {
        this.setRootDSE(null);
    }

    public Filter getFilter(String string) {
        Object object = this.get(string);
        Filter filter = null;
        if (object instanceof Filter) {
            filter = (Filter)object;
        } else {
            String string2 = this.getProperty(string);
            if (string2 != null) {
                filter = new Filter(string2);
            }
            if (filter != null) {
                this.put(string, filter);
            }
        }
        return filter;
    }

    public String getLogicRealm() {
        String string = this.getProperty("com.ibm.websphere.security.ldap.logicRealm");
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    public int getMaxConcurrentSearchNumberPerConnection() {
        int n;
        block5: {
            String string = this.getProperty("com.ibm.websphere.security.ldap.maxConcurrentSearchPerConnection");
            n = 5;
            if (string != null && string.length() > 0) {
                try {
                    n = new Integer(string);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "maximum number of 6 concurrent search for a connection is set to default.");
                }
            }
        }
        if (n < 5) {
            n = 5;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "maximum number of concurrent search for a connection is set to " + n);
        }
        return n;
    }

    public int getSizeOfIdleContextPool() {
        int n;
        block6: {
            String string = this.getProperty("com.ibm.websphere.security.ldap.maxIdleContextPool");
            n = 30;
            if (string != null && string.length() > 0) {
                try {
                    n = new Integer(string);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Mximum 30 idle Context instances may be maintianed by default.");
                }
            }
        }
        if (n < 6) {
            n = 6;
        }
        if (n < this.getMaxConcurrentSearchNumberPerConnection()) {
            n = this.getMaxConcurrentSearchNumberPerConnection() + 1;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "maximum number of idle context instances is " + n);
        }
        return n;
    }

    public void setLdapProperties(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLdapProperties");
        }
        ldapProperties = properties;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ldapProperties = " + ldapProperties.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLdapProperties");
        }
    }

    public static Properties getLdapProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLdapProperties");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ldapProperties = " + ldapProperties.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLdapProperties");
        }
        return ldapProperties;
    }
}

