/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.security.admintask.SetLdapConfig;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class ValidateLDAPConnection
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ValidateLDAPConnection.class, "ValidateLDAPConnection", "com.ibm.ws.security.admintask");
    private String hostName = null;
    private Integer portNumber = new Integer(389);
    private Boolean sslEnabled = null;
    private String sslAlias = null;
    private String type = null;
    private String serverID = null;
    private String baseDN = null;
    private String bindDN = null;
    private String bindPwd = null;
    private String serverPwd = null;
    private SetLdapConfig ldapConfig;
    static String ldapPropsFile = "/com/ibm/websphere/security/ldap/LdapConfig.properties";
    private static String objectFilter = "(objectclass=*)";
    public static final String GROUP_FILTER = "group.filter";
    private static final String iPlanet_OBJECT_FILTER = "(|(objectclass=*)(objectclass=ldapsubentry))";
    private static final String MS_OBJECT_FILTER = "(objectCategory=*)";

    public ValidateLDAPConnection(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ValidateLDAPConnection(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return MessageFormatHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        this.hostName = (String)this.getParameter("hostname");
        if ((Integer)this.getParameter("port") != null) {
            this.portNumber = (Integer)this.getParameter("port");
        }
        this.sslEnabled = (Boolean)this.getParameter("sslEnabled");
        this.sslAlias = (String)this.getParameter("sslAlias");
        this.type = (String)this.getParameter("type");
        this.baseDN = SecurityConfig.variableMapExpand((String)this.getParameter("baseDN"));
        this.bindDN = (String)this.getParameter("bindDN");
        this.bindPwd = (String)this.getParameter("bindPassword");
        if (this.hostName != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "hostName = " + this.hostName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "unsuccessful at getting TaskCommandResultImpl afterStepsExecuted");
            }
            return;
        }
        try {
            Object object;
            Object object2;
            Properties properties;
            String string = "ldap://";
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            if (this.hostName.indexOf(":") != -1) {
                stringBuffer.append(string).append("[" + this.hostName + "]");
            } else {
                stringBuffer.append(string).append(this.hostName);
            }
            if (this.portNumber != null && this.portNumber > 0) {
                stringBuffer.append(":" + this.portNumber);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ldapUrl = " + stringBuffer.toString());
            }
            String string2 = new String(this.hostName + ":" + this.portNumber);
            Properties properties2 = new Properties();
            if (this.type != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ldapServerType = " + this.type);
                }
                properties = null;
                try {
                    object2 = this.getClass().getResourceAsStream(ldapPropsFile);
                    properties = new Properties();
                    properties.load((InputStream)object2);
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IOException opening ldapPropsFile");
                    }
                    iOException.printStackTrace();
                    taskCommandResultImpl.setResult(new Boolean(false));
                    String string3 = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
                    taskCommandResultImpl.setException(new CommandException(iOException, string3));
                    return;
                }
                if (properties != null) {
                    if (this.type.equalsIgnoreCase("IBM_DIRECTORY_SERVER")) {
                        n = 0;
                    } else if (this.type.equalsIgnoreCase("SECUREWAY")) {
                        n = 1;
                    } else if (this.type.equalsIgnoreCase("IPLANET")) {
                        n = 2;
                    } else if (this.type.equalsIgnoreCase("NETSCAPE")) {
                        n = 3;
                    } else if (this.type.equalsIgnoreCase("DOMINO502")) {
                        n = 4;
                    } else if (this.type.equalsIgnoreCase("NDS")) {
                        n = 5;
                    } else if (this.type.equalsIgnoreCase("ACTIVE_DIRECTORY")) {
                        n = 6;
                    } else if (this.type.equalsIgnoreCase("CUSTOM")) {
                        n = 7;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ldapServerTypeValue = " + n);
                    }
                    switch (n) {
                        case 0: {
                            properties2.setProperty("user.filter", properties.getProperty("ibm_dir_server.user.filter"));
                            properties2.setProperty(GROUP_FILTER, properties.getProperty("ibm_dir_server.group.filter"));
                            properties2.setProperty("user.idmap", properties.getProperty("ibm_dir_server.user.idmap"));
                            properties2.setProperty("group.idmap", properties.getProperty("ibm_dir_server.group.idmap"));
                            properties2.setProperty("groupmember.idmap", properties.getProperty("ibm_dir_server.groupmember.idmap"));
                            break;
                        }
                        case 1: {
                            properties2.setProperty("user.filter", properties.getProperty("secureway.user.filter"));
                            properties2.setProperty(GROUP_FILTER, properties.getProperty("secureway.group.filter"));
                            properties2.setProperty("user.idmap", properties.getProperty("secureway.user.idmap"));
                            properties2.setProperty("group.idmap", properties.getProperty("secureway.group.idmap"));
                            properties2.setProperty("groupmember.idmap", properties.getProperty("secureway.groupmember.idmap"));
                            break;
                        }
                        case 2: {
                            properties2.setProperty("user.filter", properties.getProperty("iplanet.user.filter"));
                            properties2.setProperty(GROUP_FILTER, properties.getProperty("iplanet.group.filter"));
                            properties2.setProperty("user.idmap", properties.getProperty("iplanet.user.idmap"));
                            properties2.setProperty("group.idmap", properties.getProperty("iplanet.group.idmap"));
                            properties2.setProperty("groupmember.idmap", properties.getProperty("iplanet.groupmember.idmap"));
                            break;
                        }
                        case 3: {
                            properties2.setProperty("user.filter", properties.getProperty("netscape.user.filter"));
                            properties2.setProperty(GROUP_FILTER, properties.getProperty("netscape.group.filter"));
                            properties2.setProperty("user.idmap", properties.getProperty("netscape.user.idmap"));
                            properties2.setProperty("group.idmap", properties.getProperty("netscape.group.idmap"));
                            properties2.setProperty("groupmember.idmap", properties.getProperty("netscape.groupmember.idmap"));
                            break;
                        }
                        case 4: {
                            properties2.setProperty("user.filter", properties.getProperty("domino50.user.filter"));
                            properties2.setProperty(GROUP_FILTER, properties.getProperty("domino50.group.filter"));
                            properties2.setProperty("user.idmap", properties.getProperty("domino50.user.idmap"));
                            properties2.setProperty("group.idmap", properties.getProperty("domino50.group.idmap"));
                            properties2.setProperty("groupmember.idmap", properties.getProperty("domino50.groupmember.idmap"));
                            break;
                        }
                        case 6: {
                            properties2.setProperty("user.filter", properties.getProperty("actived.user.filter"));
                            properties2.setProperty(GROUP_FILTER, properties.getProperty("actived.group.filter"));
                            properties2.setProperty("user.idmap", properties.getProperty("actived.user.idmap"));
                            properties2.setProperty("group.idmap", properties.getProperty("actived.group.idmap"));
                            properties2.setProperty("groupmember.idmap", properties.getProperty("actived.groupmember.idmap"));
                            break;
                        }
                        case 5: {
                            properties2.setProperty("user.filter", properties.getProperty("edirectory.user.filter"));
                            properties2.setProperty(GROUP_FILTER, properties.getProperty("edirectory.group.filter"));
                            properties2.setProperty("user.idmap", properties.getProperty("edirectory.user.idmap"));
                            properties2.setProperty("group.idmap", properties.getProperty("edirectory.group.idmap"));
                            properties2.setProperty("groupmember.idmap", properties.getProperty("edirectory.groupmember.idmap"));
                            break;
                        }
                    }
                }
            }
            properties2.setProperty("security.registry.ldap.reuseConn", "true");
            properties2.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
            properties2.setProperty("security.registry.ldap.searchTimeLimit", "120");
            properties2.setProperty("dirType", this.type);
            properties2.setProperty("LDAP.server.realm", string2);
            properties2.setProperty("ldap.basedn", this.baseDN);
            properties2.setProperty("java.naming.provider.url", stringBuffer.toString());
            properties2.setProperty("sslEnabled", this.sslEnabled.toString());
            if (this.sslAlias != null) {
                properties2.setProperty("sslAlias", this.sslAlias);
                properties2.put("LDAP.validation", "true");
                properties2.put("security.registry.ldap.SSLAlias", this.sslAlias);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LDAP.validation is set to truesecurity.registry.ldap.SSLAlias is set to" + this.sslAlias);
                }
            }
            if (this.bindDN != null) {
                properties2.setProperty("java.naming.security.principal", this.bindDN);
            }
            if (this.bindPwd != null) {
                properties2.setProperty("java.naming.security.credentials", this.bindPwd);
            }
            properties2.setProperty("certificate.map.mode", "exactDNMode");
            properties = SecurityConfig.expandProps(properties2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "props = " + properties.toString());
            }
            try {
                this.ldapConfig = new SetLdapConfig(properties);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception creating ldapConfig");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, exception.toString());
                }
                String string4 = exception.toString();
                taskCommandResultImpl.addWarnings(string4);
                taskCommandResultImpl.setResult(new Boolean(false));
                taskCommandResultImpl.setException(new CommandException(string4));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            object2 = new SetLdapConfig(this.ldapConfig);
            if (n != 7) {
                object = ((SetLdapConfig)object2).getFilter(GROUP_FILTER).prepare("*").toLowerCase();
                if (((String)object).indexOf("ldapsubentry") > -1) {
                    objectFilter = iPlanet_OBJECT_FILTER;
                }
                if (((String)object).indexOf("objectcategory") > -1) {
                    objectFilter = MS_OBJECT_FILTER;
                }
            }
            object = new SearchControls();
            ((SearchControls)object).setSearchScope(0);
            ((SearchControls)object).setReturningObjFlag(false);
            ((SearchControls)object).setTimeLimit(120);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "baseDN: " + this.baseDN + " objectFilter = " + objectFilter);
            }
            try {
                InitialDirContext initialDirContext = new InitialDirContext((Hashtable<?, ?>)object2);
                NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(this.baseDN, objectFilter, (SearchControls)object);
                initialDirContext.close();
                taskCommandResultImpl.setResult(new Boolean(true));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            catch (AuthenticationNotSupportedException authenticationNotSupportedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "javax.naming.AuthenticationNotSupportedException");
                }
                String string5 = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
                string5 = string5.concat(": AuthenticationNotSupportedException: ");
                string5 = string5.concat(authenticationNotSupportedException.getExplanation());
                taskCommandResultImpl.addWarnings(string5);
                taskCommandResultImpl.setResult(new Boolean(false));
                taskCommandResultImpl.setException(new CommandException(string5));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            catch (AuthenticationException authenticationException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "javax.naming.AuthenticationException" + authenticationException.getExplanation());
                }
                String string6 = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
                string6 = string6.concat(": AuthenticationException: ");
                string6 = string6.concat(authenticationException.getExplanation());
                taskCommandResultImpl.addWarnings(string6);
                taskCommandResultImpl.setResult(new Boolean(false));
                taskCommandResultImpl.setException(new CommandException(string6));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            catch (NamingException namingException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "javax.naming.NamingException " + namingException.getExplanation());
                }
                namingException.printStackTrace();
                String string7 = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
                string7 = string7.concat(": NamingException: ");
                string7 = string7.concat(namingException.getExplanation());
                string7 = string7.concat(" " + namingException.getCause());
                taskCommandResultImpl.addWarnings(string7);
                taskCommandResultImpl.setResult(new Boolean(false));
                taskCommandResultImpl.setException(new CommandException(string7));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            taskCommandResultImpl.setResult(new Boolean(false));
            String string = this.getMsg(resBundle, "security.admintask.ExceptionLDAPConnect", null);
            taskCommandResultImpl.setException(new CommandException(exception, string));
            return;
        }
    }
}

