/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.CacheObject;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;

public class AuthCache
extends Cache
implements SecurityCache {
    private static final TraceComponent tc = Tr.register(AuthCache.class, "Security", "com.ibm.ejs.resources.security");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static AuthCache authCache = null;
    private static long defaultTimeout = 0L;
    private final ContextManager contextManager;
    private final WSCredentialTokenMapperInterface credTokenMapper;
    private long cushion = -1L;
    protected static boolean authCacheEnabled = true;
    protected static boolean allowLookupByBasicAuth = true;
    protected static boolean customCacheKeySupport = true;
    public static final String AUTH_CACHE_ENABLED = "com.ibm.websphere.security.util.authCacheEnabled";
    public static final String AUTH_CACHE_SIZE = "com.ibm.websphere.security.util.authCacheSize";
    public static final String AUTH_CACHE_MAX_SIZE = "com.ibm.websphere.security.util.authCacheMaxSize";
    public static final String AUTH_CACHE_SUPPORT_CUSTOM_KEY = "com.ibm.websphere.security.util.authCacheCustomKeySupport";

    public static synchronized AuthCache getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (authCache == null) {
            String string;
            Long l = (Long)SecurityConfig.getConfig().getValue("security.CacheTimeout");
            long l2 = l;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "security cache timeout is " + l2);
            }
            Cache.setDefaultTimeout(l2 * 1000L);
            String string2 = System.getProperty(AUTH_CACHE_SIZE);
            if (string2 == null || string2.equals("") || new Integer(string2) < 0) {
                string2 = "200";
            }
            if ((string = System.getProperty(AUTH_CACHE_MAX_SIZE)) == null || string.equals("") || new Integer(string) < 0) {
                string = "25000";
            }
            authCache = new AuthCache(new Integer(string2), new Integer(string), l2 * 1000L);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", authCache);
        }
        return authCache;
    }

    private AuthCache(int n, int n2, long l) {
        super(n, n2, l);
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{new Integer(n), new Long(l)});
        }
        authCacheEnabled = (string = System.getProperty(AUTH_CACHE_ENABLED)) == null ? true : !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no");
        allowLookupByBasicAuth = string == null || !string.equalsIgnoreCase("BasicAuthDisabled");
        String string2 = System.getProperty(AUTH_CACHE_SUPPORT_CUSTOM_KEY);
        if (string2 != null && (string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("no"))) {
            customCacheKeySupport = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Custom Cache Key support is disabled.");
            }
        } else {
            customCacheKeySupport = true;
        }
        this.contextManager = ContextManagerFactory.getInstance();
        this.credTokenMapper = WSCredentialTokenMapper.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthCache", this);
        }
    }

    public void removeEntry(String string, String string2) throws CacheException {
        String string3;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntry", new Object[]{string, string2});
        }
        if (string == null) {
            string = this.contextManager.getDefaultRealm();
        }
        if (string2 != null && (object = this.get(string3 = string + ":" + string2)) != null && object instanceof CacheObject) {
            this.removeEntry((CacheObject)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry");
        }
    }

    public void removeEntry(Object object) throws CacheException {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntry", new Object[]{object});
        }
        if (object != null && (object2 = this.get(object)) != null && object2 instanceof CacheObject) {
            this.removeEntry((CacheObject)object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry");
        }
    }

    public void removeEntry(CacheObject cacheObject) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntry", cacheObject);
        }
        if (cacheObject != null) {
            try {
                Object[] objectArray = cacheObject.getKeyArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.remove(objectArray[i]);
                    if (!(objectArray[i] instanceof ByteArray)) continue;
                    this.credTokenMapper.invalidateDistributedObject((ByteArray)objectArray[i]);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.util.AuthCache.removeEntry", "249", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception removing credential from cache", exception);
                }
                throw new CacheException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry");
        }
    }

    public void removeAllEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllEntries");
        }
        this.clearAllEntries();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllEntries");
        }
    }

    public Subject getSubject(byte[] byArray) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject", byArray);
        }
        Subject subject = null;
        if (authCacheEnabled) {
            ByteArray byteArray = new ByteArray(byArray);
            subject = this.getSubject(byteArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", subject);
        }
        return subject;
    }

    public Subject getSubject(Object object) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject", object);
        }
        Subject subject = null;
        if (authCacheEnabled) {
            if (object != null && object instanceof String && ((String)object).equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cache Key value is null string. Ignore it.");
                }
            } else {
                Object object2 = null;
                try {
                    object2 = this.get(object);
                    if (object2 != null && object2 instanceof CacheObject) {
                        subject = ((CacheObject)object2).getSubject();
                        Map map = ((CacheObject)object2).getPropTokenMap();
                        if (map != null) {
                            this.setPropTokenMapOnThread(map);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.util.AuthCache.getSubject", "334", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception trying to get object from cache", exception);
                    }
                    throw new CacheException(exception.getMessage(), exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", subject);
        }
        return subject;
    }

    public Subject getSubject(String string, String string2, String string3) throws CacheException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject", new Object[]{string, string2, "xxxxx"});
        }
        if (string2 == null || string3 == null || !authCacheEnabled || !allowLookupByBasicAuth) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubject", null);
            }
            return null;
        }
        if (string == null) {
            string = this.contextManager.getDefaultRealm();
        }
        Subject subject = null;
        try {
            object2 = null;
            try {
                object2 = ServerCredSigner.getInstance().getOneWayHash(string3);
                if (tc.isDebugEnabled() && object2 != null) {
                    Tr.debug(tc, "One-way password hash using SHA is: " + new BigInteger((byte[])object2));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.util.AuthCache.getSubject", "379", this);
                Tr.error(tc, "security.sas.encode.error", new Object[]{exception});
            }
            object2 = (byte[])(object2 != null ? object2 : string3.getBytes());
            object = new BasicAuthCacheData();
            ((BasicAuthCacheData)object).realm = string;
            ((BasicAuthCacheData)object).userId = string2;
            ((BasicAuthCacheData)object).password = object2;
            Object object3 = this.get(object);
            if (object3 != null && object3 instanceof CacheObject) {
                CacheObject cacheObject = (CacheObject)object3;
                subject = cacheObject.getSubject();
                Map map = cacheObject.getPropTokenMap();
                if (map != null) {
                    this.setPropTokenMapOnThread(map);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.util.AuthCache.getSubject", "409", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authentication failed", exception);
            }
            throw new CacheException(exception.getMessage(), exception);
        }
        if (subject == null && (object = this.get(object2 = (Object)(string + ":" + string2))) != null && object instanceof CacheObject) {
            this.removeEntry((CacheObject)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleared entries from AuthCache for user: " + string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", subject);
        }
        return subject;
    }

    public Subject getSubject(String string, String string2) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject", new Object[]{string, string2});
        }
        if (!authCacheEnabled || string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubject", null);
            }
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
            }
            securityManager.checkPermission(MAP_CREDENTIAL);
        }
        Subject subject = null;
        if (string == null) {
            string = this.contextManager.getDefaultRealm();
        }
        try {
            String string3 = string + ":" + string2;
            Object object = this.get(string3);
            if (object != null && object instanceof CacheObject) {
                CacheObject cacheObject = (CacheObject)object;
                if (customCacheKeySupport && cacheObject.getRevocationKey()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found following revocation object, replaced by null.", cacheObject.getSubject());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSubject", null);
                    }
                    return null;
                }
                subject = cacheObject.getSubject();
                Map map = cacheObject.getPropTokenMap();
                if (map != null) {
                    this.setPropTokenMapOnThread(map);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.util.AuthCache.getSubject", "493", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authentication failed", exception);
            }
            throw new CacheException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", subject);
        }
        return subject;
    }

    public void updateEntry(Subject subject, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateEntry", new Object[]{subject, byArray});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateEntry");
        }
    }

    public void updateEntry(Object object, Map map) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateEntry", new Object[]{object, map});
            }
            if (!authCacheEnabled || object == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updateEntry (no updates)");
                }
                return;
            }
            try {
                Object object2 = this.get(object);
                if (object2 != null && object2 instanceof CacheObject) {
                    CacheObject cacheObject = (CacheObject)object2;
                    if (map != null) {
                        Map map2 = null;
                        map2 = this.clonePropTokenMap(map);
                        if (map2 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cache entry updated with prop token map.");
                            }
                            cacheObject.setPropTokenMap(map2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.util.AuthCache.updateEntry", "554", this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Updating the propagation tokens into the AuthCache failed.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateEntry");
        }
    }

    public void insert(Subject subject) {
        this.insert(subject, null, null);
    }

    public void insert(Subject subject, Object[] objectArray) {
        this.insert(subject, null, objectArray);
    }

    public void insert(Subject subject, String string) {
        this.insert(subject, string, null);
    }

    public void insert(Subject subject, String string, Object[] objectArray) {
        this.insert(subject, null, string, objectArray);
    }

    public void insert(Subject subject, String string, String string2, Object[] objectArray) {
        block36: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "insert", new Object[]{subject, string, string2 == null ? string2 : "xxxxx", objectArray});
            }
            if (!authCacheEnabled) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "No insert happend. Exiting as AuthCache is disabled");
                }
                return;
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "insert");
                }
                return;
            }
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            CacheObject cacheObject = new CacheObject();
            cacheObject.setSubject(subject);
            try {
                Object object;
                Object object2;
                boolean bl = false;
                if (wSCredential != null) {
                    Map map;
                    Object object3;
                    String string3;
                    String string4;
                    String string5;
                    String string6;
                    ByteArray byteArray;
                    byte[] byArray;
                    Object object4;
                    SingleSignonToken singleSignonToken;
                    object2 = wSCredential.getCredentialToken();
                    object = new ByteArray((byte[])object2);
                    if (object != null) {
                        cacheObject.setKey(object);
                        this.insert(object, cacheObject);
                    }
                    if ((singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject)) != null) {
                        object4 = new ByteArray(singleSignonToken.getBytes());
                        cacheObject.setKey(object4);
                        this.insert(object4, cacheObject);
                    }
                    if ((object4 = this.credTokenMapper.getCacheKeyFromHashtable(subject)) != null && customCacheKeySupport) {
                        bl = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found Custom Cache Key");
                        }
                        cacheObject.setKey(object4);
                        this.insert(object4, cacheObject);
                    }
                    if ((byArray = (byte[])this.contextManager.get("CacheKeyAttribute")) != null) {
                        byteArray = new ByteArray(byArray);
                        cacheObject.setKey(byteArray);
                        this.insert(byteArray, cacheObject);
                    }
                    if ((byteArray = (ByteArray)this.contextManager.get("ZOSCacheKey")) != null) {
                        cacheObject.setKey(byteArray);
                        this.insert(byteArray, cacheObject);
                    }
                    if ((string6 = wSCredential.getRealmName() + ":" + wSCredential.getSecurityName()) != null) {
                        cacheObject.setKey(string6);
                        if (bl) {
                            cacheObject.setRevocationKey(true);
                        }
                        this.insert(string6, cacheObject);
                    }
                    if (string != null && !string.equals(wSCredential.getSecurityName())) {
                        string6 = wSCredential.getRealmName() + ":" + string;
                        cacheObject.setKey(string6);
                        if (bl) {
                            cacheObject.setRevocationKey(true);
                        }
                        this.insert(string6, cacheObject);
                    }
                    if ((string5 = this.credTokenMapper.createSubjectUniqueID(subject)) != null) {
                        cacheObject.setKey(string5);
                        this.insert(string5, cacheObject);
                    }
                    if ((string4 = (String)wSCredential.get("security.login_uid")) != null) {
                        string4 = wSCredential.getRealmName() + ":" + string4;
                        cacheObject.setKey(string4);
                        if (bl) {
                            cacheObject.setRevocationKey(true);
                        }
                        this.insert(string4, cacheObject);
                    }
                    if ((string3 = wSCredential.getRealmName() + ":" + wSCredential.getUniqueSecurityName()) != null) {
                        cacheObject.setKey(string3);
                        if (bl) {
                            cacheObject.setRevocationKey(true);
                        }
                        this.insert(string3, cacheObject);
                    }
                    if (objectArray != null && objectArray.length > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Additional lookup keys size: " + objectArray.length);
                        }
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Additional lookup value: " + objectArray[i]);
                            }
                            if (objectArray[i] == null) continue;
                            if (objectArray[i] instanceof byte[]) {
                                object3 = new ByteArray((byte[])objectArray[i]);
                                cacheObject.setKey(object3);
                                this.insert(object3, cacheObject);
                                continue;
                            }
                            cacheObject.setKey(objectArray[i]);
                            this.insert(objectArray[i], cacheObject);
                        }
                    }
                    if ((map = this.contextManager.getPropagationTokens()) != null) {
                        object3 = null;
                        object3 = this.clonePropTokenMap(map);
                        if (object3 != null) {
                            cacheObject.setPropTokenMap((Map)object3);
                        }
                    }
                }
                if (string2 == null || bl) break block36;
                object2 = new BasicAuthCacheData();
                object2.realm = wSCredential.getRealmName();
                if (object2.realm == null) {
                    object2.realm = this.contextManager.getDefaultRealm();
                }
                object2.userId = wSCredential.getSecurityName();
                object = null;
                try {
                    object = ServerCredSigner.getInstance().getOneWayHash(string2);
                    if (tc.isDebugEnabled() && object != null) {
                        Tr.debug(tc, "One-way password hash using SHA is: " + new BigInteger((byte[])object));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.util.AuthCache.insert", "802", this);
                    Tr.error(tc, "security.sas.encode.error", new Object[]{exception});
                }
                object2.password = (byte[])(object != null ? object : (Object)string2.getBytes());
                cacheObject.setKey(object2);
                this.insert(object2, cacheObject);
                if (string != null && !string.equals(object2.userId)) {
                    object2.userId = string;
                    cacheObject.setKey(object2);
                    this.insert(object2, cacheObject);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.util.AuthCache.insert", "822", this);
                if (!tc.isDebugEnabled()) break block36;
                Tr.debug(tc, "Exception inserting Subject into cache: ", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insert");
        }
    }

    public long getCushion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCushion");
        }
        if (this.cushion == -1L) {
            long l;
            long l2 = Cache.getDefaultTimeout();
            long l3 = 0L;
            long l4 = (Integer)SecurityConfig.getConfig().getValue("security.CacheCushionMin") * 60 * 1000 - 5000;
            long l5 = (Integer)SecurityConfig.getConfig().getValue("security.CacheCushionMax") * 60 * 1000;
            if (l5 <= 0L) {
                l5 = 600000L;
            }
            if (((Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred")).booleanValue()) {
                String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                l3 = string.equals("ICSF") ? (Long)SecurityConfig.getConfig().getValue("remove.ICSF") * 60L * 1000L : (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate") * 60L * 1000L;
            }
            this.cushion = l3 > 0L ? ((l = l3 / 5L) < l4 ? l4 : (l > l5 ? l5 : l)) : 0L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCushion", new Long(this.cushion));
        }
        return this.cushion;
    }

    private void setPropTokenMapOnThread(Map map) {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setPropTokenMapOnThread", map);
            }
            if (map != null && map.size() > 0) {
                try {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        PropagationToken propagationToken = (PropagationToken)map.get(string);
                        if (propagationToken == null) continue;
                        if (string.equals("com.ibm.ws.security.token.PropagationTokenImpl:1")) {
                            PropagationToken propagationToken2 = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                            if (propagationToken2 == null) {
                                this.contextManager.setPropagationToken(string, (PropagationToken)propagationToken.clone());
                                continue;
                            }
                            Enumeration enumeration = propagationToken.getAttributeNames();
                            while (enumeration.hasMoreElements()) {
                                String[] stringArray;
                                String[] stringArray2;
                                String string2 = (String)enumeration.nextElement();
                                if (string2 == null || string2.equals("com.ibm.wsspi.security.propagation.callers") || string2.equals("com.ibm.wsspi.security.propagation.hosts") || (stringArray2 = WSSecurityHelper.getPropagationAttributes(string2)) != null || (stringArray = propagationToken.getAttributes(string2)) == null || stringArray.length <= 0) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding attributes for " + string2 + " to existing prop token");
                                }
                                for (int i = 0; i < stringArray.length; ++i) {
                                    WSSecurityHelper.addPropagationAttribute(string2, stringArray[i]);
                                }
                            }
                            continue;
                        }
                        this.contextManager.setPropagationToken(string, (PropagationToken)propagationToken.clone());
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.AuthCache.setPropTokenMapOnThread", "957", this);
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "Exception setting propagation tokens on thread", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropTokenMapOnThread");
        }
    }

    private Map clonePropTokenMap(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clonePropTokenMap", map);
        }
        HashMap<String, Object> hashMap = null;
        if (map != null && map.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cloning propagation tokens.");
            }
            hashMap = new HashMap<String, Object>();
            try {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    PropagationToken propagationToken = (PropagationToken)map.get(string);
                    if (propagationToken == null) continue;
                    hashMap.put(string, propagationToken.clone());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.AuthCache.clonePropTokenMap", "996", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception cloning propagation tokens.", new Object[]{exception});
                }
                hashMap = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clonePropTokenMap", hashMap);
        }
        return hashMap;
    }

    class BasicAuthCacheData {
        public String realm;
        public String userId;
        public byte[] password;

        BasicAuthCacheData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof BasicAuthCacheData)) {
                return false;
            }
            if (this.realm != null ? !this.realm.equals(((BasicAuthCacheData)object).realm) : ((BasicAuthCacheData)object).realm != null) {
                return false;
            }
            if (this.userId != null ? !this.userId.equals(((BasicAuthCacheData)object).userId) : ((BasicAuthCacheData)object).userId != null) {
                return false;
            }
            return Arrays.equals(this.password, ((BasicAuthCacheData)object).password);
        }

        public int hashCode() {
            return (this.realm + ":" + this.userId).hashCode();
        }

        public String toString() {
            return this.realm + ":" + this.userId;
        }
    }
}

