/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.ISecurityUtilityImpl.StateofCurrObj;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ISecurityUtilityImpl.ThreadContextImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.JaasLoginHelper;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.auth.WSSubjectWrapperImpl;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.internals.ContextManagerInternals;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.security.server.SecurityServerFactory;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws390.sm.smf.SmfJActivity;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.auth.WSSubjectWrapper;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSCredential;

public class ContextManagerImpl
implements ContextManager,
ContextManagerInternals,
SecurityServiceListener {
    private static final TraceComponent tc = Tr.register(ContextManagerImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final String DEFAULT_REALM = "<default>";
    private static final String EMPTY = "";
    private String WIM_UR = "WIMUserRegistry";
    private PlatformCredentialManager _platformCredManager;
    private static final WebSphereRuntimePermission GET_OWN_CRED_PERM = new WebSphereRuntimePermission("SecOwnCredentials");
    private static final WebSphereRuntimePermission GET_SERVER_CRED_PERM = new WebSphereRuntimePermission("ContextManager.getServerCredential");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final ThreadLocal threadLocStorage = new SecurityThreadLocal();
    private static final String DISABLE_AUTH_RETRY = "wssecurity.disableauthretry";
    private static ServerCredSigner scs = null;
    private AuditService _auditService = null;
    private Object _registryObject = null;
    private SecurityCache cache = null;
    private JaasLoginHelper jaasLoginHelper = null;
    private String regionUserid = System.getProperty("user.name");
    private SecurityConfiguration secConfig = null;
    private String SECURITY_REALM = "";
    private SecurityServer securityServer = null;
    private AuthenticationToken serverAuthToken = null;
    private AuthorizationToken serverAuthzToken = null;
    private WSCredential serverBACred = null;
    private Subject serverBASubject = null;
    private boolean serverSecurityEnabled = true;
    private SingleSignonToken serverSSOToken = null;
    private Subject serverSubject = null;
    private WSCredential serverTokenCred = null;
    private String serverUniqueIdentity = null;
    private boolean serverSubjectCreated = false;
    private ORB theORB = null;
    private VaultImpl vault = null;
    private WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private static final String URL_HANDLER_PROP = "java.protocol.handler.pkgs";
    private static final String PKGNAME_DELIMITER = "|";
    private boolean isEnabled = false;
    private boolean alreadyChecked = false;
    private boolean isAuthenticateSpecialMethodsEnabled = false;
    private boolean isSecurityServiceStarted = false;
    private static String unauthenticatedId = null;
    boolean refreshServerSubject = false;
    static /* synthetic */ Class class$com$ibm$ws$security$server$SecurityServer;

    public static synchronized void registerPackage(String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = System.getProperty(URL_HANDLER_PROP);
        if (string2 != null) {
            object = new StringTokenizer(string2, PKGNAME_DELIMITER);
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        object = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            ((StringBuffer)object).append(string3);
            if (!iterator.hasNext()) continue;
            ((StringBuffer)object).append('|');
        }
        System.setProperty(URL_HANDLER_PROP, ((StringBuffer)object).toString());
    }

    public ContextManagerImpl() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void addWSSubjectToCache(Subject subject) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWSSubjectToCache", subject);
        }
        if (subject != null && this.processIsServer() && this.isWSSubject(subject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding WSSubject to cache.");
            }
            this.cache.insert(subject);
            this.processSubjectForPropagationAfterLogin(subject, this.secConfig.getAuthMechAuthAlias());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWSSubjectToCache");
        }
    }

    public void addPropagationTokensToCacheObject(Object object, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPropagationTokensToCacheObject", object);
        }
        if (object != null && this.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding WSSubject to cache.");
            }
            this.cache.updateEntry(object, map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPropagationTokensToCacheObject");
        }
    }

    public WSCredential authenticate(String string, byte[] byArray) throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", new Object[]{string, byArray});
        }
        WSCredential wSCredential = null;
        try {
            Subject subject = this.login(string, byArray);
            wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "430", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(loginException));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(loginException.getMessage());
            authenticationFailedException.addException(loginException);
            throw authenticationFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "438", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(exception));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(exception.getMessage());
            authenticationFailedException.addException(exception);
            throw authenticationFailedException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate", wSCredential);
        }
        return wSCredential;
    }

    public WSCredential authenticate(String string, String string2, String string3) throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", new Object[]{string, string2, string3 == null ? null : "****"});
        }
        WSCredential wSCredential = null;
        try {
            Subject subject = this.login(string, string2, string3);
            wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "466", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(wSLoginFailedException));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(wSLoginFailedException.getMessage());
            authenticationFailedException.addException(wSLoginFailedException);
            throw authenticationFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "474", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(exception));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(exception.getMessage());
            authenticationFailedException.addException(exception);
            throw authenticationFailedException;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", wSCredential);
        }
        return wSCredential;
    }

    public WSCredential authenticate(WSCredential wSCredential) throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", wSCredential);
        }
        WSCredential wSCredential2 = null;
        try {
            Subject subject = this.login(wSCredential);
            wSCredential2 = SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "498", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(wSLoginFailedException));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(wSLoginFailedException.getMessage());
            authenticationFailedException.addException(wSLoginFailedException);
            throw authenticationFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "506", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(exception));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(exception.getMessage());
            authenticationFailedException.addException(exception);
            throw authenticationFailedException;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", wSCredential2);
        }
        return wSCredential2;
    }

    public boolean callerSubjectIsServerIdentity() {
        boolean bl;
        block20: {
            Object object;
            Serializable serializable;
            block19: {
                block18: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "callerSubjectIsServerIdentity");
                    }
                    bl = false;
                    if (this.serverUniqueIdentity == null) {
                        try {
                            serializable = this.getServerSubject();
                            object = SubjectHelper.getWSCredentialFromSubject((Subject)serializable);
                            this.serverUniqueIdentity = object.getAccessId();
                        }
                        catch (WSSecurityException wSSecurityException) {
                            FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.auth.ContextManagerImpl.callerSubjectIsServerIdentity", "535", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getServerSubject() failed", wSSecurityException);
                            }
                        }
                        catch (CredentialExpiredException credentialExpiredException) {
                            FFDCFilter.processException((Throwable)credentialExpiredException, "com.ibm.ws.security.auth.ContextManagerImpl.callerSubjectIsServerIdentity", "540", this);
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug(tc, "getRealmUniqueSecurityName() on server credential failed", credentialExpiredException);
                        }
                    }
                }
                serializable = null;
                try {
                    object = this.getCallerSubject();
                    serializable = SubjectHelper.getWSCredentialFromSubject((Subject)object);
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.auth.ContextManagerImpl.callerSubjectIsServerIdentity", "553", this);
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "getCallerSubject() failed", wSSecurityException);
                }
            }
            if (serializable != null && serializable.isCurrent() && !serializable.isUnauthenticated()) {
                try {
                    object = serializable.getAccessId();
                    if (object != null) {
                        if (((String)object).equals(this.serverUniqueIdentity)) {
                            bl = true;
                        } else if (((String)object).equalsIgnoreCase(this.serverUniqueIdentity) && SecurityConfig.isIgnoreCaseAuthorization()) {
                            bl = true;
                        } else if (this.isInternalServerId((String)object)) {
                            bl = true;
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.callerSubjectIsServerIdentity", "579", this);
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "getRealmUniqueSecurityName() failed", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callerSubjectIsServerIdentity", new Boolean(bl));
        }
        return bl;
    }

    private void checkAuthRetryForThread() {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        Boolean bl = (Boolean)this.get(DISABLE_AUTH_RETRY);
        if (bl != null && bl.booleanValue()) {
            this.getThreadLocal().set_authretry_for_jaas(false);
        }
    }

    public void clearCallerContext() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearCallerContext");
        }
        StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
        stateofCurrObj.setCallerSubject(null);
        stateofCurrObj.setOwnSubject(null);
        stateofCurrObj.setInvocationSubject(null);
        stateofCurrObj.setFirstAuthUser(null);
        stateofCurrObj.setAuthFlag(false);
        this.removeStateFromTable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearCallerContext");
        }
    }

    public void clearRootException() {
        this.setRootException(null);
    }

    public boolean contains(String string) {
        if (!this.isCellSecurityEnabled()) {
            return false;
        }
        return this.getThreadLocal().contains_property(string);
    }

    public WSCredential createBasicAuthCredential(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBasicAuthCredential", new Object[]{string, string2, string3 == null ? null : "****"});
        }
        WSCredentialImpl wSCredentialImpl = null;
        wSCredentialImpl = string == null || string.length() == 0 ? new WSCredentialImpl(this.getDefaultRealm(), string2, string3) : new WSCredentialImpl(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBasicAuthCredential", wSCredentialImpl);
        }
        return wSCredentialImpl;
    }

    public WSPrincipal createPrincipal(WSCredential wSCredential) throws WSSecurityException {
        return SubjectHelper.createPrincipal(wSCredential);
    }

    public PropagationToken createPropagationToken(Subject subject) throws WSSecurityException {
        PropagationToken propagationToken;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createPropagationToken", subject);
            }
            propagationToken = null;
            try {
                WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface = this.getWSCredTokenMapper();
                if (wSCredentialTokenMapperInterface != null && subject != null) {
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                    propagationToken = wSCredentialTokenMapperInterface.createPropagationTokenFromWSCredential(wSCredential);
                    break block9;
                }
                if (wSCredentialTokenMapperInterface != null && subject == null) {
                    propagationToken = wSCredentialTokenMapperInterface.createPropagationTokenBeforeAuthenticatedCallerSet();
                    break block9;
                }
                throw new WSSecurityException("Could not instantiate WSCredTokenMapper.");
            }
            catch (WSSecurityException wSSecurityException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSecurityException creating propagation token.");
                }
                throw wSSecurityException;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception creating propagation token.");
                }
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPropagationToken", propagationToken);
        }
        return propagationToken;
    }

    public Subject createUnauthenticatedSubject() throws WSSecurityException {
        return SubjectHelper.createUnauthenticatedSubject();
    }

    private void debugCallingMethod() {
        if (!tc.isDebugEnabled()) {
            return;
        }
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (stackTraceElement.getClassName().equals(this.getClass().getName()) || stackTraceElement.getClassName().equals("com.ibm.ws.security.core.SecurityContext") || !stackTraceElement.getClassName().startsWith("com.ibm.")) continue;
            Tr.debug(tc, "Calling routine: " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
            break;
        }
    }

    private String dump(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public Object get(String string) {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        return this.getThreadLocal().get_property(string);
    }

    public AuditService getAuditService() {
        return this._auditService;
    }

    public WSCredential[] getCallerCredentials() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerCredentials");
        }
        WSCredential[] wSCredentialArray = null;
        try {
            StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
            wSCredentialArray = stateofCurrObj.getWSReceivedCreds();
            if (wSCredentialArray != null && wSCredentialArray[0] != null && !wSCredentialArray[0].isCurrent()) {
                throw new WSSecurityException("Received credential has expired.");
            }
            if (wSCredentialArray == null || wSCredentialArray.length == 0) {
                wSCredentialArray = null;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getCallerCredentials", "787", this);
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerCredentials");
        }
        return wSCredentialArray;
    }

    public Subject getCallerSubject() throws WSSecurityException {
        Object object;
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerSubject");
        }
        Subject subject = null;
        try {
            object = this.getThreadLocal().get_state_of_curr_obj();
            subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((StateofCurrObj)object){
                private final /* synthetic */ StateofCurrObj val$the_state;
                {
                    this.val$the_state = stateofCurrObj;
                }

                public Object run() throws Exception {
                    return this.val$the_state.getCallerSubject();
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getCallerSubject", "817", this);
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        object = subject;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((Subject)object){
            private final /* synthetic */ Subject val$subjectPriv;
            {
                this.val$subjectPriv = subject;
            }

            public Object run() {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCallerSubject", this.val$subjectPriv);
                }
                return null;
            }
        });
        return subject;
    }

    public byte[] getClientUniqueIDArrayForOutboundRequests(Subject subject) {
        String string;
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientUniqueIDArrayForOutboundRequests", subject);
        }
        byte[] byArray2 = byArray = (string = this.getClientUniqueIDForOutboundRequests(subject)) != null ? string.getBytes() : null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientUniqueIDArrayForOutboundRequests", byArray);
        }
        return byArray;
    }

    public String getClientUniqueIDForOutboundRequests(Subject subject) {
        String string;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getClientUniqueIDForOutboundRequests", subject);
            }
            string = null;
            try {
                WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface = this.getWSCredTokenMapper();
                if (wSCredentialTokenMapperInterface != null && subject != null) {
                    string = wSCredentialTokenMapperInterface.createUniqueIDFromAllTokens(subject);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.auth.ContextManagerImpl.getClientUniqueIDForOutboundRequests", "864");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Caught exception.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientUniqueIDForOutboundRequests", string);
        }
        return string;
    }

    public String getDefaultRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRealm");
        }
        if (this.isCellSecurityEnabled()) {
            if (this.SECURITY_REALM == null || this.SECURITY_REALM.length() == 0) {
                String string = this.getProperty("com.ibm.CORBA.principalName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security name = " + string);
                }
                this.SECURITY_REALM = RealmSecurityName.getRealm(string);
                if (this.SECURITY_REALM == null || this.SECURITY_REALM.length() == 0) {
                    this.SECURITY_REALM = DEFAULT_REALM;
                }
            } else if (this.SECURITY_REALM != null && this.SECURITY_REALM.equals(DEFAULT_REALM) && this.secConfig != null && this.secConfig.processIsServer()) {
                String string = this.getProperty("com.ibm.CORBA.principalName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security name = " + string);
                }
                this.SECURITY_REALM = RealmSecurityName.getRealm(string);
                if (this.SECURITY_REALM == null || this.SECURITY_REALM.length() == 0) {
                    this.SECURITY_REALM = DEFAULT_REALM;
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled, default realm name will be returned");
            }
            this.SECURITY_REALM = DEFAULT_REALM;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultRealm", this.SECURITY_REALM);
        }
        return this.SECURITY_REALM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renew(Subject subject, int n, boolean bl) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renew", new Object[]{new Integer(n), new Boolean(bl)});
        }
        if (subject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Subject is null.");
            }
            throw new WSSecurityException("Subject is null.");
        }
        if (n >= 100 || n < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Not renewed - " + n + " % too large or too small");
            }
            throw new WSSecurityException("Not renewed - " + n + " % too large or too small");
        }
        if (!this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Security is disabled.");
            }
            return true;
        }
        if (this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Not applicable to client side");
            }
            return true;
        }
        if (!(this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Attribute propagation is disabled, not renewing tokens.");
            }
            return false;
        }
        if (!this.secConfig.getRefreshClientSubjectGoingOutbound() && !this.isServerSubject(subject)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Client credential but com.ibm.CSI.getRefreshClientSubjectGoingOutbound is not enabled.");
            }
            return false;
        }
        try {
            Serializable serializable;
            if (!bl) {
                serializable = SubjectHelper.getWSCredentialFromSubject(subject);
                try {
                    if (serializable == null || !serializable.isForwardable()) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "Not forwardable");
                        }
                        return true;
                    }
                }
                catch (CredentialExpiredException credentialExpiredException) {
                    // empty catch block
                }
                if (serializable != null) {
                    try {
                        long l = System.currentTimeMillis();
                        long l2 = serializable.getExpiration();
                        long l3 = l2 - l;
                        Long l4 = (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate");
                        long l5 = l4 * 60L * 1000L / 100L * (long)n;
                        if (l3 > l5) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "not renewed because remaining time " + l3 + " in milliseconds > threshold " + l5);
                            }
                            return true;
                        }
                    }
                    catch (CredentialExpiredException credentialExpiredException) {
                        // empty catch block
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Refreshing Subject.");
            }
            serializable = subject;
            Subject subject2 = subject;
            synchronized (subject2) {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Subject)serializable){
                    private final /* synthetic */ Subject val$subjectPriv;
                    {
                        this.val$subjectPriv = subject;
                    }

                    public Object run() throws WSLoginFailedException, WSSecurityException {
                        Object object;
                        com.ibm.wsspi.security.token.Token token = null;
                        AuthorizationToken authorizationToken = null;
                        SingleSignonToken singleSignonToken = null;
                        Iterator<Object> iterator = this.val$subjectPriv.getPrivateCredentials().iterator();
                        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(this.val$subjectPriv);
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            if (object instanceof AuthorizationToken && object instanceof AbstractTokenImpl) {
                                authorizationToken = (AuthorizationToken)object;
                                authorizationToken = (AuthorizationToken)authorizationToken.clone();
                                ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)authorizationToken)).getToken());
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "New AuthorizationToken expiration: " + new Date(((com.ibm.wsspi.security.token.Token)object).getExpiration()));
                                continue;
                            }
                            if (object instanceof AuthenticationToken && object instanceof AbstractTokenImpl) {
                                token = (AuthenticationToken)object;
                                token = (AuthenticationToken)token.clone();
                                ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)token).getToken());
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "New AuthenticationToken expiration: " + new Date(((com.ibm.wsspi.security.token.Token)object).getExpiration()));
                                continue;
                            }
                            if (!(object instanceof SingleSignonToken) || !(object instanceof AbstractTokenImpl)) continue;
                            singleSignonToken = (SingleSignonToken)object;
                            singleSignonToken = (SingleSignonToken)singleSignonToken.clone();
                            ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)singleSignonToken)).getToken());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "New SingleSignonToken expiration: " + new Date(((com.ibm.wsspi.security.token.Token)object).getExpiration()));
                        }
                        if (token != null && authorizationToken != null) {
                            try {
                                object = ContextManagerImpl.this.getWSCredTokenMapper().createWSCredentialFromTokens(token.getBytes(), authorizationToken);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Updating Subject with new wsCred token.");
                                }
                                ((WSCredentialImpl)wSCredential).refreshCred((WSCredential)object);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "New WSCredential expiration: " + new Date(wSCredential.getExpiration()));
                                }
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.renew", "1077", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception refreshing the WSCredential.", new Object[]{exception});
                                }
                                throw new WSSecurityException(exception.getMessage(), exception);
                            }
                        }
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.renew", "1090", this);
            this.setRootException(privilegedActionException.getException());
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renew if below " + n + " %");
        }
        return true;
    }

    private Object getDistributedObject(Object object) {
        Object object2;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDistributedObject", object);
            }
            object2 = null;
            try {
                object2 = this.getWSCredTokenMapper().getDistributedObject(object);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.auth.distContextManager.getDistributedObject", "1130");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error getting distributed object.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDistributedObject", object2);
        }
        return object2;
    }

    private Object getDistributedObjectNotShared(Object object) {
        Object object2;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDistributedObjectNotShared", object);
            }
            object2 = null;
            try {
                object2 = this.getWSCredTokenMapper().getDistributedObjectNotShared(object);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.auth.distContextManager.getDistributedObjectNotShared", "1168");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error getting none shared distributed object.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDistributedObjectNotShared", object2);
        }
        return object2;
    }

    private byte[] getInitialContextTokenFromMBean(final ByteArray byteArray, final String string, final Properties properties) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInitialContextTokenFromMBean", new Object[]{byteArray, string, properties});
            }
            byArray = null;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return ContextManagerImpl.this.getWSCredTokenMapper().getInitialContextTokenFromMBean(byteArray, string, properties);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getInitialContextTokenFromMBean", "1198", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception getting initial context token from originating server.");
                        }
                        return null;
                    }
                }
            };
            try {
                byArray = (byte[])this.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.getInitialContextTokenFromMBean", "1213", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception getting initial context token from originating server.", new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialContextTokenFromMBean", byArray);
        }
        return byArray;
    }

    public WSCredential getInvocationCredential() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvocationCredential");
        }
        WSCredential wSCredential = null;
        try {
            StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
            wSCredential = stateofCurrObj.getWSInvocationCred();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getInvocationCredential", "1238", this);
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationCredential", wSCredential);
        }
        return wSCredential;
    }

    public Subject getInvocationSubject() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvocationSubject");
        }
        Subject subject = null;
        try {
            StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
            subject = stateofCurrObj.getInvocationSubject();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getInvocationSubject", "1263", this);
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationSubject");
        }
        return subject;
    }

    private JaasLoginHelper getJaasLoginHelper() throws WSSecurityException {
        if (this.jaasLoginHelper == null) {
            try {
                this.jaasLoginHelper = new JaasLoginHelper(this.secConfig.getAuthMechAuthAlias());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JaasLoginHelper()");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.auth.ContextManagerImpl.getJaasLoginHelper", "1283");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, EMPTY, exception);
                }
                this.jaasLoginHelper = null;
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return this.jaasLoginHelper;
    }

    private Object getOpaqueTokenFromCacheOrOriginatingServer(byte[] byArray) throws WSLoginFailedException {
        Object[] objectArray;
        block59: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueTokenFromCacheOrOriginatingServer");
            }
            Subject subject = null;
            objectArray = null;
            try {
                Object[] objectArray2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting distributed object from DynaCache.");
                }
                String[] stringArray = null;
                String[] stringArray2 = null;
                ByteArray byteArray = new ByteArray(byArray);
                byte[] byArray2 = (byte[])this.getDistributedObject(byteArray);
                Properties properties = new Properties();
                String[] stringArray3 = null;
                GSSCredential gSSCredential = (GSSCredential)this.getDistributedObjectNotShared(byteArray);
                if (gSSCredential != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting return_object = GSSCredential.");
                    }
                    objectArray = gSSCredential;
                }
                Token token = null;
                String[] stringArray4 = null;
                String[] stringArray5 = null;
                String[] stringArray6 = null;
                String[] stringArray7 = null;
                boolean bl = gSSCredential != null;
                String string = "true";
                if (byArray2 == null || gSSCredential == null) {
                    token = this.getWSCredTokenMapper().validateLTPAToken(byArray);
                    stringArray = token.getAttributes("process.serverName");
                    if (stringArray != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverName is " + stringArray[0]);
                    }
                    stringArray2 = token.getAttributes("hashed_uid");
                    stringArray4 = token.getAttributes("java.naming.provider.url");
                    stringArray5 = token.getAttributes("type");
                    stringArray6 = token.getAttributes("host");
                    stringArray7 = token.getAttributes("port");
                    stringArray3 = token.getAttributes("security.authMechOID");
                    if (!bl) {
                        objectArray2 = token.getAttributes("security.ltpa.sso.spnego");
                        if (objectArray2 != null) {
                            bl = string.equalsIgnoreCase(objectArray2[0]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SSO_SPNEGO is " + bl);
                        }
                    }
                    if (byteArray != null && stringArray5 != null && stringArray6 != null && stringArray7 != null && stringArray != null && stringArray[0] != null) {
                        properties.setProperty("type", stringArray5[0]);
                        properties.setProperty("host", stringArray6[0]);
                        properties.setProperty("port", stringArray7[0]);
                    }
                }
                if (byArray2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not found subject in DynaCache, getting distributed object using MBean.");
                    }
                    if (stringArray2 != null && stringArray2[0] != null) {
                        subject = this.cache.getSubject(stringArray2[0]);
                    }
                    if (subject != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found subject using token unique ID: " + stringArray2);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getSubjectFromDynaCacheOrOriginatingServer");
                        }
                        return subject;
                    }
                    if (this.secConfig.getWebPropagationTransport().equals("IIOP") && stringArray4 != null) {
                        objectArray2 = new Hashtable();
                        objectArray2.put("java.naming.provider.url", stringArray4[0]);
                        objectArray2.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                        byArray2 = this.getOpaqueTokenFromCorbaObject(byteArray, (Hashtable)objectArray2);
                    } else if (byteArray != null && stringArray5 != null && stringArray6 != null && stringArray7 != null && stringArray != null && stringArray[0] != null) {
                        if (gSSCredential == null && (bl || stringArray3 != null && stringArray3[0] != null && "oid:1.2.840.113554.1.2.2".endsWith(stringArray3[0]))) {
                            if (stringArray != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Get token from Mbean " + byteArray + stringArray[0]);
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "serverName is null");
                            }
                            if ((objectArray2 = (Object[])this.getInitialContextTokenFromMBean(byteArray, stringArray[0], properties)) == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Token is null");
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting return_object = initial context token.");
                                }
                                objectArray = objectArray2;
                            }
                        }
                        byArray2 = this.getOpaqueTokenFromMBean(byteArray, stringArray[0], properties);
                    }
                }
                if (bl && objectArray == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "GSSCredential not found locally, getting from MBean.");
                    }
                    if (stringArray != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Get token from Mbean " + byteArray + stringArray[0]);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverName is null");
                    }
                    if ((objectArray2 = (Object[])this.getInitialContextTokenFromMBean(byteArray, stringArray[0], properties)) == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Token is null");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting return_object = initial context token.");
                        }
                        objectArray = objectArray2;
                    }
                }
                if (byArray2 != null) {
                    objectArray2 = null;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Getting token holder list from opaque token.");
                        }
                        if ((objectArray2 = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(byArray2)) != null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "Token holder list has been set on the thread.");
                            }
                            this.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), objectArray2);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to get token holder list.");
                        }
                        break block59;
                    }
                    catch (WSSecurityException wSSecurityException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to get token holder list.", new Object[]{wSSecurityException});
                        }
                        break block59;
                    }
                }
                if (stringArray2 != null && stringArray2[0] != null && this.secConfig.isWebChallengeIfCustomSubjectNotFound()) {
                    throw new WSLoginFailedException("SSO token uniqueID not null, but opaque token not found.  Need to re-challenge the user to login again.");
                }
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.auth.ContextManagerImpl.getSubjectFromDynaCacheOrOriginatingServer", "1476", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{wSLoginFailedException});
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getSubjectFromDynaCacheOrOriginatingServer", "1482", this);
                if (!tc.isDebugEnabled()) break block59;
                Tr.debug(tc, "Exception getting opaque token from originating server.");
            }
        }
        if (objectArray != null && objectArray instanceof GSSCredential) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubjectFromDynaCacheOrOriginatingServer (GSSCredential)");
            } else if (objectArray != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSubjectFromDynaCacheOrOriginatingServer (byte[])");
                } else if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSubjectFromDynaCacheOrOriginatingServer (null)");
                }
            }
        }
        return objectArray;
    }

    private byte[] getOpaqueTokenFromCorbaObject(final ByteArray byteArray, final Hashtable hashtable) {
        byte[] byArray;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueTokenFromCorbaObject", new Object[]{byteArray, hashtable});
            }
            byArray = null;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    block3: {
                        try {
                            TokenHolder tokenHolder;
                            com.ibm.ws.security.server.SecurityServer securityServer;
                            InitialContext initialContext = new InitialContext(hashtable);
                            Object object = initialContext.lookup("SecurityServer");
                            if (object != null && (securityServer = (com.ibm.ws.security.server.SecurityServer)PortableRemoteObject.narrow((Object)object, (Class)(class$com$ibm$ws$security$server$SecurityServer == null ? (class$com$ibm$ws$security$server$SecurityServer = ContextManagerImpl.class$("com.ibm.ws.security.server.SecurityServer")) : class$com$ibm$ws$security$server$SecurityServer))) != null && (tokenHolder = securityServer.getOpaqueToken(byteArray)) != null) {
                                return tokenHolder.getBytes();
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromCorbaObject", "1536", this);
                            if (!tc.isDebugEnabled()) break block3;
                            Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{exception});
                        }
                    }
                    return null;
                }
            };
            try {
                byArray = (byte[])this.runAsSpecified(this.createUnauthenticatedSubject(), privilegedExceptionAction);
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromCorbaObject", "1551", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{wSSecurityException});
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromCorbaObject", "1556", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpaqueTokenFromCorbaObject", byArray);
        }
        return byArray;
    }

    private byte[] getOpaqueTokenFromMBean(final ByteArray byteArray, final String string, final Properties properties) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueTokenFromMBean", new Object[]{byteArray, string, properties});
            }
            byArray = null;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return ContextManagerImpl.this.getWSCredTokenMapper().getOpaqueTokenFromMBean(byteArray, string, properties);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromMBean", "1589", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception getting opaque token from originating server.");
                        }
                        return null;
                    }
                }
            };
            try {
                byArray = (byte[])this.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromMBean", "1604", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpaqueTokenFromMBean", byArray);
        }
        return byArray;
    }

    public Subject getOwnSubject() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOwnSubject");
        }
        Subject subject = null;
        try {
            StateofCurrObj stateofCurrObj;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GET_OWN_CRED_PERM.toString());
                }
                securityManager.checkPermission(GET_OWN_CRED_PERM);
            }
            if ((subject = (stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj()).getOwnSubject()) == null && !this.secConfig.processIsServer()) {
                subject = this.vault.get_default_subject();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getOwnSubject", "1645", this);
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOwnSubject");
        }
        return subject;
    }

    public PlatformHelper getPlatformHelper() {
        return PlatformHelperFactory.getPlatformHelper();
    }

    public PropagationToken getPropagationToken(String string) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropagationToken", string);
        }
        if (string == null) {
            throw new WSSecurityException("Invalid null parameter");
        }
        PropagationToken propagationToken = null;
        if (this.isCellSecurityEnabled()) {
            propagationToken = this.getThreadLocal().get_propagation_token(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropagationToken", propagationToken);
        }
        return propagationToken;
    }

    public Map getPropagationTokens() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropagationTokens");
        }
        Map map = null;
        if (this.isCellSecurityEnabled()) {
            map = this.getThreadLocal().get_propagation_tokens();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropagationTokens", map);
        }
        return map;
    }

    public String getProperty(String string) {
        Object object = null;
        if (this.theORB != null) {
            object = this.theORB.getProperty(string);
        }
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        if (object == null) {
            object = securityConfig.getValue(string);
        }
        String string2 = object != null ? object.toString() : EMPTY;
        return string2;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        string3 = string3 == null || EMPTY.equals(string3) ? string2 : string3;
        return string3;
    }

    public List getRealms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealms");
        }
        List list = null;
        try {
            list = this.getSecurityServer().getRealms();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getRealms", "1757", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getRealms(): ", new Object[]{exception});
            }
            list = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealms", list);
        }
        return list;
    }

    public String getRegionId() {
        return this.regionUserid;
    }

    public UserRegistry getRegistry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegistry", string);
        }
        UserRegistry userRegistry = null;
        try {
            userRegistry = this.getSecurityServer().getRegistry(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getRegistry", "1786", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getRegistry(): ", new Object[]{exception});
            }
            userRegistry = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistry", userRegistry);
        }
        return userRegistry;
    }

    private Object getRegistryObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegistryObject");
        }
        if (this._registryObject == null) {
            try {
                this._registryObject = SecurityServerImpl.getRegistryImpl(this.getDefaultRealm());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.auth.ContextManagerImpl.getRegistryObject", "1807");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting registry instance during bootstrap check.", exception);
                }
                this._registryObject = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistryObject", this._registryObject);
        }
        return this._registryObject;
    }

    public long getReqTimeout() {
        long l = this.theORB.getRequestTimeout() - 5000;
        return l;
    }

    public Throwable getRootException() {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        return this.getThreadLocal().get_root_exception();
    }

    private SecurityServer getSecurityServer() throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityServer");
        }
        if (this.securityServer == null) {
            try {
                this.securityServer = this.vault.getSecurityServer();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.auth.ContextManagerImpl.getSecurityServer", "1846");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, EMPTY, exception);
                }
                this.securityServer = null;
                throw new AuthenticationFailedException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityServer", this.securityServer);
        }
        return this.securityServer;
    }

    public String getSecurityServerHost() {
        if (this.isCellSecurityEnabled() && this.secConfig != null) {
            return this.secConfig.getSecurityServerHost();
        }
        return EMPTY;
    }

    public String getSecurityServerPort() {
        if (this.isCellSecurityEnabled() && this.secConfig != null) {
            return this.secConfig.getSecurityServerPort();
        }
        return EMPTY;
    }

    public synchronized WSCredential getServerCredential() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerCredential");
        }
        WSCredential wSCredential = null;
        if (this.secConfig == null || !this.secConfig.processIsServer()) {
            return null;
        }
        Subject subject = this.getServerSubject();
        wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerCredential", wSCredential);
        }
        return wSCredential;
    }

    public boolean getServerSecurityEnabled() {
        return this.serverSecurityEnabled;
    }

    public void refreshServerSubject() throws WSSecurityException {
        this.refreshServerSubject(false);
    }

    public void refreshServerSubject(boolean bl) throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshServerSubject");
        }
        try {
            this.refreshServerSubject = true;
            this.getServerSubjectInternal(bl);
        }
        catch (WSSecurityException wSSecurityException) {
            throw wSSecurityException;
        }
        finally {
            this.refreshServerSubject = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshServerSubject");
        }
    }

    public Subject getServerSubject() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerSubject");
        }
        Subject subject = null;
        if (this.serverSubject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BOOTSTRAP MODE: Returning BasicAuth server subject");
            }
            subject = this.serverBASubject;
        } else {
            subject = this.getServerSubjectInternal();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerSubject", subject);
        }
        return subject;
    }

    public Subject getServerSubjectInternal() throws WSSecurityException {
        return this.getServerSubjectInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject getServerSubjectInternal(boolean bl) throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerSubjectInternal");
        }
        if (this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerSubjectInternal", null);
            }
            return null;
        }
        if (this.getRegistryObject() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BOOTSTRAP MODE: Returning unauthenticated server subject.");
            }
            Subject subject = this.createUnauthenticatedSubject();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerSubjectInternal", subject);
            }
            return subject;
        }
        if (this.serverTokenCred != null && !this.serverTokenCred.isDestroyed()) {
            boolean bl2 = true;
            long l = 0L;
            try {
                long l2 = 0L;
                ContextManagerImpl contextManagerImpl = this;
                synchronized (contextManagerImpl) {
                    l2 = this.serverTokenCred.getExpiration();
                }
                if (l2 == -1L || l2 == 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Subject does not expire.");
                    }
                    return this.serverSubject;
                }
                long l3 = System.currentTimeMillis();
                l = l2 - l3 - this.cache.getCushion();
                if (l < 0L) {
                    bl2 = false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Is server subject valid? " + bl2);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2030");
                Tr.error(tc, "security.SecurityContext.getActualCreds", new Object[]{exception});
                throw new WSSecurityException(exception.getMessage(), exception);
            }
            if (bl2 && !this.refreshServerSubject) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Subject returned with sufficient time left.");
                }
                return this.serverSubject;
            }
            ContextManagerImpl contextManagerImpl = this;
            synchronized (contextManagerImpl) {
                long l4 = 0L;
                try {
                    l4 = this.serverTokenCred.getExpiration();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2053");
                    Tr.error(tc, "security.SecurityContext.getActualCreds", new Object[]{exception});
                    throw new WSSecurityException(exception.getMessage(), exception);
                }
                long l5 = System.currentTimeMillis();
                l = l4 - (l5 + this.cache.getCushion());
                if (l <= 0L || bl) {
                    if (bl) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "LTPA runtime keys being refreshed, forcing refresh of server subject");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Subject expired, refreshing...");
                    }
                    try {
                        Serializable serializable;
                        if (this.serverAuthToken != null) {
                            this.serverAuthToken = (AuthenticationToken)this.serverAuthToken.clone();
                        }
                        if (this.serverAuthzToken != null) {
                            this.serverAuthzToken = (AuthorizationToken)this.serverAuthzToken.clone();
                        }
                        if (this.serverSSOToken != null) {
                            this.serverSSOToken = (SingleSignonToken)this.serverSSOToken.clone();
                        }
                        try {
                            serializable = this.serverSubject;
                            AuthorizationToken authorizationToken = this.serverAuthzToken;
                            AuthenticationToken authenticationToken = this.serverAuthToken;
                            SingleSignonToken singleSignonToken = this.serverSSOToken;
                            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Subject)serializable, authorizationToken, authenticationToken, singleSignonToken){
                                private final /* synthetic */ Subject val$subjectPriv;
                                private final /* synthetic */ AuthorizationToken val$newAuthzToken;
                                private final /* synthetic */ AuthenticationToken val$newAuthToken;
                                private final /* synthetic */ SingleSignonToken val$newSSOToken;
                                {
                                    this.val$subjectPriv = subject;
                                    this.val$newAuthzToken = authorizationToken;
                                    this.val$newAuthToken = authenticationToken;
                                    this.val$newSSOToken = singleSignonToken;
                                }

                                public Object run() throws WSLoginFailedException, WSSecurityException {
                                    Iterator<Object> iterator = this.val$subjectPriv.getPrivateCredentials().iterator();
                                    while (iterator.hasNext()) {
                                        Object object = iterator.next();
                                        if (object instanceof AuthorizationToken && object instanceof AbstractTokenImpl) {
                                            ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)this.val$newAuthzToken)).getToken());
                                            continue;
                                        }
                                        if (object instanceof AuthenticationToken && object instanceof AbstractTokenImpl) {
                                            ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)this.val$newAuthToken)).getToken());
                                            continue;
                                        }
                                        if (!(object instanceof SingleSignonToken) || !(object instanceof AbstractTokenImpl)) continue;
                                        ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)this.val$newSSOToken)).getToken());
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2116", this);
                            this.setRootException(privilegedActionException.getException());
                            throw new WSSecurityException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                        }
                        if (this.serverAuthToken != null && this.serverAuthzToken != null) {
                            serializable = this.getWSCredTokenMapper().createWSCredentialFromTokens(this.serverAuthToken.getBytes(), this.serverAuthzToken);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Updating server Subject with new wsCred token.");
                            }
                            ((WSCredentialImpl)this.serverTokenCred).refreshCred((WSCredential)serializable);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2130");
                    }
                }
            }
        }
        if (this.serverTokenCred == null) {
            try {
                Object object;
                Serializable serializable;
                Subject subject = null;
                boolean bl3 = this.secConfig.getIsUseRegistryServerId();
                String string = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "useRegistryServerId", new Boolean(bl3));
                }
                if (!bl3) {
                    string = this.secConfig.getInternalServerId();
                    if (string == null) {
                        throw new WSSecurityException("Found null internalServerId.");
                    }
                    serializable = new Hashtable();
                    object = "server:" + this.getDefaultRealm() + "/" + string;
                    ((Hashtable)serializable).put("com.ibm.wsspi.security.cred.uniqueId", object);
                    String string2 = string;
                    ((Hashtable)serializable).put("com.ibm.wsspi.security.cred.securityName", string2);
                    Subject subject2 = new Subject();
                    subject2.getPublicCredentials().add(serializable);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "internal serverID's uniqueID = " + (String)object + " and securityName = " + string2);
                    }
                    if ((subject = this.login(this.getDefaultRealm(), string, null, null, null, null, subject2)).getPublicCredentials().contains(serializable)) {
                        subject.getPublicCredentials().remove(serializable);
                    }
                    this.cache.insert(subject);
                } else if (this.secConfig.getloginPassword() == null || this.secConfig.getloginPassword().equals(EMPTY)) {
                    subject = this.login(this.getDefaultRealm(), this.secConfig.getloginUserid());
                    this.cache.insert(subject);
                } else {
                    subject = this.login(this.getDefaultRealm(), this.secConfig.getloginUserid(), this.secConfig.getloginPassword());
                    this.cache.insert(subject, this.secConfig.getloginPassword());
                }
                if (subject != null) {
                    serializable = SubjectHelper.getWSCredentialFromSubject(subject);
                    if (this.getPlatformHelper().isZOS()) {
                        object = PlatformCredentialManager.instance().createServerCredential();
                        serializable.set("com.ibm.ws.security.zos.PlatformCredential", object);
                    }
                    this.serverTokenCred = serializable;
                    this.serverSubject = subject;
                    this.serverSubject.setReadOnly();
                    ((WSCredentialImpl)this.serverTokenCred).markServerCred(scs.getEncryptedServerSigner());
                    if (this.serverTokenCred.isForwardable()) {
                        this.serverAuthToken = this.getWSCredTokenMapper().createAuthTokenFromWSCredential(this.serverTokenCred);
                        this.serverAuthzToken = this.getWSCredTokenMapper().createAuthzTokenFromWSCredential(this.serverTokenCred);
                        this.serverSSOToken = this.getWSCredTokenMapper().createSSOTokenFromWSCredential(this.serverTokenCred);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2212");
                Tr.error(tc, "security.SecurityContext.getActualCreds", new Object[]{exception});
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        this.serverSubjectCreated = true;
        return this.serverSubject;
    }

    public String getSpecificSecurityServerHost() {
        if (!this.isCellSecurityEnabled()) {
            return EMPTY;
        }
        return this.getThreadLocal().get_all_hosts();
    }

    public String getSpecificSecurityServerPort() {
        if (!this.isCellSecurityEnabled()) {
            return EMPTY;
        }
        return this.getThreadLocal().get_all_ports();
    }

    private Subject getSubjectFromHashtableCacheKey(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectFromHashtableCacheKey", subject);
        }
        Subject subject2 = null;
        Object object = null;
        if (subject != null && (object = this.getWSCredTokenMapper().getCacheKeyFromHashtable(subject)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for Subject using cacheKey (" + object + ") from hashtable.");
            }
            subject2 = object instanceof byte[] ? this.cache.getSubject((byte[])object) : this.cache.getSubject(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectFromHashtableCacheKey", subject2);
        }
        return subject2;
    }

    private Object[] getSubjectFromTokenHolderCacheKey(byte[] byArray, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectFromTokenHolderCacheKey", new Object[]{byArray, list});
        }
        Subject subject = null;
        String string = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                TokenHolder tokenHolder = (TokenHolder)list.get(i);
                if (!tokenHolder.getName().equals("com.ibm.wsspi.security.cred.cacheKey")) continue;
                byte[] byArray2 = tokenHolder.getBytes();
                if (byArray2 != null) {
                    string = StringBytesConversion.getConvertedString(byArray2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cache key from token holder list: " + string);
                    }
                    subject = this.cache.getSubject(string);
                }
                if (subject == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Subject using cacheKey from prop token.");
                }
                if (byArray == null) continue;
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                boolean bl2 = bl = wSCredential != null && Arrays.equals(byArray, wSCredential.getCredentialToken()) || singleSignonToken != null && Arrays.equals(byArray, singleSignonToken.getBytes());
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject found from cacheKey does not have matching LTPA token.");
                }
                subject = null;
            }
        }
        Object[] objectArray = null;
        if (subject != null || string != null) {
            objectArray = new Object[]{subject, string};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectFromTokenHolderCacheKey", objectArray);
        }
        return objectArray;
    }

    public ThreadContextImpl getThreadLocal() {
        ThreadContextImpl threadContextImpl = (ThreadContextImpl)this.getThreadLocalStorage().get();
        if (threadContextImpl == null) {
            threadContextImpl = new ThreadContextImpl();
            this.getThreadLocalStorage().set(threadContextImpl);
        }
        return threadContextImpl;
    }

    private ThreadLocal getThreadLocalStorage() {
        return threadLocStorage;
    }

    public WSCredential getUnauthenticatedCredential() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnauthenticatedCredential");
        }
        Subject subject = this.createUnauthenticatedSubject();
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnauthenticatedCredential", wSCredential);
        }
        return wSCredential;
    }

    public String getUnauthenticatedString() {
        if (unauthenticatedId == null) {
            String string;
            unauthenticatedId = "UNAUTHENTICATED";
            if (this.processIsServer() && this.getPlatformHelper().isZOS() & this.secConfig != null && (string = this.secConfig.getActiveUserRegistry()) != null && string.equals("LOCALOS")) {
                String string2 = this.getProperty("com.ibm.security.SAF.unauthenticated");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getUnauthenticatedString SAF Unauthenticated ID is ", string2);
                }
                if (string2 != null) {
                    unauthenticatedId = string2;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getUnauthenticatedString Unauthenticated ID is ", unauthenticatedId);
            }
        }
        return unauthenticatedId;
    }

    public WSCredentialTokenMapperInterface getWSCredTokenMapper() throws WSSecurityException {
        if (this.wsCredTokenMapper == null) {
            this.wsCredTokenMapper = new WSCredentialTokenMapper();
        }
        return this.wsCredTokenMapper;
    }

    public void init() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        try {
            if (this.getPlatformHelper().isZOS()) {
                this._platformCredManager = PlatformCredentialManager.instance();
            }
            this.vault = VaultImpl.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init(): VaultImpl instance: ", this.vault);
            }
            if (this.vault != null) {
                scs = ServerCredSigner.getInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "init(): Server cred signer instance: ", scs);
                }
                ContextManagerImpl contextManagerImpl = this;
                this.secConfig = contextManagerImpl.vault.getSecurityConfiguration();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "init(): Security configuration instance: ", this.secConfig);
                }
                this.theORB = this.vault.getORB();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "init(): ORB instance: ", this.theORB);
                }
            } else {
                throw new WSSecurityException("Vault is null during ContextManager initialization");
            }
            if (this.secConfig == null) {
                throw new WSSecurityException("Security Configuration is null");
            }
            if (this.secConfig != null && this.secConfig.processIsServer()) {
                this.cache = AuthCache.getInstance();
            }
            this.isAuthenticateSpecialMethodsEnabled = this.secConfig.getAuthenticateSpecialMethods();
            if (this.processIsServer()) {
                SecurityService securityService = this.getSecurityService();
                if (securityService == null) {
                    throw new WSSecurityException("Security Service not available");
                }
                securityService.addListener(this);
            } else {
                this.isSecurityServiceStarted = true;
            }
        }
        catch (WSSecurityException wSSecurityException) {
            throw wSSecurityException;
        }
        catch (Exception exception) {
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void initialize(Object object) throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        if (this.secConfig == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling init again since secConfig is null.");
            }
            this.init();
        }
        if (object == null) {
            throw new WSSecurityException("Excepting Boolean, but null is passed in");
        }
        if (!(object instanceof Boolean)) {
            throw new WSSecurityException("Excepting Boolean, but " + object.getClass().getName() + " is passed in");
        }
        boolean bl = (Boolean)object;
        try {
            if (this.secConfig.getIsUseRegistryServerId()) {
                this.serverBASubject = SubjectHelper.createBasicAuthSubject(this.getDefaultRealm(), this.secConfig.getloginUserid(), this.secConfig.getloginPassword());
                this.serverBACred = SubjectHelper.getWSCredentialFromSubject(this.serverBASubject);
                ((WSCredentialImpl)this.serverBACred).markServerCred(scs.getEncryptedServerSigner());
            }
            SecurityServerFactory.create();
            Subject subject = this.getServerSubjectInternal();
            this.serverTokenCred = SubjectHelper.getWSCredentialFromSubject(subject);
            this.setOwnSubject(subject);
            this.setCallerSubject(subject);
            this.setInvocationSubject(subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.auth.ContextManagerImpl.enable", "2542");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, EMPTY, exception);
            }
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void initialize(Object object, AuditService auditService) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object, auditService});
        }
        if (auditService != null && this._auditService == null) {
            this._auditService = auditService;
        }
        this.initialize(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void initializeCallerContext(Subject subject) throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeCallerContext");
        }
        if (tc.isDebugEnabled() && subject != null) {
            Tr.debug(tc, "received_subject: " + subject.toString());
        }
        StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
        stateofCurrObj.setCallerSubject(subject);
        stateofCurrObj.setOwnSubject(null);
        stateofCurrObj.setInvocationSubject(subject);
        stateofCurrObj.setFirstAuthUser(null);
        stateofCurrObj.setAuthFlag(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeCallerContext");
        }
    }

    public void initializeCallerContext(WSCredential[] wSCredentialArray) throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeCallerContext");
        }
        StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
        stateofCurrObj.setWSReceivedCreds(wSCredentialArray);
        stateofCurrObj.setWSOwnCred(null);
        if (wSCredentialArray != null) {
            stateofCurrObj.setWSInvocationCred(wSCredentialArray[0]);
        } else {
            stateofCurrObj.setWSInvocationCred(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeCallerContext");
        }
    }

    public void initializeSystemContext() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSystemContext");
        }
        this.initializeCallerContext(this.getServerSubject());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSystemContext");
        }
    }

    public boolean isCellSecurityEnabled() {
        return ConfigURLProperties.isSecurityEnabled();
    }

    public boolean isServerCred(WSCredential wSCredential) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerCred", wSCredential);
        }
        boolean bl = scs.isServerCred(wSCredential);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerCred", new Boolean(bl));
        }
        return bl;
    }

    public boolean isServerSecurityEnabled() {
        if (this.alreadyChecked) {
            return this.isEnabled;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerSecurityEnabled");
        }
        if (this.secConfig != null) {
            String string = this.getProperty("com.ibm.ws.security.processType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processType = " + string);
            }
            if (string != null) {
                boolean bl;
                boolean bl2 = bl = string.equals("ManagedProcess") || string.equals("UnManagedProcess");
                this.isEnabled = bl ? this.secConfig.securityEnabled() && this.secConfig.getSecurityServerEnabled() : ConfigURLProperties.isSecurityEnabled();
                this.alreadyChecked = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerSecurityEnabled", this.isEnabled);
        }
        return this.isEnabled;
    }

    public boolean isServerSubject(Subject subject) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerSubject", subject);
        }
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        boolean bl = this.isServerCred(wSCredential);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerSubject", new Boolean(bl));
        }
        return bl;
    }

    public boolean isWSCred(WSCredential wSCredential) throws WSSecurityException {
        return scs.isWSCred(wSCredential);
    }

    public boolean isWSSubject(Subject subject) throws WSSecurityException {
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        return scs.isWSCred(wSCredential);
    }

    public Subject login(String string, byte[] byArray) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login", new Object[]{string, byArray});
        }
        String string2 = this.secConfig != null ? this.secConfig.getAuthMechAuthAlias() : null;
        Subject subject = this.login(string, byArray, string2, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login", subject);
        }
        return subject;
    }

    public Subject login(String string, byte[] byArray, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login", new Object[]{string, byArray, string2, httpServletRequest, httpServletResponse, map});
        }
        Subject subject = this.login(string, byArray, string2, httpServletRequest, httpServletResponse, map, (Subject)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login", subject);
        }
        return subject;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(String string, byte[] byArray, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        block59: {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "login", new Object[]{string, byArray, string2, httpServletRequest, httpServletResponse, map, subject});
            }
            if (!this.isCellSecurityEnabled() || byArray == null || byArray.length == 0) break block59;
            if (this.secConfig == null) return null;
            if (!this.secConfig.processIsServer()) {
                return null;
            }
            this.checkAuthRetryForThread();
            try {
                block60: {
                    Object object2;
                    Subject subject2;
                    block58: {
                        if (!this.secConfig.processIsServer()) break block60;
                        ArrayList arrayList = null;
                        object = null;
                        subject2 = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Web inbound login config: " + this.secConfig.getWebInboundLoginConfig());
                        }
                        if (this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking for opaque token on the thread before Subject cache lookup.");
                            }
                            if ((object2 = this.getSubjectFromTokenHolderCacheKey(byArray, arrayList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup()))) != null && (object2[0] != null || object2[1] != null)) {
                                subject2 = (Subject)object2[0];
                                object = (String)object2[1];
                            }
                        }
                        if (arrayList == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking for subject from cache using token as lookup.");
                            }
                            if ((subject2 = this.cache.getSubject(byArray)) != null && string2 != null && string2.startsWith(this.secConfig.getWebInboundLoginConfig()) && !this.isTokenMatch(byArray, subject2)) {
                                try {
                                    this.getWSCredTokenMapper().validateLTPAToken(byArray);
                                }
                                catch (Exception exception) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Token validation was failed. Most likely ltpatoken is expired. Removing cache entry.");
                                    }
                                    ByteArray byteArray = new ByteArray(byArray);
                                    this.cache.removeEntry(byteArray);
                                    subject2 = null;
                                }
                            }
                        }
                        if (subject2 == null && this.secConfig.isWebInboundPropagationEnabled() && string2 != null && string2.startsWith(this.secConfig.getWebInboundLoginConfig())) {
                            object2 = this.getOpaqueTokenFromCacheOrOriginatingServer(byArray);
                            if (object2 != null) {
                                if (object2 instanceof GSSCredential) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Logging in with GSSCredential.");
                                    }
                                    if (subject != null) {
                                        if (!subject.getPrivateCredentials().contains(object2)) {
                                            subject.getPrivateCredentials().add(object2);
                                        }
                                    } else {
                                        subject = new Subject();
                                        subject.getPrivateCredentials().add(object2);
                                    }
                                    subject2 = string2 == null ? this.getJaasLoginHelper().jaas_login(string, ((Object)((GSSCredential)object2).getName()).toString(), (String)null, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(string, ((Object)((GSSCredential)object2).getName()).toString(), null, string2, subject) : this.getJaasLoginHelper().jaas_login(string, ((Object)((GSSCredential)object2).getName()).toString(), null, string2, httpServletRequest, httpServletResponse, map, subject));
                                } else if (object2 instanceof Subject) {
                                    subject2 = (Subject)object2;
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Logging in with initial context token.");
                                    }
                                    byArray = (byte[])object2;
                                }
                            }
                            if (subject2 == null) {
                                subject2 = string2 == null ? this.getJaasLoginHelper().jaas_login(byArray, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(byArray, string2, subject) : this.getJaasLoginHelper().jaas_login(byArray, string2, httpServletRequest, httpServletResponse, map, subject));
                            }
                            if (subject2 != null) {
                                this.processSubjectForPropagationAfterLogin(subject2, string2, byArray);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding propagation login Subject to cache.");
                                }
                                if (object != null) {
                                    this.cache.insert(subject2, new Object[]{object, byArray});
                                } else {
                                    this.cache.insert(subject2, new Object[]{byArray});
                                }
                            }
                        }
                        if (subject2 == null) break block58;
                        try {
                            object2 = SubjectHelper.getWSCredentialFromSubject(subject2);
                            if (object2 != null) {
                                boolean bl = object2.isDestroyed();
                                boolean bl2 = false;
                                try {
                                    bl2 = this.getWSCredTokenMapper().checkValidityOfAllTokens(subject2);
                                }
                                catch (WSLoginFailedException wSLoginFailedException) {
                                    if (!tc.isDebugEnabled()) throw wSLoginFailedException;
                                    Tr.debug(tc, "within cushion window, fail sso.");
                                    throw wSLoginFailedException;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "login(realm, token, . . .): is subject valid? " + bl2);
                                }
                                if (bl || !bl2) {
                                    boolean bl3 = this.getWSCredTokenMapper().checkGSSCredExpired(subject2);
                                    String string3 = object2.getRealmName();
                                    String string4 = object2.getSecurityName();
                                    this.cache.removeEntry(string3, string4);
                                    subject2 = null;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                                    }
                                    if (bl3) {
                                        throw new WSLoginFailedException("GSSCredential expired, must login again.");
                                    }
                                    break block58;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "login(realm, token, authMech, . . .)");
                                }
                                Subject subject3 = subject2;
                                return subject3;
                            }
                        }
                        catch (CredentialDestroyedException credentialDestroyedException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Credential is destroyed.", new Object[]{credentialDestroyedException});
                            }
                            subject2 = null;
                            break block58;
                        }
                        catch (CredentialExpiredException credentialExpiredException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Credential has expired.", new Object[]{credentialExpiredException});
                            }
                            subject2 = null;
                            break block58;
                        }
                        {
                            subject2 = null;
                        }
                    }
                    if (subject2 == null && (subject2 = string2 == null ? this.getJaasLoginHelper().jaas_login(byArray, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(byArray, string2, subject) : this.getJaasLoginHelper().jaas_login(byArray, string2, httpServletRequest, httpServletResponse, map, subject))) != null) {
                        this.processSubjectForPropagationAfterLogin(subject2, string2, byArray);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding new Subject to cache.");
                        }
                        if (object != null) {
                            this.cache.insert(subject2, new Object[]{object, byArray});
                        } else {
                            this.cache.insert(subject2, new Object[]{byArray});
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "login(realm, token, authMech, . . .)");
                    }
                    object2 = subject2;
                    return object2;
                }
                if (!tc.isEntryEnabled()) throw new WSLoginFailedException("Token can not be validated on a pure client or authentication target is basic authen");
                Tr.exit(tc, "login(realm, token, authMech, . . .)");
                throw new WSLoginFailedException("Token can not be validated on a pure client or authentication target is basic authen");
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.auth.ContextManagerImpl.login", "2994", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + wSLoginFailedException);
                }
                if (!tc.isEntryEnabled()) throw wSLoginFailedException;
                Tr.exit(tc, "login(realm, token, authMech, . . .)");
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3001", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + this.dump(exception));
                }
                object = new WSLoginFailedException(exception.getMessage(), exception);
                if (!tc.isEntryEnabled()) throw object;
                Tr.exit(tc, "login(realm, token, authMech, . . .)");
                throw object;
            }
            finally {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Clearing propagation token from thread.");
                }
                ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            }
        }
        if (!tc.isEntryEnabled()) return null;
        Tr.exit(tc, "login(realm, token, authMech, . . .)");
        return null;
    }

    private void processSubjectForPropagationAfterLogin(Subject subject, String string) {
        this.processSubjectForPropagationAfterLogin(subject, string, null);
    }

    public Subject login(String string, Object object, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
        }
        if (this.isCellSecurityEnabled() && object != null && subject != null) {
            if (this.secConfig == null || !this.secConfig.processIsServer()) {
                return null;
            }
            try {
                Subject subject2 = this.getJaasLoginHelper().jaas_login(string, object, subject);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
                }
                return subject2;
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3043", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + wSLoginFailedException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3050", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + this.dump(exception));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
        }
        return null;
    }

    public Subject login(String string, X509Certificate[] x509CertificateArray) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, certChain) -> login(" + string + ", " + x509CertificateArray + ")");
        }
        Subject subject = this.login(string, x509CertificateArray, null, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, certChain)");
        }
        return subject;
    }

    public Subject login(String string, X509Certificate[] x509CertificateArray, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        return this.login(string, x509CertificateArray, string2, httpServletRequest, httpServletResponse, map, (Subject)null);
    }

    public Subject login(String string, X509Certificate[] x509CertificateArray, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        return this.login(string, (Object)x509CertificateArray, string2, httpServletRequest, httpServletResponse, map, subject);
    }

    public Subject login(String string, String string2) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, user) -> login(" + string + ", " + string2 + ")");
        }
        Subject subject = this.login(string, string2, null, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, user)");
        }
        return subject;
    }

    public Subject login(String string, String string2, String string3) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, user, password) -> login(" + string + ", " + string2 + ", " + SecurityConfiguration.mask(string3) + ")");
        }
        String string4 = null;
        if (this.secConfig != null) {
            string4 = this.secConfig.getAuthMechAuthAlias();
        }
        Subject subject = this.login(string, string2, string3, string4, null, null, (Map)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, user, password)");
        }
        return subject;
    }

    public Subject login(String string, String string2, String string3, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        return this.login(string, string2, string3, httpServletRequest, httpServletResponse, map, null);
    }

    public Subject login(String string, String string2, String string3, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        return this.login(string, (Object)string2, string3, httpServletRequest, httpServletResponse, map, subject);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Subject login(String string, Object object, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, loginInfo, auth_mech) -> login(" + string + ", " + object + ", " + string2 + ")");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
            }
            securityManager.checkPermission(MAP_CREDENTIAL);
        }
        if (!this.isCellSecurityEnabled()) {
            if (!tc.isEntryEnabled()) return null;
            Tr.exit(tc, "login(realm, loginInfo, . . .)");
            return null;
        }
        if (this.secConfig == null) return null;
        if (!this.secConfig.processIsServer()) {
            return null;
        }
        this.checkAuthRetryForThread();
        Subject subject2 = null;
        ArrayList arrayList = null;
        String string3 = null;
        try {
            Object[] objectArray;
            block51: {
                subject2 = this.getSubjectFromHashtableCacheKey(subject);
                if (subject2 == null && (this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for opaque token in thread before doing Subject lookup.");
                    }
                    if ((objectArray = this.getSubjectFromTokenHolderCacheKey(null, arrayList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup()))) != null) {
                        subject2 = (Subject)objectArray[0];
                        string3 = (String)objectArray[1];
                    }
                }
                if (subject2 == null && arrayList == null && !this.getWSCredTokenMapper().subjectContainsLoginHashtable(subject)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for Subject using loginInfo(user or cert).");
                    }
                    subject2 = object instanceof String ? this.cache.getSubject(string, (String)object) : this.cache.getSubject(object);
                }
                if (subject2 == null) break block51;
                try {
                    objectArray = (WSCredential)subject2.getPublicCredentials(WSCredential.class).iterator().next();
                    if (objectArray != null) {
                        boolean bl = objectArray.isDestroyed();
                        boolean bl2 = objectArray.isForwardable();
                        boolean bl3 = this.getWSCredTokenMapper().checkCushionValidityOfAllTokens(subject2, this.cache.getCushion());
                        if (tc.isDebugEnabled()) {
                            if (bl2) {
                                Tr.debug(tc, "login(realm, loginInfo, . . .): is subject valid? " + bl3);
                            } else {
                                Tr.debug(tc, "login(realm, loginInfo, . . .): is subject valid? non-forwardable Subject");
                            }
                        }
                        if (bl || bl2 && !bl3) {
                            if (object instanceof String) {
                                this.cache.removeEntry(string, (String)object);
                            } else {
                                this.cache.removeEntry(object);
                            }
                            subject2 = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                            }
                            break block51;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "login(realm, loginInfo, ...)");
                        }
                        Subject subject3 = subject2;
                        return subject3;
                    }
                }
                catch (CredentialDestroyedException credentialDestroyedException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Credential is destroyed.", new Object[]{credentialDestroyedException});
                    }
                    subject2 = null;
                    break block51;
                }
                catch (CredentialExpiredException credentialExpiredException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Credential has expired.", new Object[]{credentialExpiredException});
                    }
                    subject2 = null;
                    break block51;
                }
                {
                    subject2 = null;
                }
            }
            if (subject2 == null) {
                if (string2 == null) {
                    if (object instanceof String) {
                        subject2 = this.getJaasLoginHelper().jaas_login(string, (String)object, (String)null, subject);
                    } else {
                        if (!(object instanceof X509Certificate[])) throw new WSLoginFailedException("Unknown login data type: " + object.getClass().getName());
                        subject2 = this.getJaasLoginHelper().jaas_login(string, (X509Certificate[])object, subject);
                    }
                } else if (httpServletRequest == null) {
                    if (object instanceof String) {
                        subject2 = this.getJaasLoginHelper().jaas_login(string, (String)object, null, string2, subject);
                    } else {
                        if (!(object instanceof X509Certificate[])) throw new WSLoginFailedException("Unknown login data type: " + object.getClass().getName());
                        subject2 = this.getJaasLoginHelper().jaas_login(string, (X509Certificate[])object, string2, subject);
                    }
                } else if (object instanceof String) {
                    subject2 = this.getJaasLoginHelper().jaas_login(string, (String)object, null, string2, httpServletRequest, httpServletResponse, map, subject);
                } else {
                    if (!(object instanceof X509Certificate[])) throw new WSLoginFailedException("Unknown login data type: " + object.getClass().getName());
                    subject2 = this.getJaasLoginHelper().jaas_login(string, (X509Certificate[])object, string2, httpServletRequest, httpServletResponse, map, subject);
                }
                this.processSubjectForPropagationAfterLogin(subject2, string2);
                if (string3 != null) {
                    this.cache.insert(subject2, new Object[]{string3});
                } else if (object instanceof String) {
                    this.cache.insert(subject2, (String)object, null, null);
                } else {
                    this.cache.insert(subject2, (Object[])null);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "login(realm, loginInfo, . . .)");
            }
            objectArray = subject2;
            return objectArray;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3285", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login failed: " + wSLoginFailedException);
            }
            if (!tc.isEntryEnabled()) throw wSLoginFailedException;
            Tr.exit(tc, "login(realm, loginInfo, . . .)");
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3292", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login failed: " + this.dump(exception));
            }
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
            if (!tc.isEntryEnabled()) throw wSLoginFailedException;
            Tr.exit(tc, "login(realm, loginInfo, . . .)");
            throw wSLoginFailedException;
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing propagation token from thread.");
            }
            ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
        }
    }

    public Subject login(String string, String string2, String string3, String string4, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        return this.login(string, string2, string3, string4, httpServletRequest, httpServletResponse, map, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(final String string, final String string2, final String string3, String string4, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, user, password) -> login(" + string + ", " + string2 + ", " + SecurityConfiguration.mask(string3) + ", " + string4 + " AppContext: " + map + ")");
        }
        if (!this.isCellSecurityEnabled()) {
            if (!tc.isEntryEnabled()) return null;
            Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
            return null;
        }
        if (this.secConfig == null) {
            return null;
        }
        this.checkAuthRetryForThread();
        try {
            Object object;
            String string5;
            String string6;
            Serializable serializable2;
            block67: {
                if (!this.secConfig.processIsServer()) {
                    if (string2 == null) throw new WSLoginFailedException("Username and/or password is null.");
                    if (string2.length() == 0) throw new WSLoginFailedException("Username and/or password is null.");
                    if (string3 == null) throw new WSLoginFailedException("Username and/or password is null.");
                    if (string3.length() == 0) {
                        throw new WSLoginFailedException("Username and/or password is null.");
                    }
                    serializable2 = this.createBasicAuthCredential(string, string2, string3);
                    if (!this.secConfig.validateBasicAuth()) {
                        Subject subject2 = SubjectHelper.createSubjectFromWSCredential((WSCredential)serializable2);
                        return subject2;
                    }
                    try {
                        serializable = (Boolean)this.runAsSpecified(SubjectHelper.createUnauthenticatedSubject(), new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                boolean bl = ContextManagerImpl.this.getSecurityServer().simple_authenticate(new BasicAuthData(string2, string3, string));
                                return new Boolean(bl);
                            }
                        });
                        if (((Boolean)serializable).booleanValue()) {
                            if (!this.getThreadLocal().get_server_security_enabled()) {
                                serializable2 = null;
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "login(realm, user, password)");
                            }
                            Subject subject3 = SubjectHelper.createSubjectFromWSCredential((WSCredential)serializable2);
                            return subject3;
                        }
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3368", this);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "login(realm, user, password)");
                        }
                        if (exception instanceof WSLoginFailedException) {
                            throw exception;
                        }
                        WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                        throw wSLoginFailedException;
                    }
                    {
                        if (!tc.isEntryEnabled()) throw new WSLoginFailedException("Failed to authenticate " + serializable2.getRealmSecurityName());
                        Tr.exit(tc, "login(realm, user, password)");
                        throw new WSLoginFailedException("Failed to authenticate " + serializable2.getRealmSecurityName());
                    }
                }
                serializable2 = null;
                serializable = null;
                string6 = null;
                string5 = null;
                if (this.secConfig.isRMIInboundMappingEnabled() && this.secConfig.getRMIInboundMappingConfig() != null && this.secConfig.getRMIInboundMappingConfig().length() > 0 && subject != null && map != null) {
                    Object object2;
                    String string7;
                    String string8;
                    block66: {
                        object = null;
                        string8 = null;
                        string7 = null;
                        try {
                            object2 = subject.getPrivateCredentials(WSSubjectWrapperImpl.class).iterator();
                            if (object2.hasNext()) {
                                object = (WSSubjectWrapper)object2.next();
                            }
                            if (object == null) break block66;
                            string8 = (String)map.get("WebAppName");
                            string7 = this.getWSCredTokenMapper().createSubjectUniqueID(object.getSubject());
                            if (string7 == null) {
                                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(object.getSubject());
                                string7 = wSCredential.getAccessId();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " appName = " + string8 + " subjectId = " + string7);
                            }
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block66;
                            Tr.debug(tc, "Exception caught " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                    if (string7 != null && string7.length() > 0 && string8 != null && string8.length() > 0) {
                        string5 = string7 + "__" + string8;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appSubjectCacheKey = " + string5);
                        }
                        object2 = new Hashtable();
                        ((Hashtable)object2).put("com.ibm.wsspi.security.cred.cacheKey", string5);
                        subject.getPrivateCredentials().add(object2);
                    }
                } else if (!(string2 != null && string2.length() != 0 && string3 != null && string3.length() != 0 || this.getWSCredTokenMapper().subjectContainsLoginHashtable(subject))) {
                    throw new WSLoginFailedException("Username and/or password is null.");
                }
                if (this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for opaque token on the thread before Subject cache lookup.");
                    }
                    if ((object = this.getSubjectFromTokenHolderCacheKey(null, (List)((Object)(serializable = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup()))))) != null && (object[0] != null || object[1] != null)) {
                        serializable2 = (Subject)object[0];
                        string6 = (String)object[1];
                    }
                }
                if (serializable == null) {
                    if (string2 != null && string2.length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for subject from cache using user name token as lookup.");
                        }
                        serializable2 = this.cache.getSubject(string, string2, string3);
                    } else if (string5 != null) {
                        serializable2 = this.cache.getSubject(string5);
                        if (tc.isDebugEnabled() && serializable2 != null) {
                            Tr.debug(tc, "found subject in cache with key = " + string5);
                        }
                    }
                }
                if (serializable2 == null) break block67;
                try {
                    object = SubjectHelper.getWSCredentialFromSubject((Subject)serializable2);
                    if (object != null) {
                        boolean bl = object.isDestroyed();
                        boolean bl2 = object.isForwardable();
                        boolean bl3 = this.getWSCredTokenMapper().checkCushionValidityOfAllTokens((Subject)serializable2, this.cache.getCushion());
                        if (tc.isDebugEnabled()) {
                            if (bl2) {
                                Tr.debug(tc, "login(realm, user, password, . . .): is subject valid? " + bl3);
                            } else {
                                Tr.debug(tc, "login(realm, user, password, . . .): is subject valid? non-forwardable Subject");
                            }
                        }
                        if (bl || bl2 && !bl3) {
                            this.cache.removeEntry(string, string2);
                            serializable2 = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                            }
                            break block67;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
                        }
                        Serializable serializable3 = serializable2;
                        return serializable3;
                    }
                }
                catch (CredentialDestroyedException credentialDestroyedException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Credential is destroyed.", new Object[]{credentialDestroyedException});
                    }
                    serializable2 = null;
                    break block67;
                }
                catch (CredentialExpiredException credentialExpiredException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Credential has expired.", new Object[]{credentialExpiredException});
                    }
                    serializable2 = null;
                    break block67;
                }
                {
                    serializable2 = null;
                }
            }
            if (serializable2 == null) {
                serializable2 = string4 == null ? this.getJaasLoginHelper().jaas_login(string, string2, string3, subject) : (httpServletRequest == null && map == null ? this.getJaasLoginHelper().jaas_login(string, string2, string3, string4, subject) : this.getJaasLoginHelper().jaas_login(string, string2, string3, string4, httpServletRequest, httpServletResponse, map, subject));
                this.processSubjectForPropagationAfterLogin((Subject)serializable2, string4);
                if (string5 == null) {
                    this.cache.insert((Subject)serializable2, string2, string3, new Object[]{string6});
                } else {
                    block68: {
                        try {
                            string5 = (String)this.getWSCredTokenMapper().getCacheKeyFromHashtable((Subject)serializable2);
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block68;
                            Tr.debug(tc, "Exception caught " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                    if (string5 != null && string5.length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "insert cache: user = " + string2 + "  cache key = " + string5);
                        }
                        this.cache.insert((Subject)serializable2, string2, string3, new Object[]{string5});
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
            }
            object = serializable2;
            return object;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3561", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login failed: " + wSLoginFailedException);
            }
            if (!tc.isEntryEnabled()) throw wSLoginFailedException;
            Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3571", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login failed: " + this.dump(exception));
            }
            serializable = new WSLoginFailedException(exception.getMessage(), exception);
            if (!tc.isEntryEnabled()) throw serializable;
            Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
            throw serializable;
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing propagation token from thread.");
            }
            ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
        }
    }

    public Subject login(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(credential)");
        }
        if (this.isCellSecurityEnabled() && wSCredential != null) {
            this.checkAuthRetryForThread();
            try {
                if (wSCredential.isBasicAuth()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "authenticating userid/password credential.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "login(credential)");
                    }
                    return this.login(wSCredential.getRealmName(), wSCredential.getSecurityName(), StringBytesConversion.getConvertedString(wSCredential.getCredentialToken()));
                }
                if (wSCredential.isCurrent()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "login(credential)");
                    }
                    return SubjectHelper.createSubjectFromWSCredential(wSCredential);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Credential is not current.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(credential)");
                }
                throw new WSLoginFailedException("Credential is not current.");
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3632", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSLoginFailedException occurred.", new Object[]{wSLoginFailedException});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(credential)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3639", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authenticate failed: ", this.dump(exception));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(credential)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(credential)");
        }
        return null;
    }

    public void popInvocationCredential(WSCredential wSCredential) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setInvocationCredential(wSCredential);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.popInvocationCredential", "3663", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void popInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setInvocationSubject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.popInvocationSubject", "3680", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void popReceivedSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setCallerSubject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.popReceivedSubject", "3696", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public boolean processIsServer() {
        if (this.secConfig != null) {
            return this.secConfig.processIsServer();
        }
        return ConfigURLProperties.processIsServer();
    }

    private void processSubjectForPropagationAfterLogin(Subject subject, String string, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSubjectForPropagationAfterLogin", new Object[]{string, new ByteArray(byArray)});
        }
        try {
            Object object;
            ByteArray byteArray = null;
            if (this.secConfig.isWebInboundPropagationEnabled() && byArray != null && (object = (Object)((byte[])this.getDistributedObject(byteArray = new ByteArray(byArray)))) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processSubjectForPropagationAfterLogin (token already exists in DRS).");
                }
                return;
            }
            object = SubjectHelper.getWSCredentialFromSubject(subject);
            if (this.secConfig != null && this.secConfig.isWebInboundPropagationEnabled() || "oid:1.2.840.113554.1.2.2".endsWith(object.getOID())) {
                if (object.isForwardable()) {
                    SingleSignonToken singleSignonToken;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting SSO token from Subject.");
                    }
                    if ((singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject)) != null) {
                        Object object2;
                        ByteArray byteArray2 = new ByteArray(singleSignonToken.getBytes());
                        PropagationToken propagationToken = this.getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                        long l = 0L;
                        l = propagationToken != null ? (propagationToken.getExpiration() < object.getExpiration() ? propagationToken.getExpiration() : object.getExpiration()) : object.getExpiration();
                        long l2 = System.currentTimeMillis();
                        long l3 = l - l2;
                        int n = (int)(l3 / 1000L);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "timeToLiveSeconds: " + n);
                        }
                        if (this.secConfig.isWebInboundPropagationEnabled()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking DRS using SSO token.");
                            }
                            if ((object2 = (Object)((byte[])this.getDistributedObject(byteArray2))) == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Creating new opaque token.");
                                }
                                object2 = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(subject);
                                if (l3 > 0L && object2 != null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding opaque token to distributed cache with timeToLive " + n + " seconds.");
                                    }
                                    this.putDistributedObject(byteArray2, object2, n);
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Opaque token was null.");
                                }
                            }
                            if (byteArray != null) {
                                if (l3 > 0L && object2 != null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding input token to distributed cache with timeToLive " + n + " seconds.");
                                    }
                                    this.putDistributedObject(byteArray, object2, n);
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Input token was null, not adding to DRS.");
                            }
                        }
                        if ((object2 = SubjectHelper.getGSSCredentialFromSubject(subject)) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding GSSCredential to local cache with timeToLive " + n + " seconds.");
                            }
                            this.putDistributedObjectNotShared(byteArray2, object2, n);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot find LtpaToken2, not adding opaque token to distributed cache.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential is not forwardable, not adding to distributed cache.");
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception adding opaque authz token to distributed cache.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.processSubjectForPropagationAfterLogin", "3836", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSubjectForPropagationAfterLogin");
        }
    }

    public WSCredential pushInvocationCredential(WSCredential wSCredential) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                WSCredential wSCredential2 = this.getInvocationCredential();
                this.setInvocationCredential(wSCredential);
                return wSCredential2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.pushInvocationCredential", "3854", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public Subject pushInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Subject subject2 = this.getInvocationSubject();
                this.setInvocationSubject(subject);
                return subject2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.pushInvocationSubject", "3875", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public Subject pushReceivedSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Subject subject2 = this.getCallerSubject();
                this.setCallerSubject(subject);
                return subject2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.pushReceivedSubject", "3895", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public Object put(String string, Object object) {
        if (this.isCellSecurityEnabled()) {
            return this.getThreadLocal().set_property(string, object);
        }
        return null;
    }

    private Object putDistributedObject(Object object, Object object2, int n) {
        try {
            return this.getWSCredTokenMapper().putDistributedObject(object, object2, n);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.auth.distContextManager.getDistributedObject", "3950");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error setting distributed object.", new Object[]{exception});
            }
            return null;
        }
    }

    private Object putDistributedObject(Object object, Object object2, int n, int n2, int n3, Object[] objectArray) {
        try {
            return this.getWSCredTokenMapper().putDistributedObject(object, object2, n, n2, n3, objectArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.auth.distContextManager.getDistributedObject", "4000");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error setting distributed object.", new Object[]{exception});
            }
            return null;
        }
    }

    private Object putDistributedObjectNotShared(Object object, Object object2, int n) {
        try {
            return this.getWSCredTokenMapper().putDistributedObjectNotShared(object, object2, n);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.auth.distContextManager.putDistributedObjectNotShared", "4043");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error setting none shared distributed object.", new Object[]{exception});
            }
            return null;
        }
    }

    private void removeStateFromTable() {
        this.getThreadLocal().clearThreadContextImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object runAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, String string) throws PrivilegedActionException {
        Serializable serializable;
        Object var8_8;
        block41: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "runAs", new Object[]{subject, privilegedExceptionAction, string});
            }
            this.debugCallingMethod();
            String string2 = EMPTY;
            String string3 = "ContextManager.runAs";
            Subject subject2 = null;
            Subject subject3 = null;
            var8_8 = null;
            boolean bl = false;
            if (ConfigURLProperties.isSecurityEnabled()) {
                try {
                    Subject subject4;
                    serializable = null;
                    if (string.equals("System")) {
                        serializable = this.getServerSubject();
                    } else if (string.equals("Client")) {
                        subject4 = this.getCallerSubject();
                        serializable = subject4 != null ? subject4 : this.getInvocationSubject();
                    } else if (string.equals("ReceivedClient")) {
                        subject4 = this.getCallerSubject();
                        if (subject4 != null) {
                            serializable = subject4;
                        }
                    } else if (string.equals("Specified")) {
                        serializable = subject;
                    }
                    subject2 = this.pushInvocationSubject((Subject)serializable);
                    subject3 = this.pushReceivedSubject((Subject)serializable);
                    bl = this.setSavedSubjects(subject2, subject3);
                }
                catch (Exception exception) {
                    try {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                    }
                    catch (Exception exception2) {
                        try {
                            this.popReceivedSubject(subject3);
                            subject3 = null;
                        }
                        catch (Exception exception3) {
                            FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4139", this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "runAs(" + string + ") -> Exception occurred.", new Object[]{exception3});
                            }
                            throw new PrivilegedActionException(exception3);
                        }
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4144", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "runAs(" + string + ") -> Exception occurred.", new Object[]{exception});
                    }
                    throw new PrivilegedActionException(exception);
                }
            }
            serializable = null;
            try {
                var8_8 = privilegedExceptionAction.run();
                Object var14_16 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (ConfigURLProperties.isSecurityEnabled()) {
                    try {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                        if (bl) {
                            this.clearSavedSubjects();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            this.popInvocationSubject(subject2);
                            subject2 = null;
                            this.popReceivedSubject(subject3);
                            subject3 = null;
                        }
                        catch (Exception exception4) {
                            FFDCFilter.processException((Throwable)exception4, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4199", this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "runAs(" + string + ") -> Exception occurred.", new Object[]{exception4});
                            }
                            throw new PrivilegedActionException(exception4);
                        }
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4203", this);
                        serializable = exception;
                    }
                }
                throw throwable;
            }
            if (ConfigURLProperties.isSecurityEnabled()) {
                try {
                    this.popInvocationSubject(subject2);
                    subject2 = null;
                    this.popReceivedSubject(subject3);
                    subject3 = null;
                    if (bl) {
                        this.clearSavedSubjects();
                    }
                    break block41;
                }
                catch (Exception exception) {
                    try {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                    }
                    catch (Exception exception5) {
                        FFDCFilter.processException((Throwable)exception5, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4199", this);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "runAs(" + string + ") -> Exception occurred.", new Object[]{exception5});
                        }
                        throw new PrivilegedActionException(exception5);
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4203", this);
                    serializable = exception;
                }
            }
            break block41;
            {
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4162", this);
                    serializable = exception;
                    Object var14_17 = null;
                    if (!ConfigURLProperties.isSecurityEnabled()) break block41;
                    try {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                        if (bl) {
                            this.clearSavedSubjects();
                        }
                    }
                    catch (Exception exception6) {
                        try {
                            this.popInvocationSubject(subject2);
                            subject2 = null;
                            this.popReceivedSubject(subject3);
                            subject3 = null;
                        }
                        catch (Exception exception7) {
                            FFDCFilter.processException((Throwable)exception7, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4199", this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "runAs(" + string + ") -> Exception occurred.", new Object[]{exception7});
                            }
                            throw new PrivilegedActionException(exception7);
                        }
                        FFDCFilter.processException((Throwable)exception6, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4203", this);
                        serializable = exception6;
                    }
                }
            }
        }
        if (serializable != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runAs(" + string + ") -> Exception occurred.", new Object[]{serializable});
            }
            throw new PrivilegedActionException((Exception)serializable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runAs(" + string + ")");
        }
        return var8_8;
    }

    public Object runAsClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(null, privilegedExceptionAction, "Client");
    }

    public Object runAsReceivedClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(null, privilegedExceptionAction, "ReceivedClient");
    }

    public Object runAsSpecified(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(subject, privilegedExceptionAction, "Specified");
    }

    public Object runAsSpecified(WSCredential wSCredential, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(SubjectHelper.createSubjectFromWSCredential(wSCredential), privilegedExceptionAction, "Specified");
    }

    public Object runAsSystem(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (this.processIsServer()) {
            return this.runAs(null, privilegedExceptionAction, "System");
        }
        try {
            this.debugCallingMethod();
            return privilegedExceptionAction.run();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4266", this);
            if (exception instanceof PrivilegedActionException) {
                throw (PrivilegedActionException)exception;
            }
            throw new PrivilegedActionException(exception);
        }
    }

    public Object runAsSystemOrSpecified(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runAsSystemOrSpecified");
        }
        Object object = null;
        boolean bl = false;
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        if (this.isCellSecurityEnabled() && PlatformHelperFactory.getPlatformHelper().isZOS()) {
            String string;
            Object object2;
            WSCredential wSCredential;
            block10: {
                wSCredential = null;
                try {
                    object2 = this.getServerSubject();
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.auth.ContextManagerImpl.runAsSystemOrSpecified", "4301", this);
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "getServerSubject() failed", wSSecurityException);
                }
            }
            object2 = this.serverSubject.getPublicCredentials(WSCredential.class).iterator();
            if (object2.hasNext()) {
                wSCredential = (WSCredential)object2.next();
            }
            if (wSCredential != null && this.isInternalServerCredential(wSCredential) && (string = (String)securityConfig.getValue("com.ibm.ws.security.zOS.useSAFidForTransaction")) != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
                Subject subject;
                block11: {
                    subject = WSLoginLocalOSExtensionFactory.getInstance().getLocalOSPlatformCredSubject();
                    try {
                        this.setInvocationSubject(subject);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "failed to set the invocation subject.", exception);
                    }
                }
                object = this.runAsSpecified(subject, privilegedExceptionAction);
                bl = true;
            }
        }
        if (!bl) {
            object = this.runAsSystem(privilegedExceptionAction);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runAsSystemOrSpecified");
        }
        return object;
    }

    public void setCallerCredentials(WSCredential[] wSCredentialArray) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCallerCredentials");
            }
            try {
                if (tc.isDebugEnabled() && wSCredentialArray != null && wSCredentialArray[0] != null) {
                    Tr.debug(tc, "Setting WS received credential: " + wSCredentialArray[0].getRealmSecurityName());
                }
                StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
                stateofCurrObj.setWSReceivedCreds(wSCredentialArray);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setCallerCredentials");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.setCallerCredentials", "4374", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void setCallerSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCallerSubject");
            }
            try {
                Object object;
                if (tc.isDebugEnabled()) {
                    if (subject != null) {
                        object = subject;
                        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((Subject)object){
                            private final /* synthetic */ Subject val$subjectPriv;
                            {
                                this.val$subjectPriv = subject;
                            }

                            public Object run() {
                                Tr.debug(tc, "Setting caller subject: " + this.val$subjectPriv);
                                return null;
                            }
                        });
                    } else {
                        Tr.debug(tc, "Setting caller subject to NULL.");
                    }
                }
                object = this.getThreadLocal().get_state_of_curr_obj();
                ((StateofCurrObj)object).setCallerSubject(subject);
                if (this.getPlatformHelper().isZOS() && (SmfJActivity.isServerActivityRecordingEnabled() || SmfJActivity.isServerIntervalRecordingEnabled())) {
                    this.setFirstAuthUser(subject);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setCallerSubject");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.setCallerSubject", "4422", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void setInvocationCredential(WSCredential wSCredential) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setInvocationCredential");
                }
                if (tc.isDebugEnabled() && wSCredential != null) {
                    Tr.debug(tc, "Setting WS invocation credential: " + wSCredential.getRealmSecurityName());
                }
                StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
                stateofCurrObj.setWSInvocationCred(wSCredential);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setInvocationCredential");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.setInvocationCredential", "4451", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void setInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Object object;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setInvocationSubject");
                }
                if (tc.isDebugEnabled()) {
                    if (subject != null) {
                        object = subject;
                        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((Subject)object){
                            private final /* synthetic */ Subject val$subjectPriv;
                            {
                                this.val$subjectPriv = subject;
                            }

                            public Object run() {
                                Tr.debug(tc, "Setting invocation subject: " + this.val$subjectPriv);
                                return null;
                            }
                        });
                    } else {
                        Tr.debug(tc, "Setting invocation subject to NULL.");
                    }
                }
                object = this.getThreadLocal().get_state_of_curr_obj();
                ((StateofCurrObj)object).setInvocationSubject(subject);
                if (this.getPlatformHelper().isZOS() && (SmfJActivity.isServerActivityRecordingEnabled() || SmfJActivity.isServerIntervalRecordingEnabled())) {
                    this.setFirstAuthUser(subject);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setInvocationSubject");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.setInvocationSubject", "4499", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void setOwnSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Object object;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setOwnSubject");
                }
                if (tc.isDebugEnabled()) {
                    if (subject != null) {
                        object = subject;
                        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((Subject)object){
                            private final /* synthetic */ Subject val$subjectPriv;
                            {
                                this.val$subjectPriv = subject;
                            }

                            public Object run() {
                                Tr.debug(tc, "Setting own subject: " + this.val$subjectPriv);
                                return null;
                            }
                        });
                    } else {
                        Tr.debug(tc, "Setting own subject to NULL.");
                    }
                }
                object = this.getThreadLocal().get_state_of_curr_obj();
                ((StateofCurrObj)object).setOwnSubject(subject);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setOwnSubject");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.setOwnSubject", "4542", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void setPlatformHelper(PlatformHelper platformHelper) {
        PlatformHelperFactory.setPlatformHelper(platformHelper);
    }

    public PropagationToken setPropagationToken(String string, PropagationToken propagationToken) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            if (string == null) {
                throw new WSSecurityException("Invalid null parameters.");
            }
            return this.getThreadLocal().set_propagation_token(string, propagationToken);
        }
        return null;
    }

    public void setRootException(Throwable throwable) {
        Throwable throwable2;
        if (this.isCellSecurityEnabled() && (throwable2 = this.getThreadLocal().get_root_exception()) == null) {
            this.getThreadLocal().set_root_exception(throwable);
        }
    }

    public void setServerSecurityEnabled(boolean bl) {
        this.serverSecurityEnabled = bl;
    }

    public boolean isGrantedAdminRole(String[] stringArray, Subject subject) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAdminRole");
        }
        if (!this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedAdminRole - return true");
            }
            return true;
        }
        boolean bl = false;
        try {
            RoleBasedConfigurator roleBasedConfigurator = RoleBasedConfiguratorFactory.getConfigurator();
            RoleBasedAuthorizer roleBasedAuthorizer = roleBasedConfigurator.getRoleBasedAuthorizer("admin-authz", "domain");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got the RoleBasedAuthorizer object.");
            }
            bl = roleBasedAuthorizer.isGrantedRole(stringArray, subject);
        }
        catch (Throwable throwable) {
            String string = new String(this.getRegistryObject().toString());
            if (string.indexOf(this.WIM_UR) == -1) {
                FFDCFilter.processException(throwable, "com.ibm.ws.security.auth.ContextManagerImpl.isGrantedAdminRole", "4634", this);
            }
            throw new WSSecurityException(throwable.getMessage(), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAdminRole", new Boolean(bl));
        }
        return bl;
    }

    public boolean isServerSubjectCreated() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isServerSubjectCreated");
        }
        if (!this.processIsServer()) {
            this.serverSubjectCreated = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "process is not server, returning true");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isServerSubjectCreated:" + this.serverSubjectCreated);
        }
        return this.serverSubjectCreated;
    }

    public boolean isInternalServerCredential(WSCredential wSCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInternalServerCredential", wSCredential);
        }
        boolean bl = false;
        try {
            String string = wSCredential.getAccessId();
            bl = this.isInternalServerId(string);
        }
        catch (Exception exception) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to acquire access ID", exception);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInternalServerCredential", new Boolean(bl));
        }
        return bl;
    }

    public boolean isInternalServerId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInternalServerId", string);
        }
        boolean bl = false;
        try {
            StringBuffer stringBuffer = new StringBuffer(this.getDefaultRealm());
            stringBuffer.append("/").append("server");
            if (string != null && (string.startsWith("server") || string.startsWith(stringBuffer.toString()))) {
                bl = true;
            }
        }
        catch (Exception exception) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to determine internal server ID", exception);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInternalServerId", new Boolean(bl));
        }
        return bl;
    }

    public String removePrefix(String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePrefix", string);
        }
        if ((n = string.indexOf(":")) != 1) {
            String string2 = string.substring(n + 1);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removePrefix", string2);
            }
            return string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePrefix: prefix not found", string);
        }
        return string;
    }

    public String getFirstAuthUser() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstAuthUser");
        }
        StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
        String string = stateofCurrObj.getFirstAuthUser();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstAuthUser", string);
        }
        return string;
    }

    public void setFirstAuthUser(Subject subject) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setFirstAuthUser", subject);
            }
            StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
            if (subject != null && !stateofCurrObj.getAuthFlag()) {
                try {
                    if (!SubjectHelper.getWSCredentialFromSubject(subject).isUnauthenticated() && !this.isServerSubject(subject)) {
                        stateofCurrObj.setAuthFlag(true);
                    }
                    PlatformCredential platformCredential = this.getPlatformCredentialFromSubject(subject);
                    String string = null;
                    if (platformCredential != null) {
                        string = platformCredential.getUserId();
                    }
                    stateofCurrObj.setFirstAuthUser(string);
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.auth.ContextManagerImpl.setFirstAuthUser", "4790", this);
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Error setting firstAuthUser");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFirstAuthUser");
        }
    }

    private PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        PlatformCredential platformCredential;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
            }
            platformCredential = null;
            Iterator iterator = subject.getPrivateCredentials(PlatformCredential.class).iterator();
            if (iterator.hasNext()) {
                platformCredential = (PlatformCredential)iterator.next();
            }
            if (platformCredential == null) {
                WSCredential wSCredential = null;
                Iterator iterator2 = subject.getPublicCredentials(WSCredential.class).iterator();
                if (iterator2.hasNext()) {
                    wSCredential = (WSCredential)iterator2.next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential", wSCredential);
                }
                if (wSCredential != null) {
                    try {
                        final WSCredential wSCredential2 = wSCredential;
                        platformCredential = (PlatformCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return wSCredential2.get("com.ibm.ws.security.zos.PlatformCredential");
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Unable to get PlatformCredential", exception);
                    }
                }
            }
        }
        if (platformCredential == null) {
            platformCredential = this._platformCredManager.createDefaultCredential();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredentialFromSubject", platformCredential);
        }
        return platformCredential;
    }

    private SecurityService getSecurityService() {
        SecurityService securityService;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSecurityService");
            }
            securityService = null;
            try {
                securityService = (SecurityService)WsServiceRegistry.getService((Object)this, (Class)SecurityService.class);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unexpected exception getting security service:", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityService", securityService);
        }
        return securityService;
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged, current Security Service state: " + (this.isSecurityServiceStarted ? "STARTED" : "STOPPED"));
        }
        if ((n = securityServiceEvent.getState()) == 1) {
            this.isSecurityServiceStarted = true;
        } else if (n == 2) {
            this.isSecurityServiceStarted = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged, new Security Service state: " + (this.isSecurityServiceStarted ? "STARTED" : "STOPPED"));
        }
    }

    public boolean isSecurityServiceStarted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityServiceStarted", new Boolean(this.isSecurityServiceStarted));
        }
        return this.isSecurityServiceStarted;
    }

    public boolean isAuthenticateSpecialMethodsEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAuthenticateSpecialMethodsEnabled", new Boolean(this.isAuthenticateSpecialMethodsEnabled));
        }
        return this.isAuthenticateSpecialMethodsEnabled;
    }

    public Subject getSubjectBeforeRunAs() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectBeforeRunAs");
        }
        Subject subject = null;
        try {
            StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
            Subject[] subjectArray = stateofCurrObj.getSavedSubjects();
            subject = subjectArray[0] != null ? subjectArray[0] : subjectArray[1];
            if (subject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There were no saved subjects.  Getting invocationSubject");
                }
                subject = this.getInvocationSubject();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getSubjectBeforeRunAs", "4974", this);
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectBeforeRunAs - returning: " + subject);
        }
        return subject;
    }

    public String getUserBeforeRunAs() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserBeforeRunAs");
        }
        String string = null;
        Subject subject = null;
        StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
        string = stateofCurrObj.getUserBeforeRunAs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "user from the state: " + string);
        }
        if (string == null || string.trim() != null && string.trim().length() == 0) {
            subject = this.getSubjectBeforeRunAs();
            try {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                if (wSCredential != null) {
                    string = wSCredential.getRealmSecurityName();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user from the subject: " + string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.getUserBeforeRunAs", "5013", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserBeforeRunAs - returning: " + string);
        }
        return string;
    }

    public boolean setSavedSubjects(Subject subject, Subject subject2) throws WSSecurityException {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSavedSubjects");
        }
        if (this.isCellSecurityEnabled()) {
            try {
                if (tc.isDebugEnabled()) {
                    if (subject == null) {
                        Tr.debug(tc, "Setting null for savedSubject");
                    } else {
                        Tr.debug(tc, "Setting savedSubject:" + subject);
                    }
                    if (subject2 == null) {
                        Tr.debug(tc, "Setting null for recSavedSubject");
                    } else {
                        Tr.debug(tc, "Setting recSavedSubject:" + subject2);
                    }
                }
                StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
                bl = stateofCurrObj.setSavedSubjects(subject, subject2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ContextManagerImpl.setAuditSubject", "5058", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSavedSubjects");
        }
        return bl;
    }

    public void clearSavedSubjects() {
        StateofCurrObj stateofCurrObj = this.getThreadLocal().get_state_of_curr_obj();
        stateofCurrObj.clearSavedSubjects();
        stateofCurrObj.clearUserBeforeRunAs();
    }

    private boolean isTokenMatch(byte[] byArray, Subject subject) {
        boolean bl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTokenMatch");
            }
            bl = false;
            if (subject != null) {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                try {
                    bl = singleSignonToken != null && Arrays.equals(byArray, singleSignonToken.getBytes()) || wSCredential != null && Arrays.equals(byArray, wSCredential.getCredentialToken());
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "An exception caught:" + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTokenMatch: " + bl);
        }
        return bl;
    }

    private static final class SecurityThreadLocal
    extends WSThreadLocal {
        private SecurityThreadLocal() {
        }

        protected Object initialValue() {
            return new ThreadContextImpl();
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

