/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class JaasLoginHelper {
    private static boolean isServant = false;
    private static TraceComponent tc = null;
    String authMech = "LTPA";
    boolean bvt_mode = false;
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();

    public JaasLoginHelper() {
    }

    public JaasLoginHelper(String string) {
        this.authMech = string;
    }

    protected Subject jaas_login(byte[] byArray, String string, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(token, auth_mech = " + string + ", in_subject)");
        }
        Subject subject2 = null;
        ArrayList arrayList = null;
        LoginContext loginContext = null;
        try {
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                arrayList = (ArrayList)ContextManagerFactory.getInstance().get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
            }
            if (arrayList != null && byArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing attribute propagation login.");
                }
                loginContext = new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(byArray, arrayList));
            } else {
                loginContext = subject != null ? new LoginContext(string, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(byArray)) : new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(byArray));
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "165", this);
            Tr.audit(tc, "security.lc.create.err", new Object[]{string, loginException.toString()});
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "175", this);
            Tr.error(tc, "security.lc.create.err", new Object[]{string, securityException});
            throw new WSLoginFailedException(securityException.getMessage(), securityException);
        }
        finally {
            if (arrayList != null) {
                ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            }
        }
        try {
            loginContext.login();
            subject2 = loginContext.getSubject();
            if (subject2 == null) {
                Tr.error(tc, "security.jaas.nosubect", new Object[]{"unknown user -- token based validation", this.authMech});
                throw new WSLoginFailedException("Subject returned from login module is null.");
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "200", this);
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(token, auth_mech, in_subject): " + subject2);
        }
        return subject2;
    }

    protected Subject jaas_login(byte[] byArray, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(token, in_subject)");
        }
        Subject subject2 = null;
        subject2 = this.jaas_login(byArray, this.authMech, subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(token, in_subject): " + subject2);
        }
        return subject2;
    }

    protected Subject jaas_login(byte[] byArray, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(token, auth_mech = " + string + ") for web");
        }
        Subject subject2 = null;
        ArrayList arrayList = null;
        LoginContext loginContext = null;
        try {
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                arrayList = (ArrayList)ContextManagerFactory.getInstance().get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
            }
            if (arrayList != null && byArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing attribute propagation login.");
                }
                loginContext = new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(byArray, httpServletRequest, httpServletResponse, map, arrayList));
            } else {
                loginContext = subject != null ? new LoginContext(string, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(byArray, httpServletRequest, httpServletResponse, map)) : new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(byArray, httpServletRequest, httpServletResponse, map));
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "266", this);
            Tr.audit(tc, "security.lc.create.err", new Object[]{string, loginException.toString()});
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "276", this);
            Tr.error(tc, "security.lc.create.err", new Object[]{string, securityException});
            throw new WSLoginFailedException(securityException.getMessage(), securityException);
        }
        finally {
            if (arrayList != null) {
                ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            }
        }
        try {
            loginContext.login();
            subject2 = loginContext.getSubject();
            if (subject2 == null) {
                Tr.error(tc, "security.jaas.nosubect", new Object[]{"unknown user -- token based validation", this.authMech});
                throw new WSLoginFailedException("Subject returned from login module is null.");
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "301", this);
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(token, auth_mech) for web");
        }
        return subject2;
    }

    protected Subject jaas_login(String string, String string2, String string3, String string4, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,user,password,auth_mech,subject = " + string4 + ")");
        }
        Subject subject2 = null;
        ArrayList arrayList = null;
        LoginContext loginContext = null;
        try {
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                arrayList = (ArrayList)ContextManagerFactory.getInstance().get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
            }
            if (arrayList != null && string2 != null && string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing attribute propagation login.");
                }
                loginContext = new LoginContext(string4, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string, string3, arrayList));
            } else {
                loginContext = subject != null ? new LoginContext(string4, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string, string3)) : new LoginContext(string4, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string, string3));
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "353", this);
            Tr.audit(tc, "security.lc.create.err", new Object[]{string4, loginException.toString()});
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "363", this);
            Tr.error(tc, "security.lc.create.err", new Object[]{string4, securityException});
            throw new WSLoginFailedException(securityException.getMessage(), securityException);
        }
        finally {
            if (arrayList != null) {
                ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            }
        }
        try {
            loginContext.login();
            subject2 = loginContext.getSubject();
            if (subject2 == null) {
                Tr.error(tc, "security.jaas.nosubect", new Object[]{string2, string4});
                throw new WSLoginFailedException("Subject returned from login module is null.");
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "388", this);
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,user,password, auth_mech)");
        }
        return subject2;
    }

    protected Subject jaas_login(String string, String string2, String string3, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,user,password)");
        }
        Subject subject2 = this.jaas_login(string, string2, string3, this.authMech, subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,user,password)");
        }
        return subject2;
    }

    protected Subject jaas_login(String string, String string2, String string3, String string4, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,user,password,auth_mech = " + string4 + ") for web");
        }
        Subject subject2 = null;
        ArrayList arrayList = null;
        LoginContext loginContext = null;
        try {
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                arrayList = (ArrayList)ContextManagerFactory.getInstance().get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
            }
            if (arrayList != null && string2 != null && string != null && string3 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing attribute propagation login.");
                }
                loginContext = new LoginContext(string4, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string, (List)arrayList));
            } else {
                loginContext = subject != null ? new LoginContext(string4, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string, string3, httpServletRequest, httpServletResponse, map)) : new LoginContext(string4, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string, string3, httpServletRequest, httpServletResponse, map));
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "452", this);
            Tr.audit(tc, "security.lc.create.err", new Object[]{string4, loginException.toString()});
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "462", this);
            Tr.error(tc, "security.lc.create.err", new Object[]{string4, securityException});
            throw new WSLoginFailedException(securityException.getMessage(), securityException);
        }
        finally {
            if (arrayList != null) {
                ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            }
        }
        try {
            loginContext.login();
            subject2 = loginContext.getSubject();
            if (subject2 == null) {
                Tr.error(tc, "security.jaas.nosubect", new Object[]{string2, string4});
                throw new WSLoginFailedException("Subject returned from login module is null.");
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "487", this);
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,user,password, auth_mech) for web");
        }
        return subject2;
    }

    protected Subject jaas_login(String string, X509Certificate[] x509CertificateArray, String string2, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,certChain,auth_mech,subject = " + string2 + ")");
        }
        Subject subject2 = null;
        ArrayList arrayList = null;
        LoginContext loginContext = null;
        try {
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                arrayList = (ArrayList)ContextManagerFactory.getInstance().get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
            }
            if (arrayList != null && x509CertificateArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing attribute propagation login.");
                }
                loginContext = new LoginContext(string2, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string, x509CertificateArray, (List)arrayList));
            } else {
                loginContext = subject != null ? new LoginContext(string2, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string, x509CertificateArray)) : new LoginContext(string2, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string, x509CertificateArray));
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "540", this);
            Tr.audit(tc, "security.lc.create.err", new Object[]{string2, loginException.toString()});
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "550", this);
            Tr.error(tc, "security.lc.create.err", new Object[]{string2, securityException});
            throw new WSLoginFailedException(securityException.getMessage(), securityException);
        }
        finally {
            if (arrayList != null) {
                ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            }
        }
        try {
            loginContext.login();
            subject2 = loginContext.getSubject();
            if (subject2 == null) {
                Tr.error(tc, "security.jaas.nosubect", new Object[]{x509CertificateArray, string2});
                throw new WSLoginFailedException("Subject returned from login module is null.");
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "575", this);
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,certChain, auth_mech)");
        }
        return subject2;
    }

    protected Subject jaas_login(String string, X509Certificate[] x509CertificateArray, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,certChain)");
        }
        Subject subject2 = this.jaas_login(string, x509CertificateArray, this.authMech, subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,certChain)");
        }
        return subject2;
    }

    protected Subject jaas_login(String string, X509Certificate[] x509CertificateArray, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(realm,certChain,auth_mech = " + string2 + ") for web");
        }
        Subject subject2 = null;
        ArrayList arrayList = null;
        LoginContext loginContext = null;
        try {
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                arrayList = (ArrayList)ContextManagerFactory.getInstance().get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup());
            }
            if (arrayList != null && x509CertificateArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing attribute propagation login.");
                }
                loginContext = new LoginContext(string2, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string, x509CertificateArray, (List)arrayList));
            } else {
                loginContext = subject != null ? new LoginContext(string2, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string, x509CertificateArray, httpServletRequest, httpServletResponse, map)) : new LoginContext(string2, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string, x509CertificateArray, httpServletRequest, httpServletResponse, map));
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "639", this);
            Tr.audit(tc, "security.lc.create.err", new Object[]{string2, loginException.toString()});
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "649", this);
            Tr.error(tc, "security.lc.create.err", new Object[]{string2, securityException});
            throw new WSLoginFailedException(securityException.getMessage(), securityException);
        }
        finally {
            if (arrayList != null) {
                ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            }
        }
        try {
            loginContext.login();
            subject2 = loginContext.getSubject();
            if (subject2 == null) {
                Tr.error(tc, "security.jaas.nosubect", new Object[]{x509CertificateArray, string2});
                throw new WSLoginFailedException("Subject returned from login module is null.");
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "674", this);
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(realm,certChain, auth_mech) for web");
        }
        return subject2;
    }

    protected Subject jaas_login(String string, Object object, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaas_login(auth_mech = " + string + ", protocolPolicy, invocationSubject) for outbound");
        }
        Subject subject2 = null;
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(string, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(object));
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "708", this);
            Tr.audit(tc, "security.lc.create.err", new Object[]{string, loginException.toString()});
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "718", this);
            Tr.error(tc, "security.lc.create.err", new Object[]{string, securityException});
            throw new WSLoginFailedException(securityException.getMessage(), securityException);
        }
        try {
            if (loginContext != null) {
                loginContext.login();
                subject2 = loginContext.getSubject();
                if (subject2 == null) {
                    throw new WSLoginFailedException("Subject returned from login module is null.");
                }
            }
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, "com.ibm.ws.security.auth.JaasLoginHelper.jaas_login", "741", this);
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)loginException;
            }
            throw new WSLoginFailedException(loginException.getMessage(), loginException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(auth_mech = " + string + ", protocolPolicy, invocationSubject) for outbound");
        }
        return subject2;
    }

    static {
        Object var0 = null;
        try {
            tc = Tr.register(JaasLoginHelper.class, null, "com.ibm.ejs.resources.security");
            if (ctxMgr.getPlatformHelper().isServantJvm()) {
                isServant = true;
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "exception " + exception.toString() + " in static initializer");
        }
    }
}

