/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.util.Arrays;
import java.util.Date;

public class ServerCredSigner {
    private KeyStore ks = null;
    private KeyPairGenerator rsaKeyPairGen = null;
    private KeyPair rsaKeyPair = null;
    private Signature sig = null;
    private PublicKey rsaPub = null;
    private PrivateKey rsaPriv = null;
    private MessageDigest md = null;
    private SecurityConfiguration secConfig = null;
    private static String CRYPTO_ALGORITHM = "RSA";
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static ServerCredSigner scs = null;
    private static final String _uniqueServerID = SecurityUIDGenerator.createUID();
    private static final byte[] _uniqueServerIDBytes = _uniqueServerID.getBytes();
    private static byte[] _uniqueServerCipher = null;
    private static final String _uniqueWSCredID = SecurityUIDGenerator.createUID();
    private static final byte[] _uniqueWSCredIDBytes = _uniqueWSCredID.getBytes();
    private static byte[] _uniqueWSCredCipher = null;
    private static byte[] nullByteArray = new byte[0];
    private static final TraceComponent tc = Tr.register(ServerCredSigner.class, null, "com.ibm.ISecurityL13SupportImpl.sec");

    public static ServerCredSigner getInstance() {
        if (scs == null) {
            scs = new ServerCredSigner();
        }
        return scs;
    }

    private ServerCredSigner() {
        try {
            this.initialize();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.constructor", "96", this);
        }
    }

    private void initialize() throws WSSecurityException {
        if (!ConfigURLProperties.isSecurityEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security disabed, not initializing server cred signer.");
            }
            return;
        }
        long l = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing server cred signer at " + new Date(System.currentTimeMillis()));
        }
        String string = null;
        this.secConfig = VaultImpl.getSecurityConfiguration();
        if (this.secConfig != null && this.secConfig.processIsServer()) {
            try {
                string = Security.getProperty("DEFAULT_JCE_PROVIDER");
                this.rsaKeyPairGen = KeyPairGenerator.getInstance(CRYPTO_ALGORITHM, string);
                this.rsaKeyPairGen.initialize(512);
                this.rsaKeyPair = this.rsaKeyPairGen.generateKeyPair();
                if (this.rsaKeyPair == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WARNING: Did not successfully load the server cred signer key pair.");
                    }
                } else {
                    this.rsaPub = this.rsaKeyPair.getPublic();
                    this.rsaPriv = this.rsaKeyPair.getPrivate();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PrivateKey format: " + this.rsaPriv.getFormat());
                    Tr.debug(tc, "PrivateKey algorithm: " + this.rsaPriv.getAlgorithm());
                    Tr.debug(tc, "PublicKey format: " + this.rsaPub.getFormat());
                    Tr.debug(tc, "PublicKey algorithm: " + this.rsaPub.getAlgorithm());
                    Tr.debug(tc, "Loading " + CRYPTO_ALGORITHM + " signature instance from " + string);
                }
                this.sig = Signature.getInstance(CRYPTO_ALGORITHM, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading SHA message digest instance from " + string);
                }
                this.md = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initialization of server cred signer complete at " + new Date(System.currentTimeMillis()));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.initialize", "219", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing server cred signer.", new Object[]{exception});
                }
                throw new WSSecurityException(exception);
            }
        }
    }

    public synchronized byte[] encryptString(String string) {
        if (this.sig == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.encryptString", "238", this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from encryptString because of security disabled or not initialized.");
            }
            return nullByteArray;
        }
        if (string == null || string.length() == 0) {
            return nullByteArray;
        }
        byte[] byArray = null;
        try {
            this.sig.initSign(this.rsaPriv);
            this.sig.update(string.getBytes());
            byArray = this.sig.sign();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error encrypting: ", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedSigner", "267", this);
            return null;
        }
        return byArray;
    }

    public synchronized String decryptString(byte[] byArray) {
        if (this.sig == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.decryptString", "285", this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from decryptString because of security disabled or not initialized.");
            }
            return null;
        }
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = byArray;
        try {
            this.sig.initVerify(this.rsaPub);
            this.sig.update(byArray2);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error decrypting: ", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.verify", "313", this);
            return null;
        }
        return byArray2.toString();
    }

    protected synchronized byte[] getEncryptedServerSigner() {
        if (this.sig == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedServerSigner", "333", this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from getEncryptedServerSigner because of security disabled or not initialized.");
            }
            return nullByteArray;
        }
        if (_uniqueServerCipher == null) {
            try {
                this.sig.initSign(this.rsaPriv);
                this.sig.update(_uniqueServerIDBytes);
                _uniqueServerCipher = this.sig.sign();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error encrypting: ", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedSigner", "360", this);
                return null;
            }
        }
        return _uniqueServerCipher;
    }

    protected synchronized byte[] getEncryptedWSCredSigner() {
        if (this.sig == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedWSCredSigner", "379", this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from getEncryptedWSCredSigner because of security disabled or not initialized.");
            }
            return nullByteArray;
        }
        if (_uniqueWSCredCipher == null) {
            Object var1_2 = null;
            try {
                this.sig.initSign(this.rsaPriv);
                this.sig.update(_uniqueWSCredIDBytes);
                _uniqueWSCredCipher = this.sig.sign();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error encrypting: ", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.getEncryptedSigner", "407", this);
                return null;
            }
        }
        return _uniqueWSCredCipher;
    }

    protected synchronized boolean isServerCred(WSCredential wSCredential) {
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from isServerCred because of security disabled or not initialized.");
            }
            return false;
        }
        if (((WSCredentialImpl)wSCredential).getServerCredCipher() != null && _uniqueServerCipher != null) {
            return Arrays.equals(_uniqueServerCipher, ((WSCredentialImpl)wSCredential).getServerCredCipher());
        }
        return false;
    }

    protected synchronized boolean isWSCred(WSCredential wSCredential) {
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from isWSCred because of security disabled or not initialized.");
            }
            return false;
        }
        if (wSCredential == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "null cred passed into isWSCred()");
            }
            return false;
        }
        if (((WSCredentialImpl)wSCredential).getWSCredCipher() != null && _uniqueWSCredCipher != null) {
            return Arrays.equals(_uniqueWSCredCipher, ((WSCredentialImpl)wSCredential).getWSCredCipher());
        }
        return false;
    }

    public synchronized byte[] getOneWayHash(String string) {
        if (this.md == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception initializing ServerCredSigner.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.ServerCredSigner.getOneWayHash", "465", this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning from getOneWayHash because of security disabled or not initialized.");
            }
            return null;
        }
        this.md.reset();
        this.md.update(string.getBytes());
        return this.md.digest();
    }
}

