/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.j2c.GenericCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.ltpa.Token;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.security.auth.AuthPermission;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.omg.SecurityLevel2.Credentials;

public class WSCredentialImpl
implements WSCredential {
    private String realmname;
    private String username;
    private String uniqueusername;
    private String realmusername;
    private String realmuniqueusername;
    private String hostname;
    private String oid;
    private String primaryGroupId;
    private String accessId;
    private Token token = null;
    private byte[] credentialToken;
    private boolean forwardable;
    private long expiration = 0L;
    private boolean unauthenticated = false;
    private ArrayList groupIds;
    private ArrayList roles;
    private Hashtable hashTable = null;
    private boolean isBasicAuthCred = false;
    private boolean destroyed = false;
    private Credentials CORBACred = null;
    private byte[] refreshSync = null;
    private byte[] serverCredCipher = null;
    private byte[] wsCredCipher = null;
    private GenericCredentialImpl genericCred = null;
    private Subject wsSubject = null;
    private boolean isServerCred = false;
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    static final long serialVersionUID = 4148961460865333593L;
    private static final AuthPermission APP_READ_PERMISSION = new AuthPermission("wssecurity.applicationReadCredential");
    private static final AuthPermission APP_UPDATE_PERMISSION = new AuthPermission("wssecurity.applicationUpdateCredential");
    private static final AuthPermission READ_PERMISSION = new AuthPermission("wssecurity.readCredential");
    private static final AuthPermission UPDATE_PERMISSION = new AuthPermission("wssecurity.updateCredential");
    private static final AuthPermission CREATE_PERMISSION = new AuthPermission("wssecurity.createCredential");
    private static final AuthPermission DESTROY_PERMISSION = new AuthPermission("wssecurity.destroyCredential");
    private static final AuthPermission REFRESH_PERMISSION = new AuthPermission("wssecurity.refreshCredential");
    private static final TraceComponent tc = Tr.register(WSCredentialImpl.class, null, "com.ibm.ISecurityL13SupportImpl.sec");

    public WSCredentialImpl(String string, String string2, String string3, String string4, String string5, ArrayList arrayList, ArrayList arrayList2) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{string, string2, string3, string4, string5, arrayList, arrayList2});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        this.refreshSync = new byte[0];
        this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
        this.realmname = string;
        this.username = string2;
        this.uniqueusername = string3;
        this.primaryGroupId = string4;
        this.accessId = string5;
        this.hashTable = new Hashtable(32);
        if (this.username.endsWith(ctxMgr.getUnauthenticatedString())) {
            this.unauthenticated = true;
        }
        this.roles = arrayList != null ? (ArrayList)arrayList.clone() : new ArrayList();
        ArrayList arrayList3 = this.groupIds = arrayList2 != null ? (ArrayList)arrayList2.clone() : new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSCredentialImpl(WSCredential wSCredential, String string, Token token, boolean bl, long l) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{wSCredential, string, token, new Boolean(bl), new Long(l)});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        try {
            this.refreshSync = new byte[0];
            this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
            this.realmname = wSCredential.getRealmName();
            this.username = wSCredential.getSecurityName();
            this.uniqueusername = wSCredential.getUniqueSecurityName();
            this.primaryGroupId = wSCredential.getPrimaryGroupId();
            this.accessId = wSCredential.getAccessId();
            this.roles = wSCredential.getRoles();
            this.groupIds = wSCredential.getGroupIds();
            this.hashTable = new Hashtable(32);
            this.oid = string;
            this.forwardable = bl;
            this.expiration = l;
            this.token = token;
            this.hashTable = ((WSCredentialImpl)wSCredential).getTable();
            if (this.username.endsWith(ctxMgr.getUnauthenticatedString())) {
                this.unauthenticated = true;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred while creating credential.", new Object[]{exception});
            }
            FFDCFilter.processException(exception, "com.ibm.ws.security.auth.WSCredentialImpl.constructor", "159");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSCredentialImpl(WSCredential wSCredential, String string, byte[] byArray, boolean bl, long l) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{wSCredential, string, byArray, new Boolean(bl), new Long(l)});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        try {
            this.refreshSync = new byte[0];
            this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
            this.realmname = wSCredential.getRealmName();
            this.username = wSCredential.getSecurityName();
            this.uniqueusername = wSCredential.getUniqueSecurityName();
            this.primaryGroupId = wSCredential.getPrimaryGroupId();
            this.accessId = wSCredential.getAccessId();
            this.roles = wSCredential.getRoles();
            this.groupIds = wSCredential.getGroupIds();
            this.hashTable = new Hashtable(32);
            this.oid = string;
            this.forwardable = bl;
            this.expiration = l;
            this.credentialToken = byArray;
            this.hashTable = ((WSCredentialImpl)wSCredential).getTable();
            if (this.username.endsWith(ctxMgr.getUnauthenticatedString())) {
                this.unauthenticated = true;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred while creating credential.", new Object[]{exception});
            }
            FFDCFilter.processException(exception, "com.ibm.ws.security.auth.WSCredentialImpl.constructor", "231");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSCredentialImpl(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{string, string2, string3 == null ? null : "****"});
        }
        this.refreshSync = new byte[0];
        this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
        this.realmname = string;
        this.username = string2;
        this.uniqueusername = string2;
        this.accessId = string2;
        this.credentialToken = StringBytesConversion.getConvertedBytes(string3);
        this.isBasicAuthCred = true;
        this.oid = "oid:2.23.130.1.1.1";
        this.forwardable = true;
        this.expiration = 0L;
        this.hashTable = new Hashtable(32);
        this.groupIds = new ArrayList();
        if (this.username.endsWith(ctxMgr.getUnauthenticatedString())) {
            this.unauthenticated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSCredentialImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        this.realmname = null;
        this.realmusername = null;
        this.realmuniqueusername = null;
        this.username = null;
        this.uniqueusername = null;
        this.oid = null;
        this.primaryGroupId = null;
        this.accessId = null;
        this.forwardable = false;
        this.expiration = 0L;
        this.credentialToken = null;
        this.groupIds = null;
        this.hashTable = null;
        this.isBasicAuthCred = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup", this);
        }
    }

    public GenericCredentialImpl getGenericCredential() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGenericCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericCredential", this.genericCred);
        }
        return this.genericCred;
    }

    public void setGenericCredential(GenericCredentialImpl genericCredentialImpl) throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGenericCredential", genericCredentialImpl);
        }
        this.genericCred = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setGenericCredential");
        }
    }

    public void setSubject(Subject subject) throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSubject", subject);
        }
        this.wsSubject = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSubject");
        }
    }

    public Subject getSubject() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", this.wsSubject);
        }
        return this.wsSubject;
    }

    public String getRealmName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmName", this.realmname);
        }
        return this.realmname;
    }

    public String getSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName", this.username);
        }
        return this.username;
    }

    public String getRealmSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmSecurityName");
        }
        if (this.realmusername != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRealmSecurityName", this.realmusername);
            }
            return this.realmusername;
        }
        this.realmusername = this.getRealmName() + "/" + this.getSecurityName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmSecurityName", this.realmusername);
        }
        return this.realmusername;
    }

    public String getUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueSecurityName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueSecurityName", this.uniqueusername);
        }
        return this.uniqueusername;
    }

    public String getRealmUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmUniqueSecurityName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmUniqueSecurityName");
        }
        if (this.realmuniqueusername != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRealmUniqueSecurityName", this.realmuniqueusername);
            }
            return this.realmuniqueusername;
        }
        this.realmuniqueusername = this.getRealmName() + "/" + this.getUniqueSecurityName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmUniqueSecurityName", this.realmuniqueusername);
        }
        return this.realmuniqueusername;
    }

    public byte[] getCredentialToken() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredentialToken");
        }
        if (this.credentialToken != null) {
            if (tc.isEntryEnabled() && !this.isBasicAuthCred) {
                SecurityLogger.debugMessage("WSCredential.getCredentialToken", this.credentialToken);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCredentialToken");
            }
            return this.credentialToken;
        }
        if (this.credentialToken == null && this.token != null) {
            try {
                this.credentialToken = this.token.getBytes();
                if (tc.isEntryEnabled() && !this.isBasicAuthCred) {
                    SecurityLogger.debugMessage("WSCredential.getCredentialToken", this.credentialToken);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCredentialToken");
                }
                return this.credentialToken;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred getting bytes[] from token.", new Object[]{exception});
                }
                FFDCFilter.processException(exception, "com.ibm.ws.security.common.auth.WSCredentialImpl.getCredentialToken", "566");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCredentialToken");
                }
                return null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCredentialToken() -> null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialToken");
        }
        return null;
    }

    public String getHostName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostname");
        }
        if (this.hostname == null || this.hostname.length() == 0) {
            this.hostname = VaultImpl.getInstance().getORB().getLocalHost();
            if (this.hostname == null || this.hostname.length() == 0) {
                this.hostname = "localHost";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName", this.hostname);
        }
        return this.hostname;
    }

    public String getOID() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOID");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOID", this.oid);
        }
        return this.oid;
    }

    public boolean isForwardable() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isForwardable");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isForwardable", new Boolean(this.forwardable));
        }
        return this.forwardable;
    }

    public boolean isForwardable(String string) throws CredentialDestroyedException, CredentialExpiredException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isForwardable", string);
        }
        String string2 = this.realmname;
        String string3 = string;
        String string4 = "<default>";
        boolean bl2 = bl = string2.length() == 0 || string2.equalsIgnoreCase(string4) || string2.equalsIgnoreCase(string3) || string3.length() == 0;
        if (!bl) {
            String string5;
            SecurityConfiguration securityConfiguration;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target realm does not match current realm, target realm: " + string3 + ", current realm: " + string2 + ".");
            }
            if ((securityConfiguration = VaultImpl.getSecurityConfiguration()) != null && (string5 = securityConfiguration.getSupportedTargetRealms()) != null && !string5.equals("")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string5, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    if (!string6.equalsIgnoreCase(string3)) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (!bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "Target realm does not match current realm, target realm: " + string3 + ", current realm: " + string2 + ".");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isForwardable() -> " + bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isForwardable", new Boolean(bl));
        }
        return bl;
    }

    public long getExpiration() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpiration");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpiration", new Long(this.expiration));
        }
        return this.expiration;
    }

    public String getPrimaryGroupId() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrimaryGroupId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrimaryGroupId", this.primaryGroupId);
        }
        return this.primaryGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRoles() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRoles");
        }
        try {
            if (this.roles != null) {
                ArrayList arrayList = (ArrayList)this.roles.clone();
                return arrayList;
            }
            ArrayList arrayList = null;
            return arrayList;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRoles", this.roles);
            }
        }
    }

    public String getAccessId() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessId", this.accessId);
        }
        return this.accessId;
    }

    public ArrayList getGroupIds() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupIds");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupIds", this.groupIds);
        }
        return (ArrayList)this.groupIds.clone();
    }

    public Object get(String string) throws CredentialDestroyedException, CredentialExpiredException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(APP_READ_PERMISSION);
        }
        if (string.startsWith("wssecurity") && securityManager != null) {
            securityManager.checkPermission(READ_PERMISSION);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get", this.hashTable);
        }
        return this.hashTable.get(string);
    }

    public Object set(String string, Object object) throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "set", new Object[]{string, object});
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (string.startsWith("wssecurity") && securityManager != null) {
            securityManager.checkPermission(UPDATE_PERMISSION);
        }
        if (this.hashTable.get(string) != null && securityManager != null) {
            securityManager.checkPermission(APP_UPDATE_PERMISSION);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "set", this.hashTable);
        }
        return this.hashTable.put(string, object);
    }

    public boolean isCurrent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCurrent");
        }
        if (this.isDestroyed()) {
            return false;
        }
        boolean bl = false;
        try {
            long l;
            long l2;
            bl = this.expiration != -1L && this.expiration != 0L ? ((l2 = this.expiration - (l = System.currentTimeMillis())) <= 0L ? ServerCredSigner.getInstance().isServerCred(this) : true) : true;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Refresh of credential failed.");
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.WSCredentialImpl.refresh", "894", this);
            bl = false;
        }
        if (tc.isDebugEnabled() && !bl) {
            Tr.debug(tc, "isCurrent() -> " + bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCurrent", new Boolean(bl));
        }
        return bl;
    }

    public boolean isUnauthenticated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUnauthenticated");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUnauthenticated", new Boolean(this.unauthenticated));
        }
        return this.unauthenticated;
    }

    public final void markAsUnauthenticated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markAsUnauthenticated");
        }
        this.unauthenticated = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markAsUnauthenticated");
        }
    }

    public void destroy() throws DestroyFailedException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DESTROY_PERMISSION);
        }
        if (ServerCredSigner.getInstance().isServerCred(this)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "destroy() -> Server cred cannot be destroyed");
            }
            return;
        }
        this.destroyed = true;
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public boolean isDestroyed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDestroyed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDestroyed", new Boolean(this.destroyed));
        }
        return this.destroyed;
    }

    public boolean isBasicAuth() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isBasicAuth");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isBasicAuth", new Boolean(this.isBasicAuthCred));
        }
        return this.isBasicAuthCred;
    }

    public void refresh() throws RefreshFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
        throw new RefreshFailedException("Refresh is not supported in this mechanism.");
    }

    public Hashtable getTable() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTable");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(READ_PERMISSION);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTable", this.hashTable);
        }
        return this.hashTable != null ? (Hashtable)this.hashTable.clone() : null;
    }

    public void setTable(Hashtable hashtable) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTable", hashtable);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(UPDATE_PERMISSION);
        }
        this.hashTable = (Hashtable)hashtable.clone();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTable");
        }
    }

    protected void markServerCred(byte[] byArray) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markServerCred", byArray);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(UPDATE_PERMISSION);
        }
        this.serverCredCipher = byArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markServerCred");
        }
    }

    protected byte[] getServerCredCipher() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerCredCipher");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerCredCipher", this.serverCredCipher);
        }
        return this.serverCredCipher;
    }

    public boolean isServerCred() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerCred");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerCred", new Boolean(this.isServerCred));
        }
        return this.isServerCred;
    }

    public boolean isWSCred() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWSCred");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWSCred");
        }
        return true;
    }

    public void markServerCred() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markServerCred");
        }
        this.isServerCred = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markServerCred");
        }
    }

    protected byte[] getWSCredCipher() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSCredCipher");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSCredCipher", this.wsCredCipher);
        }
        return this.wsCredCipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshCred(WSCredential wSCredential) throws WSSecurityException {
        block15: {
            SecurityManager securityManager;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshCred", wSCredential);
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPermission(UPDATE_PERMISSION);
            }
            try {
                if (wSCredential.isBasicAuth()) break block15;
                if (wSCredential != null && !this.destroyed) {
                    byte[] byArray = this.refreshSync;
                    // MONITORENTER : this.refreshSync
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Refreshing only the credential token and expiration: " + new Date(wSCredential.getExpiration()));
                    }
                    this.credentialToken = wSCredential.getCredentialToken();
                    this.expiration = wSCredential.getExpiration();
                    this.token = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Completed refresh.");
                    }
                    // MONITOREXIT : byArray
                    break block15;
                }
                if (wSCredential != null) {
                    byte[] byArray = this.refreshSync;
                    // MONITORENTER : this.refreshSync
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Refreshing the entire WSCredential.");
                    }
                    this.destroyed = true;
                    this.token = null;
                    this.realmuniqueusername = null;
                    this.realmusername = null;
                    this.credentialToken = wSCredential.getCredentialToken();
                    this.expiration = wSCredential.getExpiration();
                    this.realmname = wSCredential.getRealmName();
                    this.username = wSCredential.getSecurityName();
                    this.uniqueusername = wSCredential.getUniqueSecurityName();
                    this.hostname = wSCredential.getHostName();
                    this.oid = wSCredential.getOID();
                    this.primaryGroupId = wSCredential.getPrimaryGroupId();
                    this.accessId = wSCredential.getAccessId();
                    this.forwardable = wSCredential.isForwardable();
                    this.unauthenticated = false;
                    this.groupIds = wSCredential.getGroupIds();
                    this.roles = wSCredential.getRoles();
                    this.hashTable = ((WSCredentialImpl)wSCredential).getTable();
                    this.isBasicAuthCred = false;
                    this.destroyed = false;
                    wSCredential = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Completed refresh.");
                    }
                    // MONITOREXIT : byArray
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred while refreshing credential.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.WSCredentialImpl.refreshCred", "1196", this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "refreshCred");
    }

    public String toString() {
        return super.toString();
    }
}

