/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.auth.WSSubjectWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import javax.security.auth.Subject;

public class WSSubjectWrapperImpl
implements WSSubjectWrapper {
    private static final TraceComponent tc = Tr.register(WSSubjectWrapperImpl.class, "Security", "com.ibm.ejs.resources.security");
    private Subject _subject = null;
    private String _uniqueId = null;
    private boolean _isValid = false;
    private long _expiration = -2L;
    private String _principal = null;
    private boolean _initialized = false;
    private boolean _isUniqueIdSet = false;

    public WSSubjectWrapperImpl(Subject subject) {
        this._subject = subject;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public boolean isValid() {
        if (!this._initialized) {
            this.initialize();
        }
        return this._isValid;
    }

    public long getExpiration() {
        if (!this._initialized) {
            this.initialize();
        }
        return this._expiration;
    }

    public boolean isForwardable() {
        return false;
    }

    public String getPrincipal() {
        if (!this._initialized) {
            this.initialize();
        }
        return this._principal;
    }

    public byte[] getBytes() {
        return null;
    }

    public String getName() {
        return "com.ibm.wsspi.security.auth.WSSubjectWrapper";
    }

    public short getVersion() {
        return 1;
    }

    public String getUniqueID() {
        block4: {
            if (!this._isUniqueIdSet) {
                try {
                    this._uniqueId = ContextManagerFactory.getInstance().getWSCredTokenMapper().createSubjectUniqueID(this._subject);
                    if (this._uniqueId == null) {
                        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(this._subject);
                        this._uniqueId = wSCredential.getAccessId();
                    }
                    this._isUniqueIdSet = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.WSSubjectWrapperImpl.getUniqueID", "214", this);
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "getUniqueID initialize error: " + this.dump(exception));
                }
            }
        }
        return this._uniqueId;
    }

    public void setReadOnly() {
        throw new UnsupportedOperationException();
    }

    public String[] getAttributes(String string) {
        throw new UnsupportedOperationException();
    }

    public String[] addAttribute(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public Enumeration getAttributeNames() {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    private void initialize() {
        block8: {
            try {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(this._subject);
                this._principal = wSCredential.getSecurityName();
                if (!wSCredential.isForwardable() || wSCredential.isBasicAuth()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSCredential is BasicAuth or not forwardable.");
                    }
                    this._initialized = true;
                    this._isValid = true;
                } else {
                    this._expiration = wSCredential.getExpiration();
                    this._initialized = true;
                    long l = System.currentTimeMillis();
                    long l2 = this._expiration - l;
                    if (this._expiration != 0L && this._expiration != -1L && l2 < 0L) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WSCredential has expired.");
                        }
                        this._isValid = false;
                    } else {
                        this._isValid = true;
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.auth.WSSubjectWrapperImpl.initialize", "294", this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "initialize error: " + this.dump(exception));
            }
        }
    }

    private String dump(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

