/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.j2c;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.IdentityPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.wsspi.security.auth.callback.WSManagedConnectionFactoryCallback;
import com.ibm.wsspi.security.auth.callback.WSMappingPropertiesCallback;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSPrincipalMappingLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(WSPrincipalMappingLoginModule.class, null, "com.ibm.ejs.resources.security");
    private Subject wspm_subject;
    private CallbackHandler wspm_callbackHandler;
    private Map wspm_sharedState;
    private Map wspm_options;
    private boolean wspm_debug = false;
    private boolean wspm_succeeded = false;
    private boolean wspm_commitSucceeded = false;
    private WSPrincipalImpl wspm_principal = null;
    private boolean wspm_useTrustedConnection = false;
    private IdentityPrincipal wspm_identityPrincipal = null;
    private PasswordCredential wspm_passwordCredential = null;
    private Map wspm_properties;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("getPasswordCredential");
    private static boolean isFineGrained = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize()");
        }
        this.wspm_subject = subject;
        this.wspm_callbackHandler = callbackHandler;
        this.wspm_sharedState = map;
        this.wspm_options = map2;
        this.wspm_debug = "true".equalsIgnoreCase((String)this.wspm_options.get("debug"));
        this.wspm_useTrustedConnection = "true".equalsIgnoreCase((String)this.wspm_options.get("useTrustedConnection"));
        if (tc.isEntryEnabled()) {
            if (this.wspm_useTrustedConnection) {
                Tr.exit(tc, "initialize( TrustedConnectionMapping )");
            } else {
                Tr.exit(tc, "initialize( DefaultPrincipalMapping )");
            }
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        if (this.wspm_commitSucceeded) {
            this.logout();
        }
        this.wspm_succeeded = false;
        boolean bl = false;
        boolean bl2 = false;
        Callback[] callbackArray = new Callback[]{new WSManagedConnectionFactoryCallback("Target ManagedConnectionFactory: "), new WSMappingPropertiesCallback("Mapping Properties (HashMap): ")};
        try {
            this.wspm_callbackHandler.handle(callbackArray);
            String string = null;
            String string2 = null;
            String string3 = null;
            this.wspm_properties = ((WSMappingPropertiesCallback)callbackArray[1]).getProperties();
            if (this.wspm_properties == null) {
                Tr.warning(tc, "security.j2c.missingParameter", new Object[]{"properties HashMap"});
            } else {
                string3 = (String)this.wspm_properties.get("com.ibm.mapping.authDataAlias");
                if (string3 == null) {
                    Tr.warning(tc, "security.j2c.missingParameter", new Object[]{"alias"});
                } else {
                    string3 = string3.trim();
                }
            }
            if (string3 != null) {
                Serializable serializable;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    if (!isFineGrained) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                            Tr.debug(tc, "Expecting : " + perm.toString());
                        }
                        securityManager.checkPermission(perm);
                    } else {
                        serializable = new WebSphereRuntimePermission("getPasswordCredential." + string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Performing Java 2 Security Permission Check (Fine Grained) ...");
                            Tr.debug(tc, "Expecting : " + ((Permission)serializable).toString());
                        }
                        securityManager.checkPermission((Permission)serializable);
                    }
                }
                if ((serializable = SecurityConfig.getConfig().getAuthData(string3)) != null) {
                    string = ((Properties)serializable).getProperty("username");
                    String string4 = ((Properties)serializable).getProperty("password");
                    String string5 = PasswordUtil.passwordDecode(string4);
                    String string6 = string2 = string5 == null ? string4 : string5;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, (string5 == null ? "Original" : "Decoded") + " version of the password is used");
                    }
                    ManagedConnectionFactory managedConnectionFactory = ((WSManagedConnectionFactoryCallback)callbackArray[0]).getManagedConnectionFacotry();
                    this.wspm_passwordCredential = new PasswordCredential(string, string2.toCharArray());
                    this.wspm_passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
                    WSCredential wSCredential = ContextManagerFactory.getInstance().getInvocationCredential();
                    String string7 = null;
                    if (wSCredential != null && !wSCredential.isUnauthenticated()) {
                        string7 = wSCredential.getSecurityName();
                    }
                    this.wspm_principal = new WSPrincipalImpl(string7);
                    if (this.wspm_useTrustedConnection) {
                        this.wspm_identityPrincipal = WSDefaultPrincipalMapping.getIdentityPrincipal(this.wspm_properties);
                        this.wspm_identityPrincipal.setManagedConnectionFactory(managedConnectionFactory);
                    }
                    this.wspm_succeeded = true;
                }
            }
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            FFDCFilter.processException((Throwable)unsupportedCallbackException, "com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", "128", this);
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to garner authentication " + "information from the user");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", "135", this);
            Tr.warning(tc, "security.j2c.unexpectedIOException", new Object[]{iOException});
            throw new LoginException("Error: " + iOException.toString());
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", "164", this);
            throw new LoginException("Error: " + wSSecurityException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.security.auth.j2c.WSPrincipalMappingLoginModule.login", "273", this);
            throw new LoginException("Error: " + classNotFoundException.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this.wspm_succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (!this.wspm_succeeded) {
            return this.wspm_succeeded;
        }
        if (this.wspm_principal != null) {
            Set<Principal> set = this.wspm_subject.getPrincipals();
            if (!set.contains(this.wspm_principal)) {
                set.add(this.wspm_principal);
            }
            if (this.wspm_identityPrincipal != null && !set.contains(this.wspm_identityPrincipal)) {
                set.add(this.wspm_identityPrincipal);
            }
            if (!this.wspm_subject.getPrivateCredentials().contains(this.wspm_passwordCredential)) {
                this.wspm_subject.getPrivateCredentials().add(this.wspm_passwordCredential);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        this.wspm_commitSucceeded = true;
        return this.wspm_commitSucceeded;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (!this.wspm_succeeded) {
            return false;
        }
        if (!this.wspm_commitSucceeded) {
            this.wspm_succeeded = false;
            this.wspm_principal = null;
            this.wspm_passwordCredential = null;
            this.wspm_identityPrincipal = null;
        } else {
            this.logout();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return this.wspm_succeeded;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        Set<Principal> set = this.wspm_subject.getPrincipals();
        set.remove(this.wspm_principal);
        this.wspm_subject.getPrivateCredentials().remove(this.wspm_passwordCredential);
        this.wspm_principal = null;
        this.wspm_passwordCredential = null;
        this.wspm_identityPrincipal = null;
        this.wspm_succeeded = false;
        this.wspm_commitSucceeded = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    static {
        Boolean bl = Boolean.TRUE;
        try {
            bl = (Boolean)SecurityConfig.getConfig().getValue("security.enforceFineGrainedJCASecurity");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl != null) {
            isFineGrained = bl;
        }
        if (tc.isDebugEnabled()) {
            if (isFineGrained) {
                Tr.debug(tc, "Enforce Fine Grained Java 2 Security Permission Check");
            } else {
                Tr.debug(tc, "Enforce Java 2 Security Permission Check");
            }
        }
    }
}

