/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.login;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.auth.login.Parser;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;

class ConfigFile
extends Parser {
    private static final TraceComponent tc = Tr.register(ConfigFile.class, null, "com.ibm.ejs.resources.security");
    private static final String AUTHPROP = "java.security.auth.login.config";
    private static final String _cname = ConfigFile.class.getName();
    private HashMap _fileMap;
    private String _loginFile;
    private boolean singleLogInFile = false;
    private PrivilegedExceptionAction openLoginFileAction = null;

    ConfigFile() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, _cname + ": Entry: constructor called.");
        }
        this._loginFile = System.getProperty(AUTHPROP);
        if (this._loginFile == null || this._loginFile.length() == 0) {
            Tr.error(tc, "security.jaas.getProperty", new Object[]{_cname, AUTHPROP});
        } else {
            if (this._loginFile.charAt(0) == '=') {
                this.singleLogInFile = true;
                this._loginFile = this._loginFile.substring(1);
            }
            this.openLoginFileAction = new OpenFileAction(this._loginFile);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, _cname + ": Exit constructor: The " + AUTHPROP + " value is: " + this._loginFile);
        }
        this.buildFileEntry();
    }

    String toString2() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("JAAS file configuration data:\n");
        if (this._fileMap != null && this._fileMap.size() > 0) {
            try {
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                Class<?> clazz = classLoader.loadClass("com.ibm.ws.security.core.JaasWCCMHelper");
                Class[] classArray = new Class[]{new HashMap().getClass()};
                Method method2 = clazz.getMethod("convertMapToString", classArray);
                Object[] objectArray = new Object[]{this._fileMap};
                Object object = method2.invoke(clazz, objectArray);
                string = (String)object;
            }
            catch (Exception exception) {
                Tr.error(tc, "security.jaas.call.convertMapToString", new Object[]{_cname, exception});
            }
            stringBuffer.append(string).append("\n");
        } else {
            stringBuffer.append("None.");
        }
        return stringBuffer.toString();
    }

    Map getFileMap() {
        return this._fileMap;
    }

    AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, _cname + " :Entry: getAppConfigurationEntry(" + string + ")");
        }
        Vector vector = null;
        if (this._fileMap != null && this._fileMap.size() != 0) {
            vector = (Vector)this._fileMap.get(string);
        }
        if (vector == null || vector.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, _cname + " :Debug: getAppConfigurationEntry() returning null because the vector is empty");
            }
            return null;
        }
        int n = vector.size();
        AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[n];
        Iterator iterator = vector.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            AppConfigurationEntry appConfigurationEntry = (AppConfigurationEntry)iterator.next();
            appConfigurationEntryArray[n2] = new AppConfigurationEntry(appConfigurationEntry.getLoginModuleName(), appConfigurationEntry.getControlFlag(), appConfigurationEntry.getOptions());
            ++n2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, _cname + " :Exit: getAppConfigurationEntry()");
        }
        return appConfigurationEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFileEntry() {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildFileEntry()");
        }
        final HashMap hashMap = new HashMap();
        Reader reader = null;
        boolean bl = false;
        try {
            if (this.openLoginFileAction != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JAAS login configuration file: " + this._loginFile + " singleLogInFile: " + this.singleLogInFile);
                }
                if ((serializable = this.parse(reader = (Reader)AccessController.doPrivileged((PrivilegedExceptionAction)this.openLoginFileAction))) != null) {
                    hashMap.putAll(serializable);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JAAS login configuration file: " + this._loginFile + " processed");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No JAAS login configuration file specified as java.security.auth.login.config property");
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof MalformedURLException) {
                Tr.error(tc, "security.jaas.open.URL", new Object[]{_cname, this._loginFile, exception});
            } else if (exception instanceof IOException) {
                Tr.error(tc, "security.jaas.create.URL", new Object[]{_cname, this._loginFile, exception});
            }
            bl = true;
        }
        catch (IOException iOException) {
            Tr.error(tc, "security.jaas.create.URL", new Object[]{_cname, this._loginFile, iOException});
            bl = true;
        }
        catch (Parser.ParserException parserException) {
            Tr.error(tc, "security.jaas.parser.URL", new Object[]{_cname, this._loginFile, parserException});
            bl = true;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        serializable = Boolean.FALSE;
        if (!this.singleLogInFile) {
            serializable = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    int n = 1;
                    String string = null;
                    URL uRL = null;
                    BufferedReader bufferedReader = null;
                    boolean bl = false;
                    while ((string = Security.getProperty("login.url." + n)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "JAAS login configuration file (" + n + "): " + string);
                        }
                        try {
                            uRL = new URL(string);
                            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                            HashMap hashMap2 = ConfigFile.this.parse(bufferedReader);
                            if (hashMap2 != null) {
                                hashMap.putAll(hashMap2);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "JAAS login configuration file (" + n + "): " + string + " processed");
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            Tr.error(tc, "security.jaas.open.URL", new Object[]{_cname, string, malformedURLException});
                            bl = true;
                        }
                        catch (IOException iOException) {
                            Tr.error(tc, "security.jaas.create.URL", new Object[]{_cname, string, iOException});
                            bl = true;
                        }
                        catch (Parser.ParserException parserException) {
                            Tr.error(tc, "security.jaas.parser.URL", new Object[]{_cname, string, parserException});
                            bl = true;
                        }
                        ++n;
                    }
                    return new Boolean(bl);
                }
            });
        }
        if (!bl && !((Boolean)serializable).booleanValue()) {
            this._fileMap = hashMap;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildFileEntry()");
        }
    }

    void refresh() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, _cname + " :Entry: refresh()");
        }
        this.clearFileEntry();
        this.buildFileEntry();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, _cname + " :Exit: refresh()");
        }
    }

    class OpenFileAction
    implements PrivilegedExceptionAction {
        private String filename;

        OpenFileAction(String string) {
            this.filename = "file:///" + string;
        }

        public Object run() throws MalformedURLException, IOException {
            URL uRL = new URL(this.filename);
            return new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
    }
}

