/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.login;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.auth.login.ConfigFile;
import com.ibm.ws.security.auth.login.Parser;
import com.ibm.ws.security.auth.login.WCCMLoginConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;

public final class Configuration
extends javax.security.auth.login.Configuration {
    private ConfigFile _fileBasedConfig = null;
    private WCCMLoginConfig _wccmLoginConfig = null;
    private String _cname = null;
    private static final AuthPermission refreshLoginConfigPerm = new AuthPermission("refreshLoginConfiguration");
    private static final AuthPermission getLoginConfigPerm = new AuthPermission("getLoginConfiguration");
    private static final TraceComponent tc = Tr.register(Configuration.class, null, "com.ibm.ejs.resources.security");

    public Configuration() throws Exception {
        try {
            this._cname = this.getClass().getName();
            Tr.audit(tc, "security.init.wccmjaas.setcfg", new Object[]{this._cname});
            this._fileBasedConfig = new ConfigFile();
            this._wccmLoginConfig = new WCCMLoginConfig();
        }
        catch (Exception exception) {
            Tr.error(tc, "security.jaas.configNewInstance");
            throw new Exception("Failed to create a Configuration instance.");
        }
    }

    public String toString() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this._cname + "Performing Java 2 Security Permission Check ..." + "Expecting : " + getLoginConfigPerm.toString());
            }
            securityManager.checkPermission(getLoginConfigPerm);
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append(this._cname + ": Dumping JAAS Configuration\n");
        stringBuffer.append(this._fileBasedConfig.toString2()).append(this._wccmLoginConfig.toString2());
        return stringBuffer.toString();
    }

    public synchronized AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this._cname + " :Entry: getAppConfigurationEntry(" + string + ")");
        }
        if (string == null && string.length() == 0) {
            Tr.warning(tc, "security.jaas.noConfig", new Object[]{this._cname});
            return null;
        }
        List list = this._wccmLoginConfig.get(string);
        if (list == null || list.size() == 0) {
            return this._fileBasedConfig.getAppConfigurationEntry(string);
        }
        int n = list.size();
        AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[n];
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            AppConfigurationEntry appConfigurationEntry = (AppConfigurationEntry)iterator.next();
            appConfigurationEntryArray[n2] = new AppConfigurationEntry(appConfigurationEntry.getLoginModuleName(), appConfigurationEntry.getControlFlag(), appConfigurationEntry.getOptions());
            ++n2;
        }
        return appConfigurationEntryArray;
    }

    public void updateWCCMConfig(HashMap hashMap) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this._cname + "Performing Java 2 Security Permission Check ..." + "Expecting : " + refreshLoginConfigPerm.toString());
            }
            securityManager.checkPermission(refreshLoginConfigPerm);
        }
        this._wccmLoginConfig.update(hashMap);
    }

    public void updateWCCMConfig(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this._cname + "Performing Java 2 Security Permission Check ..." + "Expecting : " + refreshLoginConfigPerm.toString());
            }
            securityManager.checkPermission(refreshLoginConfigPerm);
        }
        this._wccmLoginConfig.update(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateWCCMAppConfig(String string) {
        Object object;
        HashMap hashMap;
        block18: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this._cname + "Performing Java 2 Security Permission Check ..." + "Expecting : " + refreshLoginConfigPerm.toString());
                }
                securityManager.checkPermission(refreshLoginConfigPerm);
            }
            Map map = this._wccmLoginConfig.getMap();
            hashMap = new HashMap();
            Object object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                Object k = object.getKey();
                Object v = object.getValue();
                if (!k.toString().startsWith("system.")) continue;
                hashMap.put(k, v);
            }
            object2 = null;
            object = null;
            object2 = new BufferedReader(new StringReader(string));
            object = this._wccmLoginConfig.parse((Reader)object2);
            try {
                ((Reader)object2).close();
            }
            catch (IOException iOException) {
                Tr.warning(tc, "security.core.close.stream", new Object[]{this._cname});
            }
            break block18;
            catch (IOException iOException) {
                Tr.error(tc, "security.core.open.stringreader", new Object[]{this._cname, string, iOException});
                try {
                    ((Reader)object2).close();
                }
                catch (IOException iOException2) {
                    Tr.warning(tc, "security.core.close.stream", new Object[]{this._cname});
                }
            }
            catch (Parser.ParserException parserException) {
                Tr.error(tc, "security.core.parser.stringreader", new Object[]{this._cname, string, parserException});
                {
                    catch (Throwable throwable) {
                        try {
                            ((Reader)object2).close();
                        }
                        catch (IOException iOException2) {
                            Tr.warning(tc, "security.core.close.stream", new Object[]{this._cname});
                        }
                        throw throwable;
                    }
                }
                try {
                    ((Reader)object2).close();
                }
                catch (IOException iOException3) {
                    Tr.warning(tc, "security.core.close.stream", new Object[]{this._cname});
                }
            }
        }
        hashMap.putAll(object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this._cname + ": Updated JAAS Login Configuration:" + hashMap.toString());
        }
        this._wccmLoginConfig.update(hashMap);
    }

    public void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this._cname + "Performing Java 2 Security Permission Check ..." + "Expecting : " + refreshLoginConfigPerm.toString());
            }
            securityManager.checkPermission(refreshLoginConfigPerm);
        }
        this._fileBasedConfig.refresh();
    }
}

