/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.login;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;

abstract class Parser {
    StreamTokenizer st;
    int lookahead;
    HashMap login = new HashMap();
    private static final TraceComponent tc = Tr.register(Parser.class, null, "com.ibm.ejs.resources.security");

    Parser() {
    }

    HashMap parse(Reader reader) throws IOException, ParserException {
        this.clearFileEntry();
        this.init(reader);
        this.lookahead = this.st.nextToken();
        while (this.lookahead != -1) {
            while (!this.peek("}")) {
                Vector vector;
                String string = this.getString();
                if (this.peek("{")) {
                    this.skipChar(123);
                }
                if ((vector = this.parseAppConfigurationEntry()) == null || string == null || string.trim().length() <= 0) continue;
                if (this.login.containsKey(string)) {
                    Tr.error(tc, "security.jaas.duplicate.config", new Object[]{string});
                }
                this.login.put(string, vector);
            }
            if (this.peek("}")) {
                this.skipChar(125);
            }
            this.match(";");
        }
        return this.login;
    }

    void clearFileEntry() {
        this.login.clear();
    }

    Vector parseAppConfigurationEntry() {
        Vector<AppConfigurationEntry> vector = new Vector<AppConfigurationEntry>();
        try {
            while (!this.peek("}")) {
                String string = this.getString();
                String string2 = this.getString();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (!this.peek(";")) {
                    String string3 = this.getString();
                    this.skipChar(61);
                    String string4 = this.getString();
                    hashMap.put(string3, string4);
                }
                vector.add(new AppConfigurationEntry(string, this.buildFlag(string2), hashMap));
                if (!this.peek(";")) continue;
                this.skipChar(59);
            }
        }
        catch (IOException iOException) {
            Tr.error(tc, "security.jaas.app.parseIO", new Object[]{iOException});
            vector = null;
        }
        catch (ParserException parserException) {
            Tr.error(tc, "security.jaas.app.parse", new Object[]{parserException});
        }
        return vector;
    }

    String getString() throws IOException, ParserException {
        String string = null;
        switch (this.lookahead) {
            case 10: {
                throw new ParserException(this.st.lineno(), " read end of Line");
            }
            case -1: {
                throw new ParserException(this.st.lineno(), " getString:read end of file");
            }
            case -3: {
                string = this.st.sval;
                this.lookahead = this.st.nextToken();
                break;
            }
            case 34: {
                string = this.st.sval;
                this.lookahead = this.st.nextToken();
                break;
            }
            default: {
                throw new ParserException(this.st.lineno(), string, new String(new char[]{(char)this.lookahead}));
            }
        }
        return string;
    }

    String match(String string) throws IOException, ParserException {
        String string2 = null;
        switch (this.lookahead) {
            case -2: {
                throw new ParserException(this.st.lineno(), "number " + this.st.nval);
            }
            case 10: {
                throw new ParserException(this.st.lineno(), " read end of Line");
            }
            case -1: {
                throw new ParserException(this.st.lineno(), " match;read end of FILE");
            }
            case -3: {
                string2 = this.st.sval;
                this.lookahead = this.st.nextToken();
                break;
            }
            case 59: {
                if (string.equalsIgnoreCase(";")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParserException(this.st.lineno(), string, ";");
            }
            case 61: {
                if (string.equalsIgnoreCase("=")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParserException(this.st.lineno(), string, "=");
            }
            case 123: {
                if (string.equalsIgnoreCase("{")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParserException(this.st.lineno(), string, "{");
            }
            case 125: {
                if (string.equalsIgnoreCase("}")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParserException(this.st.lineno(), string, "}");
            }
            default: {
                throw new ParserException(this.st.lineno(), string2, new String(new char[]{(char)this.lookahead}));
            }
        }
        return string2;
    }

    private AppConfigurationEntry.LoginModuleControlFlag buildFlag(String string) {
        AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = null;
        if (string.equalsIgnoreCase("sufficient")) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if (string.equalsIgnoreCase("optional")) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if (string.equalsIgnoreCase("required")) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if (string.equalsIgnoreCase("requisite")) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        return loginModuleControlFlag;
    }

    boolean peek(String string) {
        boolean bl = false;
        switch (this.lookahead) {
            case -3: {
                bl = string.equalsIgnoreCase(this.st.sval);
                break;
            }
            case 59: {
                bl = string.equalsIgnoreCase(";");
                break;
            }
            case 123: {
                bl = string.equalsIgnoreCase("{");
                break;
            }
            case 125: {
                bl = string.equalsIgnoreCase("}");
                break;
            }
            case 61: {
                bl = string.equalsIgnoreCase("=");
                break;
            }
            case 32: {
                bl = string.equalsIgnoreCase(" ");
                break;
            }
        }
        return bl;
    }

    void skipChar(int n) throws IOException, ParserException {
        switch (n) {
            case 61: {
                this.lookahead = this.st.nextToken();
                break;
            }
            case 59: {
                this.lookahead = this.st.nextToken();
                break;
            }
            case 123: {
                this.lookahead = this.st.nextToken();
                break;
            }
            case 125: {
                this.lookahead = this.st.nextToken();
                break;
            }
            default: {
                if (this.lookahead == -1) break;
                this.lookahead = this.st.nextToken();
            }
        }
    }

    private void init(Reader reader) {
        this.st = reader instanceof BufferedReader ? new StreamTokenizer(new BufferedReader(reader)) : new StreamTokenizer(reader);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(48, 58);
        this.st.wordChars(45, 47);
        this.st.wordChars(92, 92);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(160, 255);
        this.st.whitespaceChars(0, 32);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
    }

    class ParserException
    extends GeneralSecurityException {
        ParserException(String string) {
            super(string);
        }

        ParserException(int n, String string) {
            super("line " + n + ": " + string);
        }

        ParserException(int n, String string, String string2) {
            super("line " + n + ": expected '" + string + "', found '" + string2 + "'");
        }
    }
}

