/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.models.base.bindings.applicationbnd.AllAuthenticatedUsers;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.Everyone;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.Server;
import com.ibm.ejs.models.base.bindings.applicationbnd.SpecialSubject;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.etools.portletapplication.Portlet;
import com.ibm.etools.portletapplication.PortletApplication;
import com.ibm.etools.portletapplication.PortletCollection;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.security.AuthorizationProvider;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.util.PortletModelHelper;
import com.ibm.ws.security.authorize.URLMap;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.security.authorization.RoleConfiguration;
import com.ibm.wsspi.security.authorization.RoleConfigurationException;
import com.ibm.wsspi.security.authorization.RoleConfigurationFactory;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.ExcludeList;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;

public class AppInstallNotify {
    private static TraceComponent tc = Tr.register(AppInstallNotify.class, null, "com.ibm.ejs.resources.security");
    private static PolicyConfigurationFactory pcf = null;
    private static AppInstallNotify appNotify = null;
    private static String FACTORY_NAME = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static String FACTORY_CLASS_NAME = "com.ibm.ws.security.provider.WSPolicyConfigurationFactoryImpl";
    private static HashMap pcConfigsMap = null;
    private static final int EXTENSION_PATTERN = 0;
    private static final int PATHPREFIX_PATTERN = 1;
    private static final int EXACT_PATTERN = 2;
    private static final int DEFAULT_PATTERN = 3;
    private static String cellName = null;
    private static String policyCfgFactoryImplClassName = null;
    private static RoleConfigurationFactory rcf = null;
    private static AuthorizationProvider authzProvider = null;
    private static Policy jPolicy = null;

    private AppInstallNotify() {
        this.initialize();
    }

    public static AppInstallNotify getInstance() {
        if (appNotify == null) {
            appNotify = new AppInstallNotify();
        }
        return appNotify;
    }

    private void initialize() {
        pcConfigsMap = new HashMap();
    }

    public void appInstalled(EARFile eARFile, String string) throws Exception {
    }

    public void appInstall(EARFile eARFile, String string, String string2, boolean bl) throws Exception {
        EJBModuleRef eJBModuleRef;
        Object object;
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appInstalled", new Object[]{eARFile, string, string2});
        }
        if (eARFile == null) {
            Tr.error(tc, "security.jacc.tools.earfile.error", new Object[]{string});
            throw new Exception("The earFile is null");
        }
        if (string == null) {
            Tr.error(tc, "security.jacc.tools.appname.error");
            throw new Exception("The appName is null");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appInstall in local mode");
            }
            this.getLocalPolicy();
            this.getPCF(bl);
            this.getRCF(bl);
        }
        if ((list = eARFile.getEJBModuleRefs()) != null && list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                eJBModuleRef = (EJBModuleRef)object.next();
                this.addEJBPermissions(eJBModuleRef, string, string2, bl, null);
            }
        }
        if ((object = eARFile.getWebModuleRefs()) != null && object.size() > 0) {
            eJBModuleRef = object.iterator();
            while (eJBModuleRef.hasNext()) {
                WebModuleRef webModuleRef = (WebModuleRef)eJBModuleRef.next();
                this.addWebPermissions(webModuleRef, string, string2, bl, null);
            }
        }
        this.addAuthorizationTable(eARFile, string, string2, bl);
        if (jPolicy == null) {
            jPolicy = !bl ? Policy.getPolicy() : this.getLocalPolicy();
        }
        if (jPolicy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Refreshing the policy ");
            }
            jPolicy.refresh();
        }
        Tr.audit(tc, "security.jacc.secpolicy.propagated", new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appInstalled");
        }
    }

    public void addAuthorizationTable(EARFile eARFile, String string, String string2, boolean bl) throws RoleConfigurationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAuthorizationTable");
        }
        if (rcf == null) {
            rcf = this.getRCF(bl);
        }
        if (rcf == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addAuthorizationTable: no roleconfiguration");
            }
            return;
        }
        RoleConfiguration roleConfiguration = null;
        if (rcf != null) {
            try {
                roleConfiguration = rcf.getRoleConfiguration(string2, true);
            }
            catch (RoleConfigurationException roleConfigurationException) {
                FFDCFilter.processException((Throwable)roleConfigurationException, "com.ibm.ws.security.authorize.AppInstallNotify.addAuthorizationTable", "223", this);
                Tr.error(tc, "security.jacc.tools.rcf", new Object[]{string2, roleConfigurationException});
                roleConfiguration = null;
                throw roleConfigurationException;
            }
        }
        if (roleConfiguration != null) {
            ApplicationBinding applicationBinding = eARFile.getBindings();
            AuthorizationTable authorizationTable = null;
            if (applicationBinding != null) {
                authorizationTable = applicationBinding.getAuthorizationTable();
            }
            EList eList = null;
            if (authorizationTable != null) {
                eList = authorizationTable.getAuthorizations();
            }
            Iterator iterator = null;
            if (eList != null) {
                iterator = eList.iterator();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    EList eList2;
                    EList eList3;
                    RoleAssignment roleAssignment = (RoleAssignment)iterator.next();
                    String string3 = roleAssignment.getRole().getRoleName();
                    EList eList4 = roleAssignment.getUsers();
                    if (eList4 != null) {
                        roleConfiguration.addUsersToRole(string3, (List)eList4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added users: " + eList4.toString() + " to role: " + string3);
                        }
                    }
                    if ((eList3 = roleAssignment.getGroups()) != null) {
                        roleConfiguration.addGroupsToRole(string3, (List)eList3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added groups: " + eList3.toString() + " to role: " + string3);
                        }
                    }
                    if ((eList2 = roleAssignment.getSpecialSubjects()) == null) continue;
                    Iterator iterator2 = eList2.iterator();
                    while (iterator2.hasNext()) {
                        SpecialSubject specialSubject = (SpecialSubject)iterator2.next();
                        if (specialSubject instanceof Everyone) {
                            roleConfiguration.addEveryoneToRole(string3);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "added Everyone to role: " + string3);
                            continue;
                        }
                        if (specialSubject instanceof AllAuthenticatedUsers) {
                            roleConfiguration.addAuthenticatedUsersToRole(string3);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "added AllAuthenticatedUsers to role: " + string3);
                            continue;
                        }
                        if (!(specialSubject instanceof Server) || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "added Server not supported for role: " + string3);
                    }
                }
            }
            roleConfiguration.commit();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Propagated RoleConfiguration information for Application: " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAuthorizationTable");
        }
    }

    public void appUninstalled(String string, String string2) throws Exception {
    }

    public void appUninstall(ApplicationDeployment applicationDeployment, String string, String string2, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appUninstalled", new Object[]{applicationDeployment, string, string2});
        }
        if (applicationDeployment == null) {
            throw new Exception("The deployment.xml in the application is null");
        }
        if (string == null) {
            Tr.error(tc, "security.jacc.tools.appname.error");
            throw new Exception("The appName is null");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appInstall in local mode");
            }
            this.getLocalPolicy();
            this.getPCF(bl);
            this.getRCF(bl);
        }
        try {
            EList eList = applicationDeployment.getModules();
            if (eList != null && eList.size() > 0) {
                for (int i = 0; i < eList.size(); ++i) {
                    ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
                    String string3 = moduleDeployment.getUri();
                    this.deleteModule(string3, string, string2, bl);
                }
            }
            this.deleteAuthorizationTable(string, string2, bl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.authorize.AppInstallNotify.appUninstalled", "333", this);
            Tr.error(tc, "security.jacc.tools.uninstall", new Object[]{string, exception});
            throw exception;
        }
        if (jPolicy == null) {
            jPolicy = !bl ? Policy.getPolicy() : this.getLocalPolicy();
        }
        if (jPolicy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Refreshing the policy ");
            }
            jPolicy.refresh();
        }
        Tr.audit(tc, "security.jacc.secpolicy.removed", new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appUninstalled");
        }
    }

    public void deleteAuthorizationTable(String string, String string2, boolean bl) throws ClassNotFoundException, PolicyContextException, ArchiveWrappedException, RoleConfigurationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAuthorizationTable");
        }
        if (rcf == null) {
            rcf = this.getRCF(bl);
        }
        if (rcf == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteAuthorizationTable: no roleconfiguration");
            }
            return;
        }
        if (rcf != null) {
            RoleConfiguration roleConfiguration = null;
            try {
                roleConfiguration = rcf.getRoleConfiguration(string2, true);
            }
            catch (RoleConfigurationException roleConfigurationException) {
                FFDCFilter.processException((Throwable)roleConfigurationException, "com.ibm.ws.security.authorize.AppInstallNotify.appUninstalled", "354", this);
                Tr.error(tc, "security.jacc.tools.rcf", new Object[]{string2, roleConfigurationException});
                roleConfiguration = null;
                throw roleConfigurationException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RoleConfiguration to be deleted is: " + roleConfiguration);
            }
            if (roleConfiguration != null) {
                roleConfiguration.delete();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleted role configuration for contextID: " + string2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteAuthorizationTable");
        }
    }

    public void addWebPermissions(WebModuleRef webModuleRef, String string, String string2, boolean bl, PolicyConfiguration policyConfiguration) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String[] stringArray;
        String[] stringArray2;
        Object object6;
        Object object7;
        Object object8;
        String string3;
        Object object9;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWebPermissions", new Object[]{webModuleRef.getUri(), string});
        }
        WebApp webApp = null;
        EList eList = null;
        EList eList2 = null;
        UserDataConstraint userDataConstraint = null;
        EList eList3 = null;
        EList eList4 = null;
        EList eList5 = null;
        EList eList6 = null;
        PolicyConfiguration policyConfiguration2 = null;
        webApp = webModuleRef.getWebApp();
        if (webApp != null) {
            eList = webApp.getConstraints();
            eList4 = webApp.getServlets();
            eList6 = webApp.getSecurityRoles();
        }
        PortletApplication portletApplication = PortletModelHelper.getPortletApplication((WebModuleRef)webModuleRef);
        if (tc.isDebugEnabled() && portletApplication != null && webApp != null) {
            Tr.debug(tc, "Portlet application: " + portletApplication + " exists for webapp: " + webApp);
        }
        String string4 = null;
        String string5 = webModuleRef.getModule().getAltDD();
        if (string5 == null || string5.length() == 0) {
            string4 = webModuleRef.getUri();
        } else {
            string4 = string5;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using alt-DD = " + string5);
            }
        }
        String string6 = this.getModuleContextID(string2, string4);
        try {
            if (pcf == null) {
                pcf = this.getPCF(bl);
            }
            if (pcf == null) {
                throw new PolicyContextException("Cannot get the PolicyConfigurationFactory of the JACC provider");
            }
            policyConfiguration2 = pcf.getPolicyConfiguration(string6, true);
        }
        catch (PolicyContextException policyContextException) {
            FFDCFilter.processException((Throwable)policyContextException, "com.ibm.ws.security.authorize.AppInstallNotify.addWebPermissions", "607", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{string6, policyContextException});
            pcf = null;
            policyConfiguration2 = null;
            throw policyContextException;
        }
        if (policyConfiguration2 == null) {
            Tr.error(tc, "security.jacc.tools.pcf.null", new Object[]{string6});
            throw new PolicyContextException("The PolicyConfiguration object is null");
        }
        Permissions permissions = new Permissions();
        Permissions permissions2 = new Permissions();
        Permissions permissions3 = new Permissions();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (eList4 != null) {
            for (int i = 0; i < eList4.size(); ++i) {
                object9 = (Servlet)eList4.get(i);
                string3 = object9.getServletName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servlet Name is: " + string3);
                }
                if ((eList5 = object9.getSecurityRoleRefs()) != null) {
                    for (int j = 0; j < eList5.size(); ++j) {
                        object8 = (SecurityRoleRef)eList5.get(j);
                        object7 = object8.getName();
                        String string7 = object8.getLink();
                        object6 = new WebRoleRefPermission(string3, (String)object7);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding the following WebRoleRefPermission (roleLink, WebRoleRefPermission) for RoleLink: ", new Object[]{string7});
                        }
                        policyConfiguration2.addToRole(string7, (Permission)object6);
                        arrayList.add(object7);
                    }
                }
                if (eList6 == null) continue;
                Iterator iterator = eList6.iterator();
                while (iterator.hasNext()) {
                    object8 = ((SecurityRole)iterator.next()).getRoleName();
                    if (arrayList.contains(object8)) continue;
                    object7 = new WebRoleRefPermission(string3, (String)object8);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the following WebRoleRefPermission (roleLink , WebRoleRefPermission): ", new Object[]{object8, object7});
                    }
                    policyConfiguration2.addToRole((String)object8, (Permission)object7);
                }
            }
        }
        if (eList6 != null) {
            Iterator iterator = eList6.iterator();
            while (iterator.hasNext()) {
                object9 = ((SecurityRole)iterator.next()).getRoleName();
                string3 = new WebRoleRefPermission("", (String)object9);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the following WebRoleRefPermission with empty string (roleName , WebRoleRefPermission): ", new Object[]{object9, string3});
                }
                policyConfiguration2.addToRole((String)object9, (Permission)((Object)string3));
            }
        }
        if (portletApplication != null) {
            EList eList7 = portletApplication.getPortlets();
            object9 = new ArrayList();
            if (eList7 != null) {
                for (int i = 0; i < eList7.size(); ++i) {
                    Portlet portlet = (Portlet)eList7.get(i);
                    object8 = portlet.getPortletName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Portlet Name is: " + (String)object8);
                    }
                    if ((object7 = portlet.getSecurityRoleRefs()) != null) {
                        for (int j = 0; j < object7.size(); ++j) {
                            object6 = (SecurityRoleRef)object7.get(j);
                            stringArray2 = object6.getName();
                            stringArray = object6.getLink();
                            object5 = new WebRoleRefPermission((String)object8, (String)stringArray2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding the following WebRoleRefPermission (roleLink, WebRoleRefPermission) for Portlet RoleLink: " + new Object[]{stringArray});
                            }
                            policyConfiguration2.addToRole((String)stringArray, (Permission)object5);
                            ((ArrayList)object9).add(stringArray2);
                        }
                    }
                    if (eList6 == null) continue;
                    Iterator iterator = eList6.iterator();
                    while (iterator.hasNext()) {
                        object6 = ((SecurityRole)iterator.next()).getRoleName();
                        if (((ArrayList)object9).contains(object6)) continue;
                        stringArray2 = new WebRoleRefPermission((String)object8, (String)object6);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding the following WebRoleRefPermission for Portlet (roleLink , WebRoleRefPermission): " + new Object[]{object6, stringArray2});
                        }
                        policyConfiguration2.addToRole((String)object6, (Permission)stringArray2);
                    }
                }
            }
        }
        HashMap<String, URLMap> hashMap = new HashMap<String, URLMap>();
        hashMap.put("/", new URLMap("/"));
        if (eList != null) {
            object9 = eList.iterator();
            while (object9.hasNext()) {
                boolean bl2;
                SecurityConstraint securityConstraint = (SecurityConstraint)object9.next();
                if (securityConstraint == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SecurityConstraint: ", new Object[]{securityConstraint});
                }
                AuthConstraint authConstraint = securityConstraint.getAuthConstraint();
                eList2 = null;
                if (authConstraint != null) {
                    eList2 = authConstraint.getRoles();
                }
                userDataConstraint = securityConstraint.getUserDataConstraint();
                object8 = null;
                if (userDataConstraint != null && (bl2 = userDataConstraint.isSetTransportGuarantee())) {
                    object8 = userDataConstraint.getTransportGuarantee().getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "transport is set: " + (String)object8);
                    }
                }
                eList3 = securityConstraint.getWebResourceCollections();
                object7 = eList3.iterator();
                while (object7.hasNext()) {
                    WebResourceCollection webResourceCollection = (WebResourceCollection)object7.next();
                    object6 = webResourceCollection.getUrlPattern();
                    if (object6 == null) continue;
                    stringArray2 = object6.iterator();
                    while (stringArray2.hasNext()) {
                        String string8;
                        stringArray = (String)stringArray2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "url being processed is: " + (String)stringArray);
                        }
                        if ((object5 = (URLMap)hashMap.get(stringArray)) == null) {
                            object5 = this.getNewURLMap((String)stringArray, hashMap);
                        }
                        object4 = webResourceCollection.getHttpMethod();
                        object3 = new ArrayList();
                        if (object4 != null && object4.size() > 0) {
                            object2 = object4.iterator();
                            while (object2.hasNext()) {
                                object = (HTTPMethodTypeEnum)object2.next();
                                string8 = object.getName();
                                ((ArrayList)object3).add(string8);
                            }
                        } else {
                            object2 = ((URLMap)object5).getAllMethods();
                            object3 = new ArrayList<String>(Arrays.asList(object2));
                        }
                        if (authConstraint != null && (eList2 == null || eList2.size() < 1)) {
                            ((URLMap)object5).setExcludedSet((ArrayList)object3);
                        } else if (authConstraint == null) {
                            ((URLMap)object5).setUncheckedSet((ArrayList)object3);
                        } else if (eList2 != null && eList2 != null) {
                            object2 = eList2.iterator();
                            while (object2.hasNext()) {
                                object = (String)object2.next();
                                if (((String)object).equals("*")) {
                                    string8 = webApp.getSecurityRoles();
                                    if (string8 == null) continue;
                                    Iterator iterator = string8.iterator();
                                    while (iterator.hasNext()) {
                                        String string9 = ((SecurityRole)iterator.next()).getRoleName();
                                        ((URLMap)object5).setRoleMap(string9, (ArrayList)object3);
                                    }
                                    continue;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting role map for role = " + (String)object);
                                }
                                ((URLMap)object5).setRoleMap((String)object, (ArrayList)object3);
                            }
                        }
                        if (object8 == null) continue;
                        ((URLMap)object5).setUserDataMap((String)object8, (ArrayList)object3);
                    }
                }
            }
        }
        if (portletApplication != null && (object9 = portletApplication.getSecurityConstraints()) != null && object9.size() > 0) {
            Iterator iterator = object9.iterator();
            while (iterator.hasNext()) {
                com.ibm.etools.portletapplication.SecurityConstraint securityConstraint = (com.ibm.etools.portletapplication.SecurityConstraint)iterator.next();
                if (securityConstraint == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SecurityConstraint for Portlet: ", new Object[]{securityConstraint});
                }
                object8 = securityConstraint.getUserDataConstraint();
                object7 = "NONE";
                if (object8 != null) {
                    object7 = object8.getTransportGuarantee().getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "transport set for Portlet is: " + (String)object7);
                    }
                }
                PortletCollection portletCollection = securityConstraint.getPortletCollection();
                object6 = portletCollection.getPortletNames();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "portletNames are: " + object6);
                }
                stringArray2 = object6.iterator();
                while (stringArray2.hasNext()) {
                    stringArray = (String)stringArray2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "url being processed for Portlet is: " + (String)stringArray);
                    }
                    object5 = null;
                    if (!stringArray.endsWith("/*")) {
                        object4 = new StringBuffer("/");
                        object5 = ((StringBuffer)object4).append((String)stringArray).append("/*").toString();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "url modified for Portlet is: " + (String)object5);
                        }
                    }
                    if ((object4 = (URLMap)hashMap.get(object5)) == null) {
                        object4 = this.getNewURLMap((String)object5, hashMap);
                    }
                    object3 = ((URLMap)object4).getAllMethods();
                    object2 = new ArrayList(Arrays.asList(object3));
                    if (object7 == null) continue;
                    ((URLMap)object4).setUserDataMap((String)object7, (ArrayList)object2);
                }
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String[] stringArray3;
            String string10 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "url is: " + string10);
            }
            if (this.unqualified(string10, (String)(object7 = ((URLMap)(object8 = (URLMap)hashMap.get(string10))).getURLPattern()))) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "url: " + string10 + " is unqualified");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "urlPatternName: " + (String)object7);
            }
            if ((stringArray3 = ((URLMap)object8).getExcludedArray()) != null) {
                permissions3.add((Permission)new WebResourcePermission((String)object7, stringArray3));
                permissions3.add((Permission)new WebUserDataPermission((String)object7, stringArray3, null));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "excluded list is null");
            }
            object6 = ((URLMap)object8).getUncheckedArray();
            if (object6 != null) {
                permissions2.add((Permission)new WebResourcePermission((String)object7, (String[])object6));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unchecked list is null");
            }
            stringArray2 = ((URLMap)object8).getUserDataArray();
            if (stringArray2 != null) {
                permissions2.add((Permission)new WebUserDataPermission((String)object7, stringArray2, "CONFIDENTIAL"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "methodarray for user data is null");
            }
            stringArray = ((URLMap)object8).getUnchkDataConstraintArray();
            if (stringArray != null) {
                permissions2.add((Permission)new WebUserDataPermission((String)object7, stringArray, "NONE"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "methodarray for unchecked user data is null");
            }
            object5 = ((URLMap)object8).getRoleMap();
            object4 = ((HashMap)object5).keySet().iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "role is " + (String)object3);
                }
                if ((object2 = (ArrayList)((HashMap)object5).get(object3)) != null && ((ArrayList)object2).size() > 0) {
                    object = new WebResourcePermission((String)object7, ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]));
                    policyConfiguration2.addToRole((String)object3, (Permission)object);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the role: " + (String)object3 + " to the permission " + object);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "methodarray for role is null");
            }
        }
        policyConfiguration2.addToExcludedPolicy((PermissionCollection)permissions3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added the following ExcludedPerms:" + permissions3);
        }
        policyConfiguration2.addToUncheckedPolicy((PermissionCollection)permissions2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added the following UncheckedPerms:" + permissions2);
        }
        this.linkConfiguration(string, policyConfiguration2, policyConfiguration);
        policyConfiguration2.commit();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWebPermissions");
        }
    }

    public void addEJBPermissions(EJBModuleRef eJBModuleRef, String string, String string2, boolean bl, PolicyConfiguration policyConfiguration) throws Exception {
        Object object;
        int n;
        String string3;
        EnterpriseBean enterpriseBean;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEJBPermissions", new Object[]{eJBModuleRef.getUri(), string});
        }
        PolicyConfiguration policyConfiguration2 = null;
        EJBJar eJBJar = null;
        AssemblyDescriptor assemblyDescriptor = null;
        EList eList = null;
        EList eList2 = null;
        EList eList3 = null;
        EList eList4 = null;
        ExcludeList excludeList = null;
        Permissions permissions = new Permissions();
        Permissions permissions2 = new Permissions();
        Permissions permissions3 = new Permissions();
        eJBJar = eJBModuleRef.getEJBJar();
        if (eJBJar != null) {
            eList3 = eJBJar.getEnterpriseBeans();
            assemblyDescriptor = eJBJar.getAssemblyDescriptor();
        }
        if (assemblyDescriptor != null) {
            eList = assemblyDescriptor.getMethodPermissions();
            excludeList = assemblyDescriptor.getExcludeList();
        }
        String string4 = null;
        String string5 = eJBModuleRef.getModule().getAltDD();
        if (string5 == null || string5.length() == 0) {
            string4 = eJBModuleRef.getUri();
        } else {
            string4 = string5;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using alt-DD = " + string5);
            }
        }
        String string6 = this.getModuleContextID(string2, string4);
        try {
            if (pcf == null) {
                pcf = this.getPCF(bl);
            }
            if (pcf == null) {
                throw new PolicyContextException("Cannot get the PolicyConfigurationFactory of the JACC provider");
            }
            policyConfiguration2 = pcf.getPolicyConfiguration(string6, true);
        }
        catch (PolicyContextException policyContextException) {
            FFDCFilter.processException((Throwable)policyContextException, "com.ibm.ws.security.authorize.AppInstallNotify.addEJBPermissions", "420", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{string6, policyContextException});
            pcf = null;
            policyConfiguration2 = null;
            throw policyContextException;
        }
        if (policyConfiguration2 == null) {
            Tr.error(tc, "security.jacc.tools.pcf.null", new Object[]{string6});
            throw new PolicyContextException("The PolicyConfiguration object is null");
        }
        if (eList3 != null && eList3.size() > 0) {
            for (n2 = 0; n2 < eList3.size(); ++n2) {
                enterpriseBean = (EnterpriseBean)eList3.get(n2);
                string3 = enterpriseBean.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bean Name processed is " + enterpriseBean.getName());
                }
                if ((eList4 = enterpriseBean.getSecurityRoleRefs()) == null) continue;
                for (n = 0; n < eList4.size(); ++n) {
                    object = (SecurityRoleRef)eList4.get(n);
                    String string7 = object.getName();
                    String string8 = object.getLink();
                    EJBRoleRefPermission eJBRoleRefPermission = new EJBRoleRefPermission(string3, string7);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the following EJBRoleRefPermission (roleName, refLink): ", new Object[]{string7, string8});
                    }
                    policyConfiguration2.addToRole(string8, (Permission)eJBRoleRefPermission);
                }
            }
        }
        if (eList != null && eList.size() > 0) {
            for (n2 = 0; n2 < eList.size(); ++n2) {
                enterpriseBean = (MethodPermission)eList.get(n2);
                string3 = enterpriseBean.getMethodElements();
                if (enterpriseBean.isUnchecked()) {
                    permissions2 = this.getEJBPermCollection((EList)string3);
                    if (permissions2 == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the following Unchecked permissions: ", new Object[]{permissions2});
                    }
                    policyConfiguration2.addToUncheckedPolicy((PermissionCollection)permissions2);
                    continue;
                }
                eList2 = enterpriseBean.getRoles();
                if (eList2 == null || eList2.size() <= 0 || (permissions = this.getEJBPermCollection((EList)string3)) == null) continue;
                for (n = 0; n < eList2.size(); ++n) {
                    object = ((SecurityRole)eList2.get(n)).getRoleName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the following Role Permissions (roleName, EJBRolePermissions): ", new Object[]{object, permissions});
                    }
                    policyConfiguration2.addToRole((String)object, (PermissionCollection)permissions);
                }
            }
        }
        EList eList5 = null;
        if (excludeList != null && (permissions3 = this.getEJBPermCollection(eList5 = excludeList.getMethodElements())) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding the following Excluded Permissions: ", new Object[]{permissions3});
            }
            policyConfiguration2.addToExcludedPolicy((PermissionCollection)permissions3);
        }
        this.linkConfiguration(string, policyConfiguration2, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Committing the EJB PolicyConfiguration ");
        }
        policyConfiguration2.commit();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEJBPermissions");
        }
    }

    private PolicyConfigurationFactory getPCF(boolean bl) {
        if (pcf == null) {
            try {
                if (System.getProperty(FACTORY_NAME) == null) {
                    policyCfgFactoryImplClassName = !bl ? SecurityConfig.getPolicyConfigurationFactoryClassName() : this.getLocalPCFName();
                    if (policyCfgFactoryImplClassName != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The policy configuration factory name is:" + policyCfgFactoryImplClassName);
                        }
                        System.setProperty(FACTORY_NAME, policyCfgFactoryImplClassName);
                        pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                    }
                } else {
                    pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.security.authorize.AppInstallNotify.initialize", "541", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during getPolicyConfigurationFactory.getPolicyConfigurationFactory:", new Object[]{classNotFoundException});
                }
                pcf = null;
            }
            catch (PolicyContextException policyContextException) {
                FFDCFilter.processException((Throwable)policyContextException, "com.ibm.ws.security.authorize.AppInstallNotify.initialize", "545", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during getPolicyConfigurationFactory.getPolicyConfigurationFactory:", new Object[]{policyContextException});
                }
                pcf = null;
            }
            catch (WorkSpaceException workSpaceException) {
                FFDCFilter.processException((Throwable)workSpaceException, "com.ibm.ws.security.authorize.AppInstallNotify.initialize", "567", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during getPolicyConfigurationFactory.getPolicyConfigurationFactory:", new Object[]{workSpaceException});
                }
                pcf = null;
            }
        }
        return pcf;
    }

    private RoleConfigurationFactory getRCF(boolean bl) {
        if (rcf == null) {
            String string = null;
            try {
                string = !bl ? SecurityConfig.getRoleConfigurationFactoryClassName() : this.getLocalRCFName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rcfClassName: ", string);
                }
                if (string != null && string.length() > 0) {
                    rcf = (RoleConfigurationFactory)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.authorize.AppInstallNotify.initialize", "563", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during the initialization of the roleConfigurationImplClass:", new Object[]{string, exception});
                }
                rcf = null;
            }
        }
        return rcf;
    }

    public void linkConfiguration(String string, PolicyConfiguration policyConfiguration, PolicyConfiguration policyConfiguration2) throws PolicyContextException {
        if (policyConfiguration2 == null) {
            if (pcConfigsMap.containsKey(string)) {
                PolicyConfiguration policyConfiguration3 = (PolicyConfiguration)pcConfigsMap.get(string);
                policyConfiguration.linkConfiguration(policyConfiguration3);
            } else {
                pcConfigsMap.put(string, policyConfiguration);
            }
        } else {
            policyConfiguration.linkConfiguration(policyConfiguration2);
        }
    }

    public PolicyConfiguration getPolicyConfiguration(String string, String string2, String string3, boolean bl, boolean bl2) {
        PolicyConfiguration policyConfiguration = null;
        String string4 = this.getModuleContextID(string3, string);
        try {
            if (pcf == null) {
                pcf = this.getPCF(bl);
            }
            if (pcf != null) {
                policyConfiguration = pcf.getPolicyConfiguration(string4, bl2);
            }
        }
        catch (PolicyContextException policyContextException) {
            FFDCFilter.processException((Throwable)policyContextException, "com.ibm.ws.security.authorize.AppInstallNotify.getPolicyConfiguration", "983", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{string4, policyContextException});
            pcf = null;
            policyConfiguration = null;
        }
        return policyConfiguration;
    }

    public void deleteModule(ModuleRef moduleRef, String string, String string2, boolean bl) throws Exception {
        String string3 = moduleRef.getUri();
        this.deleteModule(string3, string, string2, bl);
    }

    public void deleteModule(String string, String string2, String string3, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteModule", new Object[]{string, string2, string3});
        }
        PolicyConfiguration policyConfiguration = null;
        String string4 = this.getModuleContextID(string3, string);
        try {
            if (pcf == null) {
                pcf = this.getPCF(bl);
            }
            if (pcf == null) {
                throw new Exception("Cannot get the PolicyConfigurationFactory of the JACC provider");
            }
            policyConfiguration = pcf.getPolicyConfiguration(string4, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.security.authorize.AppInstallNotify.deleteModule", "930", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{string4, classNotFoundException});
            pcf = null;
            policyConfiguration = null;
            throw new Exception("Failed to get the PolicyConfiguration object", classNotFoundException);
        }
        catch (PolicyContextException policyContextException) {
            FFDCFilter.processException((Throwable)policyContextException, "com.ibm.ws.security.authorize.AppInstallNotify.deleteModule", "936", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{string4, policyContextException});
            pcf = null;
            policyConfiguration = null;
            throw new Exception("Failed to get the PolicyConfiguration object", policyContextException);
        }
        if (policyConfiguration == null) {
            Tr.error(tc, "security.jacc.tools.pcf.null", new Object[]{string4});
            throw new Exception("The PolicyConfiguration object is null");
        }
        policyConfiguration.delete();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteModule");
        }
    }

    private Permissions getEJBPermCollection(EList eList) {
        Permissions permissions = new Permissions();
        if (eList != null && eList.size() > 0) {
            for (int i = 0; i < eList.size(); ++i) {
                Object object;
                MethodElement methodElement = (MethodElement)eList.get(i);
                String string = methodElement.getEnterpriseBean().getName();
                String string2 = methodElement.getName();
                int n = methodElement.getType().getValue();
                String string3 = methodElement.getType().getName();
                if (string2.equals("*")) {
                    string2 = null;
                }
                if (string3 != null && string3.equals("Unspecified")) {
                    string3 = null;
                }
                String[] stringArray = null;
                if (methodElement.hasMethodParams() && (object = methodElement.getMethodParams()) != null) {
                    stringArray = object.toArray(new String[object.size()]);
                }
                if (tc.isDebugEnabled()) {
                    object = new StringBuffer("addingEJBPermCollection: ejbName = ");
                    ((StringBuffer)object).append(string).append(", methodName = ").append(string2).append(", methodInfName = ").append(string3).append(", paramArray = ").append(stringArray);
                    Tr.debug(tc, ((StringBuffer)object).toString());
                }
                object = new EJBMethodPermission(string, string2, string3, stringArray);
                permissions.add((Permission)object);
            }
        } else {
            permissions = null;
        }
        return permissions;
    }

    private int urlType(String string) {
        String string2 = string.toString();
        if (string2.startsWith("*.")) {
            return 0;
        }
        if (string2.startsWith("/") && string2.endsWith("/*")) {
            return 1;
        }
        if (string2.equals("/")) {
            return 3;
        }
        return 2;
    }

    private boolean urlPatternMatch(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        if (string.equals("/*")) {
            return true;
        }
        if (string.startsWith("/") && string.endsWith("/*")) {
            String string3 = string.substring(0, string.length() - 2);
            int n = string3.length();
            if (string2.startsWith(string3) && (string2.length() == n || string2.charAt(n + 1) == '/')) {
                return true;
            }
        }
        if (string.startsWith("*.") && string2.endsWith(string.substring(1))) {
            return true;
        }
        return string.equals("/");
    }

    private boolean unqualified(String string, String string2) {
        boolean bl = false;
        if (string2.indexOf(":") != -1) {
            int n = string2.indexOf(":");
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n + 1), ":");
            while (stringTokenizer.hasMoreTokens()) {
                if (!this.urlPatternMatch(stringTokenizer.nextToken(), string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private String getModuleContextID(String string, String string2) {
        String string3 = null;
        if (string != null && string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("/").append(string2);
            string3 = stringBuffer.toString();
        } else {
            string3 = string2;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationProvider getAuthorizationProvider() throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationProvider");
        }
        WorkSpace workSpace = null;
        Resource resource = null;
        try {
            RepositoryContext repositoryContext;
            String string = "" + System.currentTimeMillis();
            workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(string);
            RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells");
            URI uRI = URI.createURI((String)"security.xml");
            Collection collection = workSpace.findContext(repositoryContextType);
            Security security2 = null;
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                repositoryContext = (RepositoryContext)iterator.next();
                resource = repositoryContext.getResourceSet().createResource(uRI);
                HashMap hashMap = new HashMap();
                resource.load(hashMap);
                security2 = (Security)resource.getContents().get(0);
            }
            repositoryContext = null;
            if (security2 != null) {
                repositoryContext = security2.getAuthConfig();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorization config in local mode is: " + repositoryContext);
            }
            if (repositoryContext != null) {
                authzProvider = (AuthorizationProvider)repositoryContext.getAuthorizationProviders().get(0);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorization provider in local mode is: " + authzProvider);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.authorize.AppInstallNotify.getLocalPCFName", "1211", this);
            Tr.error(tc, "security.jacc.tools.authzprovider.error", new Object[]{exception});
        }
        finally {
            if (resource != null) {
                resource.unload();
                resource = null;
            }
            if (workSpace != null) {
                String string = workSpace.getUserName();
                WorkSpaceManagerFactory.getManager().removeWorkSpace(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationProvider");
        }
        return authzProvider;
    }

    private String getLocalPCFName() throws WorkSpaceException {
        String string = null;
        if (authzProvider == null) {
            authzProvider = this.getAuthorizationProvider();
        }
        if (authzProvider != null) {
            string = authzProvider.getPolicyConfigurationFactoryImplClassName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PolicyConfigurationFactory in localMode is: " + string);
        }
        return string;
    }

    private String getLocalRCFName() throws WorkSpaceException {
        String string = null;
        if (authzProvider == null) {
            authzProvider = this.getAuthorizationProvider();
        }
        if (authzProvider != null) {
            string = authzProvider.getRoleConfigurationFactoryImplClassName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RoleConfigurationFactory in localMode is: " + string);
        }
        return string;
    }

    private Policy getLocalPolicy() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalPolicy");
        }
        if (jPolicy == null) {
            String string = System.getProperty("javax.security.jacc.policy.provider");
            if (string == null) {
                if (authzProvider == null) {
                    authzProvider = this.getAuthorizationProvider();
                }
                if (authzProvider != null) {
                    string = authzProvider.getJ2eePolicyImplClassName();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicyName in local mode is: " + string);
                }
            }
            if (string != null) {
                Policy.setPolicy((Policy)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance());
                jPolicy = Policy.getPolicy();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalPolicy");
        }
        return jPolicy;
    }

    private URLMap getNewURLMap(String string, HashMap hashMap) {
        URLMap uRLMap = new URLMap(string);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = this.urlType(string2);
            switch (this.urlType(string)) {
                case 0: {
                    if (n == 1 || n == 2 && this.urlPatternMatch(string, string2)) {
                        uRLMap.appendURLPattern(string2);
                        break;
                    }
                    if (n != 3) break;
                    ((URLMap)hashMap.get(string2)).appendURLPattern(string);
                    break;
                }
                case 1: {
                    if ((n == 1 || n == 2) && this.urlPatternMatch(string, string2)) {
                        uRLMap.appendURLPattern(string2);
                        break;
                    }
                    if (n == 1 && this.urlPatternMatch(string2, string)) {
                        ((URLMap)hashMap.get(string2)).appendURLPattern(string);
                        break;
                    }
                    if (n != 0 && n != 3) break;
                    ((URLMap)hashMap.get(string2)).appendURLPattern(string);
                    break;
                }
                case 2: {
                    if ((n == 0 || n == 1) && this.urlPatternMatch(string2, string)) {
                        ((URLMap)hashMap.get(string2)).appendURLPattern(string);
                        break;
                    }
                    if (n != 3) break;
                    ((URLMap)hashMap.get(string2)).appendURLPattern(string);
                    break;
                }
                case 3: {
                    if (n == 3) break;
                    uRLMap.appendURLPattern(string2);
                    break;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "full urlPattern created is: " + uRLMap.getURLPattern());
        }
        hashMap.put(string, uRLMap);
        return uRLMap;
    }
}

