/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.authorize.AppInstallNotify;
import com.ibm.ws.security.authorize.JaccTaskUtil;
import java.util.Hashtable;

public class JaccInstallTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(JaccInstallTask.class, null, "com.ibm.ejs.resources.security");
    private static String nativeJACC = "com.ibm.ws.security.policy.JaccPolicyProxy";

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sec-install performTask");
        }
        if (!this._isLocal) {
            String string = null;
            object = AdminServiceFactory.getAdminService();
            if (object != null) {
                string = object.getProcessType();
            }
            if (string == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sec performTask");
                }
                return true;
            }
            if (!string.equals("DeploymentManager") && !string.equals("UnManagedProcess")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sec performTask");
                }
                return true;
            }
        } else {
            if (this._isInNodeSync) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "No jacc operation during node sync. sec performTask");
                }
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Not during node sync. Continue with jacc operation");
            }
        }
        try {
            boolean bl;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Check to see if JACC is enabled");
            }
            if (bl = JaccTaskUtil.checkForJacc(this._repository, this._isLocal, this._cellName, false)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JACC is enabled");
                }
                object = appData2.getAppName();
                EARFile eARFile = appData2.getEAR();
                String string = appData2.getAppContextIDForSecurity();
                AppInstallNotify.getInstance().appInstall(eARFile, (String)object, string, this._isLocal);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.authorize.JaccInstallTask.performTask", "91", this);
            Tr.error(tc, "security.jacc.install.task", new Object[]{appData2.getAppName(), exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sec performTask");
        }
        return true;
    }
}

