/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.KeyManager;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.websphere.models.config.ipc.ssl.ManagementScope;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.SslFactory;
import com.ibm.websphere.models.config.ipc.ssl.SslPackage;
import com.ibm.websphere.models.config.ipc.ssl.TrustManager;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.orb.securityprotocol.CommonSecureInterop;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocol;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPTransport;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.DynamicSSLConfigSelection;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SSLConfigGroup;
import com.ibm.websphere.models.config.security.SSLType;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SecurityPackage;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class MergeSecurityConfig {
    private static TraceComponent tc = Tr.register(MergeSecurityConfig.class, null, "com.ibm.ejs.resources.security");
    private static ManagementScope cellScope = null;
    private static String DIST = "windows";
    private static String ZOS1 = "os390";
    private static String ZOS2 = "os400";
    private static String DefaultSSLSettings = "DefaultSSLSettings";
    private static String DefaultCellSSL = "CellDefaultSSLSettings";
    private static String DefaultNodeSSL = "NodeDefaultSSLSettings";
    private static String DefaultKeyStore = "DefaultKeyStore";
    private static String DefaultTrustStore = "DefaultTrustStore";
    private static String DefaultNodeLTPA = "NodeLTPA";
    private static String DefaultCellScope = "cell";
    private static String DefaultNodeScope = "node";
    private static String DefaultConfigCellsPath = "/config/cells/";
    private static String DefaultCellsPath = "/cells/";
    private static String DefaultNodesPath = "/nodes/";
    private static String DefaultEtcPath = "/etc";
    private static String DefaultP12KeyStore = "key.p12";
    private static String DefaultP12TrustStore = "trust.p12";
    private static String DefaultHostnameVariable = "${hostname}";

    public static Security merge(String string, String string2, Security security2, Security security3, String string3, String string4) throws Exception {
        return MergeSecurityConfig.merge(string, string2, security2, security3, string3, string4, DIST, DIST);
    }

    public static Security merge(String string, String string2, Security security2, Security security3, String string3, String string4, String string5, String string6) throws Exception {
        return MergeSecurityConfig.merge(string, string2, security2, security3, string3, string4, DIST, DIST, false, null);
    }

    public static Security merge(String string, String string2, Security security2, Security security3, String string3, String string4, String string5, String string6, boolean bl, String string7) throws Exception {
        CharSequence charSequence;
        CharSequence charSequence2;
        String string8;
        int n;
        CharSequence charSequence3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        EList eList;
        int n2;
        Object object7;
        JAASConfigurationEntry jAASConfigurationEntry;
        Object object8;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge", new Object[]{string, string2, string3, string4, string5, string6, Boolean.toString(bl), string7});
        }
        if (security2 == null) {
            throw new Exception("Null cell level security object provided");
        }
        if (security3 == null) {
            throw new Exception("Null server level security object provided");
        }
        if (string3 == null) {
            throw new Exception("Null nodeName provided");
        }
        if (security2.isEnabled() && bl) {
            boolean bl2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding a older version node. Check for validSecurityConfig. ");
            }
            if (bl2 = MergeSecurityConfig.checkIfInternalServerIdUsed(security2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InternalServerId is set in the dmgr config. Cannot add an older version node unless the serverID/passwd option is used. ");
                }
                throw new Exception("InternalServerId is used in the current dmgr config. Cannot add an older node. Modify the dmgr security config to use the serverID/passwd before adding an older version node");
            }
            if (!string5.equals(ZOS1) || !(security2.getActiveUserRegistry() instanceof LocalOSUserRegistry)) {
                boolean bl3 = MergeSecurityConfig.checkIfNullServerPasswordUsed(security2);
                if (bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The server password is null or missing in the dmgr config. Cannot add an older version node unless the server password is entered. ");
                    }
                    throw new Exception("The server password is null or missing in the current dmgr config. Cannot add an older node. Modify the dmgr security config to use the server password before adding an older version node");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The dmgr security config check passed.");
                }
            }
        }
        string3 = "_" + string3 + "_";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node name is " + string3);
        }
        if (security3.getApplicationLoginConfig() != null && security3.getApplicationLoginConfig().getEntries().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting JAAS configuration.");
            }
            EList eList2 = security2.getApplicationLoginConfig().getEntries();
            ArrayList<String> arrayList = null;
            if (eList2 != null && eList2.size() > 0) {
                arrayList = new ArrayList<String>(eList2.size());
                object8 = eList2.iterator();
                while (object8.hasNext()) {
                    jAASConfigurationEntry = (JAASConfigurationEntry)object8.next();
                    arrayList.add(jAASConfigurationEntry.getAlias());
                }
            }
            object8 = security3.getApplicationLoginConfig().getEntries();
            jAASConfigurationEntry = object8.iterator();
            object7 = new ArrayList(object8.size());
            while (jAASConfigurationEntry.hasNext()) {
                JAASConfigurationEntry jAASConfigurationEntry2 = (JAASConfigurationEntry)jAASConfigurationEntry.next();
                if (arrayList == null || !arrayList.contains(jAASConfigurationEntry2.getAlias())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding JAAS alias: " + jAASConfigurationEntry2.getAlias() + " to cell.");
                    }
                    object7.add(jAASConfigurationEntry2);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding JAAS alias: " + jAASConfigurationEntry2.getAlias() + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{jAASConfigurationEntry2.getAlias()});
            }
            for (n2 = 0; n2 < object7.size(); ++n2) {
                eList = (JAASConfigurationEntry)object7.get(n2);
                object6 = eList.eResource();
                object5 = null;
                if (object6 instanceof XMIResource) {
                    object5 = ((XMIResource)object6).getID((EObject)eList);
                }
                StringBuffer stringBuffer = null;
                if (object5 != null) {
                    int n3 = ((String)object5).indexOf(95);
                    StringBuffer stringBuffer2 = new StringBuffer((String)object5);
                    if (n3 != -1) {
                        stringBuffer = stringBuffer2.replace(n3, n3 + 1, string3);
                        ((XMIResource)object6).setID((EObject)eList, stringBuffer.toString());
                    } else {
                        stringBuffer = stringBuffer2.append(string3);
                        ((XMIResource)object6).setID((EObject)eList, stringBuffer.toString());
                    }
                }
                object4 = eList.getLoginModules();
                for (int i = 0; i < object4.size(); ++i) {
                    object3 = (JAASLoginModule)object4.get(i);
                    object2 = object3.getOptions();
                    object6 = object3.eResource();
                    if (object6 instanceof XMIResource) {
                        object5 = ((XMIResource)object6).getID((EObject)object3);
                    }
                    if (object5 != null) {
                        int n4 = ((String)object5).indexOf(95);
                        object = new StringBuffer((String)object5);
                        stringBuffer = null;
                        if (n4 != -1) {
                            stringBuffer = ((StringBuffer)object).replace(n4, n4 + 1, string3);
                            ((XMIResource)object6).setID((EObject)object3, stringBuffer.toString());
                        } else {
                            stringBuffer = ((StringBuffer)object).append(string3);
                            ((XMIResource)object6).setID((EObject)object3, stringBuffer.toString());
                        }
                    }
                    if (object2 == null) continue;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = (Property)iterator.next();
                        object6 = object.eResource();
                        object5 = null;
                        if (object6 instanceof XMIResource) {
                            object5 = ((XMIResource)object6).getID((EObject)object);
                        }
                        if (object5 == null) continue;
                        charSequence3 = new StringBuffer((String)object5);
                        int n5 = ((String)object5).indexOf(95);
                        if (n5 != -1) {
                            stringBuffer = ((StringBuffer)charSequence3).replace(n5, n5 + 1, string3);
                            ((XMIResource)object6).setID((EObject)object, stringBuffer.toString());
                            continue;
                        }
                        stringBuffer = ((StringBuffer)charSequence3).append(string3);
                        ((XMIResource)object6).setID((EObject)object, stringBuffer.toString());
                    }
                }
                security2.getApplicationLoginConfig().getEntries().add(object7.get(n2));
            }
        }
        if (security3.getAuthDataEntries() != null && security3.getAuthDataEntries().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting J2C configuration.");
            }
            EList eList3 = security2.getAuthDataEntries();
            ArrayList<String> arrayList = null;
            if (eList3 != null && eList3.size() > 0) {
                arrayList = new ArrayList<String>(eList3.size());
                object8 = eList3.iterator();
                while (object8.hasNext()) {
                    jAASConfigurationEntry = (JAASAuthData)object8.next();
                    arrayList.add(jAASConfigurationEntry.getAlias());
                }
            }
            object8 = security3.getAuthDataEntries();
            jAASConfigurationEntry = new ArrayList(object8.size());
            object7 = object8.iterator();
            while (object7.hasNext()) {
                JAASAuthData jAASAuthData = (JAASAuthData)object7.next();
                if (arrayList == null || !arrayList.contains(jAASAuthData.getAlias())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding J2C alias: " + jAASAuthData.getAlias() + " to cell.");
                    }
                    jAASConfigurationEntry.add(jAASAuthData);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding J2C alias: " + jAASAuthData.getAlias() + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{jAASAuthData.getAlias()});
            }
            for (n2 = 0; n2 < jAASConfigurationEntry.size(); ++n2) {
                eList = (JAASAuthData)jAASConfigurationEntry.get(n2);
                object6 = eList.eResource();
                object5 = null;
                if (object6 instanceof XMIResource) {
                    object5 = ((XMIResource)object6).getID((EObject)eList);
                }
                if (object5 != null) {
                    int n6 = ((String)object5).indexOf(95);
                    object4 = new StringBuffer((String)object5);
                    StringBuffer stringBuffer = null;
                    if (n6 != -1) {
                        stringBuffer = ((StringBuffer)object4).replace(n6, n6 + 1, string3);
                        ((XMIResource)object6).setID((EObject)eList, stringBuffer.toString());
                    } else {
                        stringBuffer = ((StringBuffer)object4).append(string3);
                        ((XMIResource)object6).setID((EObject)eList, stringBuffer.toString());
                    }
                }
                security2.getAuthDataEntries().add(jAASConfigurationEntry.get(n2));
            }
        }
        if (security3.getManagementScopes() != null && security3.getManagementScopes().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting getManagementScopes configuration.");
            }
            EList eList4 = security2.getManagementScopes();
            ArrayList<String> arrayList = null;
            if (eList4 != null && eList4.size() > 0) {
                arrayList = new ArrayList<String>(eList4.size());
                object8 = eList4.iterator();
                while (object8.hasNext()) {
                    jAASConfigurationEntry = (ManagementScope)object8.next();
                    if (jAASConfigurationEntry == null) continue;
                    object7 = jAASConfigurationEntry.eResource();
                    String string9 = null;
                    if (object7 instanceof XMIResource) {
                        string9 = ((XMIResource)object7).getID((EObject)jAASConfigurationEntry);
                    }
                    if (string9 == null) continue;
                    arrayList.add(jAASConfigurationEntry.getScopeName());
                }
            }
            object8 = security3.getManagementScopes();
            jAASConfigurationEntry = object8.iterator();
            object7 = new ArrayList(object8.size());
            while (jAASConfigurationEntry.hasNext()) {
                ManagementScope managementScope = (ManagementScope)jAASConfigurationEntry.next();
                eList = managementScope.eResource();
                object6 = null;
                if (eList instanceof XMIResource) {
                    object6 = ((XMIResource)eList).getID((EObject)managementScope);
                }
                if (cellScope == null) {
                    cellScope = (ManagementScope)eList4.get(0);
                }
                managementScope = MergeSecurityConfig.fixUpCell(managementScope, cellScope);
                if (arrayList == null || object6 != null && !arrayList.contains(managementScope.getScopeName())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding ManagementScope alias: " + managementScope.getScopeName() + " to cell.");
                    }
                    object7.add(managementScope);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding ManagementScope alias: " + managementScope.getScopeName() + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{managementScope.getScopeName()});
            }
            for (n2 = 0; n2 < object7.size(); ++n2) {
                eList = (ManagementScope)object7.get(n2);
                if (eList == null) continue;
                security2.getManagementScopes().add((Object)eList);
            }
        }
        String string10 = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
        Object object9 = null;
        object8 = security2.getKeyStores();
        for (n = 0; n < object8.size(); ++n) {
            object7 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object8.get(n);
            String string11 = null;
            if (object7.getManagementScope() != null) {
                string11 = object7.getManagementScope().getScopeType();
            }
            if (string11 == null || !string11.equals(DefaultCellScope) || !object7.getName().endsWith(DefaultTrustStore)) continue;
            object9 = object7;
        }
        n = 0;
        object7 = null;
        Object object10 = null;
        if (security3.getRepertoire() != null && security3.getRepertoire().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSL configuration.");
            }
            eList = security2.getRepertoire();
            object6 = null;
            if (eList != null && eList.size() > 0) {
                object6 = new ArrayList(eList.size());
                object5 = eList.iterator();
                while (object5.hasNext()) {
                    Resource resource;
                    SSLConfig sSLConfig = (SSLConfig)object5.next();
                    object4 = sSLConfig.getAlias();
                    if (object4 != null && ((String)object4).equals(DefaultCellSSL)) {
                        resource = sSLConfig.getSetting().getKeyStore();
                        object3 = sSLConfig.getSetting().getTrustStore();
                        if (resource != null && object3 != null) {
                            if (resource.getLocation() != null && resource.isFileBased() && !resource.isReadOnly() && resource.getType() != null && !resource.getType().equals("JCERACFKS") && !resource.getType().equals("PKCS12")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting migration keystore to: " + resource.getName());
                                }
                                object7 = resource;
                                n = 1;
                            }
                            if (object3.getLocation() != null && object3.isFileBased() && !resource.isReadOnly() && object3.getType() != null && !object3.getType().equals("JCERACFKS") && !object3.getType().equals("PKCS12")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting migration truststore to: " + object3.getName());
                                }
                                object10 = object3;
                                n = 1;
                            }
                        }
                    }
                    resource = sSLConfig.eResource();
                    object3 = null;
                    if (resource instanceof XMIResource) {
                        object3 = ((XMIResource)resource).getID((EObject)sSLConfig);
                    }
                    if (object3 == null) continue;
                    object2 = sSLConfig.getManagementScope() != null ? sSLConfig.getManagementScope().getScopeName() : object3;
                    object6.add(MergeSecurityConfig.getCellAliasKey(sSLConfig.getAlias(), (String)object2));
                }
            }
            object5 = security3.getRepertoire();
            Iterator iterator = object5.iterator();
            object4 = new ArrayList(object5.size());
            while (iterator.hasNext()) {
                Object object11;
                SSLConfig sSLConfig = (SSLConfig)iterator.next();
                object3 = sSLConfig.getAlias();
                if (n != 0 && object3 != null && ((String)object3).equals(DefaultNodeSSL)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting alias " + (String)object3 + " keystores to the cell keystores due to migration.");
                    }
                    sSLConfig.getSetting().setKeyStore((com.ibm.websphere.models.config.ipc.ssl.KeyStore)object7);
                    sSLConfig.getSetting().setTrustStore(object10);
                }
                if (sSLConfig.getType() == null || sSLConfig.getType().getName().equals("JSSE")) {
                    object2 = sSLConfig.getSetting().getKeyStore();
                    object11 = sSLConfig.getSetting().getTrustStore();
                    if (object2 != null && object11 != null) {
                        try {
                            object = MergeSecurityConfig.checkIfKeyStoreExistsAndCreateIfNot((com.ibm.websphere.models.config.ipc.ssl.KeyStore)object2, string10, string2, string4);
                            if (object != null) {
                                MergeSecurityConfig.checkIfTrustStoreExistsAndCreateIfNot(object11, string10, string2, (Certificate)object);
                            }
                        }
                        catch (SSLException sSLException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception creating keystore or truststore.", new Object[]{sSLException});
                            }
                            Tr.error(tc, "security.merge.node.keystore.creation.failed", new Object[]{string3, sSLException.getMessage()});
                            throw sSLException;
                        }
                    }
                }
                if (object9 != null && object9.isFileBased() && !object9.isReadOnly()) {
                    sSLConfig = MergeSecurityConfig.replaceDefaultNodeTrustStoreWithCellTrustStore(sSLConfig, (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object9);
                }
                sSLConfig = MergeSecurityConfig.replaceDummyKeyStoreWithCellKeyStoreIfNecessary(sSLConfig, (List)security2.getKeyStores());
                object2 = sSLConfig.eResource();
                object11 = null;
                if (object2 instanceof XMIResource) {
                    object11 = ((XMIResource)object2).getID((EObject)sSLConfig);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server refID: " + (String)object11);
                }
                object = object11;
                if (sSLConfig.getManagementScope() != null) {
                    charSequence3 = MergeSecurityConfig.fixUpCell(sSLConfig.getManagementScope(), cellScope);
                    object = charSequence3.getScopeName();
                }
                if (object6 == null || !object6.contains(MergeSecurityConfig.getCellAliasKey(sSLConfig.getAlias(), (String)object))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding SSL alias: " + MergeSecurityConfig.getCellAliasKey(sSLConfig.getAlias(), (String)object) + " to cell.");
                    }
                    object4.add(sSLConfig);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding SSL alias: " + MergeSecurityConfig.getCellAliasKey(sSLConfig.getAlias(), (String)object) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{sSLConfig.getAlias()});
            }
            for (int i = 0; i < object4.size(); ++i) {
                int n7;
                object3 = (SSLConfig)object4.get(i);
                object2 = object3.getSetting();
                CryptoHardwareToken cryptoHardwareToken = object2.getCryptoHardware();
                object = object2.getProperties();
                charSequence3 = null;
                Resource resource = object3.eResource();
                string8 = null;
                if (resource instanceof XMIResource) {
                    string8 = ((XMIResource)resource).getID((EObject)object3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Fixing refID: " + string8);
                }
                if (string8 != null) {
                    n7 = string8.indexOf(95);
                    charSequence2 = new StringBuffer(string8);
                    if (n7 != -1) {
                        charSequence3 = charSequence2.replace(n7, n7 + 1, string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fixed up refID: " + ((StringBuffer)charSequence3).toString());
                        }
                        ((XMIResource)resource).setID((EObject)object3, ((StringBuffer)charSequence3).toString());
                    } else {
                        charSequence3 = charSequence2.append(string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fixed up refID: " + ((StringBuffer)charSequence3).toString());
                        }
                        ((XMIResource)resource).setID((EObject)object3, ((StringBuffer)charSequence3).toString());
                    }
                }
                if (object2 != null) {
                    resource = object2.eResource();
                    string8 = null;
                    if (resource instanceof XMIResource) {
                        string8 = ((XMIResource)resource).getID((EObject)object2);
                    }
                    if (string8 != null) {
                        n7 = string8.indexOf(95);
                        charSequence2 = new StringBuffer(string8);
                        if (n7 != -1) {
                            charSequence3 = charSequence2.replace(n7, n7 + 1, string3);
                            ((XMIResource)resource).setID((EObject)object2, ((StringBuffer)charSequence3).toString());
                        } else {
                            charSequence3 = charSequence2.append(string3);
                            ((XMIResource)resource).setID((EObject)object2, ((StringBuffer)charSequence3).toString());
                        }
                    }
                }
                if (cryptoHardwareToken != null) {
                    resource = cryptoHardwareToken.eResource();
                    string8 = null;
                    if (resource instanceof XMIResource) {
                        string8 = ((XMIResource)resource).getID((EObject)cryptoHardwareToken);
                    }
                    if (string8 != null) {
                        n7 = string8.indexOf(95);
                        charSequence2 = new StringBuffer(string8);
                        if (n7 != -1) {
                            charSequence3 = charSequence2.replace(n7, n7 + 1, string3);
                            ((XMIResource)resource).setID((EObject)cryptoHardwareToken, ((StringBuffer)charSequence3).toString());
                        } else {
                            charSequence3 = charSequence2.append(string3);
                            ((XMIResource)resource).setID((EObject)cryptoHardwareToken, ((StringBuffer)charSequence3).toString());
                        }
                    }
                }
                if (object != null) {
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        charSequence2 = (Property)iterator2.next();
                        resource = charSequence2.eResource();
                        string8 = null;
                        if (resource instanceof XMIResource) {
                            string8 = ((XMIResource)resource).getID((EObject)charSequence2);
                        }
                        if (string8 == null) continue;
                        charSequence = new StringBuffer(string8);
                        int n8 = string8.indexOf(95);
                        if (n8 != -1) {
                            charSequence3 = charSequence.replace(n8, n8 + 1, string3);
                            ((XMIResource)resource).setID((EObject)charSequence2, ((StringBuffer)charSequence3).toString());
                            continue;
                        }
                        charSequence3 = charSequence.append(string3);
                        ((XMIResource)resource).setID((EObject)charSequence2, ((StringBuffer)charSequence3).toString());
                    }
                }
                security2.getRepertoire().add(object4.get(i));
            }
        }
        boolean bl4 = false;
        boolean bl5 = false;
        if (security3.getKeyStores() != null && security3.getKeyStores().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeyStore configuration.");
            }
            object5 = new ArrayList();
            EList eList5 = security2.getKeyStores();
            object4 = null;
            if (eList5 != null && eList5.size() > 0) {
                object4 = new ArrayList(eList5.size());
                Iterator iterator = eList5.iterator();
                while (iterator.hasNext()) {
                    object3 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)iterator.next();
                    if (object3 == null) continue;
                    object2 = object3.eResource();
                    String string12 = null;
                    if (object2 instanceof XMIResource) {
                        string12 = ((XMIResource)object2).getID((EObject)object3);
                    }
                    if (string12 == null) continue;
                    object = object3.getManagementScope() != null ? object3.getManagementScope().getScopeName() : string12;
                    object4.add(MergeSecurityConfig.getCellAliasKey(object3.getName(), (String)object));
                }
            }
            EList eList6 = security3.getKeyStores();
            object3 = eList6.iterator();
            object2 = new ArrayList(eList6.size());
            while (object3.hasNext()) {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object3.next();
                if (keyStore.getLocation().indexOf(DefaultConfigCellsPath) != -1 || keyStore.getLocation().indexOf(DefaultCellsPath) != -1) {
                    keyStore.setLocation(MergeSecurityConfig.fixUpKeyStoreCell(keyStore.getLocation()));
                }
                object = keyStore.eResource();
                charSequence3 = null;
                if (object instanceof XMIResource) {
                    charSequence3 = ((XMIResource)object).getID((EObject)keyStore);
                }
                String string13 = charSequence3;
                if (keyStore.getManagementScope() != null) {
                    string8 = MergeSecurityConfig.fixUpCell(keyStore.getManagementScope(), cellScope);
                    string13 = string8.getScopeName();
                }
                if (object4 == null || charSequence3 != null && !object4.contains(MergeSecurityConfig.getCellAliasKey(keyStore.getName(), string13))) {
                    if (keyStore.getName().startsWith(DefaultNodeLTPA)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeyStore alias: " + MergeSecurityConfig.getCellAliasKey(keyStore.getName(), string13) + " to cell.");
                    }
                    object2.add(keyStore);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeyStore alias: " + MergeSecurityConfig.getCellAliasKey(keyStore.getName(), string13) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{keyStore.getName()});
            }
            for (int i = 0; i < object2.size(); ++i) {
                object = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object2.get(i);
                if (object == null) continue;
                security2.getKeyStores().add(object);
            }
            EList eList7 = security2.getKeyStores();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total number of keystores = " + eList7.size());
            }
            for (int i = 0; i < eList7.size(); ++i) {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore;
                int n9;
                charSequence3 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList7.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking at keystore " + charSequence3.getName() + " (" + charSequence3.getManagementScope() != null ? charSequence3.getManagementScope().getScopeName() : "no scope found).");
                }
                String string14 = null;
                if (charSequence3.getManagementScope() != null) {
                    string14 = charSequence3.getManagementScope().getScopeType();
                }
                if (string14 != null && string14.equals(DefaultCellScope) && charSequence3.getName().endsWith(DefaultKeyStore) && charSequence3.isFileBased()) {
                    for (n9 = 0; n9 < eList7.size(); ++n9) {
                        keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList7.get(n9);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking at keystore " + keyStore.getName() + " (" + keyStore.getManagementScope() != null ? keyStore.getManagementScope().getScopeName() : "no scope found).");
                        }
                        charSequence2 = null;
                        if (keyStore.getManagementScope() != null) {
                            charSequence2 = keyStore.getManagementScope().getScopeType();
                        }
                        if (charSequence2 == null || ((String)charSequence2).equals(DefaultCellScope) || !keyStore.getName().endsWith(DefaultTrustStore) || !keyStore.isFileBased()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exchanging signers from keystore " + charSequence3.getName() + " in scope " + charSequence3.getManagementScope() != null ? charSequence3.getManagementScope().getScopeName() : ("no scope found with truststore " + keyStore.getName() + " in scope " + keyStore.getManagementScope() != null ? keyStore.getManagementScope().getScopeName() : "no scope found"));
                        }
                        charSequence = MergeSecurityConfig.whichLocationKeyStoreExists(keyStore.getLocation(), string10, string2);
                        KeyStoreManager.getInstance().exchangeSigners(string10, (com.ibm.websphere.models.config.ipc.ssl.KeyStore)charSequence3, (String)charSequence, keyStore);
                        bl4 = true;
                    }
                }
                if (string14 != null && !string14.equals(DefaultCellScope) && charSequence3.getName().endsWith(DefaultKeyStore) && charSequence3.isFileBased()) {
                    for (n9 = 0; n9 < eList7.size(); ++n9) {
                        keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList7.get(n9);
                        charSequence2 = null;
                        if (keyStore.getManagementScope() != null) {
                            charSequence2 = keyStore.getManagementScope().getScopeType();
                        }
                        if (charSequence2 == null || !((String)charSequence2).equals(DefaultCellScope) || !keyStore.getName().endsWith(DefaultTrustStore) || !keyStore.isFileBased()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exchanging signers from keystore " + charSequence3.getName() + " in scope " + charSequence3.getManagementScope() != null ? charSequence3.getManagementScope().getScopeName() : ("no scope found with truststore " + keyStore.getName() + " in scope " + keyStore.getManagementScope() != null ? keyStore.getManagementScope().getScopeName() : "no scope found"));
                        }
                        charSequence = MergeSecurityConfig.whichLocationKeyStoreExists(charSequence3.getLocation(), string10, string2);
                        KeyStoreManager.getInstance().exchangeSigners((String)charSequence, (com.ibm.websphere.models.config.ipc.ssl.KeyStore)charSequence3, string10, keyStore);
                        bl5 = true;
                    }
                }
                if (!charSequence3.getName().equals("CMSKeyStore") || !charSequence3.isFileBased() || charSequence3.getManagementScope() == null) continue;
                for (n9 = 0; n9 < eList7.size(); ++n9) {
                    keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList7.get(n9);
                    if (!keyStore.getName().endsWith(DefaultKeyStore) || !keyStore.isFileBased() || keyStore.getManagementScope() == null || charSequence3.getManagementScope().getScopeName().equals(keyStore.getManagementScope().getScopeName())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exchanging signers from keystore " + keyStore.getName() + " with keystore " + charSequence3.getName());
                    }
                    charSequence2 = MergeSecurityConfig.whichLocationKeyStoreExists(charSequence3.getLocation(), string10, string2);
                    charSequence = MergeSecurityConfig.whichLocationKeyStoreExists(keyStore.getLocation(), string10, string2);
                    KeyStoreManager.getInstance().exchangeSigners((String)charSequence, keyStore, (String)charSequence2, (com.ibm.websphere.models.config.ipc.ssl.KeyStore)charSequence3);
                }
            }
        }
        if (!bl4) {
            Tr.info(tc, "security.merge.cell.signer.not.exchanged", new Object[]{string3});
        }
        if (!bl5) {
            Tr.info(tc, "security.merge.node.signer.not.exchanged", new Object[]{string3});
        }
        if (security3.getKeySets() != null && security3.getKeySets().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeySet configuration.");
            }
            object5 = security2.getKeySets();
            ArrayList<String> arrayList = null;
            if (object5 != null && object5.size() > 0) {
                arrayList = new ArrayList<String>(object5.size());
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    KeySet keySet = (KeySet)object4.next();
                    if (keySet == null) continue;
                    object3 = keySet.eResource();
                    object2 = null;
                    if (object3 instanceof XMIResource) {
                        object2 = ((XMIResource)object3).getID((EObject)keySet);
                    }
                    if (object2 == null) continue;
                    Object object12 = keySet.getManagementScope() != null ? keySet.getManagementScope().getScopeName() : object2;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(keySet.getName(), (String)object12));
                }
            }
            object4 = security3.getKeySets();
            Iterator iterator = object4.iterator();
            object3 = new ArrayList(object4.size());
            while (iterator.hasNext()) {
                object2 = (KeySet)iterator.next();
                Resource resource = object2.eResource();
                String string15 = null;
                if (resource instanceof XMIResource) {
                    string15 = ((XMIResource)resource).getID((EObject)object2);
                }
                charSequence3 = string15;
                if (object2.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(object2.getManagementScope(), cellScope);
                    charSequence3 = managementScope.getScopeName();
                }
                if (arrayList == null || string15 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(object2.getName(), (String)charSequence3))) {
                    if (object2.getName().startsWith(DefaultNodeLTPA)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeySet alias: " + MergeSecurityConfig.getCellAliasKey(object2.getName(), (String)charSequence3) + " to cell.");
                    }
                    object3.add(object2);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeySet alias: " + MergeSecurityConfig.getCellAliasKey(object2.getName(), (String)charSequence3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{object2.getName()});
            }
            for (int i = 0; i < object3.size(); ++i) {
                KeySet keySet = (KeySet)object3.get(i);
                if (keySet == null) continue;
                security2.getKeySets().add((Object)keySet);
            }
        }
        if (security3.getKeySetGroups() != null && security3.getKeySetGroups().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeySetGroup configuration.");
            }
            object5 = security2.getKeySetGroups();
            ArrayList<String> arrayList = null;
            if (object5 != null && object5.size() > 0) {
                arrayList = new ArrayList<String>(object5.size());
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    String string16;
                    KeySetGroup keySetGroup = (KeySetGroup)object4.next();
                    if (keySetGroup == null) continue;
                    object3 = keySetGroup.eResource();
                    String string17 = null;
                    if (object3 instanceof XMIResource) {
                        string17 = ((XMIResource)object3).getID((EObject)keySetGroup);
                    }
                    String string18 = string16 = keySetGroup.getManagementScope() != null ? keySetGroup.getManagementScope().getScopeName() : string17;
                    if (string17 == null) continue;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(keySetGroup.getName(), string16));
                }
            }
            object4 = security3.getKeySetGroups();
            Iterator iterator = object4.iterator();
            object3 = new ArrayList(object4.size());
            while (iterator.hasNext()) {
                KeySetGroup keySetGroup = (KeySetGroup)iterator.next();
                Resource resource = keySetGroup.eResource();
                String string19 = null;
                if (resource instanceof XMIResource) {
                    string19 = ((XMIResource)resource).getID((EObject)keySetGroup);
                }
                charSequence3 = string19;
                if (keySetGroup.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(keySetGroup.getManagementScope(), cellScope);
                    charSequence3 = managementScope.getScopeName();
                }
                if (arrayList == null || string19 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(keySetGroup.getName(), (String)charSequence3))) {
                    if (keySetGroup.getName().startsWith(DefaultNodeLTPA)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeySetGroup alias: " + MergeSecurityConfig.getCellAliasKey(keySetGroup.getName(), (String)charSequence3) + " to cell.");
                    }
                    object3.add(keySetGroup);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeySetGroup alias: " + MergeSecurityConfig.getCellAliasKey(keySetGroup.getName(), (String)charSequence3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{keySetGroup.getName()});
            }
            for (int i = 0; i < object3.size(); ++i) {
                KeySetGroup keySetGroup = (KeySetGroup)object3.get(i);
                if (keySetGroup == null) continue;
                security2.getKeySetGroups().add((Object)keySetGroup);
            }
        }
        if (security3.getDynamicSSLConfigSelections() != null && security3.getDynamicSSLConfigSelections().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting DynamicSSLConfigSelection configuration.");
            }
            object5 = security2.getDynamicSSLConfigSelections();
            ArrayList<String> arrayList = null;
            if (object5 != null && object5.size() > 0) {
                arrayList = new ArrayList<String>(object5.size());
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    DynamicSSLConfigSelection dynamicSSLConfigSelection = (DynamicSSLConfigSelection)object4.next();
                    if (dynamicSSLConfigSelection == null) continue;
                    object3 = dynamicSSLConfigSelection.eResource();
                    String string20 = null;
                    if (object3 instanceof XMIResource) {
                        string20 = ((XMIResource)object3).getID((EObject)dynamicSSLConfigSelection);
                    }
                    if (string20 == null) continue;
                    String string21 = dynamicSSLConfigSelection.getManagementScope() != null ? dynamicSSLConfigSelection.getManagementScope().getScopeName() : string20;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(dynamicSSLConfigSelection.getName(), string21));
                }
            }
            object4 = security3.getDynamicSSLConfigSelections();
            Iterator iterator = object4.iterator();
            object3 = new ArrayList(object4.size());
            while (iterator.hasNext()) {
                DynamicSSLConfigSelection dynamicSSLConfigSelection = (DynamicSSLConfigSelection)iterator.next();
                Resource resource = dynamicSSLConfigSelection.eResource();
                String string22 = null;
                if (resource instanceof XMIResource) {
                    string22 = ((XMIResource)resource).getID((EObject)dynamicSSLConfigSelection);
                }
                charSequence3 = string22;
                if (dynamicSSLConfigSelection.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(dynamicSSLConfigSelection.getManagementScope(), cellScope);
                    charSequence3 = managementScope.getScopeName();
                }
                if (arrayList == null || string22 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(dynamicSSLConfigSelection.getName(), (String)charSequence3))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding DynamicSSLConfigSelection alias: " + MergeSecurityConfig.getCellAliasKey(dynamicSSLConfigSelection.getName(), (String)charSequence3) + " to cell.");
                    }
                    object3.add(dynamicSSLConfigSelection);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding DynamicSSLConfigSelection alias: " + MergeSecurityConfig.getCellAliasKey(dynamicSSLConfigSelection.getName(), (String)charSequence3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{dynamicSSLConfigSelection.getName()});
            }
            for (int i = 0; i < object3.size(); ++i) {
                DynamicSSLConfigSelection dynamicSSLConfigSelection = (DynamicSSLConfigSelection)object3.get(i);
                if (dynamicSSLConfigSelection == null) continue;
                security2.getDynamicSSLConfigSelections().add((Object)dynamicSSLConfigSelection);
            }
        }
        if (security3.getKeyManagers() != null && security3.getKeyManagers().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeyManager configuration.");
            }
            object5 = security2.getKeyManagers();
            ArrayList<String> arrayList = null;
            if (object5 != null && object5.size() > 0) {
                arrayList = new ArrayList<String>(object5.size());
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    KeyManager keyManager = (KeyManager)object4.next();
                    if (keyManager == null) continue;
                    object3 = keyManager.eResource();
                    String string23 = null;
                    if (object3 instanceof XMIResource) {
                        string23 = ((XMIResource)object3).getID((EObject)keyManager);
                    }
                    if (string23 == null) continue;
                    String string24 = keyManager.getManagementScope() != null ? keyManager.getManagementScope().getScopeName() : string23;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(keyManager.getName(), string24));
                }
            }
            object4 = security3.getKeyManagers();
            Iterator iterator = object4.iterator();
            object3 = new ArrayList(object4.size());
            while (iterator.hasNext()) {
                KeyManager keyManager = (KeyManager)iterator.next();
                Resource resource = keyManager.eResource();
                String string25 = null;
                if (resource instanceof XMIResource) {
                    string25 = ((XMIResource)resource).getID((EObject)keyManager);
                }
                charSequence3 = string25;
                if (keyManager.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(keyManager.getManagementScope(), cellScope);
                    charSequence3 = managementScope.getScopeName();
                }
                if (arrayList == null || string25 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(keyManager.getName(), (String)charSequence3))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeyManager alias: " + MergeSecurityConfig.getCellAliasKey(keyManager.getName(), (String)charSequence3) + " to cell.");
                    }
                    object3.add(keyManager);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeyManager alias: " + MergeSecurityConfig.getCellAliasKey(keyManager.getName(), (String)charSequence3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{keyManager.getName()});
            }
            for (int i = 0; i < object3.size(); ++i) {
                KeyManager keyManager = (KeyManager)object3.get(i);
                if (keyManager == null) continue;
                security2.getKeyManagers().add((Object)keyManager);
            }
        }
        if (security3.getTrustManagers() != null && security3.getTrustManagers().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting TrustManager configuration.");
            }
            object5 = security2.getTrustManagers();
            ArrayList<String> arrayList = null;
            if (object5 != null && object5.size() > 0) {
                arrayList = new ArrayList<String>(object5.size());
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    TrustManager trustManager = (TrustManager)object4.next();
                    if (trustManager == null) continue;
                    object3 = trustManager.eResource();
                    String string26 = null;
                    if (object3 instanceof XMIResource) {
                        string26 = ((XMIResource)object3).getID((EObject)trustManager);
                    }
                    if (string26 == null) continue;
                    String string27 = trustManager.getManagementScope() != null ? trustManager.getManagementScope().getScopeName() : string26;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(trustManager.getName(), string27));
                }
            }
            object4 = security3.getTrustManagers();
            Iterator iterator = object4.iterator();
            object3 = new ArrayList(object4.size());
            while (iterator.hasNext()) {
                TrustManager trustManager = (TrustManager)iterator.next();
                Resource resource = trustManager.eResource();
                String string28 = null;
                if (resource instanceof XMIResource) {
                    string28 = ((XMIResource)resource).getID((EObject)trustManager);
                }
                charSequence3 = string28;
                if (trustManager.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(trustManager.getManagementScope(), cellScope);
                    charSequence3 = managementScope.getScopeName();
                }
                if (arrayList == null || string28 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(trustManager.getName(), (String)charSequence3))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding TrustManager alias: " + MergeSecurityConfig.getCellAliasKey(trustManager.getName(), (String)charSequence3) + " to cell.");
                    }
                    object3.add(trustManager);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding TrustManager alias: " + MergeSecurityConfig.getCellAliasKey(trustManager.getName(), (String)charSequence3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{trustManager.getName()});
            }
            for (int i = 0; i < object3.size(); ++i) {
                TrustManager trustManager = (TrustManager)object3.get(i);
                if (trustManager == null) continue;
                security2.getTrustManagers().add((Object)trustManager);
            }
        }
        if (security3.getSslConfigGroups() != null && security3.getSslConfigGroups().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSLConfigGroups configuration.");
            }
            object5 = security2.getSslConfigGroups();
            ArrayList<String> arrayList = null;
            if (object5 != null && object5.size() > 0) {
                arrayList = new ArrayList<String>(object5.size());
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    SSLConfigGroup sSLConfigGroup = (SSLConfigGroup)object4.next();
                    if (sSLConfigGroup == null) continue;
                    object3 = sSLConfigGroup.eResource();
                    String string29 = null;
                    if (object3 instanceof XMIResource) {
                        string29 = ((XMIResource)object3).getID((EObject)sSLConfigGroup);
                    }
                    if (string29 == null) continue;
                    String string30 = sSLConfigGroup.getManagementScope() != null ? sSLConfigGroup.getManagementScope().getScopeName() : string29;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(sSLConfigGroup.getName() + ":" + sSLConfigGroup.getDirection(), string30));
                }
            }
            object4 = security3.getSslConfigGroups();
            Iterator iterator = object4.iterator();
            object3 = new ArrayList(object4.size());
            while (iterator.hasNext()) {
                SSLConfigGroup sSLConfigGroup = (SSLConfigGroup)iterator.next();
                Resource resource = sSLConfigGroup.eResource();
                String string31 = null;
                if (resource instanceof XMIResource) {
                    string31 = ((XMIResource)resource).getID((EObject)sSLConfigGroup);
                }
                charSequence3 = string31;
                if (sSLConfigGroup.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(sSLConfigGroup.getManagementScope(), cellScope);
                    charSequence3 = managementScope.getScopeName();
                }
                if (arrayList == null || string31 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(sSLConfigGroup.getName() + ":" + sSLConfigGroup.getDirection(), (String)charSequence3))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding SSLConfigGroup alias: " + MergeSecurityConfig.getCellAliasKey(sSLConfigGroup.getName() + ":" + sSLConfigGroup.getDirection(), (String)charSequence3) + " to cell.");
                    }
                    object3.add(sSLConfigGroup);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding SSLConfigGroup alias: " + MergeSecurityConfig.getCellAliasKey(sSLConfigGroup.getName() + ":" + sSLConfigGroup.getDirection(), (String)charSequence3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{sSLConfigGroup.getName()});
            }
            for (int i = 0; i < object3.size(); ++i) {
                SSLConfigGroup sSLConfigGroup = (SSLConfigGroup)object3.get(i);
                if (sSLConfigGroup == null) continue;
                security2.getSslConfigGroups().add((Object)sSLConfigGroup);
            }
        }
        if (string5.equals(ZOS1) || string5.equals(ZOS2) || string6.equals(ZOS1) || string6.equals(ZOS2)) {
            if (!MergeSecurityConfig.iiopPropExists(security2)) {
                object5 = null;
                String string32 = null;
                object4 = null;
                object4 = string5.equals(ZOS1) || string5.equals(ZOS2) ? security2 : security3;
                object5 = MergeSecurityConfig.getIIOPClaimSSLAlias((Security)object4);
                string32 = MergeSecurityConfig.getIIOPPerformSSLAlias((Security)object4);
                if (string5.equals(ZOS1) || string6.equals(ZOS1)) {
                    MergeSecurityConfig.createZOSProperties(security2, (String)object5, string32);
                }
            }
            if (string5.equals(ZOS1)) {
                String string33;
                MergeSecurityConfig.mergeIBMProtocolToCell(security2, security3);
                object5 = MergeSecurityConfig.getIIOPClaimSSLAlias(security2);
                if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, (String)object5)) {
                    String string34 = MergeSecurityConfig.getIIOPClaimSSLAlias(security3);
                    MergeSecurityConfig.setIIOPClaimSSLAlias(security2, string34);
                }
                if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, string33 = MergeSecurityConfig.getIIOPPerformSSLAlias(security2))) {
                    object4 = MergeSecurityConfig.getIIOPPerformSSLAlias(security3);
                    MergeSecurityConfig.setIIOPPerformSSLAlias(security2, (String)object4);
                }
            }
        } else if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fixed up SSL alias for previous node version");
            }
            object5 = null;
            String string35 = null;
            object4 = null;
            object5 = MergeSecurityConfig.getIIOPClaimSSLAlias(security2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI existingClaimSSLAlias = " + (String)object5);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, (String)object5)) {
                string35 = MergeSecurityConfig.getIIOPClaimSSLAlias(security3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI claimSSLAlias = " + string35);
                }
                MergeSecurityConfig.setIIOPClaimSSLAlias(security2, string35);
            }
            String string36 = MergeSecurityConfig.getIIOPPerformSSLAlias(security2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI existingPerformSSLAlias = " + string36);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, string36)) {
                object4 = MergeSecurityConfig.getIIOPPerformSSLAlias(security3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI performSSLAlias = " + (String)object4);
                }
                MergeSecurityConfig.setIIOPPerformSSLAlias(security2, (String)object4);
            }
            MergeSecurityConfig.mergeIBMProtocolToCell(security2, security3, bl);
            object5 = MergeSecurityConfig.getIIOPClaimSSLAlias(security2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IBM existingClaimSSLAlias = " + (String)object5);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, (String)object5)) {
                string35 = MergeSecurityConfig.getIIOPClaimSSLAlias(security3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IBM claimSSLAlias = " + string35);
                }
                MergeSecurityConfig.setIIOPClaimSSLAlias(security2, string35);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, string36 = MergeSecurityConfig.getIIOPPerformSSLAlias(security2))) {
                object4 = MergeSecurityConfig.getIIOPPerformSSLAlias(security3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IBM performSSLAlias = " + (String)object4);
                }
                MergeSecurityConfig.setIIOPPerformSSLAlias(security2, (String)object4);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create Dmgr_node/DefaultSSLSettings if not exist for older version node");
            }
            object5 = string7 + "/" + DefaultSSLSettings;
            MergeSecurityConfig.createDmgrDefaultSSLSettings(security2, (String)object5);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "merging custom properties");
        }
        object5 = security2.getProperties();
        EList eList8 = security3.getProperties();
        for (int i = 0; i < eList8.size(); ++i) {
            Property property = (Property)eList8.get(i);
            boolean bl6 = false;
            for (int j = 0; j < object5.size(); ++j) {
                Property property2 = (Property)object5.get(j);
                if (!property2.getName().equals(property.getName())) continue;
                bl6 = true;
            }
            if (!bl6) {
                MergeSecurityConfig.modifyProp(property, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + property.getName() + "=" + property.getValue() + "to cell");
                }
                object5.add(property);
                continue;
            }
            Tr.info(tc, "security.merge.notadded", new Object[]{property.getName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
        return security2;
    }

    private static boolean isJSSETypeFromCellRepertoire(Security security2, String string) {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isJSSETypeFromCellRepertoire");
        }
        if ((eList = security2.getRepertoire()) != null && eList.size() > 0) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                SSLConfig sSLConfig = (SSLConfig)iterator.next();
                if (!sSLConfig.getAlias().equals(string)) continue;
                SSLType sSLType = sSLConfig.getType();
                if (sSLType.getValue() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isJSSETypeFromCellRepertoire: true");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isJSSETypeFromCellRepertoire: false (type is SSSL)");
                }
                return false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isJSSETypeFromCellRepertoire: false (entry not found)");
        }
        return false;
    }

    private static void mergeIBMProtocolToCell(Security security2, Security security3) {
        MergeSecurityConfig.mergeIBMProtocolToCell(security2, security3, false);
    }

    private static void mergeIBMProtocolToCell(Security security2, Security security3, boolean bl) {
        IIOPSecurityProtocol iIOPSecurityProtocol;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeIBMProtocolToCell");
        }
        if ((iIOPSecurityProtocol = security2.getIBM()) != null && !bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "nothing to do, IBM protocol information already exists");
            }
            return;
        }
        IIOPSecurityProtocol iIOPSecurityProtocol2 = security3.getIBM();
        if (iIOPSecurityProtocol2 != null) {
            security2.setIBM(iIOPSecurityProtocol2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeIBMProtocolToCell");
        }
    }

    private static void modifyProp(Property property, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyProp " + property + " " + string);
        }
        Resource resource = property.eResource();
        String string2 = null;
        StringBuffer stringBuffer = null;
        if (resource instanceof XMIResource) {
            string2 = ((XMIResource)resource).getID((EObject)property);
        }
        if (string2 != null) {
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            int n = string2.indexOf(95);
            if (n != -1) {
                stringBuffer = stringBuffer2.replace(n, n + 1, string);
                ((XMIResource)resource).setID((EObject)property, stringBuffer.toString());
            } else {
                stringBuffer = stringBuffer2.append(string);
                ((XMIResource)resource).setID((EObject)property, stringBuffer.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyProp " + property);
        }
    }

    private static void createZOSProperties(Security security2, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createZOSProperties " + string + " " + string2);
        }
        PropertiesPackage propertiesPackage = PropertiesPackage.eINSTANCE;
        PropertiesFactory propertiesFactory = propertiesPackage.getPropertiesFactory();
        Property property = propertiesFactory.createProperty();
        Property property2 = propertiesFactory.createProperty();
        property.setName("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig");
        property2.setName("was.com.ibm.websphere.security.zos.csiv2.outbound.transport.sslconfig");
        property.setValue(string);
        property2.setValue(string2);
        EList eList = security2.getProperties();
        eList.add(property);
        eList.add(property2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createZOSProperties");
        }
    }

    private static boolean iiopPropExists(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "iiopPropExists " + security2);
        }
        boolean bl = false;
        EList eList = security2.getProperties();
        for (int i = 0; i < eList.size(); ++i) {
            Property property = (Property)eList.get(i);
            if (!property.getName().equals("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig")) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "iiopPropExists " + bl);
        }
        return bl;
    }

    private static String getIIOPClaimSSLAlias(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIIOPClaimSSLAlias " + security2);
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
        EList eList = commonSecureInterop.getLayers();
        Object var4_4 = null;
        TransportLayer transportLayer = eList.iterator();
        while (transportLayer.hasNext() && !((var4_4 = transportLayer.next()) instanceof TransportLayer)) {
        }
        transportLayer = var4_4;
        IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
        String string = iIOPTransport.getSslConfig();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIIOPClaimSSLAlias " + string);
        }
        return string;
    }

    private static void setIIOPClaimSSLAlias(Security security2, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIIOPClaimSSLAlias with alias: " + string + ", into cell security.xml: " + security2);
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
        EList eList = commonSecureInterop.getLayers();
        Object var5_5 = null;
        TransportLayer transportLayer = eList.iterator();
        while (transportLayer.hasNext() && !((var5_5 = transportLayer.next()) instanceof TransportLayer)) {
        }
        transportLayer = var5_5;
        IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
        iIOPTransport.setSslConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIIOPClaimSSLAlias");
        }
    }

    private static String getIIOPPerformSSLAlias(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIIOPPerformSSLAlias " + security2);
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getPerforms();
        EList eList = commonSecureInterop.getLayers();
        Object var4_4 = null;
        TransportLayer transportLayer = eList.iterator();
        while (transportLayer.hasNext() && !((var4_4 = transportLayer.next()) instanceof TransportLayer)) {
        }
        transportLayer = var4_4;
        IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
        String string = iIOPTransport.getSslConfig();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIIOPPerformSSLAlias " + string);
        }
        return string;
    }

    private static ManagementScope fixUpCell(ManagementScope managementScope, ManagementScope managementScope2) {
        String string = managementScope.getScopeName();
        ManagementScopeData managementScopeData = new ManagementScopeData(string);
        string = managementScope2.getScopeName();
        ManagementScopeData managementScopeData2 = new ManagementScopeData(string);
        managementScopeData.setCellName(managementScopeData2.getCellName());
        String string2 = managementScopeData.formFullScope();
        managementScope.setScopeName(string2);
        return managementScope;
    }

    private static String fixUpKeyStoreCell(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Original keyStoreLocation: " + string);
        }
        String string2 = ManagementScopeManager.getInstance().getCellName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name: " + string2);
        }
        int n = string.indexOf(DefaultConfigCellsPath);
        String string3 = string;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (n != -1) {
            string4 = string.substring(0, n + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "First part: " + string4);
            }
            string5 = string.substring(n + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The rest: " + string5);
            }
        } else {
            n = string.lastIndexOf(DefaultCellsPath);
            if (n != -1) {
                string4 = string.substring(0, n + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "First part: " + string4);
                }
                string5 = string.substring(n + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The rest: " + string5);
                }
            }
        }
        if (string4 != null && string5 != null) {
            if (string5.indexOf(DefaultNodesPath) != -1) {
                n = string5.indexOf(DefaultNodesPath);
                string6 = string5.substring(n + DefaultNodesPath.length());
                string3 = string4 + string2 + DefaultNodesPath + string6;
            } else {
                n = string5.indexOf("/");
                string6 = string5.substring(n + "/".length());
                string3 = string4 + string2 + "/" + string6;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Last part: " + string6);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Fixed up location: " + string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New keystore location: " + string3);
        }
        return string3;
    }

    private static void setIIOPPerformSSLAlias(Security security2, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIIOPPerformSSLAlias with alias: " + string + ", into cell security.xml: " + security2);
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getPerforms();
        EList eList = commonSecureInterop.getLayers();
        Object var5_5 = null;
        TransportLayer transportLayer = eList.iterator();
        while (transportLayer.hasNext() && !((var5_5 = transportLayer.next()) instanceof TransportLayer)) {
        }
        transportLayer = var5_5;
        IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
        iIOPTransport.setSslConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIIOPPerformSSLAlias");
        }
    }

    private static SSLConfig replaceDefaultNodeTrustStoreWithCellTrustStore(SSLConfig sSLConfig, com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) {
        com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceDefaultNodeTrustStoreWithCellTrustStore", new Object[]{sSLConfig.getAlias(), keyStore.getName()});
        }
        if (sSLConfig.getType() != null && sSLConfig.getType() == SSLType.SSSL_LITERAL) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary (type=SSSL)");
            }
            return sSLConfig;
        }
        SecureSocketLayer secureSocketLayer = sSLConfig.getSetting();
        if (secureSocketLayer != null && (keyStore2 = secureSocketLayer.getTrustStore()) != null && keyStore2.getName().endsWith(DefaultTrustStore)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Replacing Node TrustStore with Cell TrustStore.");
            }
            secureSocketLayer.setTrustStore(keyStore);
            sSLConfig.setSetting(secureSocketLayer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary");
        }
        return sSLConfig;
    }

    private static SSLConfig replaceDummyKeyStoreWithCellKeyStoreIfNecessary(SSLConfig sSLConfig, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary", new Object[]{sSLConfig.getAlias()});
        }
        if (sSLConfig.getType() != null && sSLConfig.getType() == SSLType.SSSL_LITERAL) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary (type=SSSL)");
            }
            return sSLConfig;
        }
        SecureSocketLayer secureSocketLayer = sSLConfig.getSetting();
        if (secureSocketLayer != null) {
            String string = secureSocketLayer.getKeyFileName();
            if (string != null && string.endsWith("DummyServerKeyFile.jks")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)iterator.next();
                    if (keyStore == null) continue;
                    String string2 = keyStore.getName();
                    String string3 = null;
                    if (keyStore.getManagementScope() != null) {
                        string3 = keyStore.getManagementScope().getScopeType();
                    }
                    if (string3 != null && string3.equals(DefaultCellScope) && string2 != null && string2.endsWith(DefaultKeyStore)) {
                        secureSocketLayer.setKeyFileName(MergeSecurityConfig.fixupNodeConfigRoot(string, keyStore.getLocation()));
                        secureSocketLayer.setKeyFilePassword(keyStore.getPassword());
                        secureSocketLayer.setKeyFileFormat(KeyFileFormatKind.get((String)keyStore.getType()));
                    }
                    if (string3 != null && string3.equals(DefaultCellScope) && string2 != null && string2.endsWith(DefaultTrustStore)) {
                        secureSocketLayer.setTrustFileName(MergeSecurityConfig.fixupNodeConfigRoot(string, keyStore.getLocation()));
                        secureSocketLayer.setTrustFilePassword(keyStore.getPassword());
                        secureSocketLayer.setTrustFileFormat(KeyFileFormatKind.get((String)keyStore.getType()));
                    }
                    sSLConfig.setSetting(secureSocketLayer);
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary (not a dummy keystore)");
                }
                return sSLConfig;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary");
        }
        return sSLConfig;
    }

    private static String fixupNodeConfigRoot(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupNodeConfigRoot", new Object[]{string, string2});
        }
        String string3 = string;
        int n = string2.indexOf(DefaultConfigCellsPath);
        if (n != -1) {
            String string4 = string2.substring(n);
            int n2 = string.indexOf(DefaultEtcPath);
            if (n2 != -1) {
                String string5 = string.substring(0, n2);
                string3 = string5 + string4;
            }
        } else {
            int n3 = string2.lastIndexOf(DefaultCellsPath);
            if (n3 != -1) {
                String string6 = string2.substring(n3);
                int n4 = string.indexOf(DefaultEtcPath);
                if (n4 != -1) {
                    String string7 = string.substring(0, n4);
                    string3 = string7 + "/config" + string6;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupNodeConfigRoot -> " + string3);
        }
        return string3;
    }

    public static Certificate checkIfKeyStoreExistsAndCreateIfNot(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore, String string, String string2, String string3) throws SSLException {
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfKeyStoreExistsAndCreateIfNot");
        }
        boolean bl = keyStore.isFileBased();
        String string5 = keyStore.getLocation();
        String string6 = keyStore.getName();
        String string7 = string4 = keyStore.getManagementScope() != null ? keyStore.getManagementScope().getScopeName() : null;
        if (string6 != null && string6.endsWith(DefaultKeyStore) && string4 != null && !string4.equals(DefaultCellScope) && bl) {
            string5 = MergeSecurityConfig.fixupLocationWithRepositoryRoot(string2, string5);
            File file = new File(string5 = MergeSecurityConfig.fixUpKeyStoreCell(string5));
            if (file.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot -> (exists)");
                }
                return null;
            }
            try {
                string5 = MergeSecurityConfig.checkForLocationInRepositoryRootMakeDirectoryIfNecessary(string, keyStore.getLocation());
                String string8 = string6;
                String string9 = keyStore.getPassword();
                String string10 = keyStore.getType();
                String string11 = keyStore.getProvider();
                String string12 = keyStore.getManagementScope() != null ? keyStore.getManagementScope().getScopeName() : null;
                Boolean bl2 = Boolean.TRUE;
                Boolean bl3 = Boolean.TRUE;
                Boolean bl4 = Boolean.FALSE;
                Boolean bl5 = Boolean.TRUE;
                KeyStoreInfo keyStoreInfo = new KeyStoreInfo(string8, string5, string9, string11, string10, bl3, null, string12, null, bl4, bl5, bl2, null, new Integer(0), Boolean.FALSE, null);
                String string13 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                String string14 = null;
                string14 = string13 != null ? string13 : "default";
                String string15 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqKeySize", "1024");
                String string16 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqSubjectDN", "cn=${hostname},o=IBM,c=US");
                string16 = string16.indexOf(DefaultHostnameVariable) != -1 && string3 != null ? MergeSecurityConfig.expandHostNameVariable(string16, string3) : KeyStoreManager.getInstance().expand(string16);
                String string17 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqDays", "365");
                int n = new Integer(string15);
                int n2 = new Integer(string17);
                CertReqInfo certReqInfo = new CertReqInfo(string14, n, string16, n2, keyStoreInfo, null);
                Certificate certificate = CertificateManager.getInstance().selfSignedCertificateCreate(certReqInfo);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot");
                }
                return certificate;
            }
            catch (Exception exception) {
                if (exception instanceof SSLException) {
                    throw (SSLException)exception;
                }
                throw new SSLException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
        return null;
    }

    private static String expandHostNameVariable(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandHostNameVariable", new Object[]{string, string2});
        }
        String string3 = string;
        int n = string.indexOf(DefaultHostnameVariable);
        if (n != -1) {
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + DefaultHostnameVariable.length());
            if (string4 != null && !string4.equals("") && string5 != null && !string5.equals("")) {
                string3 = string4 + string2 + string5;
            } else if (string4 != null && !string4.equals("")) {
                string3 = string4 + string2;
            } else if (string5 != null && !string5.equals("")) {
                string3 = string2 + string5;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandHostNameVariable -> " + string3);
        }
        return string3;
    }

    public static void checkIfTrustStoreExistsAndCreateIfNot(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore, String string, String string2, Certificate certificate) throws SSLException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfTrustStoreExistsAndCreateIfNot");
        }
        boolean bl = keyStore.isFileBased();
        String string4 = keyStore.getLocation();
        String string5 = keyStore.getName();
        String string6 = string3 = keyStore.getManagementScope() != null ? keyStore.getManagementScope().getScopeName() : null;
        if (string5 != null && string5.endsWith(DefaultTrustStore) && string3 != null && !string3.equals(DefaultCellScope) && bl) {
            string4 = MergeSecurityConfig.fixupLocationWithRepositoryRoot(string2, string4);
            File file = new File(string4 = MergeSecurityConfig.fixUpKeyStoreCell(string4));
            if (file.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot -> (exists)");
                }
                return;
            }
            try {
                string4 = MergeSecurityConfig.checkForLocationInRepositoryRootMakeDirectoryIfNecessary(string, keyStore.getLocation());
                String string7 = string5;
                String string8 = keyStore.getPassword();
                String string9 = keyStore.getType();
                String string10 = keyStore.getProvider();
                String string11 = keyStore.getManagementScope() != null ? keyStore.getManagementScope().getScopeName() : null;
                KeyStore keyStore2 = KeyStoreManager.getInstance().getKeyStore(string7, string9, string10, string4, string8, string11, true, null);
                String string12 = "default_signer";
                if (keyStore2 != null) {
                    keyStore2.setCertificateEntry(string12, certificate);
                    FileOutputStream fileOutputStream = new FileOutputStream(string4);
                    keyStore2.store(fileOutputStream, string8.toCharArray());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (signer set)");
                    }
                    return;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SSLException) {
                    throw (SSLException)exception;
                }
                throw new SSLException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
    }

    private static String checkForLocationInRepositoryRootMakeDirectoryIfNecessary(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForLocationInRepositoryRootMakeDirectoryIfNecessary", new Object[]{string, string2});
        }
        String string3 = MergeSecurityConfig.fixupLocationWithRepositoryRoot(string, string2);
        string3 = MergeSecurityConfig.fixUpKeyStoreCell(string3);
        String string4 = MergeSecurityConfig.stripFileFromPath(string3);
        File file = new File(string4);
        boolean bl = false;
        if (!file.exists()) {
            bl = file.mkdirs();
        }
        if (!bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not create the directory to add the keyfile.  AddNode is going to fail.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForLocationInRepositoryRootMakeDirectoryIfNecessary");
        }
        return string3;
    }

    private static String stripFileFromPath(String string) {
        int n = string.lastIndexOf("/");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static String whichLocationKeyStoreExists(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "whichLocationKeyStoreExists");
        }
        String string4 = MergeSecurityConfig.fixupLocationWithRepositoryRoot(string3, string);
        File file = new File(string4 = MergeSecurityConfig.fixUpKeyStoreCell(string4));
        if (file.exists()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "whichLocationKeyStoreExists -> " + string3);
            }
            return string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "whichLocationKeyStoreExists -> " + string2);
        }
        return string2;
    }

    private static String fixupLocationWithRepositoryRoot(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupLocationWithRepositoryRoot", new Object[]{string, string2});
        }
        int n = string2.lastIndexOf(DefaultCellsPath);
        String string3 = string2;
        if (n != -1) {
            String string4 = string2.substring(n);
            string3 = string + string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupLocationWithRepositoryRoot -> " + string3);
        }
        return string3;
    }

    private static String getCellAliasKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(":");
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCellAliasKey -> " + string3);
        }
        return string3;
    }

    private static void createDmgrDefaultSSLSettings(Security security2, String string) {
        Object object;
        Object object2;
        SSLConfig sSLConfig;
        SSLConfig sSLConfig2;
        SSLConfig sSLConfig3;
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDmgrDefaultSSLSettings(" + string + ")");
        }
        if ((eList = security2.getRepertoire()) != null && eList.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "search" + string);
            }
            sSLConfig3 = eList.iterator();
            while (sSLConfig3.hasNext()) {
                sSLConfig2 = (SSLConfig)sSLConfig3.next();
                sSLConfig = sSLConfig2.eResource();
                object2 = null;
                if (sSLConfig instanceof XMIResource) {
                    object2 = ((XMIResource)sSLConfig).getID((EObject)sSLConfig2);
                }
                if (object2 == null || !string.equals(sSLConfig2.getAlias())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found: " + string + "  Cell refID: " + (String)object2);
                }
                return;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "search" + DefaultCellSSL);
        }
        sSLConfig3 = null;
        sSLConfig2 = eList.iterator();
        while (sSLConfig2.hasNext()) {
            sSLConfig = (SSLConfig)sSLConfig2.next();
            object2 = sSLConfig.eResource();
            object = null;
            if (object2 instanceof XMIResource) {
                object = ((XMIResource)object2).getID((EObject)sSLConfig);
            }
            if (object == null || !DefaultCellSSL.equals(sSLConfig.getAlias())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found: " + DefaultCellSSL + "  Cell refID: " + (String)object);
            }
            sSLConfig3 = sSLConfig;
            break;
        }
        if (sSLConfig3 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add " + string);
            }
            sSLConfig = SecurityPackage.eINSTANCE;
            object2 = sSLConfig.getSecurityFactory();
            object = SslPackage.eINSTANCE;
            SslFactory sslFactory = object.getSslFactory();
            SSLConfig sSLConfig4 = object2.createSSLConfig();
            SecureSocketLayer secureSocketLayer = sslFactory.createSecureSocketLayer();
            SecureSocketLayer secureSocketLayer2 = sSLConfig3.getSetting();
            sSLConfig4.setAlias(string);
            sSLConfig4.setManagementScope(sSLConfig3.getManagementScope());
            secureSocketLayer.setClientAuthentication(secureSocketLayer2.isClientAuthentication());
            secureSocketLayer.setSecurityLevel(secureSocketLayer2.getSecurityLevel());
            secureSocketLayer.setEnableCryptoHardwareSupport(secureSocketLayer2.isEnableCryptoHardwareSupport());
            secureSocketLayer.setEnabledCiphers(secureSocketLayer2.getEnabledCiphers());
            secureSocketLayer.setJsseProvider(secureSocketLayer2.getJsseProvider());
            secureSocketLayer.setClientAuthenticationSupported(secureSocketLayer2.isClientAuthenticationSupported());
            secureSocketLayer.setSslProtocol(secureSocketLayer2.getSslProtocol());
            EList eList2 = secureSocketLayer2.getTrustManager();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                TrustManager trustManager = (TrustManager)iterator.next();
                secureSocketLayer.getTrustManager().add((Object)trustManager);
            }
            secureSocketLayer.setKeyManager(secureSocketLayer2.getKeyManager());
            secureSocketLayer.setKeyStore(secureSocketLayer2.getKeyStore());
            secureSocketLayer.setTrustStore(secureSocketLayer2.getTrustStore());
            sSLConfig4.setSetting(secureSocketLayer);
            security2.getRepertoire().add((Object)sSLConfig4);
        }
    }

    public static Security updateCellNameAndNodeName(Security security2, String string, String string2) {
        com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore;
        Iterator iterator;
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellNameAndNodeName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name: " + string + "Node name: " + string2);
        }
        if (security2.getKeyStores() != null && security2.getKeyStores().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting new cell name & node name for KeyStore.");
            }
            if ((eList = security2.getKeyStores()) != null) {
                iterator = eList.iterator();
                while (iterator.hasNext()) {
                    keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)iterator.next();
                    if (keyStore.getLocation().indexOf(DefaultConfigCellsPath) == -1 && keyStore.getLocation().indexOf(DefaultCellsPath) == -1) continue;
                    keyStore.setLocation(MergeSecurityConfig.fixUpKeyStore(keyStore.getLocation(), string, string2));
                }
            }
        }
        if (security2.getManagementScopes() != null && security2.getManagementScopes().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting new cell name & node name for ManagementScopes.");
            }
            if ((eList = security2.getManagementScopes()) != null) {
                iterator = eList.iterator();
                while (iterator.hasNext()) {
                    keyStore = (ManagementScope)iterator.next();
                    if (keyStore.getScopeName().indexOf("(cell):") == -1) continue;
                    keyStore.setScopeName(MergeSecurityConfig.fixUpManagementScope(keyStore.getScopeType(), string, string2));
                }
            }
        }
        MergeSecurityConfig.fixUpSslConfigGroup(string, string2, security2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCellNameAndNodeName");
        }
        return security2;
    }

    private static String fixUpKeyStore(String string, String string2, String string3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Original keyStoreLocation: " + string);
        }
        int n = string.indexOf(DefaultConfigCellsPath);
        String string4 = string;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (n != -1) {
            string5 = string.substring(0, n + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "First part: " + string5);
            }
            string6 = string.substring(n + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The rest: " + string6);
            }
        } else {
            n = string.lastIndexOf(DefaultCellsPath);
            if (n != -1) {
                string5 = string.substring(0, n + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "First part: " + string5);
                }
                string6 = string.substring(n + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The rest: " + string6);
                }
            }
        }
        if (string5 != null && string6 != null) {
            if (string6.indexOf(DefaultNodesPath) != -1) {
                n = string6.indexOf(DefaultNodesPath);
                string7 = string6.substring(n + DefaultNodesPath.length());
                if (string7 != null && string7.indexOf("/") != -1) {
                    n = string7.indexOf("/");
                    string7 = string7.substring(n + "/".length());
                }
                string4 = string5 + string2 + DefaultNodesPath + string3 + "/" + string7;
            } else {
                n = string6.indexOf("/");
                string7 = string6.substring(n + "/".length());
                string4 = string5 + string2 + "/" + string7;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Last part: " + string7);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Fixed up location: " + string4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New keystore location: " + string4);
        }
        return string4;
    }

    private static String fixUpManagementScope(String string, String string2, String string3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scoprType: " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name: " + string2 + "Node name: " + string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(cell):");
        stringBuffer.append(string2);
        if (string.equals(DefaultNodeScope)) {
            stringBuffer.append(":(node):");
            stringBuffer.append(string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New newScopeName: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static void fixUpSslConfigGroup(String string, String string2, Security security2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enter fixUpSslConfigGroup");
        }
        if (security2.getSslConfigGroups() != null && security2.getSslConfigGroups().size() > 0) {
            EList eList;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting new cell name & node name for sslConfigGroup.");
            }
            if ((eList = security2.getSslConfigGroups()) != null) {
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    SSLConfigGroup sSLConfigGroup = (SSLConfigGroup)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scopeType: " + sSLConfigGroup.getManagementScope() != null ? sSLConfigGroup.getManagementScope().getScopeName() : "no scope found");
                    }
                    if (sSLConfigGroup.getManagementScope() == null) continue;
                    if (sSLConfigGroup.getManagementScope().getScopeType().equals(DefaultCellScope)) {
                        sSLConfigGroup.setName(string);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "set cell Name: " + string);
                        continue;
                    }
                    sSLConfigGroup.setName(string2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "set node Name: " + string2);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "exit fixUpSslConfigGroup");
        }
    }

    private static boolean checkIfInternalServerIdUsed(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfInternalServerIdUsed");
        }
        boolean bl = security2.getActiveUserRegistry().isUseRegistryServerId();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfInternalServerIdUsed", bl ? Boolean.FALSE : Boolean.TRUE);
        }
        return !bl;
    }

    private static boolean checkIfNullServerPasswordUsed(Security security2) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfNullServerPasswordUsed");
        }
        if ((string = security2.getActiveUserRegistry().getServerPassword()) == null || string.length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkIfNullServerPasswordUsed", " null server passwd. return true.");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfNullServerPasswordUsed", " return false.");
        }
        return false;
    }
}

