/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.AppContextManager;

public class AppContextManagerFactory {
    private static final TraceComponent tc = Tr.register(AppContextManagerFactory.class, "Security", "com.ibm.ejs.resources.security");
    private static final String APP_CONTEXT_MGR_IMPL = "com.ibm.ws.security.core.AppContextManagerImpl";
    private static final AppContextManagerFactory factory = new AppContextManagerFactory();
    private static AppContextManager instance = null;

    public static AppContextManager getInstance() {
        if (instance != null) {
            return instance;
        }
        try {
            instance = (AppContextManager)Class.forName(APP_CONTEXT_MGR_IMPL).newInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loaded AppContextManagerImpl class: com.ibm.ws.security.core.AppContextManagerImpl");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.security.core.AppContextManagerFactory.AppContextManagerFactory", "57");
            Tr.error(tc, "Could not find class: com.ibm.ws.security.core.AppContextManagerImpl");
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException(instantiationException, "com.ibm.ws.security.core.AppContextManagerFactory.AppContextManagerFactory", "62");
            Tr.error(tc, "Could not instantiate class: com.ibm.ws.security.core.AppContextManagerImpl");
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.AppContextManagerFactory.AppContextManagerFactory", "67");
            Tr.error(tc, "Could not load class: com.ibm.ws.security.core.AppContextManagerImpl");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppContextManagerFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        Class clazz = AppContextManagerFactory.class;
        synchronized (clazz) {
            AppContextManagerFactory.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }
}

