/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class ContextManagerFactory {
    private static final TraceComponent tc = Tr.register(ContextManagerFactory.class, "Security", "com.ibm.ejs.resources.security");
    private static final String CONTEXT_MGR_IMPL = "com.ibm.ws.security.auth.ContextManagerImpl";
    private static final String CONTEXT_MGR_PLUGIN_KEY = "com.ibm.ws.security.plugin.ContextManager";
    private static final String CONTEXT_MGR_HANDLER_KEY = "com.ibm.ws.security.plugin.ContextManager.InvocationHandler";
    private static final String plugins_list = "/META-INF/plugins.list";
    private static final ContextManagerFactory factory = new ContextManagerFactory();
    private static ContextManager instance = null;

    public static void setInstance(ContextManager contextManager) {
        instance = contextManager;
    }

    public static ContextManager getInstance() {
        if (instance != null) {
            return instance;
        }
        String string = ContextManagerFactory.getContextMgrImplFromPluginList();
        try {
            String string2;
            ContextManager contextManager = (ContextManager)Class.forName(string).newInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loaded ContextManagerImpl class: " + string);
            }
            if ((string2 = ContextManagerFactory.getContextMgrHandlerImpl()) != null) {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getDeclaredConstructor(ContextManager.class);
                InvocationHandler invocationHandler = (InvocationHandler)constructor.newInstance(contextManager);
                contextManager = (ContextManager)Proxy.newProxyInstance(contextManager.getClass().getClassLoader(), contextManager.getClass().getInterfaces(), invocationHandler);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ContextManager InvocationHandler loaded", contextManager);
                }
            }
            if (instance == null) {
                instance = contextManager;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", "109");
            Tr.error(tc, "Could not find class: " + string);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException(instantiationException, "com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", "114");
            Tr.error(tc, "Could not instantiate class: " + string);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", "119");
            Tr.error(tc, "Could not load class: " + string);
        }
        return instance;
    }

    private static String getContextMgrImplFromPluginList() {
        String string;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getContextManagerImplFromPluginList");
            }
            string = null;
            try {
                InputStream inputStream = Class.forName("com.ibm.ws.security.core.ContextManagerFactory").getResourceAsStream(plugins_list);
                if (inputStream != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!string2.startsWith("com.ibm.ws.security.plugin.ContextManager=")) continue;
                        int n = string2.indexOf(61) + 1;
                        string = string2.substring(n);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.ContextManagerFactory.getContextMgrImplFromPluginList", "153");
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Failed to load context manager impl from plugin list", exception);
            }
        }
        if (string == null) {
            string = CONTEXT_MGR_IMPL;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextManagerImplFromPluginList", string);
        }
        return string;
    }

    private static String getContextMgrHandlerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextMgrHandlerImpl");
        }
        String string = null;
        try {
            InputStream inputStream = Class.forName("com.ibm.ws.security.core.ContextManagerFactory").getResourceAsStream(plugins_list);
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.startsWith("com.ibm.ws.security.plugin.ContextManager.InvocationHandler=")) continue;
                    int n = string2.indexOf(61) + 1;
                    string = string2.substring(n);
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to load context manager handler from plugin list", exception);
            }
            string = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextMgrHandlerImpl", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextManagerFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        Class clazz = ContextManagerFactory.class;
        synchronized (clazz) {
            ContextManagerFactory.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }
}

