/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.AccessPermission;
import com.ibm.ws.security.util.LRUCache;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jst.j2ee.common.SecurityRole;

public abstract class PermissionRoleMap {
    LRUCache prMap;
    int cacheSize = 600;
    public static final String pr_HASH_SIZE = "com.ibm.websphere.security.core.prhashsize";
    private static final TraceComponent tc = Tr.register(PermissionRoleMap.class);
    public static final SecurityRole[] NO_REQUIRED_ROLES = new SecurityRole[0];
    public static final SecurityRole[] EMPTY_REQUIRED_ROLES = new SecurityRole[0];

    protected PermissionRoleMap() {
        int n;
        String string = null;
        string = System.getProperty(pr_HASH_SIZE);
        if (string != null && (n = new Integer(string).intValue()) > 0) {
            this.cacheSize = n;
        }
        this.prMap = new LRUCache(this.cacheSize);
    }

    public SecurityRole[] getRequiredRoles(AccessContext accessContext, AccessPermission accessPermission) {
        return this.getRequiredRoles(accessContext, accessPermission, null);
    }

    public SecurityRole[] getRequiredRoles(AccessContext accessContext, AccessPermission accessPermission, HttpServletRequest httpServletRequest) {
        SecurityRole[] securityRoleArray;
        SecurityRole[] securityRoleArray2 = null;
        LRUCache lRUCache = (LRUCache)this.prMap.get(accessContext.getEnterpriseAppName());
        if (lRUCache == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "No app permission cache found for " + accessContext.getEnterpriseAppName());
            }
            lRUCache = new LRUCache(this.cacheSize);
            this.prMap.put(accessContext.getEnterpriseAppName(), lRUCache);
        } else {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "App permission cache found for " + accessContext.getEnterpriseAppName());
            }
            securityRoleArray2 = (SecurityRole[])lRUCache.get(accessPermission);
        }
        if (securityRoleArray2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "No permissions found for " + accessPermission.getResourceName() + ":" + accessPermission.getMethodName());
            }
            if ((securityRoleArray = httpServletRequest != null ? this.getRequiredRoles(accessContext, accessPermission.getResourceName(), accessPermission.getMethodName(), httpServletRequest) : this.getRequiredRoles(accessContext, accessPermission.getResourceName(), accessPermission.getMethodName())) == null) {
                lRUCache.put(accessPermission, NO_REQUIRED_ROLES);
                securityRoleArray = NO_REQUIRED_ROLES;
            } else {
                lRUCache.put(accessPermission, securityRoleArray);
            }
            securityRoleArray2 = securityRoleArray;
        }
        if (tc.isEntryEnabled()) {
            securityRoleArray = new StringBuffer(accessContext.getEnterpriseAppName());
            securityRoleArray.append(", ");
            securityRoleArray.append(accessPermission.getResourceName());
            securityRoleArray.append(":");
            securityRoleArray.append(accessPermission.getMethodName());
            securityRoleArray.append(" required roles are ");
            if (securityRoleArray2 == NO_REQUIRED_ROLES) {
                securityRoleArray.append("none");
            } else {
                for (int i = 0; i < securityRoleArray2.length; ++i) {
                    securityRoleArray.append(securityRoleArray2[i]);
                    if (i >= securityRoleArray2.length - 1) continue;
                    securityRoleArray.append(", ");
                }
            }
            Tr.debug(tc, securityRoleArray.toString());
        }
        return securityRoleArray2;
    }

    protected abstract SecurityRole[] getRequiredRoles(AccessContext var1, String var2, String var3);

    protected abstract SecurityRole[] getRequiredRoles(AccessContext var1, String var2, String var3, HttpServletRequest var4);
}

