/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.ORBInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.orb.securityprotocol.CommonSecureInterop;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocol;
import com.ibm.websphere.models.config.orb.securityprotocol.IdentityAssertionLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.IdentityAssertionQOP;
import com.ibm.websphere.models.config.orb.securityprotocol.MessageLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.MessageQOP;
import com.ibm.websphere.models.config.orb.securityprotocol.ServerIdentity;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportQOP;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.security.CustomAuthMechanism;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.SASPropFile;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class SASConfig {
    private static final TraceComponent tc = Tr.register(SASConfig.class, null, "com.ibm.ejs.resources.security");
    private static SASConfig config;
    public static final String SECURITY_ENABLED_PROPERTY = "com.ibm.CORBA.securityEnabled";
    public static final String AUTHENTICATION_TARGET_PROPERTY = "com.ibm.CORBA.authenticationTarget";
    public static final String PRINCIPAL_NAME_PROPERTY = "com.ibm.CORBA.principalName";
    public static final String LOGIN_USERID = "com.ibm.CORBA.loginUserid";
    public static final String LOGIN_PASSWORD = "com.ibm.CORBA.loginPassword";
    public static final String SECURITY_CACHE_TIMEOUT_PROPERTY = "com.ibm.CORBA.securityCacheTimeout";
    public static final String ORB_SSL_LISTENER_ADDRESS = "ORB_SSL_LISTENER_ADDRESS";
    public static final String CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS = "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS";
    public static final String CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS = "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS";
    public static final String SAS_SSL_SERVERAUTH_LISTENER_ADDRESS = "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS";
    public static final String CELL_NODE_SERVER = "com.ibm.CSI.CellNodeServer";
    public static final String PLUGGABLE_AUTHZN_PROPERTY = "com.ibm.websphere.security.authorizationTable";
    private static final String[] propNames;
    private static final int SECURITY_ENABLED = 0;
    private static final int AUTHENTICATION_TARGET = 1;
    private static final int PRINCIPAL_NAME = 2;
    private static final int LOGIN_USERID_INDEX = 3;
    private static final int LOGIN_PASSWORD_INDEX = 4;
    private static final int SECURITY_CACHE_TIMEOUT = 5;
    private static final int SERVER_SECURITY_ENABLED = 6;
    private static final String LOCALOS_USERID = "LOCALOS.server.id";
    private static final String LOCALOS_PASSWORD = "LOCALOS.server.pwd";
    private boolean isRequired;
    private boolean forceRestart = false;
    private URL configURL = null;
    private URL futureConfigURL = null;
    private Properties localOSData;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$channelservice$channels$ORBInboundChannel;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$channelservice$channels$SSLInboundChannel;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$channelservice$channels$TCPInboundChannel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SASConfig getInstance() {
        if (config == null) {
            Class clazz = SASConfig.class;
            synchronized (clazz) {
                if (config == null) {
                    config = new SASConfig();
                }
            }
        }
        return config;
    }

    private SASConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SASConfig");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SASConfig");
        }
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    private boolean isInitialized() {
        return this.configURL != null;
    }

    private static void copy(URL uRL, URL uRL2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = uRL.openStream();
            outputStream = SASConfig.getOutputStream(uRL2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.security.core.SASConfig.copy", "179");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "copy", iOException);
            }
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copy");
        }
    }

    public Properties getLoginData(String string) throws IOException {
        Properties properties = null;
        if (string.equals("LOCALOS")) {
            properties = this.localOSData;
        }
        return properties;
    }

    public synchronized void setLoginData(String string, Properties properties) throws IOException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLoginData");
        }
        if (!this.isInitialized()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setLoginData");
            }
            throw new FileNotFoundException("ConfigURL");
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(".server.");
        int n = stringBuffer.length();
        stringBuffer.append("id");
        String string2 = stringBuffer.toString();
        String string3 = properties.getProperty(string2);
        String string4 = this.localOSData.getProperty(string2);
        if (string4 != null && string3 != null && !string4.equals(string3)) {
            this.localOSData.put(string2, string3);
            bl = true;
        }
        stringBuffer.setLength(n);
        stringBuffer.append("pwd");
        string2 = stringBuffer.toString();
        string3 = properties.getProperty(string2);
        string4 = this.localOSData.getProperty(string2);
        if (string4 != null && string3 != null && !string4.equals(string3)) {
            object = null;
            try {
                object = PasswordUtil.decode(string3);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                FFDCFilter.processException((Throwable)((Object)invalidPasswordDecodingException), "com.ibm.ws.security.core.SASConfig.setLoginData", "249", this);
                object = string3;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SASConfig.setLoginData", "254", this);
                object = string3;
                Tr.error(tc, "security.sas.decode.error", new Object[]{string3, string2});
            }
            this.localOSData.put(string2, object);
            bl = true;
        }
        if (bl) {
            object = this.loadProperties(this.futureConfigURL);
            Enumeration<?> enumeration = this.localOSData.propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                ((Properties)object).put(string2, this.localOSData.getProperty(string2));
            }
            try {
                SASPropFile.encodePropPasswords((Properties)object);
            }
            catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
                FFDCFilter.processException((Throwable)((Object)invalidPasswordEncodingException), "com.ibm.ws.security.core.SASConfig.setLoginData", "278", this);
                Tr.error(tc, "security.sas.encode.error", new Object[]{string2, this.localOSData.getProperty(string2)});
            }
            SASPropFile.saveConfig((Properties)object, this.futureConfigURL);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLoginData");
        }
    }

    private boolean isCurrent() {
        boolean bl = false;
        try {
            Properties properties = this.loadProperties(this.configURL);
            Properties properties2 = this.loadProperties(this.futureConfigURL);
            bl = this.equal(properties2, properties);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.core.SASConfig.isCurrent", "299", this);
            Tr.error(tc, "security.sasconfig.currenterror", new Object[]{this.configURL.getPath(), this.futureConfigURL.getPath()});
        }
        return bl;
    }

    private boolean equal(Properties properties, Properties properties2) {
        boolean bl = true;
        try {
            for (int i = 0; i < propNames.length; ++i) {
                String string;
                String string2 = properties.getProperty(propNames[i]);
                if (string2.equals(string = properties2.getProperty(propNames[i]))) continue;
                bl = false;
                break;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.core.SASConfig.equal", "325", this);
            bl = false;
        }
        return bl;
    }

    private Properties loadProperties(URL uRL) throws IOException {
        return SASConfig.loadProperties(uRL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL uRL, boolean bl) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = uRL.openStream();
        try {
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (bl) {
            try {
                SASPropFile.decodePropPasswords(properties);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                FFDCFilter.processException((Throwable)((Object)invalidPasswordDecodingException), "com.ibm.ws.security.core.SASConfig.loadProperties", "365");
                Tr.error(tc, "security.sas.decode.error", new Object[]{uRL, properties});
            }
        }
        return properties;
    }

    private static OutputStream getOutputStream(URL uRL) throws IOException {
        OutputStream outputStream = null;
        outputStream = uRL.getProtocol().equals("file") ? new FileOutputStream(uRL.getFile()) : uRL.openConnection().getOutputStream();
        return outputStream;
    }

    private static boolean exists(URL uRL) {
        boolean bl = false;
        try {
            InputStream inputStream = uRL.openStream();
            int n = inputStream.read();
            inputStream.close();
            if (n >= 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.SASConfig.exists", "404");
        }
        return bl;
    }

    private static boolean delete(URL uRL) {
        boolean bl = false;
        if (uRL.getProtocol().equals("file")) {
            try {
                OutputStream outputStream = SASConfig.getOutputStream(uRL);
                outputStream.close();
                bl = true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.security.core.SASConfig.delete", "422");
            }
        }
        return bl;
    }

    private static boolean renameTo(URL uRL, URL uRL2) {
        boolean bl = false;
        if (uRL.getProtocol().equals("file")) {
            try {
                SASConfig.copy(uRL, uRL2);
                SASConfig.delete(uRL);
                bl = true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.security.core.SASConfig.renameTo", "439");
            }
        }
        return bl;
    }

    private boolean isORBSecurityEnabled(ORB oRB) {
        boolean bl = false;
        String string = oRB.getProperty(SECURITY_ENABLED_PROPERTY);
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateORBConfig(Security security2, Properties properties, EndPointMgr endPointMgr, Server server2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateORBConfig");
        }
        Class clazz = SASConfig.class;
        synchronized (clazz) {
            Object object;
            try {
                object = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
                SASConfig.refresh((String)object, security2, properties, endPointMgr, server2);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.SASConfig.updateORBConfig", "499");
                Tr.error(tc, "security.sasconfig.registryattrs", new Object[]{exception});
                Tr.debug(tc, "Exception: ", new Object[]{exception});
            }
            if (tc.isDebugEnabled()) {
                object = properties.propertyNames();
                while (object.hasMoreElements()) {
                    String string = "updateORBConfig";
                    String string2 = (String)object.nextElement();
                    if (string2 == null) continue;
                    String string3 = properties.getProperty(string2);
                    if (string2.indexOf("Password") != -1 || string2.indexOf("password") != -1) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, string + ": " + string2 + " = " + SecurityConfiguration.mask(string3));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, string + ": " + string2 + " = " + string3);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateORBConfig");
            }
        }
    }

    private static synchronized void refresh(String string, Security security2, Properties properties, EndPointMgr endPointMgr, Server server2) throws RemoteException, IOException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("cell.security.enabled");
        String string3 = null;
        string3 = bl != null ? String.valueOf(bl) : "false";
        if (string3 != null) {
            properties.put(propNames[0], string3);
        }
        if ((string3 = String.valueOf((Boolean)SecurityConfig.getConfig().getValue("server.security.enabled"))) != null) {
            properties.put(propNames[6], string3);
        }
        properties.put("com.ibm.CORBA.processIsServer", "true");
        try {
            string2 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.CommTrace.ExcludeServiceContexts");
            if (string2 != null) {
                properties.put("com.ibm.ws.security.CommTrace.ExcludeServiceContexts", string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl.booleanValue()) {
            String string4;
            String string5;
            Boolean bl2;
            string3 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
            if (string3 != null) {
                properties.put(propNames[1], string3);
            }
            string3 = (String)SecurityConfig.getConfig().getValue("security.serverId");
            string2 = null;
            if (string3 == null) {
                string3 = "";
            }
            if (string3 != null && string3 instanceof String) {
                string2 = string3;
                properties.put(LOGIN_USERID, string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("process.serverName")) != null) {
                properties.put(CELL_NODE_SERVER, string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiOutboundPropagationEnabled")) != null) {
                properties.put("com.ibm.CSI.rmiOutboundPropagationEnabled", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiOutboundLoginEnabled")) != null) {
                properties.put("com.ibm.CSI.rmiOutboundLoginEnabled", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiInboundMappingEnabled")) != null) {
                properties.put("com.ibm.CSI.rmiInboundMappingEnabled", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiOutboundMappingEnabled")) != null) {
                properties.put("com.ibm.CSI.rmiOutboundMappingEnabled", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiInboundMappingConfig")) != null) {
                properties.put("com.ibm.CSI.rmiInboundMappingConfig", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiInboundPropagationEnabled")) != null) {
                properties.put("com.ibm.CSI.rmiInboundPropagationEnabled", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled")) != null) {
                properties.put("com.ibm.ws.security.webInboundPropagationEnabled", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.ssoInteropModeEnabled")) != null) {
                properties.put("com.ibm.ws.security.ssoInteropModeEnabled", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiInboundLoginConfig")) != null) {
                properties.put("com.ibm.CSI.rmiInboundLoginConfig", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig")) != null) {
                properties.put("com.ibm.ws.security.webInboundLoginConfig", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiOutboundLoginConfig")) != null) {
                properties.put("com.ibm.CSI.rmiOutboundLoginConfig", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.supportedTargetRealms")) != null) {
                properties.put("com.ibm.CSI.supportedTargetRealms", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound")) != null) {
                properties.put("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webPropagationTransport")) != null) {
                properties.put("com.ibm.ws.security.webPropagationTransport", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.propagationExcludeList")) != null) {
                properties.put("com.ibm.ws.security.propagationExcludeList", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.krb.support_ltpa")) != null) {
                properties.put("com.ibm.websphere.security.krb.support_ltpa", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.includeRunAsChangesInCallerList")) != null) {
                properties.put("com.ibm.ws.security.includeRunAsChangesInCallerList", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.createTokenSubjectForAsynchLogin")) != null) {
                properties.put("com.ibm.ws.security.createTokenSubjectForAsynchLogin", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.assertLDAPShortName")) != null) {
                properties.put("com.ibm.ws.security.assertLDAPShortName", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.internalServerId")) != null) {
                properties.put("com.ibm.ws.security.internalServerId", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.authenticateSpecialMethods")) != null) {
                properties.put("com.ibm.CSI.authenticateSpecialMethods", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.neverUseClientCertificateForCallerLogin")) != null) {
                properties.put("com.ibm.CSI.neverUseClientCertificateForCallerLogin", string3);
            }
            if ((bl2 = (Boolean)SecurityConfig.getConfig().getValue("com.ibm.ws.security.isUseRegistryServerId")) == null || bl2.booleanValue()) {
                properties.put("com.ibm.ws.security.isUseRegistryServerId", "true");
            } else {
                properties.put("com.ibm.ws.security.isUseRegistryServerId", "false");
            }
            string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.processType");
            if (string3 != null) {
                properties.put("com.ibm.ws.security.processType", string3);
            }
            string3 = (String)SecurityConfig.getConfig().getValue("security.serverPasswd");
            try {
                if (string3 != null && string3 instanceof String) {
                    string3 = PasswordUtil.encode(string3);
                }
            }
            catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
                FFDCFilter.processException((Throwable)((Object)invalidPasswordEncodingException), "com.ibm.ws.security.core.SASConfig.refresh", "665");
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.SASConfig.refresh", "669");
                Tr.error(tc, "security.sas.encode.error", new Object[]{string3, LOGIN_PASSWORD});
            }
            if (string3 != null) {
                properties.put(LOGIN_PASSWORD, string3);
            }
            if ((string5 = string + "/" + string2) != null && string2 != null) {
                properties.put(propNames[2], string5);
            }
            if (security2.getActiveAuthMechanism() instanceof CustomAuthMechanism) {
                string3 = (String)SecurityConfig.getConfig().getValue("security.authMechOID");
                if (string3 != null) {
                    properties.put("com.ibm.CSI.WSSecurityContextCustomOID", string3);
                }
                if ((string3 = (String)SecurityConfig.getConfig().getValue("security.authMechContextImpl")) != null) {
                    properties.put("com.ibm.CSI.WSSecurityContextCustomClass", string3);
                }
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("security.authMechOID")) != null) {
                properties.put("com.ibm.CSI.WSSecurityContextActiveOID", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("security.authMechContextImpl")) != null) {
                properties.put("com.ibm.CSI.WSSecurityContextActiveClass", string3);
            }
            if ((string3 = ((Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred")).toString()) != null) {
                properties.put("com.ibm.CSI.WSSecurityContextActiveForwardable", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("security.authMechAuthAlias")) != null) {
                properties.put("com.ibm.CSI.authMechAuthAlias", string3);
            }
            if ((string3 = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistryType")) != null) {
                properties.put("com.ibm.CSI.activeUserRegistry", string3);
            }
            if ((string4 = (String)SecurityConfig.getConfig().getValue(PLUGGABLE_AUTHZN_PROPERTY)) != null && !string4.equals("") && (string3 = (String)SecurityConfig.getConfig().getValue(PLUGGABLE_AUTHZN_PROPERTY)) != null) {
                properties.put(PLUGGABLE_AUTHZN_PROPERTY, string3);
            }
            properties.put("com.ibm.ws.orb.transport.ConnectionInterceptorName", "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor");
            string3 = ((Boolean)SecurityConfig.getConfig().getValue("com.ibm.CSI.localCommDataForNonLocalOSEnabled")).toString();
            if (string3 != null) {
                properties.put("com.ibm.CSI.localCommDataForNonLocalOSEnabled", string3);
            }
            SASConfig.setCSIValues(security2, server2, properties, endPointMgr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }

    private static void setCSIValues(Security security2, Server server2, Properties properties, EndPointMgr endPointMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCSIValues: " + security2);
        }
        try {
            Object object;
            String string;
            String string2;
            String string3;
            IdentityAssertionQOP identityAssertionQOP;
            CommonSecureInterop commonSecureInterop;
            String string4;
            int n;
            IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
            CommonSecureInterop commonSecureInterop2 = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
            if (commonSecureInterop2.isStateful()) {
                properties.put("com.ibm.CSI.claimStateful", "true");
            } else {
                properties.put("com.ibm.CSI.claimStateful", "false");
            }
            IdentityAssertionLayer identityAssertionLayer = null;
            for (int i = 0; i < commonSecureInterop2.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop2.getLayers().get(i) instanceof IdentityAssertionLayer)) continue;
                identityAssertionLayer = (IdentityAssertionLayer)commonSecureInterop2.getLayers().get(i);
                break;
            }
            if (identityAssertionLayer != null) {
                IdentityAssertionQOP identityAssertionQOP2 = (IdentityAssertionQOP)identityAssertionLayer.getSupportedQOP();
                if (identityAssertionQOP2.isEnable()) {
                    properties.put("com.ibm.CSI.claimIdentityAssertionSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.claimIdentityAssertionSupported", "false");
                }
            }
            ServerIdentity serverIdentity = null;
            String string5 = "";
            for (int i = 0; i < identityAssertionLayer.getTrustedServers().size(); ++i) {
                serverIdentity = (ServerIdentity)identityAssertionLayer.getTrustedServers().get(i);
                string5 = i == 0 ? serverIdentity.getServerId() : string5 + "," + serverIdentity.getServerId();
            }
            if (string5 != null) {
                properties.put("com.ibm.CSI.trustedPrincipalList", string5);
            }
            MessageLayer messageLayer = null;
            for (n = 0; n < commonSecureInterop2.getLayers().size(); ++n) {
                if (!((IIOPLayer)commonSecureInterop2.getLayers().get(n) instanceof MessageLayer)) continue;
                messageLayer = (MessageLayer)commonSecureInterop2.getLayers().get(n);
                break;
            }
            if (messageLayer != null) {
                MessageQOP messageQOP = (MessageQOP)messageLayer.getSupportedQOP();
                if (messageQOP.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.claimClientAuthenticationSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.claimClientAuthenticationSupported", "false");
                }
                string4 = (MessageQOP)messageLayer.getRequiredQOP();
                if (string4.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.claimClientAuthenticationRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.claimClientAuthenticationRequired", "false");
                }
            }
            n = 0;
            if (server2 != null) {
                n = SASConfig.setCSIInboundTranportFromChannelFramework(server2, properties, endPointMgr) ? 1 : 0;
            }
            string4 = null;
            string4 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.neverUseClientCertificateForCallerLogin");
            if (string4 != null) {
                properties.put("com.ibm.CSI.neverUseClientCertificateForCallerLogin", string4);
            }
            if ((string4 = ((Boolean)SecurityConfig.getConfig().getValue("com.ibm.CSI.localCommDataForNonLocalOSEnabled")).toString()) != null) {
                properties.put("com.ibm.CSI.localCommDataForNonLocalOSEnabled", string4);
            }
            if (server2 == null || n == 0) {
                commonSecureInterop = null;
                for (int i = 0; i < commonSecureInterop2.getLayers().size(); ++i) {
                    if (!((IIOPLayer)commonSecureInterop2.getLayers().get(i) instanceof TransportLayer)) continue;
                    commonSecureInterop = (TransportLayer)commonSecureInterop2.getLayers().get(i);
                    break;
                }
                if (commonSecureInterop != null) {
                    TransportQOP transportQOP = (TransportQOP)commonSecureInterop.getSupportedQOP();
                    if (transportQOP.isEnableProtection()) {
                        properties.put("com.ibm.CSI.claimTransportAssocSSLTLSSupported", "true");
                    } else {
                        properties.put("com.ibm.CSI.claimTransportAssocSSLTLSSupported", "false");
                    }
                    if (transportQOP.isEstablishTrustInClient()) {
                        properties.put("com.ibm.CSI.claimTLClientAuthenticationSupported", "true");
                    } else {
                        properties.put("com.ibm.CSI.claimTLClientAuthenticationSupported", "false");
                    }
                    if (transportQOP.isIntegrity()) {
                        properties.put("com.ibm.CSI.claimMessageIntegritySupported", "true");
                    } else {
                        properties.put("com.ibm.CSI.claimMessageIntegritySupported", "false");
                    }
                    if (transportQOP.isConfidentiality()) {
                        properties.put("com.ibm.CSI.claimMessageConfidentialitySupported", "true");
                    } else {
                        properties.put("com.ibm.CSI.claimMessageConfidentialitySupported", "false");
                    }
                    TransportQOP transportQOP2 = (TransportQOP)commonSecureInterop.getRequiredQOP();
                    if (transportQOP2.isEnableProtection()) {
                        properties.put("com.ibm.CSI.claimTransportAssocSSLTLSRequired", "true");
                    } else {
                        properties.put("com.ibm.CSI.claimTransportAssocSSLTLSRequired", "false");
                    }
                    if (transportQOP2.isEstablishTrustInClient()) {
                        properties.put("com.ibm.CSI.claimTLClientAuthenticationRequired", "true");
                    } else {
                        properties.put("com.ibm.CSI.claimTLClientAuthenticationRequired", "false");
                    }
                    if (transportQOP2.isIntegrity()) {
                        properties.put("com.ibm.CSI.claimMessageIntegrityRequired", "true");
                    } else {
                        properties.put("com.ibm.CSI.claimMessageIntegrityRequired", "false");
                    }
                    if (transportQOP2.isConfidentiality()) {
                        properties.put("com.ibm.CSI.claimMessageConfidentialityRequired", "true");
                    } else {
                        properties.put("com.ibm.CSI.claimMessageConfidentialityRequired", "false");
                    }
                    identityAssertionQOP = commonSecureInterop.getServerAuthentication();
                    string3 = identityAssertionQOP.getSslConfig();
                    if (string3 != null) {
                        properties.put("com.ibm.ssl.csi.inbound.alias", string3);
                    }
                    if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        string2 = null;
                        string = "0";
                        try {
                            string2 = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS);
                            if (string2 != null) {
                                string = Integer.toString(string2.getPort());
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException(exception, "com.ibm.ws.security.core.SASConfig.setCSIValues", "846");
                        }
                        if (string != null && !string.equals("")) {
                            properties.put("com.ibm.CSI.SSLPort", string);
                        } else {
                            properties.put("com.ibm.CSI.SSLPort", "0");
                        }
                        object = null;
                        String string6 = "0";
                        try {
                            object = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS);
                            if (object != null) {
                                string6 = Integer.toString(object.getPort());
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException(exception, "com.ibm.ws.security.core.SASConfig.setCSIValues", "868");
                        }
                        if (string6 != null && !string6.equals("")) {
                            properties.put("com.ibm.CSI.ClientCertSSLPort", string6);
                        } else {
                            properties.put("com.ibm.CSI.ClientCertSSLPort", "0");
                        }
                    }
                }
            }
            if ((commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getPerforms()).isStateful()) {
                properties.put("com.ibm.CSI.performStateful", "true");
            } else {
                properties.put("com.ibm.CSI.performStateful", "false");
            }
            properties.put("com.ibm.CORBA.sessionGCinterval", Integer.toString(commonSecureInterop.getSessionGCInterval()));
            properties.put("com.ibm.CORBA.sessionGCdiscardunused", Integer.toString(commonSecureInterop.getSessionGCIdleTime()));
            IdentityAssertionLayer identityAssertionLayer2 = null;
            for (int i = 0; i < commonSecureInterop.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop.getLayers().get(i) instanceof IdentityAssertionLayer)) continue;
                identityAssertionLayer2 = (IdentityAssertionLayer)commonSecureInterop.getLayers().get(i);
                break;
            }
            if (identityAssertionLayer2 != null) {
                IdentityAssertionQOP identityAssertionQOP3 = (IdentityAssertionQOP)identityAssertionLayer2.getSupportedQOP();
                if (identityAssertionQOP3.isEnable()) {
                    properties.put("com.ibm.CSI.performIdentityAssertionSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performIdentityAssertionSupported", "false");
                }
                identityAssertionQOP = (IdentityAssertionQOP)identityAssertionLayer2.getRequiredQOP();
                if (identityAssertionQOP.isEnable()) {
                    properties.put("com.ibm.CSI.performIdentityAssertionRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performIdentityAssertionRequired", "false");
                }
                string3 = identityAssertionQOP3.getTrustedId();
                string2 = identityAssertionQOP3.getTrustedPassword();
                if (string3 != null && !string3.equals("") && string2 != null && !string2.equals("")) {
                    properties.put("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId", string3);
                    properties.put("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword", string2);
                }
            }
            MessageLayer messageLayer2 = null;
            for (int i = 0; i < commonSecureInterop.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop.getLayers().get(i) instanceof MessageLayer)) continue;
                messageLayer2 = (MessageLayer)commonSecureInterop.getLayers().get(i);
                break;
            }
            if (messageLayer2 != null) {
                MessageQOP messageQOP = (MessageQOP)messageLayer2.getSupportedQOP();
                if (messageQOP.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.performClientAuthenticationSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performClientAuthenticationSupported", "false");
                }
                string3 = (MessageQOP)messageLayer2.getRequiredQOP();
                if (string3.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.performClientAuthenticationRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performClientAuthenticationRequired", "false");
                }
                properties.put("com.ibm.CORBA.authenticationRetryCount", Integer.toString(messageLayer2.getAuthenticationLayerRetryCount()));
                if (messageLayer2.getAuthenticationLayerRetryCount() > 0) {
                    properties.put("com.ibm.CORBA.authenticationRetryEnabled", "true");
                } else {
                    properties.put("com.ibm.CORBA.authenticationRetryEnabled", "false");
                }
            }
            TransportLayer transportLayer = null;
            for (int i = 0; i < commonSecureInterop.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop.getLayers().get(i) instanceof TransportLayer)) continue;
                transportLayer = (TransportLayer)commonSecureInterop.getLayers().get(i);
                break;
            }
            if (transportLayer != null) {
                TransportQOP transportQOP = (TransportQOP)transportLayer.getSupportedQOP();
                if (transportQOP.isEnableProtection()) {
                    properties.put("com.ibm.CSI.performTransportAssocSSLTLSSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performTransportAssocSSLTLSSupported", "false");
                }
                if (transportQOP.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.performTLClientAuthenticationSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performTLClientAuthenticationSupported", "false");
                }
                if (transportQOP.isIntegrity()) {
                    properties.put("com.ibm.CSI.performMessageIntegritySupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performMessageIntegritySupported", "false");
                }
                if (transportQOP.isConfidentiality()) {
                    properties.put("com.ibm.CSI.performMessageConfidentialitySupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performMessageConfidentialitySupported", "false");
                }
                string2 = (TransportQOP)transportLayer.getRequiredQOP();
                if (string2.isEnableProtection()) {
                    properties.put("com.ibm.CSI.performTransportAssocSSLTLSRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performTransportAssocSSLTLSRequired", "false");
                }
                if (string2.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.performTLClientAuthenticationRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performTLClientAuthenticationRequired", "false");
                }
                if (string2.isIntegrity()) {
                    properties.put("com.ibm.CSI.performMessageIntegrityRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performMessageIntegrityRequired", "false");
                }
                if (string2.isConfidentiality()) {
                    properties.put("com.ibm.CSI.performMessageConfidentialityRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performMessageConfidentialityRequired", "false");
                }
                string = transportLayer.getServerAuthentication();
                object = string.getSslConfig();
                if (object != null) {
                    properties.put("com.ibm.ssl.csi.outbound.alias", object);
                }
            }
            properties.put("com.ibm.CORBA.loginTimeout", new Integer(300).toString());
            String string7 = (String)SecurityConfig.getConfig().getValue("com.ibm.CORBA.delegateCredentials");
            if (string7 == null || string7.equals("")) {
                string7 = "methoddefined";
            }
            properties.put("com.ibm.CORBA.delegateCredentials", string7);
        }
        catch (Exception exception) {
            Tr.error(tc, "security.init.error", new Object[]{exception});
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.SASConfig.updateORBConfig", "1126");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCSIValues");
        }
    }

    private static boolean setCSIInboundTranportFromChannelFramework(Server server2, Properties properties, EndPointMgr endPointMgr) {
        ArrayList<Object> arrayList;
        ArrayList<Properties> arrayList2;
        block35: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCSIInboundTranportFromChannelFramework: " + server2);
            }
            arrayList2 = new ArrayList<Properties>();
            arrayList = new ArrayList<Object>();
            try {
                EList eList = server2.getServices();
                if (eList != null && eList.size() > 0) {
                    Object object;
                    TransportChannelService transportChannelService = null;
                    Class clazz = TransportChannelService.class;
                    EList eList2 = eList.iterator();
                    while (eList2.hasNext()) {
                        object = eList2.next();
                        if (!clazz.isInstance(object)) continue;
                        transportChannelService = (TransportChannelService)object;
                        break;
                    }
                    if (transportChannelService != null) {
                        eList2 = transportChannelService.getChains();
                        if (eList2 != null && eList2.size() > 0) {
                            object = eList2.iterator();
                            while (object.hasNext()) {
                                Object object2;
                                Object object3;
                                EList eList3;
                                Chain chain = (Chain)object.next();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Looking at chain: " + chain.getName());
                                }
                                if ((eList3 = chain.getTransportChannels()) == null || eList3.size() <= 0) continue;
                                ORBInboundChannel oRBInboundChannel = null;
                                SSLInboundChannel sSLInboundChannel = null;
                                TCPInboundChannel tCPInboundChannel = null;
                                Class clazz2 = class$com$ibm$websphere$models$config$channelservice$channels$ORBInboundChannel == null ? SASConfig.class$("com.ibm.websphere.models.config.channelservice.channels.ORBInboundChannel") : class$com$ibm$websphere$models$config$channelservice$channels$ORBInboundChannel;
                                Class clazz3 = class$com$ibm$websphere$models$config$channelservice$channels$SSLInboundChannel == null ? SASConfig.class$("com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel") : class$com$ibm$websphere$models$config$channelservice$channels$SSLInboundChannel;
                                Class clazz4 = class$com$ibm$websphere$models$config$channelservice$channels$TCPInboundChannel == null ? SASConfig.class$("com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel") : class$com$ibm$websphere$models$config$channelservice$channels$TCPInboundChannel;
                                Object object4 = eList3.iterator();
                                while (object4.hasNext()) {
                                    object3 = object4.next();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Looking at channel: " + ((TransportChannel)object3).getName());
                                    }
                                    if (clazz2.isInstance(object3)) {
                                        oRBInboundChannel = (ORBInboundChannel)object3;
                                    }
                                    if (clazz3.isInstance(object3)) {
                                        sSLInboundChannel = (SSLInboundChannel)object3;
                                    }
                                    if (!clazz4.isInstance(object3)) continue;
                                    tCPInboundChannel = (TCPInboundChannel)object3;
                                }
                                object4 = null;
                                object3 = null;
                                if (oRBInboundChannel != null && tCPInboundChannel != null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found ORB TCP endpoint: " + tCPInboundChannel.getEndPointName());
                                    }
                                    if ((object2 = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(tCPInboundChannel.getEndPointName())) != null) {
                                        object3 = Integer.toString(object2.getPort());
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Found ORB port: " + object3);
                                        }
                                    }
                                }
                                if (oRBInboundChannel != null && tCPInboundChannel != null && sSLInboundChannel == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found ORB TCP chain: " + chain.getName());
                                    }
                                    object4 = tCPInboundChannel.getEndPointName();
                                    object2 = new Properties();
                                    if (object3 != null) {
                                        ((Properties)object2).setProperty("com.ibm.CORBA.ListenerPort", (String)object3);
                                    }
                                    ((Properties)object2).setProperty("ChainName", chain.getName());
                                    if (object4 != null) {
                                        ((Properties)object2).setProperty("EndPointName", (String)object4);
                                    }
                                    arrayList.add(object2);
                                }
                                if (oRBInboundChannel == null || sSLInboundChannel == null || tCPInboundChannel == null) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found ORB SSL chain: " + chain.getName());
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ORB SSL config: " + sSLInboundChannel.getSslConfigAlias());
                                }
                                object2 = sSLInboundChannel.getSslConfigAlias();
                                try {
                                    object4 = tCPInboundChannel.getEndPointName();
                                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                    hashMap.put("com.ibm.ssl.direction", "inbound");
                                    hashMap.put("com.ibm.ssl.endPointName", object4);
                                    Properties properties2 = JSSEHelper.getInstance().getProperties((String)object2, hashMap, null);
                                    if (properties2 == null) continue;
                                    Properties properties3 = new Properties(properties2);
                                    if (object3 != null) {
                                        properties3.setProperty("com.ibm.CSI.SSLPort", (String)object3);
                                    }
                                    properties3.setProperty("ChainName", chain.getName());
                                    if (object4 != null) {
                                        properties3.setProperty("EndPointName", (String)object4);
                                    }
                                    arrayList2.add(properties3);
                                }
                                catch (SSLException sSLException) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Exception occurred in setCSIInboundTranportFromChannelFramework: ", new Object[]{sSLException});
                                    }
                                    FFDCFilter.processException(sSLException, "com.ibm.ws.security.core.SASConfig.setCSIInboundTranportFromChannelFramework", "1265");
                                }
                            }
                            SecurityConfig.getConfig().setValue("iiop.insecure.transports", arrayList);
                            SecurityConfig.getConfig().setValue("iiop.secure.transports", arrayList2);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No Chains found in TransportChannelService in server.xml.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No TransportChannelService found in server.xml.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Services found in server.xml.");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block35;
                Tr.debug(tc, "Exception getting http transports: ", new Object[]{exception.toString()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCSIInboundTranportFromChannelFramework");
        }
        return arrayList2.size() != 0 || arrayList.size() != 0;
    }

    private static boolean hasValue(String string) {
        return string != null && string.length() > 0;
    }

    static {
        propNames = SASPropFile.propNames;
    }
}

