/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import java.io.File;
import java.security.KeyStore;
import java.security.Security;
import java.util.ArrayList;

public final class SSLConfigValidation {
    static WSPKCSInKeyStoreList pkStoreL = new WSPKCSInKeyStoreList();
    static WSPKCSInKeyStore wspkStore = null;
    private static final TraceComponent tc = Tr.register(SSLConfigValidation.class, null, "com.ibm.ejs.resources.security");

    public static int checkTokenLibFile(String string, String string2, String string3, String string4, String string5, String string6) {
        int n;
        block12: {
            File file;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkTokenLibFile");
            }
            String string7 = PasswordUtil.passwordDecode(string4);
            String string8 = SSLConfigValidation.resolveInstallRoot(string2);
            n = 0;
            String string9 = string3;
            if (string9 == null || string9.equals("")) {
                string9 = "0";
            }
            if ((file = new File(string8)) == null || !file.isFile() || !file.canRead()) {
                n = 1;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tokenLib file not found.");
                }
            }
            if (n == 0) {
                try {
                    wspkStore = pkStoreL.insert(string, string8 + ":" + string9, string7, true, false);
                }
                catch (Exception exception) {
                    n = 2;
                    FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.checkTokenLibFile", "90");
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "invalid password.");
                }
            }
        }
        if (n == 0 && string5 != null && !string5.equals("") && !SSLConfigValidation.findTokenAlias(string5)) {
            n = 3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalid serverAlias.");
            }
        }
        if (n == 0 && string6 != null && !string6.equals("") && !SSLConfigValidation.findTokenAlias(string6)) {
            n = 4;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalid clientAlias.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTokenLibFile");
        }
        return n;
    }

    public static int checkKeyFile(String string, String string2, String string3, String string4, String string5) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkKeyFile");
        }
        String string6 = PasswordUtil.passwordDecode(string3);
        String string7 = SSLConfigValidation.resolveInstallRoot(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyFilename: ", string7);
        }
        int n = 0;
        boolean bl2 = true;
        int n2 = 0;
        KeyStore keyStore = null;
        ArrayList arrayList = new ArrayList();
        while (bl2) {
            try {
                keyStore = KeyStore.getInstance(string);
            }
            catch (Exception exception) {
                n = 2;
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "176");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid fileType.");
                }
                bl2 = false;
            }
            if (n != 0) continue;
            try {
                keyStore.load(WSKeyStore.openKeyStore(string7), string6 == null ? null : string6.toCharArray());
                bl2 = false;
            }
            catch (Exception exception) {
                if (exception.getMessage().equalsIgnoreCase("Invalid keystore format") || exception.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (n2 == 0) {
                        Tr.warning(tc, "security.ssl.config.initialization.warning.invalidkeystoretype");
                        arrayList = WSKeyStore.getKeyStoreTypes();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Valid keyStore list: " + arrayList.toString());
                        }
                    }
                    if (n2 >= arrayList.size()) {
                        n = 3;
                        FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "206");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "checkKeyFile", exception);
                        }
                        bl2 = false;
                    }
                    string = (String)arrayList.get(n2++);
                    continue;
                }
                n = 3;
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "219");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checkKeyFile", exception);
                }
                bl2 = false;
            }
        }
        WSKeyStore wSKeyStore = new WSKeyStore();
        if (n == 0 && string4 != null && !string4.equals("")) {
            bl = false;
            try {
                bl = keyStore.containsAlias(string4);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "242");
            }
            if (!bl) {
                n = 4;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid serverAlias.");
                }
            }
        }
        if (n == 0 && string5 != null && !string5.equals("")) {
            bl = false;
            try {
                bl = keyStore.containsAlias(string5);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", "266");
            }
            if (!bl) {
                n = 5;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid clientAlias.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyFile");
        }
        return n;
    }

    public static int checkTrustFile(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTrustFile");
        }
        String string4 = PasswordUtil.passwordDecode(string3);
        String string5 = SSLConfigValidation.resolveInstallRoot(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "trustFilename: ", string5);
        }
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        KeyStore keyStore = null;
        ArrayList<Object> arrayList = new ArrayList();
        while (bl) {
            try {
                keyStore = KeyStore.getInstance(string);
            }
            catch (Exception exception) {
                n = 2;
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.checkTrustFile", "320");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalid fileType.");
                }
                bl = false;
            }
            if (n != 0) continue;
            try {
                keyStore.load(WSKeyStore.openKeyStore(string5), string4 == null ? null : string4.toCharArray());
                bl = false;
            }
            catch (Exception exception) {
                if (exception.getMessage().equalsIgnoreCase("Invalid keystore format") || exception.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (n2 == 0) {
                        Tr.warning(tc, "security.ssl.config.initialization.warning.invalidkeystoretype");
                        arrayList = new ArrayList<String>(Security.getAlgorithms("KeyStore"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Valid keyStore list: " + arrayList.toString());
                        }
                    }
                    if (n2 >= arrayList.size()) {
                        n = 3;
                        FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.checkTrustFile", "351");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "checkTrustFile", exception);
                        }
                        bl = false;
                    }
                    string = (String)arrayList.get(n2++);
                    continue;
                }
                n = 3;
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.checkTrustFile", "364");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checkTrustFile", exception);
                }
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTrustFile");
        }
        return n;
    }

    private static String resolveInstallRoot(String string) {
        String string2 = string;
        String string3 = "${USER_INSTALL_ROOT}";
        int n = string3.length();
        if (string.startsWith(string3)) {
            String string4 = (String)SecurityConfig.getConfig().getValue(string3);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(0, n, string4);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static boolean findTokenAlias(String string) {
        KeyStore keyStore = wspkStore.getKS();
        boolean bl = false;
        try {
            bl = keyStore.containsAlias(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.SSLConfigValidation.findTokenAlias", "380");
        }
        return bl;
    }
}

