/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.security.token.TokenHolder;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public final class SecurityAdminHelper {
    private static final TraceComponent tc = Tr.register(SecurityAdminHelper.class, null, "com.ibm.ejs.resources.security");
    private static String servantId = null;
    private static final String OBJNAME_PREFIX = "WebSphere:type=SecurityAdminHelper,";
    private static SecurityAdminHelper thisObj;
    private static ObjectName thisMBean;
    private static AdminService adminServ;

    private SecurityAdminHelper() {
    }

    public static boolean initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize SecurityAdminHelper", thisMBean);
        }
        if (thisMBean == null) {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            adminServ = AdminServiceFactory.getAdminService();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Set the AdminService for this process");
            }
            if (thisObj == null) {
                thisObj = new SecurityAdminHelper();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create an instance of this class if not already in existence");
                }
            }
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(thisObj, "SecurityAdminHelper");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Register SecurityAdminHelper mbean");
            }
            Properties properties = new Properties();
            properties.setProperty("servantId", SecurityAdminHelper.getServantIdentifier());
            try {
                thisMBean = mBeanFactory.activateMBean("SecurityAdminHelper", defaultRuntimeCollaborator, "SecurityAdminHelper", "com/ibm/ws/management/descriptor/xml/SecurityAdminHelper.xml", properties);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use servantId as one of the extra property to distinguish each");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.SecurityAdminHelper.initialize", "001");
                Tr.error(tc, "security.init.mbeanerror", new Object[]{"SecurityAdminHelper", exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initialize returning false", thisMBean);
                }
                return false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize returning true", thisMBean);
        }
        return true;
    }

    public static String getServantIdentifier() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServantIdentifier", servantId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServantIdentifier", servantId);
        }
        return servantId;
    }

    public static TokenHolder getOpaqueToken(ByteArray byteArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpaqueToken(ssoToken, servantId)", new Object[]{byteArray, string});
        }
        if (servantId.equals(string)) {
            if (thisObj == null && !SecurityAdminHelper.initialize()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning null");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) invoking getOpaqueToken locally", thisObj);
            }
            TokenHolder tokenHolder = thisObj.getOpaqueToken(byteArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning", tokenHolder);
            }
            return tokenHolder;
        }
        ObjectName objectName = null;
        TokenHolder tokenHolder = null;
        try {
            Set set;
            if (adminServ == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) AdminService isn't set", adminServ);
                }
                return null;
            }
            objectName = new ObjectName("WebSphere:type=SecurityAdminHelper,servantId=" + string + ",*");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "scope: " + objectName);
            }
            if ((set = adminServ.queryNames(objectName, null)).size() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) one MBean found", String.valueOf(set.size()));
                }
                Iterator iterator = set.iterator();
                ObjectName objectName2 = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) invoking MBean", objectName2);
                }
                tokenHolder = (TokenHolder)adminServ.invoke(objectName2, "getOpaqueToken", new Object[]{byteArray}, new String[]{ByteArray.class.getName()});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning", tokenHolder);
                }
            } else {
                if (set.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) no MBean found", objectName);
                    }
                    return null;
                }
                if (set.size() > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) more than one MBean found", String.valueOf(set.size()));
                    }
                    Iterator iterator = set.iterator();
                    ObjectName objectName3 = (ObjectName)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) using MBean", objectName3);
                        while (iterator.hasNext()) {
                            Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) found MBean", iterator.next());
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getOpaqueToken(ssoToken, servantId) invoking MBean", objectName3);
                    }
                    tokenHolder = (TokenHolder)adminServ.invoke(objectName3, "getOpaqueToken", new Object[]{byteArray}, new String[]{ByteArray.class.getName()});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning", tokenHolder);
                    }
                }
            }
            return tokenHolder;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.core.SecurityAdminHelper.getOpaqueToken", "002");
            Tr.error(tc, "security.invoke.mbeanerror", new Object[]{"SecurityAdminHelper", exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken(ssoToken, servantId) returning null");
            }
            return null;
        }
    }

    public TokenHolder getOpaqueToken(ByteArray byteArray) {
        TokenHolder tokenHolder;
        byte[] byArray;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueToken");
            }
            byArray = null;
            tokenHolder = null;
            try {
                DistributedMap distributedMap = DistributedMapFactory.getMap("WSSecureMap");
                if (distributedMap != null) {
                    byArray = (byte[])distributedMap.get(byteArray);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdminHelper.getOpaqueToken", "003", this);
                if (!tc.isEntryEnabled()) break block8;
                Tr.exit(tc, "Exception occurred getting opaque token from distributed map.", new Object[]{exception});
            }
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns opaque token.");
            }
            tokenHolder = new TokenHolder(byArray, "WS_OPAQUE", 1);
        }
        return tokenHolder;
    }

    static {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Method method2 = null;
        Method method3 = null;
        Object var4_4 = null;
        Object object = null;
        try {
            clazz = Class.forName("com.ibm.ws.management.AdminServiceImpl");
            if (clazz != null) {
                method2 = clazz.getMethod("getPlatformUtils", new Class[0]);
                var4_4 = clazz.newInstance();
                if (method2 != null) {
                    clazz2 = Class.forName("com.ibm.ws.management.util.PlatformUtils");
                    object = method2.invoke(clazz, new Object[0]);
                    method3 = clazz2.getMethod("getPrintableStoken", new Class[0]);
                    servantId = (String)method3.invoke(object, new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "servantId:", servantId);
                    }
                }
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "exception " + exception.toString() + " in SecurityAdminHelper static initializer");
            throw new UndeclaredThrowableException(exception);
        }
        thisObj = null;
        thisMBean = null;
        adminServ = null;
    }
}

