/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.audit.AuditService;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class SecurityContext {
    private static final TraceComponent tc = Tr.register(SecurityContext.class, null, "com.ibm.ejs.resources.security");
    private static boolean need_to_get_security_config = true;
    private static String realm = null;
    private static boolean isbServerProcess = false;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("SecurityContext");

    public static ContextManager getContextManager() {
        return ContextManagerFactory.getInstance();
    }

    protected static void setIsServerProcess() throws WSSecurityException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting server process = true");
        }
        isbServerProcess = true;
    }

    protected static void enable(AuditService auditService) throws WSSecurityException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling ContextManager.initialize()");
        }
        ContextManagerFactory.getInstance().initialize(new Boolean(false), auditService);
    }

    public static boolean isServerProcess() {
        return isbServerProcess;
    }

    public static void initialize() throws WSSecurityException {
    }

    public static void destroy() throws WSSecurityException {
        ContextManagerFactory.getInstance().clearCallerContext();
    }

    public static boolean isSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityEnabled");
        }
        boolean bl = WSSecurityHelper.isGlobalSecurityEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecurityEnabled", bl);
        }
        return bl;
    }

    public static String getUser() {
        String string;
        block4: {
            if (!SecurityContext.isServerProcess()) {
                return null;
            }
            string = null;
            try {
                WSCredential[] wSCredentialArray = ContextManagerFactory.getInstance().getCallerCredentials();
                if (wSCredentialArray != null && wSCredentialArray.length != 0 && wSCredentialArray[0] != null && !wSCredentialArray[0].isUnauthenticated()) {
                    string = wSCredentialArray[0].getAccessId();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error in getAccessId() from caller credential", generalSecurityException);
            }
        }
        return string;
    }

    public static String getOwnName() {
        String string;
        block4: {
            if (!SecurityContext.isServerProcess()) {
                return null;
            }
            string = null;
            try {
                WSCredential wSCredential = ContextManagerFactory.getInstance().getServerCredential();
                if (wSCredential != null && !wSCredential.isUnauthenticated()) {
                    string = wSCredential.getSecurityName();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error in getSecurityName() from server credential", generalSecurityException);
            }
        }
        return SecurityContext.unqualifySecurityName(string);
    }

    public static String getName() {
        if (!SecurityContext.isServerProcess()) {
            return null;
        }
        String string = SecurityContext.getCallerNameWeb();
        return SecurityContext.unqualifySecurityName(string);
    }

    public static String getCallerName() {
        String string;
        block4: {
            if (!SecurityContext.isServerProcess()) {
                return null;
            }
            string = null;
            try {
                WSCredential[] wSCredentialArray = ContextManagerFactory.getInstance().getCallerCredentials();
                if (wSCredentialArray != null && wSCredentialArray.length != 0 && wSCredentialArray[0] != null) {
                    string = wSCredentialArray[0].getRealmSecurityName();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error in getRealmSecurityName() from caller credential", generalSecurityException);
            }
        }
        return string;
    }

    public static String getCallerNameWeb() {
        String string;
        block4: {
            if (!SecurityContext.isServerProcess()) {
                return null;
            }
            string = null;
            try {
                WSCredential[] wSCredentialArray = ContextManagerFactory.getInstance().getCallerCredentials();
                if (wSCredentialArray != null && wSCredentialArray.length != 0 && wSCredentialArray[0] != null && !wSCredentialArray[0].isUnauthenticated()) {
                    string = wSCredentialArray[0].getRealmSecurityName();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error in getRealmSecurityName() from caller credential", generalSecurityException);
            }
        }
        return string;
    }

    public static String unqualifySecurityName(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.indexOf("/");
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static Object runAsSystem(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (!SecurityContext.isServerProcess()) {
            return null;
        }
        return ContextManagerFactory.getInstance().runAsSystem(privilegedExceptionAction);
    }

    public static Object runAsReceivedClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (!SecurityContext.isServerProcess()) {
            return null;
        }
        return ContextManagerFactory.getInstance().runAsReceivedClient(privilegedExceptionAction);
    }

    public static Object runAsClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        if (!SecurityContext.isServerProcess()) {
            return null;
        }
        return ContextManagerFactory.getInstance().runAsClient(privilegedExceptionAction);
    }
}

