/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.authorize.AppInstallNotify;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityConfigException;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.delegation.DelegationFactory;
import com.ibm.ws.security.ejb.BeanPermissionRoleMapTable;
import com.ibm.ws.security.ejb.RunAsMapTable;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.web.SecurityMetaDataListener;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAppCache;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public final class ServerSecurityComponentImpl
extends ComponentImpl
implements DeployedObjectListener {
    private static final TraceComponent tc = Tr.register(ServerSecurityComponentImpl.class, null, "com.ibm.ejs.resources.security");
    private static final String DENYALL_ROLE_NAME = "DenyAllRole";
    private static boolean svrSecurityEnabled = true;
    private SecurityServer secServer = null;
    Hashtable webModulesMap;
    private MetaDataSlot mmdSlot;
    private MetaDataSlot cmdSlot;
    private static AppInstallNotify appInstallNotify = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void initialize(Object var1_1) throws ConfigurationWarning, ConfigurationError {
        block21: {
            if (ServerSecurityComponentImpl.tc.isEntryEnabled()) {
                Tr.entry(ServerSecurityComponentImpl.tc, "initialize", var1_1);
            }
            if (this.isNodeAgent()) {
                Tr.exit(ServerSecurityComponentImpl.tc, "initialize");
                return;
            }
            ServerSecurityComponentImpl.svrSecurityEnabled = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
            if (ServerSecurityComponentImpl.tc.isDebugEnabled()) {
                if (ServerSecurityComponentImpl.svrSecurityEnabled) {
                    Tr.debug(ServerSecurityComponentImpl.tc, "serverSecurityEnabled");
                } else {
                    Tr.debug(ServerSecurityComponentImpl.tc, "serverSecurityDisabled");
                }
            }
            var2_2 = null;
            this.webModulesMap = new Hashtable<K, V>();
            if (!ServerSecurityComponentImpl.svrSecurityEnabled) break block21;
            var2_2 = (Repository)this.getService(Repository.class);
            var3_3 = null;
            var4_5 = "server.xml";
            try {
                var3_3 = var2_2.getConfigRoot().getResource(4, var4_5);
            }
            catch (Exception var5_6) {
                FFDCFilter.processException((Throwable)var5_6, "com.ibm.ws.security.core.ServerSecurityComponentImpl.initialize", "177", this);
                if (ServerSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(ServerSecurityComponentImpl.tc, "Failed to load resource from process :  ", var4_5);
                }
                if (var2_2 != null) {
                    this.releaseService(var2_2);
                }
                return;
            }
            try {
                var5_7 = (Server)var3_3.getContents().get(0);
                var6_8 = new EtoolsCopyUtility();
                var5_7 = (Server)var6_8.copy((EObject)var5_7);
                var7_9 = var2_2.getConfigRoot();
                var8_10 = this.getServerAdminProps(var7_9, var5_7);
                SecurityConfig.getConfig().setValue("process.jmxConnectorProps", var8_10);
                var9_11 = (VirtualHostMgr)this.getService(VirtualHostMgr.class);
                var10_12 = new HashMap<String, Object>();
                var11_13 = null;
                var12_14 = var9_11.getVirtualHosts();
                for (var13_15 = 0; var13_15 < var12_14.length; ++var13_15) {
                    var11_13 = var12_14[var13_15];
                    var14_17 = var11_13.getName();
                    var15_18 = var11_13.getAliases();
                    var16_19 = new ArrayList<String>();
                    for (var17_20 = 0; var17_20 < var15_18.length; ++var17_20) {
                        var18_21 = var15_18[var17_20];
                        var19_22 = var18_21.getPort();
                        var16_19.add(var19_22);
                        if (!ServerSecurityComponentImpl.tc.isDebugEnabled()) continue;
                        Tr.debug(ServerSecurityComponentImpl.tc, "Adding port " + var19_22 + " to list for vHost " + var14_17);
                    }
                    var10_12.put(var14_17, var16_19.clone());
                }
                SecurityConfig.getConfig().setValue("host.virtualhosts", var10_12);
                if (var9_11 != null) {
                    this.releaseService(var9_11);
                }
                var13_16 = (EndPointMgr)this.getService(EndPointMgr.class);
                SecurityConfig.updateHTTPTransports(var5_7, var13_16);
                if (var13_16 == null) break block21;
                this.releaseService(var13_16);
            }
            catch (Exception var3_4) {
                try {
                    FFDCFilter.processException((Throwable)var3_4, "com.ibm.ws.security.core.ServerSecurityComponentImpl.initialize", "227", this);
                    Tr.warning(ServerSecurityComponentImpl.tc, "security.servcomp.init");
                    ** if (var2_2 == null) goto lbl-1000
                }
                catch (Throwable var20_23) {
                    if (var2_2 != null) {
                        this.releaseService(var2_2);
                    }
                    throw var20_23;
                }
lbl-1000:
                // 1 sources

                {
                    this.releaseService(var2_2);
                }
lbl-1000:
                // 2 sources

                {
                }
            }
        }
        if (var2_2 != null) {
            this.releaseService(var2_2);
        }
        if (ServerSecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.exit(ServerSecurityComponentImpl.tc, "initialize");
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (this.isNodeAgent()) {
            Tr.exit(tc, "start");
            return;
        }
        try {
            if (svrSecurityEnabled) {
                this.registerListenerWithMetaDataService();
            }
            ApplicationMgr applicationMgr = (ApplicationMgr)this.getService(ApplicationMgr.class);
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (!platformHelper.isZOS() || !platformHelper.isControlJvm()) {
                try {
                    applicationMgr.addDeployedObjectListener(this);
                }
                finally {
                    if (applicationMgr != null) {
                        this.releaseService(applicationMgr);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting Security Server");
            }
            SecurityService securityService = (SecurityService)this.getService(SecurityService.class);
            try {
                securityService.startSecurity();
            }
            finally {
                if (securityService != null) {
                    this.releaseService(securityService);
                }
            }
            if (svrSecurityEnabled) {
                Object object;
                boolean bl = false;
                Properties properties = (Properties)SecurityConfig.getConfig().getValue("security.toplevel.properties");
                if (properties != null && (object = (String)properties.get("com.ibm.ws.security.WSSecureMapInitAtStartup")) != null && ((String)object).equalsIgnoreCase("TRUE")) {
                    bl = true;
                }
                if (bl) {
                    object = (String)properties.get("com.ibm.ws.security.WSSecureMapSize");
                    getDMaps getDMaps2 = new getDMaps((String)object);
                    getDMaps2.start();
                } else {
                    Properties properties2;
                    object = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
                    if (((Boolean)object).booleanValue() && WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Initializing DistributedMap for security attribute propagation.");
                        }
                        properties2 = new Properties();
                        properties2.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
                        properties2.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
                        DistributedMapFactory.getMap("WSSecureMap", properties2);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initializing DistributedMap for Kerberos.");
                    }
                    properties2 = new Properties();
                    properties2.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
                    properties2.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
                    DistributedMapFactory.getMap("WSSecureMapNotShared", properties2);
                }
                if (SecurityConfig.isDefaultJaccProvider()) {
                    appInstallNotify = AppInstallNotify.getInstance();
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.start", "337", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start failed", new Object[]{exception});
            }
            throw new RuntimeError(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        TrustAssociationManager trustAssociationManager = TrustAssociationManager.getInstance();
        if (trustAssociationManager != null) {
            trustAssociationManager.cleanTAInterceptors();
        }
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged");
        }
        if ((deployedObject = (DeployedObject)deployedObjectEvent.getSource()).getModuleFile().isEARFile()) {
            if (deployedObjectEvent.getNewValue() == "STARTING") {
                if (svrSecurityEnabled) {
                    this.install(deployedObject);
                }
                this.refreshAuthDataEntries();
            } else if (deployedObjectEvent.getNewValue() == "STOPPED" && svrSecurityEnabled) {
                this.uninstall(deployedObject);
            }
        } else if (deployedObject.getModuleFile().isWARFile()) {
            if (deployedObjectEvent.getNewValue() == "STARTING") {
                if (svrSecurityEnabled) {
                    this.installWeb((DeployedModule)deployedObject);
                }
            } else if (deployedObjectEvent.getNewValue() == "STOPPED" && svrSecurityEnabled) {
                this.uninstallWeb((DeployedModule)deployedObject);
            }
        } else if (deployedObject.getModuleFile().isEJBJarFile()) {
            if (deployedObjectEvent.getNewValue() == "STARTING") {
                if (svrSecurityEnabled) {
                    this.installEJB((DeployedModule)deployedObject);
                    DelegationFactory.clearDelegationCache();
                }
            } else if (deployedObjectEvent.getNewValue() == "STOPPED" && svrSecurityEnabled) {
                this.uninstallEJB((DeployedModule)deployedObject);
                DelegationFactory.clearDelegationCache();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    private void installWeb(DeployedModule deployedModule) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installWeb", deployedModule.getName());
        }
        ModuleDeployment moduleDeployment = deployedModule.getModuleDeployment();
        WebModule webModule = (WebModule)((EARFile)deployedModule.getDeployedApplication().getModuleFile()).getModule(moduleDeployment.getUri(), moduleDeployment.getAltDD());
        String string = webModule.getContextRoot();
        String string2 = ((WebAppBinding)deployedModule.getBinding()).getVirtualHostName();
        WebModuleRef webModuleRef = (WebModuleRef)deployedModule.getModuleRef();
        String string3 = deployedModule.getDeployedApplication().getName();
        if (svrSecurityEnabled && SecurityConfig.isDefaultJaccProvider() && !WSAccessManager.checkIfAdminApp(string3)) {
            try {
                appInstallNotify.addWebPermissions(webModuleRef, string3, WSAccessManager.getContextID(string3), false, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.installWeb", "427", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "installWeb failed", new Object[]{exception});
                }
                throw new RuntimeWarning(exception);
            }
        }
        String string4 = string2 + ":" + string;
        this.webModulesMap.put(deployedModule, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installWeb");
        }
    }

    private void uninstallWeb(DeployedModule deployedModule) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallWeb", deployedModule.getName());
        }
        try {
            String string = (String)this.webModulesMap.get(deployedModule);
            String string2 = deployedModule.getDeployedApplication().getName();
            String string3 = deployedModule.getName();
            WebModuleRef webModuleRef = (WebModuleRef)deployedModule.getModuleRef();
            if (string != null) {
                WebAppCache.removeWebApp(string2, string);
                this.webModulesMap.remove(deployedModule);
            }
            if (svrSecurityEnabled && SecurityConfig.isDefaultJaccProvider() && !WSAccessManager.checkIfAdminApp(string2)) {
                appInstallNotify.deleteModule((ModuleRef)webModuleRef, string2, WSAccessManager.getContextID(string2), false);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.uninstallWeb", "469", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "uninstallWeb failed", new Object[]{exception});
            }
            throw new RuntimeWarning(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallWeb");
        }
    }

    private void installEJB(DeployedModule deployedModule) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installEJB", deployedModule.getName());
        }
        String string = deployedModule.getDeployedApplication().getName();
        String string2 = deployedModule.getName();
        EJBModuleRef eJBModuleRef = (EJBModuleRef)deployedModule.getModuleRef();
        if (svrSecurityEnabled && SecurityConfig.isDefaultJaccProvider() && !WSAccessManager.checkIfAdminApp(string)) {
            try {
                appInstallNotify.addEJBPermissions(eJBModuleRef, string, WSAccessManager.getContextID(string), false, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.installEJB", "493", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "installEJB failed", new Object[]{exception});
                }
                throw new RuntimeWarning(exception);
            }
        }
        BeanPermissionRoleMapTable.addBeanPermissionRoleMap(string + ":" + string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installEJB");
        }
    }

    private void uninstallEJB(DeployedModule deployedModule) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallEJB", deployedModule.getName());
        }
        try {
            String string = deployedModule.getDeployedApplication().getName();
            String string2 = deployedModule.getName();
            EJBModuleRef eJBModuleRef = (EJBModuleRef)deployedModule.getModuleRef();
            BeanPermissionRoleMapTable.removeBeanPermissionRoleMap(string + ":" + string2);
            if (svrSecurityEnabled && SecurityConfig.isDefaultJaccProvider() && !WSAccessManager.checkIfAdminApp(string)) {
                appInstallNotify.deleteModule((ModuleRef)eJBModuleRef, string, WSAccessManager.getContextID(string), false);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.uninstallEJB", "522", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "uninstallEJB failed", new Object[]{exception});
            }
            throw new RuntimeWarning(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallEJB");
        }
    }

    private void install(DeployedObject deployedObject) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install", deployedObject);
        }
        try {
            Object object;
            RunAsMap runAsMap;
            ApplicationBinding applicationBinding = (ApplicationBinding)deployedObject.getBinding();
            String string = deployedObject.getName();
            AuthorizationTable authorizationTable = null;
            if (SecurityConfig.nativeAuthz) {
                authorizationTable = applicationBinding.getAuthorizationTable();
                if (authorizationTable != null) {
                    this.removeSubjectsFromDenyAllRole(string, authorizationTable);
                    WSAccessManager.addAuthorizationTable(string, authorizationTable);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Authorization Table processed for Application " + string);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Authorization Table Not defined for Application " + string);
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Application " + string + " installed without Authorization Table");
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization Table in the binding file is not processed as native authorization is not used.");
            }
            if ((runAsMap = applicationBinding.getRunAsMap()) != null) {
                RunAsMapTable.addRunAsMap(string, runAsMap);
                object = runAsMap.getRunAsBindings();
                if (object.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RunAsMap Not defined properly for Application " + string);
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event(tc, "RunAsMap processed for Application " + string);
                }
            }
            if (SecurityConfig.isJACCEnabled() && (object = ((DeployedApplication)deployedObject).getApplicationDeployment().getAppContextIDForSecurity()) != null) {
                WSAccessManager.storeContextID(string, (String)object);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.install", "597", this);
            Tr.error(tc, "security.servcomp.init");
            Tr.debug(tc, "Exception occurred in application install.", new Object[]{exception});
            throw new RuntimeWarning(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
    }

    private void uninstall(DeployedObject deployedObject) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstall", deployedObject);
        }
        try {
            String string = deployedObject.getName();
            if (SecurityConfig.nativeAuthz) {
                WSAccessManager.removeAuthorizationTable(string);
            }
            RunAsMapTable.removeRunAsMap(string);
            if (SecurityConfig.isJACCEnabled()) {
                WSAccessManager.removeContextID(string);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.uninstall", "634", this);
            throw new RuntimeWarning(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstall");
        }
    }

    protected void removeSubjectsFromDenyAllRole(String string, AuthorizationTable authorizationTable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUsersFromDenyAllRole", string);
        }
        boolean bl = false;
        EList eList = authorizationTable.getAuthorizations();
        for (int i = 0; i < eList.size(); ++i) {
            RoleAssignment roleAssignment = (RoleAssignment)eList.get(i);
            String string2 = roleAssignment.getRole().getRoleName();
            if (string2 != null && string2.equals(DENYALL_ROLE_NAME)) {
                EList eList2;
                EList eList3;
                EList eList4 = roleAssignment.getUsers();
                if (eList4 != null && eList4.size() > 0) {
                    roleAssignment.getUsers().clear();
                    bl = true;
                }
                if ((eList3 = roleAssignment.getGroups()) != null && eList3.size() > 0) {
                    roleAssignment.getGroups().clear();
                    bl = true;
                }
                if ((eList2 = roleAssignment.getSpecialSubjects()) != null && eList2.size() > 0) {
                    roleAssignment.getSpecialSubjects().clear();
                    bl = true;
                }
                if (!bl) continue;
                Tr.warning(tc, "security.servcomp.remove.DenyAllRole", new Object[]{string});
                continue;
            }
            if (string2 != null) continue;
            Tr.debug(tc, "auth.getRole().getRoleName() returns null, there might be a problem in the descriptors.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeUsersFromDenyAllRole");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAuthDataEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAuthDataEntries");
        }
        Repository repository2 = (Repository)this.getService(Repository.class);
        ConfigRoot configRoot = repository2.getConfigRoot();
        try {
            Resource resource = null;
            String string = "security.xml";
            try {
                resource = configRoot.getResource(0, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.refreshAuthDataEntries", "712", this);
                Tr.error(tc, "security.loadresource.error", new Object[]{string, exception});
                throw exception;
            }
            Security security2 = (Security)resource.getContents().get(0);
            if (security2 == null) {
                throw new SecurityConfigException("Cannot get the Security object. Security.xml may not exist");
            }
            SecurityConfig.getConfig().refreshAuthDataEntries(security2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.refreshAuthDataEntries", "723", this);
            Tr.error(tc, "security.servcomp.init");
        }
        finally {
            if (repository2 != null) {
                this.releaseService(repository2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAuthDataEntries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getServerAdminProps(ConfigRoot configRoot, Server server2) throws Exception {
        Properties properties;
        block34: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServerAdminProps");
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            properties = new Properties();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            try {
                String string7;
                EList eList;
                Properties properties2;
                SecurityService securityService;
                String string8;
                String string9;
                Object object;
                Object object2;
                properties.setProperty("isInternal", "true");
                EList eList2 = server2.getServices();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Number of custom services: " + eList2.size());
                }
                AdminService adminService = null;
                Class clazz = AdminService.class;
                Object object3 = eList2.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Custom service: " + object2);
                    }
                    if (!clazz.isInstance(object2)) continue;
                    adminService = (AdminService)object2;
                    break;
                }
                if (adminService != null) {
                    Property property;
                    object3 = adminService.getPreferredConnector();
                    if (object3 instanceof SOAPConnector || !(object3 instanceof RMIConnector)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Preferred connector type is SOAP.");
                        }
                        properties.setProperty("type", "SOAP");
                        string4 = "SOAP";
                        object2 = object3.getProperties();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            string9 = object.next();
                            property = (Property)string9;
                            if (property.getName().equals("sslConfig")) {
                                string8 = property.getValue();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "SSLConfig alias to use: " + string8);
                                }
                                if (string8 == null) continue;
                                securityService = null;
                                try {
                                    securityService = (SecurityService)this.getService(class$com$ibm$ws$security$service$SecurityService == null ? ServerSecurityComponentImpl.class$("com.ibm.ws.security.service.SecurityService") : class$com$ibm$ws$security$service$SecurityService);
                                    if (securityService == null || (properties2 = securityService.getSecureSocketLayer(string8)) == null) continue;
                                    eList = properties2.propertyNames();
                                    while (eList.hasMoreElements()) {
                                        String string10 = (String)eList.nextElement();
                                        string7 = properties2.getProperty(string10);
                                        if (string10 == null || string7 == null) continue;
                                        properties.setProperty(string10, string7);
                                    }
                                    continue;
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.getServerAdminProps", "822", this);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Exception occurred getting SSLProps.", new Object[]{exception});
                                    continue;
                                }
                                finally {
                                    if (securityService != null) {
                                        this.releaseService(securityService);
                                    }
                                    continue;
                                }
                            }
                            properties.setProperty(property.getName(), property.getValue());
                        }
                    } else if (object3 instanceof RMIConnector) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Preferred connector type is RMI.");
                        }
                        properties.setProperty("type", "RMI");
                        string4 = "RMI";
                        object2 = object3.getProperties();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            string9 = object.next();
                            property = (Property)string9;
                            properties.setProperty(property.getName(), property.getValue());
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Admin service is null.");
                }
                if (((StringTokenizer)(object2 = new StringTokenizer((String)(object3 = (String)SecurityConfig.getConfig().getValue("process.serverName")), ":"))).countTokens() == 3) {
                    string3 = ((StringTokenizer)object2).nextToken();
                    string2 = ((StringTokenizer)object2).nextToken();
                    string = ((StringTokenizer)object2).nextToken();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cell:node:server = " + string3 + ":" + string2 + ":" + string);
                    }
                }
                object = configRoot.list(3, null);
                string9 = configRoot.getValue(3);
                block11: for (int i = 0; i < ((Object)object).length; ++i) {
                    if (!((String)object[i]).equals(string2)) continue;
                    configRoot.setValue(3, (String)object[i]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node name: " + (String)object[i]);
                    }
                    string8 = configRoot.getResource(3, "serverindex.xml");
                    securityService = string8.getContents();
                    properties2 = (ServerIndex)string8.getContents().get(0);
                    eList = properties2.getServerEntries();
                    for (int j = 0; j < eList.size(); ++j) {
                        String string11;
                        string7 = (ServerEntry)eList.get(j);
                        if (string7 == null || !(string11 = string7.getServerType()).equals("APPLICATION_SERVER") || !string7.getServerName().equals(string)) continue;
                        EndPoint endPoint = null;
                        EndPoint endPoint2 = null;
                        EList eList3 = string7.getSpecialEndpoints();
                        for (int k = 0; k < eList3.size(); ++k) {
                            NamedEndPoint namedEndPoint = (NamedEndPoint)eList3.get(k);
                            if (namedEndPoint.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) {
                                endPoint = namedEndPoint.getEndPoint();
                            }
                            if (!namedEndPoint.getEndPointName().equals("BOOTSTRAP_ADDRESS") || (endPoint2 = namedEndPoint.getEndPoint()) == null) continue;
                            string6 = new Integer(endPoint2.getPort()).toString();
                            string5 = endPoint2.getHost();
                            properties.setProperty("java.naming.provider.url", "corbaloc:iiop:" + string5 + ":" + string6 + "/" + "WsnAdminNameService");
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "PROVIDER_URL: corbaloc:iiop:" + string5 + ":" + string6);
                        }
                        if (endPoint != null && string4.equals("SOAP")) {
                            properties.setProperty("port", new Integer(endPoint.getPort()).toString());
                            properties.setProperty("host", endPoint.getHost());
                            continue block11;
                        }
                        if (endPoint2 == null || !string4.equals("RMI")) continue block11;
                        properties.setProperty("port", new Integer(endPoint2.getPort()).toString());
                        properties.setProperty("host", endPoint2.getHost());
                        continue block11;
                    }
                }
                configRoot.setValue(3, string9);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.getServerAdminProps", "946", this);
                if (!tc.isDebugEnabled()) break block34;
                Tr.debug(tc, "Exception occurred getting SSLProps.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAdminProps");
        }
        return properties;
    }

    private boolean registerListenerWithMetaDataService() {
        boolean bl;
        block6: {
            bl = true;
            SecurityMetaDataListener securityMetaDataListener = null;
            try {
                MetaDataService metaDataService = (MetaDataService)this.getService(MetaDataService.class);
                if (metaDataService != null) {
                    this.mmdSlot = metaDataService.reserveSlot(ModuleMetaData.class);
                    this.cmdSlot = metaDataService.reserveSlot(ComponentMetaData.class);
                    securityMetaDataListener = new SecurityMetaDataListener();
                    metaDataService.addMetaDataListener(securityMetaDataListener);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "registered MetaDataListener: " + securityMetaDataListener);
                    }
                } else {
                    bl = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempt to register MetaDataListener failed: metaDataService is null.");
                    }
                }
            }
            catch (Exception exception) {
                bl = false;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.registerListenerWithMetaDataService", "981", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "attempt to register MetaDataListener failed." + exception.getMessage());
            }
        }
        return bl;
    }

    private boolean isNodeAgent() {
        return AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent");
    }

    class getDMaps
    extends Thread {
        String stringCacheSize;

        getDMaps(String string) {
            this.stringCacheSize = string;
        }

        public void run() {
            Serializable serializable;
            int n;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDmaps.run");
            }
            boolean bl = false;
            if (this.stringCacheSize != null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSSecureMap stringCacheSize is " + this.stringCacheSize);
                    }
                    if ((n = ((Integer)(serializable = Integer.valueOf(this.stringCacheSize))).intValue()) < 100) {
                        Tr.warning(tc, "WSSecureMapSize value " + n + " is too small and will be ignored.  Must be at least 100");
                    } else {
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Tr.warning(tc, "WSSecureMapSize value " + this.stringCacheSize + " is not a valid integer.  It will be ignored.");
                }
            }
            serializable = new Properties();
            if (bl) {
                ((Properties)serializable).put("com.ibm.ws.cache.CacheConfig.cacheSize", this.stringCacheSize);
            }
            ((Properties)serializable).put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
            ((Properties)serializable).put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
            n = 0;
            DistributedMap distributedMap = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing DistributedMap for Kerberos on separate thread.");
            }
            while ((distributedMap = DistributedMapFactory.getMap("WSSecureMapNotShared", (Properties)serializable)) == null && n < 60) {
                ++n;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DistributedMap is null during security start.  Wait a half second then do retry " + n);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    Tr.error(tc, "Caught exception in Thread.sleep " + exception.toString());
                }
            }
            if (distributedMap == null) {
                Tr.warning(tc, "Unable to initialize WSSecureMapNotShared during security start.");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initialized dmap after this many retries: " + n);
            }
            distributedMap = null;
            Boolean bl2 = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
            if (bl2.booleanValue() && WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initializing DistributedMap for security attribute propagation on separate thread.");
                }
                Properties properties = new Properties();
                if (bl) {
                    properties.put("com.ibm.ws.cache.CacheConfig.cacheSize", this.stringCacheSize);
                }
                properties.put("com.ibm.ws.cache.CacheConfig.enableDiskOffload", "false");
                properties.put("com.ibm.ws.cache.CacheConfig.diskOffloadLocation", "");
                distributedMap = DistributedMapFactory.getMap("WSSecureMap", properties);
            }
            if (distributedMap == null) {
                Tr.warning(tc, "Unable to initialize WSSecureMap during security start.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDmaps.run");
            }
        }
    }
}

