/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.UserMapping;
import com.ibm.websphere.security.UserMappingException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;

public class UserMappingImpl
implements UserMapping {
    private static final TraceComponent tc = Tr.register(UserMappingImpl.class, null, "com.ibm.ejs.resources.security");
    private static UserRegistry registry;
    private UserMapping customMapping;
    public static final String MAPPING_USERS_PROPERTY = "WAS_customUserMappingImpl";

    public String mapCertificateToName(X509Certificate[] x509CertificateArray) throws UserMappingException, NotImplementedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificateToName");
        }
        String string = null;
        boolean bl = this.checkCustomMapping();
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using customMapping for certificates");
            }
            try {
                string = this.customMapping.mapCertificateToName(x509CertificateArray);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapCertificateToName", string);
                }
                return string;
            }
            catch (NotImplementedException notImplementedException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using defaultMapping for certificate mapping");
        }
        if (registry == null) {
            registry = this.getUserRegistry();
        }
        try {
            string = registry.mapCertificate(x509CertificateArray);
        }
        catch (CertificateMapNotSupportedException certificateMapNotSupportedException) {
            int n;
            String string2;
            int n2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The user registry does not support mapCertificate. Mapping using first name in the certificate");
            }
            string = (n2 = (string2 = x509CertificateArray[0].getSubjectDN().getName()).indexOf("=")) == -1 ? string2 : ((n = string2.indexOf(",")) == -1 ? string2.substring(n2 + 1) : string2.substring(n2 + 1, n));
        }
        catch (CertificateMapFailedException certificateMapFailedException) {
            FFDCFilter.processException((Throwable)certificateMapFailedException, "com.ibm.UserMappingImpl.mapCertificateToName", "87", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The following exception occurred in UserMappingImpl when calling mapCertificate: ", new Object[]{certificateMapFailedException});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapCertificateToName");
            }
            throw new UserMappingException(certificateMapFailedException.getMessage());
        }
        catch (CustomRegistryException customRegistryException) {
            FFDCFilter.processException((Throwable)customRegistryException, "com.ibm.UserMappingImpl.mapCertificateToName", "92", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The following exception occurred in UserMappingImpl when calling mapCertificate: ", new Object[]{customRegistryException});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapCertificateToName");
            }
            throw new UserMappingException(customRegistryException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.UserMappingImpl.mapCertificateToName", "97", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The following exception occurred in UserMappingImpl when calling mapCertificate: ", new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapCertificateToName");
            }
            throw new UserMappingException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificateToName", string);
        }
        return string;
    }

    public String mapDNToName(String string) throws UserMappingException, NotImplementedException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapDNToName", string);
        }
        String string2 = null;
        boolean bl = this.checkCustomMapping();
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using customMapping for DN mapping");
            }
            try {
                string2 = this.customMapping.mapDNToName(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapDNToName", string2);
                }
                return string2;
            }
            catch (NotImplementedException notImplementedException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using defaultMapping for DN mapping");
        }
        if (((String)SecurityConfig.getConfig().getValue("security.activeUserRegistryType")).equals("LDAP")) {
            block14: {
                Boolean bl2 = (Boolean)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.expandX500ExtendedAttribute");
                if (bl2 != null && bl2.booleanValue() && string.indexOf("2.5.4.46=#") != -1) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Convert OID:2.5.4.46 to DNQUALIFIER");
                        }
                        X500Principal x500Principal = new X500Principal(string);
                        string = x500Principal.toString();
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Fail to Convert OID:2.5.4.46 to DNQUALIFIER, use the original DN.");
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapDNToName", string);
            }
            return string;
        }
        int n2 = string.indexOf("=");
        string2 = n2 == -1 ? string : ((n = string.indexOf(",")) == -1 ? string.substring(n2 + 1) : string.substring(n2 + 1, n));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapDNToName", string2);
        }
        return string2;
    }

    public String mapPrincipalToName(String string) throws UserMappingException, NotImplementedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapPrincipalToName");
        }
        String string2 = null;
        boolean bl = this.checkCustomMapping();
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using customMapping for Principal mapping");
            }
            try {
                string2 = this.customMapping.mapPrincipalToName(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapPrincipalToName", string2);
                }
                return string2;
            }
            catch (NotImplementedException notImplementedException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using defaultMapping for Principal mapping");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapPrincipalToName", string);
        }
        return string;
    }

    private boolean checkCustomMapping() throws UserMappingException {
        Properties properties;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCustomMapping");
        }
        if ((string = (String)(properties = (Properties)SecurityConfig.getConfig().getValue("security.toplevel.properties")).get(MAPPING_USERS_PROPERTY)) != null && string.trim().length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using custom mapping for certificates: " + string);
            }
            try {
                Class clazz = ExtClassLoader.getInstance().loadClass(string);
                Object t = clazz.newInstance();
                this.customMapping = (UserMapping)t;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom user mapping: " + string + " successfully loaded");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCustomMapping", "true");
                }
                return true;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.security.core.UserMappingImpl.mapCertificateToName", "126", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The following exception occurred in UserMappingImpl when loading the custom implementation: ", new Object[]{throwable});
                }
                throw new UserMappingException(throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCustomMapping", "false");
        }
        return false;
    }

    private UserRegistry getUserRegistry() throws UserMappingException {
        ContextManager contextManager;
        Object var2_1 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UserMapping:getUserRegistry");
        }
        if ((contextManager = ContextManagerFactory.getInstance()) != null) {
            try {
                registry = contextManager.getRegistry(contextManager.getDefaultRealm());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.UserMappingImpl.getUserRegistry", "142");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to get registry from ContextManager");
                }
                Tr.error(tc, "security.sambean.urerr", new Object[]{exception});
                throw new UserMappingException(exception.getMessage());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to get ContextManager");
            }
            Tr.error(tc, "security.sambean.nullsecserver");
            throw new UserMappingException("Unable to get ContextManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UserMapping:getUserRegistry");
        }
        return registry;
    }
}

