/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.localOSORB;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.csiv2.zOSCSIv2PerformPolicy;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class NativeCSIv2PerformPolicyData
implements zOSCSIv2PerformPolicy {
    private static final TraceComponent tc = Tr.register(NativeCSIv2PerformPolicyData.class, "Security", "com.ibm.ejs.resources.security");
    private ByteBuffer m_NativeByteBuffer;
    private byte[] m_readWriteByteArray;
    private boolean[] m_performFlags;
    private static final int PERFORM_IDENTITY_ASSERTION_INDEX = 0;
    private static final int PERFORM_AUTHORIZATION_TOKEN_INDEX = 1;
    private static final int PERFORM_CLIENT_AUTHENTICATION_INDEX = 2;
    private static final int PERFORM_SSL_INDEX = 3;
    private static final int PERFORM_SSL_CONFIDENTIALITY_INDEX = 4;
    private static final int PERFORM_SSL_INTEGRITY_INDEX = 5;
    private static final int PERFORM_SSL_CLIENT_AUTH_INDEX = 6;
    private static final int IS_STATEFUL_INDEX = 7;
    private static final int CSIv2PPDSize_OFFSET = 0;
    private static final int CSIv2PPDPerformFlags_OFFSET = 4;
    private static final int CSIv2PPDPerformFlags_LENGTH = 8;
    private static final int CSIv2PPDPerformFlag1_OFFSET = 4;
    private static final int CSIv2PPDPerformFlag2_OFFSET = 5;
    private static final int CSIv2PPDPerformFlag3_OFFSET = 6;
    private static final int CSIv2PPDPerformFlag4_OFFSET = 7;
    private static final int CSIv2PPDPerformFlag5_OFFSET = 8;
    private static final int CSIv2PPDPerformFlag6_OFFSET = 9;
    private static final int CSIv2PPDPerformFlag7_OFFSET = 10;
    private static final int CSIv2PPDPerformFlag8_OFFSET = 11;
    private static final int CSIv2PPDClientAuthMechOID_Offset_OFFSET = 12;
    private static final int CSIv2PPDClientAuthMechOID_Len_OFFSET = 16;
    private static final int CSIv2PPDTargetSecurityName_Offset_OFFSET = 20;
    private static final int CSIv2PPDTargetSecurityName_Len_OFFSET = 24;
    private static final int CSIv2PPDTargetHostName_Offset_OFFSET = 28;
    private static final int CSIv2PPDTargetHostName_Len_OFFSET = 32;
    private static final int CSIv2PPDTargetTCPPort_OFFSET = 36;
    private static final int CSIv2PPDTargetSSLPort_OFFSET = 40;
    private static final int CSIv2PPDServiceConfig_Offset_OFFSET = 44;
    private static final int CSIv2PPDServiceConfig_Len_OFFSET = 48;
    private static final int CSIv2PPDData_OFFSET = 52;

    public NativeCSIv2PerformPolicyData() {
        this.m_NativeByteBuffer = null;
        this.m_readWriteByteArray = null;
        this.m_performFlags = null;
    }

    public NativeCSIv2PerformPolicyData(ByteBuffer byteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byteBuffer);
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException();
        }
        this.m_NativeByteBuffer = byteBuffer;
        this.m_readWriteByteArray = new byte[this.m_NativeByteBuffer.capacity()];
        this.m_NativeByteBuffer.position(0);
        this.m_NativeByteBuffer.get(this.m_readWriteByteArray, 0, this.m_readWriteByteArray.length);
        this.m_performFlags = new boolean[8];
        this.getCSIv2PPDPerformFlags(this.m_performFlags);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private byte[] getBytes(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBytes", new Object[]{new Integer(n), new Integer(n2)});
        }
        byte[] byArray = null;
        int n3 = 0;
        n3 = this.m_NativeByteBuffer.getInt(n);
        if (n3 > 0) {
            int n4 = this.m_NativeByteBuffer.getInt(n2);
            byArray = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray[i] = this.m_readWriteByteArray[52 + n4 + i];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes", byArray);
        }
        return byArray;
    }

    private String getString(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString", new Object[]{new Integer(n), new Integer(n2)});
        }
        String string = null;
        int n3 = 0;
        n3 = this.m_NativeByteBuffer.getInt(n);
        if (n3 > 0) {
            int n4 = this.m_NativeByteBuffer.getInt(n2);
            try {
                string = new String(this.m_readWriteByteArray, 52 + n4, n3, "IBM-1047");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getString", string);
        }
        return string;
    }

    public void getCSIv2PPDPerformFlags(boolean[] blArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIv2PPDPerformFlags", blArray);
        }
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.m_readWriteByteArray[4 + i] != 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIv2PPDPerformFlags", blArray);
        }
    }

    public String getPerformClientAuthMechOID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPerformClientAuthMechOID");
        }
        String string = this.getString(16, 12);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerformClientAuthMechOID", string);
        }
        return string;
    }

    public String getTargetSecurityName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetSecurityName");
        }
        String string = this.getString(24, 20);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetSecurityName", string);
        }
        return string;
    }

    public String getCurrentSecurityName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentSecurityName");
        }
        String string = ContextManagerFactory.getInstance().getDefaultRealm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentSecurityName", string);
        }
        return string;
    }

    public String getTargetHostName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetHostName");
        }
        String string = this.getString(32, 28);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetHostName", string);
        }
        return string;
    }

    public int getTargetTCPPort() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetTCPPort");
        }
        int n = this.m_NativeByteBuffer.getInt(36);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetTCPPort", new Integer(n));
        }
        return n;
    }

    public int getTargetSSLPort() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetSSLPort");
        }
        int n = this.m_NativeByteBuffer.getInt(40);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetSSLPort", new Integer(n));
        }
        return n;
    }

    public String getServiceCfgList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceCfgList");
        }
        String string = this.getString(48, 44);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceCfgList", string);
        }
        return string;
    }

    public boolean performIdentityAssertion() {
        return this.m_performFlags[0];
    }

    public boolean performAuthorizationToken() {
        return this.m_performFlags[1];
    }

    public boolean performClientAuthentication() {
        return this.m_performFlags[2];
    }

    public boolean performSSL() {
        return this.m_performFlags[3];
    }

    public boolean performSSLConfidentiality() {
        return this.m_performFlags[4];
    }

    public boolean performSSLIntegrity() {
        return this.m_performFlags[5];
    }

    public boolean performSSLClientAuth() {
        return this.m_performFlags[6];
    }

    public boolean isStateful() {
        return this.m_performFlags[7];
    }

    public String[] getPerformIDANamingMechList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPerformIDANamingMechList");
        }
        String[] stringArray = new String[]{""};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerformIDANamingMechList", stringArray);
        }
        return stringArray;
    }

    public int getPerformIdentityTokenType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPerformIdentityTokenType");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerformIdentityTokenType");
        }
        return 0;
    }
}

