/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.localOSORB;

import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.UserMappingImpl;
import com.ibm.ws.security.localOSORB.NativeCSIv2PerformPolicyData;
import com.ibm.ws.security.localOSORB.SecurityORBInterface;
import com.ibm.ws.security.ltpa.AuthzPropToken;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.token.PropagationTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.x500.X500Principal;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;

public final class SecurityORBImpl
implements SecurityORBInterface {
    private static final TraceComponent tc = Tr.register(SecurityORBImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final int IDTypeServer = 2;
    private static final int IDTypeClNative = 4;
    private static final int IDTypeClUnauthenticated = 8;
    private static final int IDTypeDefault = 14;
    private static SecurityORBImpl soi = new SecurityORBImpl();
    private ContextManager contextManager = null;
    private SecurityCache cache = null;
    private WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private boolean defaultControllerOutboundIsServer = false;
    private Boolean isSAFRegistry = null;
    private Boolean securityDisabled = null;
    public static final int UID_PW_LOGIN_FAILED_MINOR = -910016206;
    public static final int LTPA_LOGIN_FAILED_MINOR = -910016205;
    public static final int UNABLE_TO_ASSERT_ID_MINOR = -910016204;

    public static final SecurityORBImpl getSecurityORB() {
        return soi;
    }

    private SecurityORBImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.contextManager = ContextManagerFactory.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityCache getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCache");
        }
        SecurityORBImpl securityORBImpl = soi;
        synchronized (securityORBImpl) {
            this.cache = AuthCache.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCache", this.cache);
        }
        return this.cache;
    }

    public void initialize(String string, int n, String string2, int n2, int n3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{string, new Integer(n), string2, new Integer(n2), new Integer(n3)});
        }
        if (!PlatformHelperFactory.getPlatformHelper().isClientJvm()) {
            // empty if block
        }
        this.defaultControllerOutboundIsServer = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSAFRegistry() {
        if (this.isSAFRegistry != null) {
            return this.isSAFRegistry;
        }
        SecurityORBImpl securityORBImpl = this;
        synchronized (securityORBImpl) {
            if (!PlatformHelperFactory.getPlatformHelper().isClientJvm()) {
                String string = this.contextManager.getProperty("security.use.localos.userregistry");
                this.isSAFRegistry = new Boolean(string);
            }
        }
        return this.isSAFRegistry;
    }

    private boolean isSecurityDisabled() {
        if (this.securityDisabled != null) {
            return this.securityDisabled;
        }
        this.securityDisabled = new Boolean(!this.contextManager.isServerSecurityEnabled());
        return this.securityDisabled;
    }

    public void connectReceivedCredentials(int n, byte[] byArray, int n2, byte[] byArray2, byte[] byArray3, boolean bl, byte[] byArray4, int n3, String string, int n4, String string2, String string3, long l, byte[] byArray5, String string4) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connectReceivedCredential", new Object[]{new Integer(n), byArray, new Integer(n2), byArray2, byArray3, new Boolean(bl), byArray4, new Integer(n3), string, new Integer(n4), string2, string3, new Long(l), byArray5, string4 == null ? "null" : "****"});
        }
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        String string5 = (String)securityConfig.getValue("com.ibm.ws.security.defaultLoginConfig");
        Subject subject = null;
        if (n3 == 2) {
            try {
                subject = this.contextManager.getServerSubject();
            }
            catch (Exception exception) {
                throw new RemoteException("getServerSubject failure: " + exception.getMessage(), exception);
            }
        }
        if (n3 == 8 || n3 == 14) {
            try {
                subject = this.contextManager.createUnauthenticatedSubject();
            }
            catch (Exception exception) {
                throw new RemoteException("getUnauthenticatedCredential failure: " + exception.getMessage(), exception);
            }
        }
        if (null != string4) {
            try {
                subject = this.contextManager.login(string2, string, string4, securityConfig.getRMIInboundLoginConfig(), null, null, null);
            }
            catch (Exception exception) {
                this.throwNoPermission(exception, -910016206);
            }
        } else if (n > 0) {
            try {
                subject = this.doCSIv2Token(n, byArray, string2, byArray4, byArray3);
            }
            catch (Exception exception) {
                this.throwNoPermission(exception, -910016205);
            }
        } else if (n2 == 0) {
            String string6;
            String string7 = string6 = string2 != null ? string2 : this.contextManager.getDefaultRealm();
            if (PlatformHelperFactory.getPlatformHelper().isControlJvm()) {
                try {
                    subject = this.contextManager.login(string6, string, string5, null, null, null);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Login failed", exception);
                    }
                    if (n3 == 14 || n3 == 4) {
                        try {
                            subject = this.contextManager.createUnauthenticatedSubject();
                        }
                        catch (Exception exception2) {
                            throw new RemoteException("getUnauthenticatedCredential failure: " + exception2.getMessage(), exception2);
                        }
                    }
                    throw new RemoteException("Authentication failed", exception);
                }
            } else {
                if (this.isSAFRegistry()) {
                    // empty if block
                }
                try {
                    subject = this.contextManager.login(string6, string, securityConfig.getRMIInboundLoginConfig(), null, null, null);
                }
                catch (Exception exception) {
                    throw new RemoteException("Authentication failed", exception);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "idType is " + n2);
        }
        if (n2 > 0) {
            if (n3 == 8 || n3 == 14 || this.contextManager.getUnauthenticatedString().equals(new String(byArray2))) {
                try {
                    subject = this.contextManager.createUnauthenticatedSubject();
                }
                catch (Exception exception) {
                    throw new RemoteException("Could not acquire unauthenticated credential", exception);
                }
            }
            if (n > 0) {
                this.checkID(subject);
                try {
                    this.contextManager.clearCallerContext();
                }
                catch (Exception exception) {
                    Tr.event(tc, "Unexpected exception from clearCallerContext", exception);
                }
            }
            try {
                subject = this.doCSIv2Token(n2, byArray2, string2, byArray4, byArray3);
            }
            catch (Exception exception) {
                this.throwNoPermission(exception, -910016204);
            }
        }
        try {
            this.contextManager.initializeCallerContext(subject);
        }
        catch (WSSecurityException wSSecurityException) {
            Tr.event(tc, "security.ORB.WSSecurityException", wSSecurityException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectReceivedCredential");
        }
    }

    public void disconnectReceivedCredentials() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disconnectReceivedCredentials");
        }
        try {
            byte[] byArray;
            WSCredentialImpl wSCredentialImpl;
            if (PlatformHelperFactory.getPlatformHelper().isClientJvm() || (wSCredentialImpl = (WSCredentialImpl)SubjectHelper.getWSCredentialFromSubject(this.contextManager.getCallerSubject())) == null || (byArray = wSCredentialImpl.getCredentialToken()) != null) {
                // empty if block
            }
            this.contextManager.clearCallerContext();
        }
        catch (Exception exception) {
            Tr.event(tc, "caught callerCred exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disconnectReceivedCredential");
        }
    }

    private int getNscTokenFromSubject(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNscTokenFromSubject", subject);
        }
        int n = 0;
        PlatformCredential platformCredential = null;
        try {
            platformCredential = (PlatformCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                    if (wSCredential != null) {
                        return wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.SecurityORBImpl.getNscTokenFromSubject", "695", this);
            if (exception instanceof CredentialDestroyedException) {
                Tr.event(tc, "security.cred.CredentialDestroyedException", exception);
            }
            if (exception instanceof CredentialExpiredException) {
                Tr.event(tc, "security.cred.CredentialExpiredException", exception);
            }
            Tr.event(tc, "security.ORB.WSSecurityException", new WSSecurityException(exception));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Platform credential", platformCredential);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNscTokenFromSubject", new Integer(n));
        }
        return n;
    }

    private X509Certificate[] convertCertificate(byte[] byArray) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCertificate", byArray);
        }
        X509Certificate[] x509CertificateArray = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(dataInputStream);
            x509CertificateArray = collection.toArray(new X509Certificate[0]);
        }
        catch (Exception exception) {
            throw new RemoteException("Certificate conversion failed", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertCertificate", x509CertificateArray);
        }
        return x509CertificateArray;
    }

    private Subject doCSIv2Token(int n, byte[] byArray, String string, byte[] byArray2, byte[] byArray3) throws Exception {
        ArrayList arrayList;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doCSIv2Token", new Object[]{new Integer(n), byArray, string, byArray2, byArray3});
        }
        Subject subject = null;
        try {
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() && byArray2 != null && (subject = this.getCache().getSubject(byArray2)) != null && !this.getWSCredTokenMapper().checkValidityOfAllTokens(subject)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing expired credential from cache", subject);
                }
                object = SubjectHelper.getWSCredentialFromSubject(subject);
                this.getCache().removeEntry(object.getRealmName(), object.getSecurityName());
                subject = null;
            }
            if ((WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled()) && byArray3 != null && subject != null) {
                object = WSOpaqueTokenHelper.getInstance();
                arrayList = ((WSOpaqueTokenHelper)object).createTokenHolderListFromOpaqueToken(byArray3);
                for (int i = 0; i < arrayList.size(); ++i) {
                    TokenHolder tokenHolder = (TokenHolder)arrayList.get(i);
                    if (!tokenHolder.getName().equals("com.ibm.ws.security.token.PropagationTokenImpl")) continue;
                    final PropagationTokenImpl propagationTokenImpl = new PropagationTokenImpl();
                    AuthzPropToken authzPropToken = new AuthzPropToken(tokenHolder.getBytes(), null, null, null);
                    propagationTokenImpl.initializeToken(authzPropToken);
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            String string = propagationTokenImpl.getName() + ":" + propagationTokenImpl.getVersion();
                            SecurityORBImpl.this.contextManager.setPropagationToken(string, propagationTokenImpl);
                            return null;
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.localOSORB.SecurityORBImpl.doCSIv2Token", "834", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Cached login failed, logging in", exception);
            }
            subject = null;
        }
        if (subject == null) {
            if ((WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled()) && byArray3 != null) {
                object = WSOpaqueTokenHelper.getInstance();
                arrayList = ((WSOpaqueTokenHelper)object).createTokenHolderListFromOpaqueToken(byArray3);
                this.contextManager.put(((WSOpaqueTokenHelper)object).getOpaqueTokenLookup(), arrayList);
            }
            subject = this.doCSIv2Login(n, byArray, string, byArray2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCSIv2Token", subject);
        }
        return subject;
    }

    /*
     * Unable to fully structure code
     */
    private Subject doCSIv2Login(int var1_1, byte[] var2_2, String var3_3, byte[] var4_4) throws WSSecurityException {
        if (SecurityORBImpl.tc.isEntryEnabled()) {
            Tr.entry(SecurityORBImpl.tc, "doCSIv2Login", new Object[]{new Integer(var1_1), var2_2, var3_3, var4_4});
        }
        var5_5 = null;
        try {
            this.contextManager.put("CacheKeyAttribute", var4_4);
            var6_6 = SecurityConfig.getConfig().getRMIInboundLoginConfig();
            switch (var1_1) {
                case 1: {
                    if (SecurityORBImpl.tc.isDebugEnabled()) {
                        Tr.debug(SecurityORBImpl.tc, "token login", var2_2);
                    }
                    var5_5 = this.contextManager.login(var3_3, var2_2, var6_6, null, null, null);
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 3: {
                    if (SecurityORBImpl.tc.isDebugEnabled()) {
                        Tr.debug(SecurityORBImpl.tc, "uid login", var2_2);
                    }
                    var5_5 = this.contextManager.login(var3_3, new String(var2_2));
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 4: {
                    if (SecurityORBImpl.tc.isDebugEnabled()) {
                        Tr.debug(SecurityORBImpl.tc, "DN login", var2_2);
                    }
                    var7_9 = new X500Principal(var2_2);
                    var8_10 = var7_9.getName();
                    var8_10 = CSIUtil.getInstance().parseDN(var8_10);
                    var5_5 = this.contextManager.login(var3_3, var8_10);
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 2: {
                    if (SecurityORBImpl.tc.isDebugEnabled()) {
                        Tr.debug(SecurityORBImpl.tc, "Certificate login", var2_2);
                    }
                    var9_11 = this.convertCertificate(var2_2);
                    var10_12 = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(var3_3);
                    var11_13 = new UserMappingImpl().mapCertificateToName(var9_11);
                    var5_5 = this.contextManager.login(var3_3, var11_13, var6_6, null, null, null);
                    var12_14 = SubjectHelper.getWSCredentialFromSubject(var5_5);
                    break;
                }
                ** default:
lbl40:
                // 1 sources

                break;
            }
        }
        catch (WSSecurityException var6_7) {
            throw var6_7;
        }
        catch (Throwable var6_8) {
            throw new WSSecurityException(var6_8.getMessage(), var6_8);
        }
        finally {
            this.contextManager.put("CacheKeyAttribute", null);
        }
        if (SecurityORBImpl.tc.isEntryEnabled()) {
            Tr.exit(SecurityORBImpl.tc, "doCSIv2Login", var5_5);
        }
        return var5_5;
    }

    private WSCredentialTokenMapperInterface getWSCredTokenMapper() throws WSSecurityException {
        if (this.wsCredTokenMapper != null) {
            return this.wsCredTokenMapper;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSCredTokenMapper");
        }
        if (this.wsCredTokenMapper == null) {
            this.wsCredTokenMapper = WSCredentialTokenMapper.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSCredTokenMapper", this.wsCredTokenMapper);
        }
        return this.wsCredTokenMapper;
    }

    public int rmiOutboundLogin(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rmiOutboundLogin", byArray);
        }
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        int n = 8;
        try {
            Subject subject = this.getOutboundSubject();
            if (securityConfig.isRMIOutboundLoginEnabled() || securityConfig.isRMIOutboundPropagationEnabled()) {
                final Subject subject2 = subject;
                Subject subject3 = (Subject)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        return SubjectHelper.createNewSubjectFromExisting(subject2);
                    }
                });
                NativeCSIv2PerformPolicyData nativeCSIv2PerformPolicyData = new NativeCSIv2PerformPolicyData(ByteBuffer.wrap(byArray));
                CSIv2PerformPolicy cSIv2PerformPolicy = new CSIv2PerformPolicy(nativeCSIv2PerformPolicyData);
                Subject subject4 = this.contextManager.login(securityConfig.getRMIOutboundLoginConfig(), cSIv2PerformPolicy, subject3);
                this.contextManager.setInvocationSubject(subject);
                WSCredentialImpl wSCredentialImpl = (WSCredentialImpl)SubjectHelper.getWSCredentialFromSubject(subject4);
                byte[] byArray2 = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(subject4);
                String string = this.contextManager.getClientUniqueIDForOutboundRequests(subject);
                byte[] byArray3 = string != null ? string.getBytes() : null;
                byte[] byArray4 = wSCredentialImpl.getCredentialToken();
                if (byArray4 != null) {
                    // empty if block
                }
            }
            n = 0;
        }
        catch (Exception exception) {
            Tr.event(tc, "exception occurred in rmiOutboundLogin", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rmiOutboundLogin", new Integer(n));
        }
        return n;
    }

    void checkID(Subject subject) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkID", subject);
        }
        boolean bl = false;
        try {
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            String string = wSCredential.getSecurityName();
            bl = CSIUtil.getInstance().isTrusted(string);
        }
        catch (Exception exception) {
            throw new RemoteException("Unable to determine asserting subject's name");
        }
        if (!bl) {
            throw new RemoteException("Asserting identity is not trusted.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkID");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCurrentCredentials() {
        int n;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCurrentCredentials");
            }
            n = 0;
            try {
                int n2;
                Subject subject = this.getOutboundSubject();
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                if (((WSCredentialImpl)wSCredential).isServerCred() && wSCredential.getExpiration() != 0L && wSCredential.getExpiration() != -1L && !this.getWSCredTokenMapper().checkCushionValidityOfAllTokens(subject, this.contextManager.getReqTimeout())) {
                    subject = this.contextManager.getServerSubject();
                    wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                }
                byte[] byArray = wSCredential != null ? wSCredential.getCredentialToken() : new byte[]{};
                ArrayList arrayList = wSCredential != null ? wSCredential.getGroupIds() : null;
                byte[] byArray2 = this.arrayListToByteArray(arrayList);
                String string = this.contextManager.getClientUniqueIDForOutboundRequests(subject);
                byte[] byArray3 = this.isPropagationEnabled() && string != null ? string.getBytes() : null;
                int n3 = n2 = byArray3 != null ? byArray3.length : 0;
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                if (PlatformHelperFactory.getPlatformHelper().isServantJvm()) {
                    if (!((WSCredentialImpl)wSCredential).isServerCred() && wSCredential.getExpiration() != 0L && wSCredential.getExpiration() != -1L && !this.getWSCredTokenMapper().checkValidityOfAllTokens(subject)) {
                        this.throwNoPermission(null, 1229079302);
                    }
                    if (this.isSAFRegistry() && (n = this.getNscTokenFromSubject(subject)) != 0 && !wSCredential.isUnauthenticated()) {
                        // empty if block
                    }
                } else if (PlatformHelperFactory.getPlatformHelper().isClientJvm() ? "oid:2.23.130.1.1.1".equals(wSCredential.getOID()) && this.contextManager.getUnauthenticatedString().equals(wSCredential.getSecurityName()) : PlatformHelperFactory.getPlatformHelper().isControlJvm() && this.isSAFRegistry()) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) break block11;
                Tr.event(tc, "Unexpected exception on outbound", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentCredentials", new Integer(n));
        }
        return n;
    }

    private byte[] arrayListToByteArray(ArrayList arrayList) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "arrayListToByteArray", arrayList);
            }
            byArray = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(arrayList);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to serialize list", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayListToByteArray", byArray);
        }
        return byArray;
    }

    private boolean isPropagationEnabled() {
        if (PlatformHelperFactory.getPlatformHelper().isClientJvm()) {
            return false;
        }
        return WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled();
    }

    private Subject getOutboundSubject() throws WSSecurityException {
        Subject subject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundSubject");
        }
        if ((subject = this.contextManager.getInvocationSubject()) == null) {
            subject = this.contextManager.getCallerSubject();
        }
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Going outobund without credentials: ", new Exception("Traceback for debug"));
            }
            subject = this.getDefaultOutboundSubject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundSubject", subject);
        }
        return subject;
    }

    private Subject getDefaultOutboundSubject() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultOutboundSubject");
        }
        Subject subject = null;
        subject = PlatformHelperFactory.getPlatformHelper().isControlJvm() && this.defaultControllerOutboundIsServer ? this.contextManager.getServerSubject() : this.contextManager.createUnauthenticatedSubject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultOutboundSubject", subject);
        }
        return subject;
    }

    private void throwNoPermission(Throwable throwable, int n) throws NO_PERMISSION {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "throwNoPermission", new Object[]{throwable, new Integer(n)});
        }
        NO_PERMISSION nO_PERMISSION = null;
        if (throwable instanceof WSLoginFailedException) {
            WSLoginFailedException wSLoginFailedException = (WSLoginFailedException)throwable;
            throwable = wSLoginFailedException.getCause();
        }
        if (throwable instanceof NO_PERMISSION) {
            nO_PERMISSION = (NO_PERMISSION)throwable;
        }
        if (nO_PERMISSION == null) {
            nO_PERMISSION = new NO_PERMISSION(n, CompletionStatus.COMPLETED_NO);
            nO_PERMISSION.initCause(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "throwNoPermission", (Object)nO_PERMISSION);
        }
        throw nO_PERMISSION;
    }
}

