/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPAKeyPair;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.LinkedList;

public final class LTPADigSignature {
    private static final TraceComponent tc = Tr.register(LTPADigSignature.class, null, "com.ibm.ejs.resources.security");
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    static byte[][] testRawPubKey = null;
    static byte[][] testRawPrivKey = null;
    static MessageDigest md1 = null;
    static MessageDigest md2 = null;
    static MessageDigest md1JCE = null;
    static MessageDigest md2JCE = null;
    private static Object lockObj1 = new Object();
    private static Object lockObj2 = new Object();
    static final LinkedList l2;
    static final LinkedList ll;
    static final HashMap hm;
    static long created;
    static long cacheHits;

    static void generateRSAKeys(byte[][] byArray, byte[][] byArray2) {
        byte[][] byArray3 = LTPACrypto.rsaKey(128, true, true);
        byArray2[2] = byArray3[2];
        byArray2[4] = byArray3[3];
        byArray2[3] = byArray3[4];
        byArray[0] = byArray3[0];
        byArray[1] = byArray3[2];
    }

    static byte[] sign(byte[] byArray, LTPAPrivateKey lTPAPrivateKey) throws NoSuchAlgorithmException {
        return LTPADigSignature.sign(byArray, lTPAPrivateKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sign(byte[] byArray, LTPAPrivateKey lTPAPrivateKey, boolean bl) throws NoSuchAlgorithmException {
        byte[] byArray2;
        byte[] byArray3;
        String string = new String(byArray) + bl;
        Object object = hm;
        synchronized (object) {
            byArray3 = (byte[])hm.get(string);
        }
        if (byArray3 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cache hit in sign.");
            }
            object = new byte[byArray3.length];
            System.arraycopy(byArray3, 0, object, 0, byArray3.length);
            ++cacheHits;
            return object;
        }
        object = lTPAPrivateKey.getRawKey();
        Object object2 = lockObj1;
        synchronized (object2) {
            byArray2 = bl ? md1JCE.digest(byArray) : md1.digest(byArray);
        }
        LTPACrypto.setRSAKey((byte[][])object);
        object2 = LTPACrypto.signISO9796((byte[][])object, byArray2, 0, byArray2.length, bl);
        HashMap hashMap = hm;
        synchronized (hashMap) {
            ++created;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sign [" + created + "/" + cacheHits + "]added:" + string);
            }
            hm.put(string, object2);
            ll.addLast(string);
            l2.addLast(new Long(System.currentTimeMillis()));
            while (hm.size() > 5000) {
                l2.removeFirst();
                hm.remove(ll.removeFirst());
            }
            long l = System.currentTimeMillis();
            while (l - (Long)l2.getFirst() > 60000L) {
                l2.removeFirst();
                hm.remove(ll.removeFirst());
            }
        }
        return object2;
    }

    static boolean verify(byte[] byArray, byte[] byArray2, LTPAPublicKey lTPAPublicKey) throws NoSuchAlgorithmException {
        return LTPADigSignature.verify(byArray, byArray2, lTPAPublicKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean verify(byte[] byArray, byte[] byArray2, LTPAPublicKey lTPAPublicKey, boolean bl) throws NoSuchAlgorithmException {
        byte[] byArray3;
        byte[][] byArray4 = lTPAPublicKey.getRawKey();
        Object object = lockObj2;
        synchronized (object) {
            byArray3 = bl ? md2JCE.digest(byArray) : md2.digest(byArray);
        }
        boolean bl2 = LTPACrypto.verifyISO9796(byArray4, byArray3, 0, byArray3.length, byArray2, 0, byArray2.length, bl);
        return bl2;
    }

    static LTPAKeyPair generateLTPAKeyPair() {
        byte[][] byArrayArray = new byte[2][];
        byte[][] byArrayArray2 = new byte[8][];
        LTPADigSignature.generateRSAKeys(byArrayArray, byArrayArray2);
        LTPAPublicKey lTPAPublicKey = new LTPAPublicKey(byArrayArray);
        LTPAPrivateKey lTPAPrivateKey = new LTPAPrivateKey(byArrayArray2);
        return new LTPAKeyPair(lTPAPublicKey, lTPAPrivateKey);
    }

    static {
        try {
            md1JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
            md2JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
            FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPADigSignature", "51");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
            Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
            FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPADigSignature", "55");
        }
        if (LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA()) {
            try {
                md1 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPADigSignature", "64");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
                FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPADigSignature", "68");
            }
        } else {
            try {
                md1 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPADigSignature", "75");
            }
        }
        l2 = new LinkedList();
        ll = new LinkedList();
        hm = new HashMap();
        created = 0L;
        cacheHits = 0L;
    }
}

