/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import java.util.Map;
import java.util.Properties;

public class LTPAKeyHelper {
    private static final TraceComponent tc = Tr.register(LTPAKeyHelper.class, "Security", "com.ibm.ejs.resources.security");
    public static final String SHARED_KEY_PROPERTY = "com.ibm.websphere.ltpa.3DESKey";
    public static final String PUBLIC_KEY_PROPERTY = "com.ibm.websphere.ltpa.PublicKey";
    public static final String PRIVATE_KEY_PROPERTY = "com.ibm.websphere.ltpa.PrivateKey";
    private String publicKey = null;
    private String privateKey = null;
    private String shareKey = null;
    private String encKeyStorePwd = null;

    public LTPAKeyHelper(String string) throws KeyException, Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LTPAKeyHelper " + string);
        }
        Map map = KeySetGroupManager.getInstance().getKeySetGroup(string).getLatestKeys();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get the latest keys = " + map);
        }
        WSKeySet[] wSKeySetArray = KeySetGroupManager.getInstance().getKeySetGroup(string).getAllKeySets();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get all key sets = " + wSKeySetArray);
        }
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < wSKeySetArray.length; ++i) {
            object = wSKeySetArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySet = " + ((WSKeySet)object).toString());
            }
            if (object == null || ((WSKeySet)object).getPassword() == null) continue;
            if (((WSKeySet)object).getIsKeyPair()) {
                string2 = ((WSKeySet)object).getPassword();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "keyPairPwd = " + (string2 != null ? "*****" : null));
                continue;
            }
            string3 = ((WSKeySet)object).getPassword();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "sharedKeyPwd = " + (string3 != null ? "*****" : null));
        }
        String string4 = null;
        if (string2 != null) {
            string4 = string2;
        } else if (string3 != null) {
            string4 = string3;
        }
        try {
            this.encKeyStorePwd = PasswordUtil.passwordEncode(string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encKeyStorePwd = " + (this.encKeyStorePwd != null ? "*****" : null));
            }
            object = null;
            LTPAServerObject lTPAServerObject = new LTPAServerObject();
            if (lTPAServerObject != null) {
                object = lTPAServerObject.exportSSOProperties(string4.getBytes("UTF8"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ltpaServer is null! not good.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ssoProps = " + object);
            }
            this.shareKey = ((Properties)object).getProperty(SHARED_KEY_PROPERTY);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "shareKey = " + this.shareKey);
            }
            this.privateKey = ((Properties)object).getProperty(PRIVATE_KEY_PROPERTY);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "privateKey = " + this.privateKey);
            }
            this.publicKey = ((Properties)object).getProperty(PUBLIC_KEY_PROPERTY);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "publicKey = " + this.publicKey);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.ltpaKeyHelper", "121", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LTPAKeyHelper", exception.getMessage());
            }
            throw exception;
        }
        if (this.shareKey == null || this.shareKey.length() == 0) {
            throw new Exception("shareKey is Null");
        }
        if (this.privateKey == null || this.privateKey.length() == 0) {
            throw new Exception("privateKey is Null");
        }
        if (this.publicKey == null || this.publicKey.length() == 0) {
            throw new Exception("publicKey is Null");
        }
        if (string4 == null || string4.length() == 0) {
            throw new Exception("keyStorePwd is Null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LTPAKeyHelper");
        }
    }

    public String getLTPAPublicKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLTPAPublicKey");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLTPAPublicKey " + this.publicKey);
        }
        return this.publicKey;
    }

    public String getLTPAPrivateKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLTPAPrivateKey");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLTPAPrivateKey " + this.privateKey);
        }
        return this.privateKey;
    }

    public String getSharedKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSharedKey");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSharedKey " + this.shareKey);
        }
        return this.shareKey;
    }

    public String getKeyStorePassword() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStorePassword");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStorePassword " + (this.encKeyStorePwd != null ? "*****" : null));
        }
        return this.encKeyStorePwd;
    }
}

