/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.crypto.KeyPairGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPADigSignature;
import com.ibm.ws.security.ltpa.LTPAKeyPair;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import java.security.Key;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public class LTPAKeyPairGenerator
implements KeyPairGenerator {
    private static final TraceComponent tc = Tr.register(LTPAKeyPairGenerator.class, null, "com.ibm.ejs.resources.security");
    private Properties customProperties = null;

    public void init(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{properties});
        }
        this.customProperties = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public KeyPair generateKeyPair() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKeyPair");
        }
        try {
            LTPAKeyPair lTPAKeyPair = LTPADigSignature.generateLTPAKeyPair();
            if (lTPAKeyPair != null) {
                LTPAPrivateKey lTPAPrivateKey = lTPAKeyPair.getPrivate();
                LTPAPublicKey lTPAPublicKey = lTPAKeyPair.getPublic();
                SecretKeySpec secretKeySpec = new SecretKeySpec(lTPAPublicKey.getEncoded(), "LTPA_RSA_PUBLIC");
                SecretKeySpec secretKeySpec2 = new SecretKeySpec(lTPAPrivateKey.getEncoded(), "LTPA_RSA_PRIVATE");
                KeyPair keyPair = new KeyPair(secretKeySpec, (Key)secretKeySpec2);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateKeyPair");
                }
                return keyPair;
            }
            throw new KeyException("Key pair could not be generated.");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAKeyPairGenerator.generateKeyPair", "108", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error generating key pair.", new Object[]{exception});
            }
            if (exception instanceof KeyException) {
                throw (KeyException)exception;
            }
            throw new KeyException(exception.getMessage(), exception);
        }
    }
}

