/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.orbssl.SSLConnectionDataImpl;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;

public class ExtendedSSLConnectionData
extends SSLConnectionDataImpl {
    private static final String variable_data_name = "NATIVE_VARIABLE_DATA";
    private static final String effective_policy_name = "EFFECTIVE_POLICY_DATA";
    private String SSLKeyStoreClientAlias = "";
    private String SSLConfigAlias = "";
    private CSIv2EffectivePerformPolicy effectivePolicy = null;

    public ExtendedSSLConnectionData(String string, long l, short s, int n, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) {
        super(string, l, s, n);
        this.effectivePolicy = cSIv2EffectivePerformPolicy;
        VaultImpl vaultImpl = VaultImpl.getInstance();
        if (vaultImpl != null) {
            this.SSLConfigAlias = vaultImpl.getSecurityConfiguration().getCSIOutboundSSLConfigAlias();
        }
    }

    public ExtendedSSLConnectionData(byte[] byArray) throws Exception {
        super(null, 0L, (short)0, 0);
        this.constructFromBytes(byArray);
    }

    public byte[] getBytes() throws Exception {
        String string = "";
        String string2 = "ExtendedSSLConnectionData.getBytes";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
        byte[] byArray = null;
        try {
            TokenHolder tokenHolder = this.serializeVariables();
            arrayList.add(tokenHolder);
            if (this.effectivePolicy != null) {
                arrayList.add(new TokenHolder(this.effectivePolicy.getBytes(), effective_policy_name, 1));
            }
            byArray = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromTokenHolderList(null, arrayList);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.getBytes", "158", this);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception getting session bytes for private security context.";
                SecurityLogger.debugMessage(string2, string);
            }
            SecurityLogger.logException(string2, exception, 0, 0);
            throw exception;
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
        return byArray;
    }

    private void constructFromBytes(byte[] byArray) throws Exception {
        String string = "";
        String string2 = "ExtendedSSLConnectionData.constructFromBytes";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        if (byArray != null) {
            if (SecurityLogger.debugEntryEnabled) {
                string = "ExtendedSSLConnectionData bytes: ";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.debugMessage(string2, byArray);
            }
            try {
                ArrayList arrayList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(byArray);
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        TokenHolder tokenHolder = (TokenHolder)arrayList.get(i);
                        String string3 = tokenHolder.getName();
                        if (SecurityLogger.debugTraceEnabled) {
                            string = "Handling token name: " + string3;
                            SecurityLogger.debugMessage(string2, string);
                        }
                        if (string3 != null && string3.equals(effective_policy_name)) {
                            this.effectivePolicy = new CSIv2EffectivePerformPolicy(tokenHolder.getBytes());
                            continue;
                        }
                        if (string3 == null || !string3.equals(variable_data_name)) continue;
                        this.deserializeVariables(tokenHolder.getBytes());
                    }
                } else {
                    String string4 = new String(byArray);
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "ConnectionKey string: " + string4;
                        SecurityLogger.debugMessage(string2, string);
                    }
                    this.setConnectionKey(string4);
                    this.setConnectionType(2L);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.constructFromBytes", "240", this);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Exception constructing private service context.";
                    SecurityLogger.debugMessage(string2, string);
                }
                SecurityLogger.logException(string2, exception, 0, 0);
                throw exception;
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    private TokenHolder serializeVariables() throws Exception {
        String string = "";
        String string2 = "ExtendedSSLConnectionData.serializeVariables";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        TokenHolder tokenHolder = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(300);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(this.getConnectionType());
            dataOutputStream.writeShort(this.getPerformQOP());
            dataOutputStream.writeInt(this.getErrorCode());
            String string3 = this.getConnectionKey();
            if (string3 != null && string3.length() > 0) {
                dataOutputStream.writeInt(string3.length());
                dataOutputStream.write(string3.getBytes(), 0, string3.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this.SSLKeyStoreClientAlias != null && this.SSLKeyStoreClientAlias.length() > 0) {
                dataOutputStream.writeInt(this.SSLKeyStoreClientAlias.length());
                dataOutputStream.write(this.SSLKeyStoreClientAlias.getBytes(), 0, this.SSLKeyStoreClientAlias.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this.SSLConfigAlias != null && this.SSLConfigAlias.length() > 0) {
                dataOutputStream.writeInt(this.SSLConfigAlias.length());
                dataOutputStream.write(this.SSLConfigAlias.getBytes(), 0, this.SSLConfigAlias.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            tokenHolder = new TokenHolder(byteArrayOutputStream.toByteArray(), variable_data_name, 1);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.serializeVariables", "315", this);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception serializing native variables.";
                SecurityLogger.debugMessage(string2, string);
            }
            SecurityLogger.logException(string2, exception, 0, 0);
            throw exception;
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
        return tokenHolder;
    }

    private void deserializeVariables(byte[] byArray) throws Exception {
        String string = "";
        String string2 = "ExtendedSSLConnectionData.deserializeVariables";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            byte[] byArray2;
            this.setConnectionType(dataInputStream.readLong());
            this.setPerformQOP(dataInputStream.readShort());
            this.setErrorCode(dataInputStream.readInt());
            int n = dataInputStream.readInt();
            if (n > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this.setConnectionKey(new String(byArray2));
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this.SSLKeyStoreClientAlias = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this.SSLConfigAlias = new String(byArray2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.deserializeVariables", "394", this);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception de-serializing native variables.";
                SecurityLogger.debugMessage(string2, string);
            }
            SecurityLogger.logException(string2, exception, 0, 0);
            throw exception;
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    public String getKeyStoreClientAlias() {
        return this.SSLKeyStoreClientAlias;
    }

    public String getSSLConfigAlias() {
        return this.SSLConfigAlias;
    }

    public int getSessionTimeout() {
        return 0;
    }

    public boolean getMessageLoggingEnabled() {
        return false;
    }

    public void setMessageLoggingEnabled(boolean bl) {
    }

    public CSIv2EffectivePerformPolicy getEffectivePolicy() {
        return this.effectivePolicy;
    }

    public void setEffectivePolicy(CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) {
        this.effectivePolicy = cSIv2EffectivePerformPolicy;
    }
}

