/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.KeyRingFileException;
import com.ibm.ws.orb.transport.WSSSLClientSocketFactory;
import com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl;
import com.ibm.ws.orbimpl.transport.WSTransport;
import com.ibm.ws.security.orbssl.SSLConnectionData;
import com.ibm.ws.security.orbssl.SocketFactoryMessageUtility;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public final class WSSSLClientSocketFactoryImpl
implements WSSSLClientSocketFactory {
    private static final int DEFAULT_SESSION_TIMEOUT = 30;
    private static String[] ENABLED_CIPHERS = null;
    private static String[] SUPPORTED_CIPHERS = null;
    private static int sslHandshakeReadTimeout = 10000;
    private static boolean sslHandshakeReadTimeoutInitialized = false;

    public Socket createSSLSocket(ConnectionData connectionData) throws KeyRingFileException, IOException {
        return this.createSSLSocket(connectionData, 0, null);
    }

    public Socket createSSLSocket(ConnectionData connectionData, int n) throws KeyRingFileException, IOException {
        return this.createSSLSocket(connectionData, n, null);
    }

    public Socket createSSLSocket(ConnectionData connectionData, int n, ORBForTransports oRBForTransports) throws KeyRingFileException, IOException {
        Object object;
        Object object2;
        SSLSocket sSLSocket;
        block72: {
            SSLConnectionData sSLConnectionData = (SSLConnectionData)connectionData;
            final String string = sSLConnectionData.getSSLConfigAlias();
            String string2 = null;
            String string3 = sSLConnectionData.getConnectionKey();
            string2 = WSTransport.getHostFromKeyString(string3);
            short s = sSLConnectionData.getPerformQOP();
            boolean bl = true;
            int n2 = -1;
            n2 = WSTransport.getPortFromKeyString(string3);
            SSLContext sSLContext = null;
            sSLSocket = null;
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                String string4;
                Object object3;
                object2 = new HashMap<String, String>();
                ((HashMap)object2).put("com.ibm.ssl.direction", "outbound");
                ((HashMap)object2).put("com.ibm.ssl.remoteHost", string2);
                ((HashMap)object2).put("com.ibm.ssl.remotePort", Integer.toString(n2));
                ((HashMap)object2).put("com.ibm.ssl.endPointName", "IIOP");
                object = null;
                try {
                    object = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((HashMap)object2){
                        private final /* synthetic */ HashMap val$connectionInfo;
                        {
                            this.val$connectionInfo = hashMap;
                        }

                        public Object run() throws Exception {
                            return JSSEHelper.getInstance().getProperties(string, this.val$connectionInfo, null);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                sSLContext = JSSEHelper.getInstance().getSSLContext((Map)object2, (Properties)object);
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                try {
                    block71: {
                        Socket socket;
                        object3 = new InetSocketAddress(string2, n2);
                        string4 = connectionData.getLocalHost();
                        if (sSLConnectionData.getUseSingleNIC()) {
                            if (n == 0) {
                                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string2, n2, InetAddress.getByName(string4), 0);
                            } else {
                                socket = new Socket();
                                socket.bind(new InetSocketAddress(string4, 0));
                                socket.connect((SocketAddress)object3, n);
                                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string2, n2, true);
                            }
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLSocket(cd, connTimeout)", "Bind Client Socket To A Specific NIC card=" + sSLConnectionData.getUseSingleNIC() + ", Remote Host=" + string2 + ", Remote Port=" + n2 + ", LocalHost=" + string4 + ", java.net.InetAddress.getByName( LocalHost )=" + InetAddress.getByName(string4) + ", ConnectTimeout = " + n + " ms.");
                            }
                        } else {
                            if (n == 0) {
                                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string2, n2);
                            } else {
                                socket = new Socket();
                                socket.connect((SocketAddress)object3, n);
                                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string2, n2, true);
                            }
                            if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLSocket(cd, connTimeout)", "Bind Client Socket To Multiple NIC cards=" + !sSLConnectionData.getUseSingleNIC() + ", Remote Host=" + string2 + ", Remote Port=" + n2 + ", ConnectTimeout = " + n + " ms.");
                            }
                        }
                        try {
                            sSLSocket.setKeepAlive(true);
                        }
                        catch (SocketException socketException) {
                            if (!ORBRas.isTrcLogging) break block71;
                            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "IIOPSSLConnectionClient.createSSLSocket", "\n[\nException calling setKeepAlive() " + socketException.getMessage() + "\n]");
                        }
                    }
                    try {
                        sSLSocket.setTcpNoDelay(true);
                    }
                    catch (SocketException socketException) {
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "IIOPSSLConnectionClient.createSSLSocket", "\n[\nException calling setTcpNoDelay() " + socketException.getMessage() + "\n]");
                        }
                    }
                }
                catch (IOException iOException) {
                    String string5 = null;
                    if (iOException instanceof SSLHandshakeException) {
                        string5 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLHandshakeException", iOException.getMessage());
                        ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string5, (String)null, (Object)iOException);
                    } else if (iOException instanceof SSLProtocolException) {
                        string5 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLProtocolException", iOException.getMessage());
                        ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string5, (String)null, (Object)iOException);
                    } else if (iOException instanceof SSLPeerUnverifiedException) {
                        string5 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLPeerUnverifiedException", iOException.getMessage());
                        ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string5, (String)null, (Object)iOException);
                    } else if (iOException instanceof SSLKeyException) {
                        string5 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLKeyException", iOException.getMessage());
                        ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string5, (String)null, (Object)iOException);
                    } else if (iOException instanceof SSLException) {
                        string5 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLException", iOException.getMessage());
                        ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string5, (String)null, (Object)iOException);
                    } else if (LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                        string5 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.IOException", iOException.getMessage());
                        ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string5, (String)null, (Object)iOException);
                    }
                    if (!bl && ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", (Exception)iOException);
                    }
                    if (LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "437", this);
                    }
                    String string6 = "Could not create Client Side Socket " + iOException.toString();
                    throw new COMM_FAILURE("CONNECT_FAILURE_ON_SSL_CLIENT_SOCKET - " + string5, 1229066352, CompletionStatus.COMPLETED_NO);
                }
                if (sSLSocket == null) break block72;
                object3 = ((Properties)object).getProperty("com.ibm.ssl.enabledCipherSuites");
                ENABLED_CIPHERS = SSLConfigManager.getInstance().parseEnabledCiphers((String)object3);
                if (ENABLED_CIPHERS == null) {
                    string4 = ((Properties)object).getProperty("com.ibm.ssl.securityLevel");
                    SUPPORTED_CIPHERS = sSLSocketFactory.getSupportedCipherSuites();
                    SUPPORTED_CIPHERS = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(SUPPORTED_CIPHERS, string4);
                }
                if (ENABLED_CIPHERS != null && ENABLED_CIPHERS.length > 0) {
                    sSLSocket.setEnabledCipherSuites(ENABLED_CIPHERS);
                } else if (SUPPORTED_CIPHERS != null && SUPPORTED_CIPHERS.length > 0) {
                    sSLSocket.setEnabledCipherSuites(SUPPORTED_CIPHERS);
                }
                int n3 = 0;
                if (oRBForTransports != null) {
                    n3 = WSSSLClientSocketFactoryImpl.getSSLHandshakeReadTimeout(oRBForTransports);
                }
                if (n3 > 0) {
                    try {
                        sSLSocket.setSoTimeout(n3);
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLSocket", "The read timeout for this sslHandshake has been set to " + n3 + " milliseconds.");
                        }
                    }
                    catch (Exception exception) {
                        ORBRas.orbTrcLogger.exception(8L, (Object)this, "createSSLSocket", exception);
                    }
                }
                sSLSocket.startHandshake();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "540", this);
                String string7 = null;
                if (iOException instanceof SSLHandshakeException) {
                    string7 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLHandshakeException", iOException.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string7, (String)null, (Object)iOException);
                } else if (iOException instanceof SSLProtocolException) {
                    string7 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLProtocolException", iOException.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string7, (String)null, (Object)iOException);
                } else if (iOException instanceof SSLPeerUnverifiedException) {
                    string7 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLPeerUnverifiedException", iOException.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string7, (String)null, (Object)iOException);
                } else if (iOException instanceof SSLKeyException) {
                    string7 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLKeyException", iOException.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string7, (String)null, (Object)iOException);
                } else if (iOException instanceof SSLException) {
                    string7 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLException", iOException.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string7, (String)null, (Object)iOException);
                } else {
                    string7 = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.IOException", iOException.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", string7, (String)null, (Object)iOException);
                }
                if (!bl && ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", (Exception)iOException);
                }
                throw new COMM_FAILURE("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_CLIENT_SOCKET: " + string7, 1229066352, CompletionStatus.COMPLETED_NO);
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                if (LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                    FFDCFilter.processException((Throwable)cOMM_FAILURE, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "591", this);
                }
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", (Exception)((Object)cOMM_FAILURE));
                    }
                } else if (ORBRas.isMsgLogging && LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.createSSLSocket"), (String)null, (Object)cOMM_FAILURE);
                }
                throw cOMM_FAILURE;
            }
            catch (Exception exception) {
                if (LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "628", this);
                }
                if (!bl) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", exception);
                    }
                } else if (ORBRas.isMsgLogging && LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.createSSLSocket"), (String)null, (Object)exception);
                }
                throw new COMM_FAILURE("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_CLIENT_SOCKET Exception=" + exception, 1229066352, CompletionStatus.COMPLETED_NO);
            }
        }
        object2 = null;
        try {
            object = sSLSocket;
            object2 = (SSLSession)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((SSLSocket)object){
                private final /* synthetic */ SSLSocket val$sock;
                {
                    this.val$sock = sSLSocket;
                }

                public Object run() {
                    return this.val$sock.getSession();
                }
            });
            try {
                sSLSocket.setSoTimeout(0);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLSocket", "SSL handshake getSession returns successfully, the read timeout for this sslHandshake has been set back to 0");
                }
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(8L, (Object)this, "createSSLSocket", exception);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "714", this);
        }
        if (object2 == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "IIOPSSLConnectionClient.createSSLSocket", "ssl_sock.getSession returned null");
            }
            throw new COMM_FAILURE("GET_SSL_SESSION_RETURNED_NULL", 1229066362, CompletionStatus.COMPLETED_NO);
        }
        return sSLSocket;
    }

    private static synchronized int getSSLHandshakeReadTimeout(ORBForTransports oRBForTransports) {
        if (!sslHandshakeReadTimeoutInitialized) {
            block7: {
                String string = oRBForTransports.getProperty("com.ibm.ws.orb.transport.SSLHandshakeTimeout");
                try {
                    if (string != null && string.length() > 0 && Integer.parseInt(string) > 0) {
                        sslHandshakeReadTimeout = Integer.parseInt(string);
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, WSSSLClientSocketFactoryImpl.class.getName(), "getSSLHandshakeReadTimeout(ORBForTransports)", "The ORB property com.ibm.ws.orb.transport.SSLHandshakeTimeout= " + sslHandshakeReadTimeout + " milliseconds.");
                        }
                    } else {
                        sslHandshakeReadTimeout = 10000;
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, WSSSLClientSocketFactoryImpl.class.getName(), "getSSLHandshakeReadTimeout(ORBForTransports)", "The ORB property com.ibm.ws.orb.transport.SSLHandshakeTimeout is null or is not set, or set to be a non-positive number, will use default 10000 milliseconds.");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    sslHandshakeReadTimeout = 10000;
                    if (!ORBRas.isTrcLogging) break block7;
                    ORBRas.orbTrcLogger.trace(4112L, WSSSLClientSocketFactoryImpl.class.getName(), "getSSLHandshakeReadTimeout(ORBForTransports)", "NumberFormatException thrown when retrieving user input value for ORB property com.ibm.ws.orb.transport.SSLHandshakeTimeout = " + string + ", will use default 10000 milliseconds.");
                }
            }
            sslHandshakeReadTimeoutInitialized = true;
        }
        return sslHandshakeReadTimeout;
    }
}

