/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.Parser;
import com.ibm.ws.security.util.ParserException;
import java.io.IOException;
import java.io.Reader;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

abstract class FilterParser
extends Parser {
    private HashMap filterEntries = new HashMap(2);
    private ArrayList filterPermissions = new ArrayList(32);
    static final String FILTER_KEYWORD = "filterMask";
    static final String RUNTIME_FILTER_KEYWORD = "runtimeFilterMask";

    FilterParser(Reader reader, boolean bl) {
        super(reader, bl);
    }

    void parse() throws IOException, ParserException {
        FilterEntry filterEntry;
        this.parser.nextToken();
        while (!this.parser.eof()) {
            if (this.parser.peek(FILTER_KEYWORD)) {
                this.addFilterEntry(this.parseFilterEntry(FILTER_KEYWORD));
            } else if (this.parser.peek(RUNTIME_FILTER_KEYWORD)) {
                this.addFilterEntry(this.parseFilterEntry(RUNTIME_FILTER_KEYWORD));
            } else {
                throw new ParserException(this.parser.getLineNumber(), "Unexpected keyword \"" + this.parser.getStringValue() + "\"");
            }
            this.parser.match(";");
        }
        if (!this.filterEntries.isEmpty() && (filterEntry = (FilterEntry)this.filterEntries.get(FILTER_KEYWORD)) != null) {
            int n = filterEntry.permissionEntries.size();
            for (int i = 0; i < n; ++i) {
                Permission permission = this.getPermissionInstance((Parser.PermissionEntry)filterEntry.permissionEntries.get(i));
                this.filterPermissions.add(permission);
            }
        }
    }

    ArrayList getFilterPermissions() {
        return (ArrayList)this.filterPermissions.clone();
    }

    FilterEntry getFilterEntry(String string) {
        return (FilterEntry)this.filterEntries.get(string);
    }

    private void addFilterEntry(FilterEntry filterEntry) {
        if (filterEntry != null) {
            FilterEntry filterEntry2 = (FilterEntry)this.filterEntries.get(filterEntry.getType());
            if (filterEntry2 != null) {
                filterEntry2.add(filterEntry);
            } else {
                this.filterEntries.put(filterEntry.getType(), filterEntry);
            }
        }
    }

    private FilterEntry parseFilterEntry(String string) throws IOException, ParserException {
        FilterEntry filterEntry = new FilterEntry(string);
        this.parser.match(string);
        this.parser.match("{");
        while (!this.parser.peek("}")) {
            if (this.parser.peek("permission")) {
                try {
                    Parser.PermissionEntry permissionEntry = this.parsePermissionEntry();
                    filterEntry.add(permissionEntry);
                }
                catch (Parser.ExpandException expandException) {
                    FFDCFilter.processException((Throwable)expandException, "com.ibm.ws.security.policy.FilterParser.parseFilterEntry", "102", this);
                    this.warning("security.policy.filterparser.expandperm", new Object[]{expandException});
                    this.parser.skipEntry();
                }
                this.parser.match(";");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected permission entry");
        }
        this.parser.match("}");
        return filterEntry;
    }

    Iterator getFilterEntries() {
        return this.filterEntries.values().iterator();
    }

    public String toString() {
        String string;
        if (!this.filterEntries.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer(512);
            FilterEntry filterEntry = (FilterEntry)this.filterEntries.get(FILTER_KEYWORD);
            if (filterEntry != null) {
                stringBuffer.append(filterEntry.toString()).append(NEW_LINE);
            }
            if ((filterEntry = (FilterEntry)this.filterEntries.get(RUNTIME_FILTER_KEYWORD)) != null) {
                stringBuffer.append(filterEntry.toString());
            }
            string = stringBuffer.toString();
        } else {
            string = "";
        }
        return string;
    }

    class FilterEntry {
        private List permissionEntries = new ArrayList();
        private String type;

        private FilterEntry(String string) {
            this.type = string;
        }

        void add(Parser.PermissionEntry permissionEntry) {
            if (!this.permissionEntries.contains(permissionEntry)) {
                this.permissionEntries.add(permissionEntry);
            }
        }

        boolean contains(Parser.PermissionEntry permissionEntry) {
            return this.permissionEntries.contains(permissionEntry);
        }

        Iterator getPermissions() {
            return this.permissionEntries.iterator();
        }

        String getType() {
            return this.type;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.permissionEntries.size() * 40);
            stringBuffer.append(this.type).append(' ');
            stringBuffer.append('{').append(Parser.NEW_LINE);
            Iterator iterator = this.permissionEntries.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append("};").append(Parser.NEW_LINE);
            return stringBuffer.toString();
        }

        private void add(FilterEntry filterEntry) {
            if (filterEntry != null) {
                int n = filterEntry.permissionEntries.size();
                for (int i = 0; i < n; ++i) {
                    this.add((Parser.PermissionEntry)filterEntry.permissionEntries.get(i));
                }
            }
        }
    }
}

