/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.ApplicationParserTr;
import com.ibm.ws.security.policy.FilterParser;
import com.ibm.ws.security.policy.Parser;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

class FilterParserTr
extends FilterParser {
    private static final TraceComponent tc = Tr.register(ApplicationParserTr.class, null, "com.ibm.ejs.resources.security");

    FilterParserTr(Reader reader, boolean bl) {
        super(reader, bl);
    }

    public void warning(String string) {
        Tr.warning(tc, string);
    }

    public void warning(String string, Object[] objectArray) {
        Tr.warning(tc, string, objectArray);
    }

    public void error(String string) {
        Tr.error(tc, string);
    }

    public void error(String string, Object[] objectArray) {
        Tr.error(tc, string, objectArray);
    }

    public void audit(String string) {
        Tr.audit(tc, string);
    }

    public void audit(String string, Object[] objectArray) {
        Tr.audit(tc, string, objectArray);
    }

    public void debug(String string) {
        Tr.debug(tc, string);
    }

    public boolean isDebugEnabled() {
        return tc.isDebugEnabled();
    }

    public boolean isEntryEnabled() {
        return tc.isEntryEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: java " + FilterParser.class.getName() + " <policy file name>");
            System.exit(1);
        }
        Reader reader = null;
        try {
            String string = stringArray[0];
            reader = new FileReader(string);
            FilterParserTr filterParserTr = new FilterParserTr(reader, false);
            filterParserTr.parse();
            Iterator iterator = filterParserTr.getFilterEntries();
            while (iterator.hasNext()) {
                System.out.println(Parser.NEW_LINE);
                System.out.println(iterator.next().toString());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.policy.FilterParser.main", "170");
            System.err.println();
            exception.printStackTrace();
            System.exit(2);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.security.policy.FilterParser.main", "179");
                    iOException.printStackTrace();
                }
                reader = null;
            }
        }
        System.exit(0);
    }
}

