/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.protocol.SSLSocketFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.net.SocketFactory;

public class LdapSSLSocketFactory
extends SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(LdapSSLSocketFactory.class, "Security", "com.ibm.ejs.resources.security");
    private static final LdapSSLSocketFactory defaultFactory = new LdapSSLSocketFactory();

    private LdapSSLSocketFactory() {
        try {
            Properties properties = (Properties)SecurityConfig.getConfig().getValue("security.registry.ldap.props");
            final String string = (String)properties.get("security.registry.ldap.SSLAlias");
            String string2 = (String)properties.get("com.ibm.ssl.remoteHost");
            String string3 = (String)properties.get("com.ibm.ssl.remotePort");
            final HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            hashMap.put("com.ibm.ssl.endPointName", "LDAP");
            if (string2 != null && !string2.equals("")) {
                hashMap.put("com.ibm.ssl.remoteHost", string2);
            }
            if (string3 != null && !string3.equals("")) {
                hashMap.put("com.ibm.ssl.remotePort", string3);
            }
            try {
                this.props = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return JSSEHelper.getInstance().getProperties(string, hashMap, null);
                    }
                });
                this.default_constructor = false;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.ldap.LdapSSLSocketFactory.<init>", "64", (Object)this);
            Tr.error(tc, "security.registry.ldap.initerror", exception.getMessage());
        }
    }

    public static SocketFactory getDefault() {
        return defaultFactory;
    }

    public static Properties getDefaultConfig() {
        return defaultFactory.getConfig();
    }

    public Properties getConfig() {
        return this.props;
    }
}

