/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.protocol.SSLSocketFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.SetLdapConfig;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.net.SocketFactory;

public class ValidateLdapSSLSocketFactory
extends SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(ValidateLdapSSLSocketFactory.class, "Security", "com.ibm.ejs.resources.security");
    private static int hashCode = 0;
    private static ValidateLdapSSLSocketFactory defaultFactory = new ValidateLdapSSLSocketFactory();

    private ValidateLdapSSLSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateLdapSSLSocketFactory");
        }
        this.props = ValidateLdapSSLSocketFactory.getCurrentSSLProp();
        this.default_constructor = false;
        if (this.props != null) {
            hashCode = this.props.hashCode();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateLdapSSLSocketFactory");
        }
    }

    private ValidateLdapSSLSocketFactory(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateLdapSSLSocketFactory(Properties)");
        }
        this.default_constructor = false;
        if (properties != null) {
            this.props = properties;
            hashCode = properties.hashCode();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateLdapSSLSocketFactory(Properties");
        }
    }

    private static Properties getCurrentSSLProp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentSSLProp");
        }
        Properties properties = null;
        try {
            Properties properties2 = SetLdapConfig.getLdapProperties();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ldapProperties = " + properties2.toString());
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            if (properties2 != null) {
                string = (String)properties2.get("security.registry.ldap.SSLAlias");
                string2 = (String)properties2.get("com.ibm.ssl.remoteHost");
                string3 = (String)properties2.get("com.ibm.ssl.remotePort");
            }
            final String string4 = string;
            final HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            hashMap.put("com.ibm.ssl.endPointName", "LDAP");
            if (string2 != null && !string2.equals("")) {
                hashMap.put("com.ibm.ssl.remoteHost", string2);
            }
            if (string3 != null && !string3.equals("")) {
                hashMap.put("com.ibm.ssl.remotePort", string3);
            }
            try {
                properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return JSSEHelper.getInstance().getProperties(string4, hashMap, null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.registry.ldap.ValidateLdapSSLSocketFactory.getCurrentSSLProp", "64");
            Tr.error(tc, "security.registry.ldap.initerror", exception.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "props =" + properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentSSLProp");
        }
        return properties;
    }

    public static SocketFactory getDefault() {
        Properties properties = ValidateLdapSSLSocketFactory.getCurrentSSLProp();
        if (properties != null && hashCode != properties.hashCode()) {
            defaultFactory = new ValidateLdapSSLSocketFactory(properties);
        }
        return defaultFactory;
    }

    public static Properties getDefaultConfig() {
        return defaultFactory.getConfig();
    }

    public Properties getConfig() {
        return this.props;
    }
}

