/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.os400;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.os400.OS400RegistryException;
import com.ibm.ws.security.util.RegExp;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class OS400RegistryImpl
implements UserRegistry {
    private static TraceComponent tc;
    private String realm;
    private String typeRealm = "";
    private boolean longPasswordEnabled = false;
    private boolean isRegistryWIM = false;
    int maxUidSize = -1;
    int maxPWSize = -1;

    private native String[] ntv_getUsers(String var1, boolean var2) throws OS400RegistryException;

    private native String[] ntv_getGroupsForUser(String var1) throws OS400RegistryException;

    private native boolean ntv_isValid(String var1, boolean var2) throws OS400RegistryException;

    private native void ntv_authenticate(String var1, String var2) throws OS400RegistryException;

    private native String ntv_getDisplayName(String var1, boolean var2) throws OS400RegistryException;

    private native String[] ntv_getUsersForGroup(String var1) throws OS400RegistryException;

    private native boolean ntv_isLongPasswordEnabled() throws OS400RegistryException;

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword");
        }
        if (string.length() > this.getMaxUidSize() || string2.length() > this.getMaxPWSize()) {
            Tr.error(tc, "security.registry.checkpass.failed", new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword");
            }
            throw new PasswordCheckFailedException("checkPassword failed due to userid length (" + string.length() + ") and/or password length " + string2.length() + ") too large.");
        }
        String string3 = string.toUpperCase();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking password for user '" + string3 + "'.");
        }
        String string4 = string2.trim();
        string2 = null;
        try {
            if (string4.length() == 0) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("Authentication failed for user: " + string + " Password has zero length");
                Tr.error(tc, "security.authn.failed.foruser", new Object[]{string, passwordCheckFailedException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", passwordCheckFailedException);
                }
                throw passwordCheckFailedException;
            }
            if (string4.startsWith("*")) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("Authentication failed for user: " + string + " Password begins with *");
                Tr.error(tc, "security.authn.failed.foruser", new Object[]{string, passwordCheckFailedException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", passwordCheckFailedException);
                }
                throw passwordCheckFailedException;
            }
            if (!this.longPasswordEnabled) {
                string4 = string4.toUpperCase();
            }
            this.ntv_authenticate(string3, string4);
            string4 = null;
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.checkPassword", "236", this);
            this.logErrorCode(oS400RegistryException);
            PasswordCheckFailedException passwordCheckFailedException = null;
            switch (oS400RegistryException.getErrorCode()) {
                case 6: {
                    passwordCheckFailedException = new PasswordCheckFailedException("Authentication failed for user: " + string + " userID/password does not exist in the registry");
                    Tr.error(tc, "security.authn.failed.foruser", new Object[]{string, passwordCheckFailedException});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkPassword", passwordCheckFailedException);
                    }
                    throw passwordCheckFailedException;
                }
                case 0: 
                case 1: 
                case 2: {
                    Tr.error(tc, "security.authn.error", new Object[]{string, oS400RegistryException});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkPassword", oS400RegistryException);
                    }
                    throw new CustomRegistryException(this.typeRealm + ": " + string + ", " + oS400RegistryException.getMessage());
                }
            }
            passwordCheckFailedException = new PasswordCheckFailedException("Authentication failed for user: " + string + " Profile error occurred, error code: " + String.valueOf(oS400RegistryException.getErrorCode()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Profile error: " + this.typeRealm + ": " + string + ", " + oS400RegistryException.getMessage());
                Tr.debug(tc, "Error code: " + String.valueOf(oS400RegistryException.getErrorCode()));
            }
            Tr.error(tc, "security.authn.failed.foruser", new Object[]{string, passwordCheckFailedException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", passwordCheckFailedException);
            }
            throw passwordCheckFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.checkPassword", "267", this);
            Tr.error(tc, "security.authn.error", new Object[]{string, exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", exception);
            }
            throw new CustomRegistryException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkPassword");
        }
        return string;
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate");
        }
        CertificateMapNotSupportedException certificateMapNotSupportedException = new CertificateMapNotSupportedException("");
        Tr.error(tc, "security.registry.mapcertificate.notsupported");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate", certificateMapNotSupportedException);
        }
        throw certificateMapNotSupportedException;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    public String getGroupDisplayName(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName");
        }
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        stringBuffer.append(": ");
        try {
            stringBuffer.append(this.ntv_getDisplayName(string.toUpperCase(), true));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Display name for '" + string + "': " + stringBuffer);
            }
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroupDisplayName", "394", this);
            this.logErrorCode(oS400RegistryException);
            Tr.error(tc, "security.registry.groupdisplayname.error", new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupDisplayName", oS400RegistryException);
            }
            this.throwException(oS400RegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName");
        }
        return stringBuffer.toString();
    }

    public String getUniqueGroupId(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId");
        }
        if (!this.isValidGroup(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Group name not found: " + string);
            }
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException(string);
            if (!this.isRegistryWIM) {
                Tr.error(tc, "security.registry.uniquegrpid.error", new Object[]{string, entryNotFoundException});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueGroupId", entryNotFoundException);
            }
            throw entryNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", string.toUpperCase());
        }
        return string.toUpperCase();
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds");
        }
        return this.getGroupsForUser(string);
    }

    public Enumeration getGroups(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups(String)");
        }
        String[] stringArray = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pattern: " + string);
            }
            stringArray = this.ntv_getUsers("*ALL", true);
            this.filterArray(stringArray, string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroups", "516", this);
            this.logErrorCode(oS400RegistryException);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups(String)", oS400RegistryException);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups(String)");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public Result getGroups(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", string + ":" + n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Limit is " + n);
        }
        int n2 = 0;
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", string + ":" + n);
            }
            return result;
        }
        Enumeration enumeration = this.getGroups(string);
        if (enumeration == null) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no groups found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", string + ":" + n);
            }
            return result;
        }
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
            if (n == 0 || ++n2 != n) continue;
        }
        result.setList(arrayList);
        if (enumeration.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", string + ":" + n);
        }
        return result;
    }

    public List getGroupsForUser(String string, int n) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Limit is " + n);
        }
        int n2 = 0;
        String[] stringArray = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving groups for: " + string);
            }
            stringArray = this.ntv_getGroupsForUser(string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroupsForUser", "612", this);
            this.logErrorCode(oS400RegistryException);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser", oS400RegistryException);
            }
            this.throwException(oS400RegistryException, string);
        }
        if (stringArray.length == 1 && stringArray[0].equals("*NONE")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups for user '" + string + "'found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser");
            }
            return new ArrayList(0);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Groups for user '" + string + "':");
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < stringArray.length && n2++ < n; ++i) {
            arrayList.add(stringArray[i]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser");
        }
        return arrayList;
    }

    public String getGroupSecurityName(String string) throws CustomRegistryException, EntryNotFoundException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName");
        }
        if (!this.isValidGroup(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Group name not found: " + string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupSecurityName");
            }
            throw new EntryNotFoundException(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Group name found: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName");
        }
        return string.toUpperCase();
    }

    public String getUserDisplayName(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName");
        }
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        stringBuffer.append(": ");
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Display name for '" + string + "': " + stringBuffer);
            }
            stringBuffer.append(this.ntv_getDisplayName(string.toUpperCase(), false));
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", "728", this);
            this.logErrorCode(oS400RegistryException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to get display name for '" + string + "'.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserDisplayName");
            }
            this.throwException(oS400RegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserDisplayName");
        }
        return stringBuffer.toString();
    }

    public String getUniqueUserId(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", string);
        }
        if (!this.isValidUser(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "User name not found: " + string);
            }
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException(string);
            if (!this.isRegistryWIM) {
                Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{string});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueUserId", entryNotFoundException);
            }
            throw entryNotFoundException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "User name found: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId", string.toUpperCase());
        }
        return string.toUpperCase();
    }

    public Enumeration getUsers() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers");
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getUsers("*ALL", false);
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", "815", this);
            this.logErrorCode(oS400RegistryException);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{"*", oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", oS400RegistryException);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public Enumeration getUsers(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers(String)");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pattern: " + string);
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getUsers("*ALL", false);
            this.filterArray(stringArray, string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", "861", this);
            this.logErrorCode(oS400RegistryException);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers(String)", oS400RegistryException);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers(String)");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public Result getUsers(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", string + ":" + n);
        }
        int n2 = 0;
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", string + ":" + n);
            }
            return result;
        }
        Enumeration enumeration = this.getUsers(string);
        if (enumeration == null) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users found.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", string + ":" + n);
            }
            return result;
        }
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        while (enumeration.hasMoreElements() && (n == 0 || n2++ < n)) {
            arrayList.add(enumeration.nextElement());
        }
        result.setList(arrayList);
        if (enumeration.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", string + ":" + n);
        }
        return result;
    }

    public Result getUsersForGroup(String string, int n) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup", string);
        }
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        String[] stringArray = null;
        int n2 = 0;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving users for: " + string);
            }
            stringArray = this.ntv_getUsersForGroup(string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", "950", this);
            this.logErrorCode(oS400RegistryException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred: " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
            }
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup", oS400RegistryException);
            }
            this.throwException(oS400RegistryException, string);
        }
        if (stringArray.length == 1 && stringArray[0].equals("*NONE")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users for group '" + string + "'found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            result.setList(new ArrayList(0));
            return result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Users for group '" + string + "':");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        for (int i = 0; i < stringArray.length && (n == 0 || n2++ < n); ++i) {
            arrayList.add(stringArray[i]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, stringArray[i]);
        }
        result.setList(arrayList);
        if (stringArray.length > n) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsersForGroup");
        }
        return result;
    }

    public String getUserSecurityName(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName");
        }
        if (!this.isValidUser(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "User name not found: " + string);
            }
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException(string);
            if (!this.isRegistryWIM) {
                Tr.error(tc, "security.registry.usersecurityname.error", new Object[]{string, entryNotFoundException});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserSecurityName", entryNotFoundException);
            }
            throw entryNotFoundException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "User name found: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName");
        }
        return string.toUpperCase();
    }

    public void initialize(Properties properties) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            this.realm = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "1068", this);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get host name.");
                }
                this.realm = InetAddress.getLocalHost().toString();
            }
            catch (UnknownHostException unknownHostException2) {
                FFDCFilter.processException((Throwable)unknownHostException2, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "1079", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get host name or IP address.");
                }
                this.realm = "UNKNOWN";
            }
        }
        this.typeRealm = this.typeRealm + "[" + this.realm + "]";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "OS400RegistryImpl type and realm: " + this.typeRealm + ".");
        }
        try {
            this.longPasswordEnabled = this.ntv_isLongPasswordEnabled();
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "1099", this);
            this.logErrorCode(oS400RegistryException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred: " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "OS400RegistryImpl longPasswordEnabled: " + this.longPasswordEnabled + ".");
        }
        SecurityConfig.getConfig();
        this.isRegistryWIM = SecurityConfig.isRegWIM();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public boolean isValidGroup(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup");
        }
        try {
            if (string == null || string.equals("")) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.ntv_isValid(string.toUpperCase(), true);
            return bl;
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "1143", this);
            this.logErrorCode(oS400RegistryException);
            Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{string, oS400RegistryException});
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup");
            }
        }
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser");
        }
        try {
            if (string == null || string.equals("")) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.ntv_isValid(string.toUpperCase(), false);
            return bl;
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "1182", this);
            this.logErrorCode(oS400RegistryException);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred: " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
            }
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser", oS400RegistryException);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser");
            }
        }
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", string);
        }
        return null;
    }

    public List getGroupsForUser(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", string);
        }
        String[] stringArray = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving groups for: " + string);
            }
            stringArray = this.ntv_getGroupsForUser(string.toUpperCase());
        }
        catch (OS400RegistryException oS400RegistryException) {
            FFDCFilter.processException((Throwable)oS400RegistryException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroupsForUser", "1235", this);
            this.logErrorCode(oS400RegistryException);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{string, oS400RegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser", oS400RegistryException);
            }
            this.throwException(oS400RegistryException, string);
        }
        if (stringArray.length == 1 && stringArray[0].trim().equals("*NONE")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups for user '" + string + "'found");
            }
            return new ArrayList(0);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Groups for user '" + string + "':");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser");
        }
        return arrayList;
    }

    private Enumeration arrayToEnumeration(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayToEnumeration");
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "element[" + String.valueOf(i) + "]: " + stringArray[i]);
                }
                vector.addElement(stringArray[i]);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "element[" + String.valueOf(i) + "]: null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayToEnumeration");
        }
        return vector.elements();
    }

    private void filterArray(String[] stringArray, String string) {
        RegExp regExp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterArray");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pattern: " + string);
            }
            regExp = new RegExp(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.filterArray", "1312", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IllegalArgumentException: " + illegalArgumentException.getMessage());
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "filterArray");
            }
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!regExp.match(stringArray[i])) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a match: " + stringArray[i]);
                }
                stringArray[i] = null;
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "A match: " + stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterArray");
        }
    }

    private void throwException(OS400RegistryException oS400RegistryException, String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "throwException");
        }
        switch (oS400RegistryException.getErrorCode()) {
            case 0: 
            case 1: 
            case 2: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "throwException");
                }
                throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(oS400RegistryException.getErrorCode()) + ", " + oS400RegistryException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "throwException");
        }
        throw new EntryNotFoundException(this.typeRealm + ": " + string + ", " + oS400RegistryException.getMessage());
    }

    private int getMaxUidSize() {
        if (this.maxUidSize == -1) {
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.registry.maxUseridSize");
            this.maxUidSize = string != null ? Integer.parseInt(string) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMaxUidSize: " + this.maxUidSize);
            }
        }
        return this.maxUidSize;
    }

    private int getMaxPWSize() {
        if (this.maxPWSize == -1) {
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.registry.maxPasswordSize");
            this.maxPWSize = string != null ? Integer.parseInt(string) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMaxPWSize: " + this.maxPWSize);
            }
        }
        return this.maxPWSize;
    }

    private void logErrorCode(OS400RegistryException oS400RegistryException) {
        StringBuffer stringBuffer = new StringBuffer("Native error code = ");
        stringBuffer.append(oS400RegistryException.getErrorCode());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, stringBuffer.toString());
        }
    }

    static {
        String string = System.getProperty("was.install.library");
        System.load("/QSYS.LIB/" + string + ".LIB/QWASUREG.SRVPGM");
        tc = Tr.register(OS400RegistryImpl.class, null, "com.ibm.ejs.resources.security");
    }
}

