/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.SecurityProviderException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.eclipse.jst.j2ee.common.SecurityRole;

public final class PluggableAuthorizationTableProxy {
    private static final TraceComponent tc = Tr.register(PluggableAuthorizationTableProxy.class, "Security", "com.ibm.ejs.resources.security");
    public static final String SUBJECT_KEY = "AUTHZ_SUBJECT";
    private static PluggableAuthorizationTableProxy _instance = null;
    private static boolean _isSAFAuthorization = false;
    private static boolean _attemptedLoad = false;
    private final AuthorizationTable _authTable;
    private final String _cellName;
    private final String _serverName;

    public static synchronized PluggableAuthorizationTableProxy getAuthorizationTableProxy() {
        if (_attemptedLoad) {
            return _instance;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationTableProxy");
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        String string = contextManager.getProperty("com.ibm.websphere.security.authorizationTable", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pluggable Authz Table name: " + string);
        }
        _attemptedLoad = true;
        if (string != null && string.length() != 0) {
            try {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                }
                Object obj = clazz.newInstance();
                _instance = new PluggableAuthorizationTableProxy((AuthorizationTable)obj);
                _isSAFAuthorization = "com.ibm.ws.security.zOS.authz.SAFAuthorizationTableImpl".equals(string);
                SecurityConfig.setNativeAuthz(false);
                try {
                    if (obj != null && obj.getClass().getMethod("passSubject", null) != null) {
                        _isSAFAuthorization = true;
                        SecurityConfig.setNativeAuthz(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_isSAFAuthorization is set too: " + _isSAFAuthorization);
                }
                if (!_isSAFAuthorization) {
                    Tr.audit(tc, "security.wsaccessmanager.classloaded", new Object[]{string});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException(classNotFoundException, "com.ibm.ws.security.core.WSAccessManager.WSAccessManager", "125");
                Tr.error(tc, "security.wsaccessmanager.classnotfound", new Object[]{string});
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException(instantiationException, "com.ibm.ws.security.core.WSAccessManager.WSAccessManager", "130");
                Tr.error(tc, "security.wsaccessmanager.instantiationerror", new Object[]{string});
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.core.WSAccessManager.WSAccessManager", "135");
                Tr.error(tc, "security.wsaccessmanager.classloading", new Object[]{string});
            }
            if (_instance == null) {
                Tr.audit(tc, "security.wsaccessmanager.classloadingaudit", new Object[]{string});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthorizationTableProxy", _instance);
        }
        return _instance;
    }

    private PluggableAuthorizationTableProxy(AuthorizationTable authorizationTable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", authorizationTable);
        }
        this._authTable = authorizationTable;
        this._cellName = (String)SecurityConfig.getConfig().getValue("cellname");
        this._serverName = (String)SecurityConfig.getConfig().getValue("shortservername");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public static boolean isSAFAuthorizationEnabled() {
        return _isSAFAuthorization;
    }

    public AuthorizationTable getAuthorizationTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationTable");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthorizationTable", this._authTable);
        }
        return this._authTable;
    }

    public boolean isGrantedRole(AccessContext accessContext, SecurityRole securityRole, Subject subject) {
        HashMap hashMap = this.createAccessContext(accessContext, subject);
        String string = securityRole.getRoleName();
        return this.isGrantedRole(hashMap, string, subject);
    }

    public boolean isGrantedRole(HashMap hashMap, String string, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRole", new Object[]{hashMap, string, subject});
        }
        boolean bl = false;
        try {
            WSPrincipal wSPrincipal = SubjectHelper.getPrincipalFromSubject(subject);
            hashMap = this.getAccessContext(hashMap, subject);
            bl = this._authTable.isGrantedRole(hashMap, string, wSPrincipal);
        }
        catch (SecurityProviderException securityProviderException) {
            FFDCFilter.processException((Throwable)securityProviderException, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "215", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableError", new Object[]{securityProviderException});
            Exception exception = securityProviderException.getException();
            if (exception != null) {
                Tr.error(tc, "security.wsaccessmanager.VendorAuthTableSpecificError", new Object[]{exception});
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "224", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableGenericError");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole", new Boolean(bl));
        }
        return bl;
    }

    public boolean isGrantedAnyRole(AccessContext accessContext, SecurityRole[] securityRoleArray, Subject subject) {
        HashMap hashMap = this.createAccessContext(accessContext, subject);
        String[] stringArray = this.getRoleNamesFromRoles(securityRoleArray);
        return this.isGrantedAnyRole(hashMap, stringArray, subject);
    }

    public boolean isGrantedAnyRole(HashMap hashMap, String[] stringArray, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAnyRole", new Object[]{hashMap, stringArray, subject});
        }
        boolean bl = false;
        try {
            WSPrincipal wSPrincipal = SubjectHelper.getPrincipalFromSubject(subject);
            hashMap = this.getAccessContext(hashMap, subject);
            bl = this._authTable.isGrantedAnyRole(hashMap, stringArray, wSPrincipal);
        }
        catch (SecurityProviderException securityProviderException) {
            FFDCFilter.processException((Throwable)securityProviderException, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "271", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableError", new Object[]{securityProviderException});
            Exception exception = securityProviderException.getException();
            if (exception != null) {
                Tr.error(tc, "security.wsaccessmanager.VendorAuthTableSpecificError", new Object[]{exception});
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "280", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableGenericError");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(bl));
        }
        return bl;
    }

    public boolean isEveryoneGranted(AccessContext accessContext, SecurityRole[] securityRoleArray) {
        HashMap hashMap = this.createAccessContext(accessContext, null);
        String[] stringArray = this.getRoleNamesFromRoles(securityRoleArray);
        return this.isEveryoneGranted(hashMap, stringArray);
    }

    public boolean isEveryoneGranted(HashMap hashMap, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted", new Object[]{hashMap, stringArray});
        }
        boolean bl = false;
        try {
            bl = this._authTable.isEveryoneGranted(hashMap, stringArray);
        }
        catch (SecurityProviderException securityProviderException) {
            FFDCFilter.processException((Throwable)securityProviderException, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "323", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableError", new Object[]{securityProviderException});
            Exception exception = securityProviderException.getException();
            if (exception != null) {
                Tr.error(tc, "security.wsaccessmanager.VendorAuthTableSpecificError", new Object[]{exception});
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "332", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableGenericError");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted", new Boolean(bl));
        }
        return bl;
    }

    private HashMap createAccessContext(AccessContext accessContext, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAccessContext", new Object[]{accessContext, subject});
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("SERVER_NAME", this._serverName);
        hashMap.put("CELL_NAME", this._cellName);
        hashMap.put("APPLICATION_NAME", accessContext.getEnterpriseAppName());
        if (_isSAFAuthorization && subject != null) {
            hashMap.put(SUBJECT_KEY, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAccessContext", hashMap);
        }
        return hashMap;
    }

    private HashMap getAccessContext(HashMap hashMap, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessContext", new Object[]{hashMap, subject});
        }
        HashMap hashMap2 = hashMap;
        if (_isSAFAuthorization && subject != null && hashMap != null) {
            hashMap2 = (HashMap)hashMap.clone();
            hashMap2.put(SUBJECT_KEY, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessContext", hashMap2);
        }
        return hashMap2;
    }

    private String[] getRoleNamesFromRoles(SecurityRole[] securityRoleArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRoleNamesFromRoles", securityRoleArray);
        }
        String[] stringArray = securityRoleArray != null ? new String[securityRoleArray.length] : new String[]{};
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = securityRoleArray[i].getRoleName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoleNamesFromRoles", stringArray);
        }
        return stringArray;
    }
}

