/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.role.PluggableAuthorizationTableProxy;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfiguratorImpl;
import com.ibm.ws.security.role.RoleBasedModule;
import com.ibm.ws.security.role.RoleBasedSubjectMap;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import java.security.GeneralSecurityException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;

class RoleBasedAuthorizerImpl
implements RoleBasedAuthorizer {
    private static TraceComponent tc = Tr.register(RoleBasedAuthorizerImpl.class, "Security", "com.ibm.ejs.resources.security");
    private RoleBasedConfiguratorImpl configurator = null;
    private String appName = null;
    private String cellName = null;
    private String serverName = null;
    private HashMap accessContext = new HashMap(3);
    private PluggableAuthorizationTableProxy pluggableAuthTable = null;
    private boolean isSAFAuthz = false;
    private boolean _handleAllAuthz = false;
    private boolean _alreadyAttempted = false;
    private static boolean ignoreCase = false;
    private static final ContextManager contextManager = ContextManagerFactory.getInstance();
    private boolean staticsInitialized = false;
    private static AuditHandlerImpl auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;
    private static String providerName = "WebSphere";
    private static final boolean providerSuccess = true;

    public RoleBasedAuthorizerImpl(String string, RoleBasedConfiguratorImpl roleBasedConfiguratorImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{string, roleBasedConfiguratorImpl});
        }
        this.appName = string;
        this.configurator = roleBasedConfiguratorImpl;
        this.pluggableAuthTable = PluggableAuthorizationTableProxy.getAuthorizationTableProxy();
        if (this.pluggableAuthTable != null) {
            this.cellName = (String)SecurityConfig.getConfig().getValue("cellname");
            this.serverName = (String)SecurityConfig.getConfig().getValue("shortservername");
            this.accessContext.put("APPLICATION_NAME", this.appName);
            this.accessContext.put("SERVER_NAME", this.serverName);
            this.accessContext.put("CELL_NAME", this.cellName);
            providerName = "AuthorizationTable";
            this.isSAFAuthz = PluggableAuthorizationTableProxy.isSAFAuthorizationEnabled();
        }
        if (!this.staticsInitialized) {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
            if (bl != null && bl.booleanValue()) {
                ignoreCase = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ignoreCase is set");
                }
            }
            try {
                AuditServiceImpl auditServiceImpl = (AuditServiceImpl)AuditServiceImpl.getAuditService();
                if (auditServiceImpl != null) {
                    Class<?> clazz;
                    auditHandler = (AuditHandlerImpl)auditServiceImpl.newAuditHandler("WAS.security", "WAS.security");
                    if (auditHandler != null) {
                        auditFactory = (J2EEAuditEventFactory)auditHandler.getAuditEventFactory("J2EE");
                    }
                    if (auditFactory != null && !(clazz = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory")).isInstance(auditFactory)) {
                        auditFactory = null;
                    }
                }
                if (auditHandler != null) {
                    auditHandler.setAppName(this.appName);
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "security.wsaccessmanager.classnotfound", new Object[]{"J2EEAuditEventFactory"});
            }
            this.staticsInitialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean checkAccess(String string, String string2, String string3) {
        boolean bl;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkAccess", new Object[]{string, string2, string3});
            }
            bl = false;
            try {
                String[] stringArray;
                Object object;
                int n;
                String[] stringArray2;
                CredHolder credHolder = null;
                RoleBasedSubjectMap roleBasedSubjectMap = this.configurator.getRoleBasedSubjectMap(this.appName);
                RoleBasedModule roleBasedModule = this.configurator.getRoleBasedModule(this.appName, string);
                if (roleBasedModule == null && this.appName.startsWith("admin-authz")) {
                    roleBasedModule = this.configurator.getRoleBasedModule("admin-authz", string);
                }
                HashSet hashSet = roleBasedModule != null ? roleBasedModule.getRequiredRoles(string2 + ":" + string3) : null;
                HashSet<String> hashSet2 = new HashSet<String>();
                String[] stringArray3 = stringArray2 = hashSet != null ? hashSet.toArray(new String[0]) : new String[]{};
                if (this.appName.startsWith("admin-authz")) {
                    for (n = 0; n < stringArray2.length; ++n) {
                        object = AdminAuthorizerFactory.getAdminAuthorizer();
                        if (object != null) {
                            stringArray = object.getAllParentRoles(stringArray2[n]);
                            hashSet2.add(stringArray2[n]);
                            hashSet2.addAll((Collection<String>)stringArray);
                            continue;
                        }
                        hashSet2.add(stringArray2[n]);
                    }
                } else {
                    for (n = 0; n < stringArray2.length; ++n) {
                        hashSet2.add(stringArray2[n]);
                    }
                }
                if (this.isEveryoneGranted(hashSet2, roleBasedSubjectMap)) {
                    bl = true;
                } else {
                    credHolder = this.getEffectiveCredentials();
                    if (credHolder.isThreadMissingCredentials() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invocation and received credentials are both null.", new Object[]{string3, string2, string});
                    }
                    if (this.pluggableAuthTable != null && (this.handleAllAuthz() || !contextManager.isInternalServerCredential(credHolder.cred))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "calling " + this.pluggableAuthTable + " for authorization decision");
                        }
                        bl = this.checkAccess(hashSet2, string, string2, string3, credHolder);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "calling default authz engine for authorization decision");
                        }
                        bl = this.checkAccess(hashSet2, string, string2, string3, credHolder, roleBasedSubjectMap);
                    }
                }
                if (!bl) {
                    String string4 = this.getAccessId(credHolder.cred);
                    object = this.getSecurityName(credHolder.cred);
                    stringArray = hashSet2 != null ? hashSet2.toArray(new String[0]) : new String[]{};
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == 0) {
                            stringBuffer.append(stringArray[i]);
                            continue;
                        }
                        stringBuffer.append(", ").append(stringArray[i]);
                    }
                    Tr.audit(tc, "security.rolebauthz.authzfail", new Object[]{this.appName, string2, string3, object, string4, stringBuffer.toString()});
                }
            }
            catch (RoleBasedAppException roleBasedAppException) {
                FFDCFilter.processException((Throwable)roleBasedAppException, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", "324", this);
                if (!tc.isDebugEnabled()) break block20;
                Tr.debug(tc, "Unable to acquire role info", roleBasedAppException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(bl));
        }
        return bl;
    }

    private boolean checkAccess(Set set, String string, String string2, String string3, CredHolder credHolder) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", new Object[]{set, string, string2, string3, credHolder});
        }
        boolean bl = false;
        Exception exception = null;
        try {
            String[] stringArray = set == null ? new String[]{} : set.toArray(new String[0]);
            bl = this.pluggableAuthTable.isGrantedAnyRole(this.accessContext, stringArray, credHolder.subject);
        }
        catch (Exception exception2) {
            FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", "357", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception caught: ", exception2);
            }
            Exception exception3 = exception = exception2 instanceof Exception ? exception2 : null;
        }
        if (auditFactory != null && auditFactory.isActive(1, 0) && bl) {
            auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", "", null, string2, "WAS", string3, providerName, true, credHolder.subject, "security.audit.authz.success.audit", null);
        }
        if (auditFactory != null && auditFactory.isActive(1, 4) && !bl) {
            auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", "", exception, string2, "WAS", string3, providerName, true, credHolder.subject, "security.audit.authz.denied.audit", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(bl));
        }
        return bl;
    }

    private boolean checkAccess(Set set, String string, String string2, String string3, CredHolder credHolder, RoleBasedSubjectMap roleBasedSubjectMap) {
        Exception exception;
        boolean bl;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkAccess", new Object[]{set, string, string2, string3, credHolder, roleBasedSubjectMap});
            }
            bl = false;
            exception = null;
            try {
                if (roleBasedSubjectMap.isGrantedAnyRole(credHolder.cred, set)) {
                    bl = true;
                } else if (this.isGroupGrantedAnyRole(set, roleBasedSubjectMap, credHolder.cred)) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", "413", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Unexpected exception caught: ", throwable);
            }
        }
        if (auditFactory != null && auditFactory.isActive(1, 0) && bl) {
            auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", "", null, string2, "WAS", string3, providerName, true, credHolder.subject, "security.audit.authz.success.audit", null);
        }
        if (auditFactory != null && auditFactory.isActive(1, 4) && !bl) {
            auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", "", exception, string2, "WAS", string3, providerName, true, credHolder.subject, "security.audit.authz.denied.audit", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(bl));
        }
        return bl;
    }

    private boolean isEveryoneGranted(Set set, RoleBasedSubjectMap roleBasedSubjectMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted", new Object[]{set, roleBasedSubjectMap});
        }
        boolean bl = false;
        if (this.pluggableAuthTable == null || set == null || set.size() == 0) {
            bl = roleBasedSubjectMap.isEveryoneGranted(set);
        } else {
            String[] stringArray = set == null ? new String[]{} : set.toArray(new String[0]);
            bl = this.pluggableAuthTable.isEveryoneGranted(this.accessContext, stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted", new Boolean(bl));
        }
        return bl;
    }

    private boolean isGroupGrantedAnyRole(Set set, RoleBasedSubjectMap roleBasedSubjectMap, WSCredential wSCredential) {
        ArrayList arrayList;
        boolean bl;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isGroupGrantedAnyRole", new Object[]{set, roleBasedSubjectMap, wSCredential});
            }
            bl = false;
            arrayList = null;
            try {
                arrayList = wSCredential.getGroupIds();
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isCallerInRole", "492", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception getting group IDs", generalSecurityException);
            }
        }
        String[] stringArray = arrayList == null ? new String[]{} : arrayList.toArray(new String[arrayList.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (ignoreCase) {
                stringArray[i] = stringArray[i].toLowerCase();
            }
            if (!roleBasedSubjectMap.isGroupGrantedAnyRole(stringArray[i], set)) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGroupGrantedAnyRole", new Boolean(bl));
        }
        return bl;
    }

    public boolean isCallerInRole(String string) {
        Object object;
        Object object2;
        CredHolder credHolder;
        boolean bl;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isCallerInRole", string);
            }
            bl = false;
            if (string == null) {
                Tr.error(tc, "security.roleref.configerror", new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isCallerInRole", new Boolean(bl));
                }
                return bl;
            }
            credHolder = this.getEffectiveCredentials();
            if (credHolder.isThreadMissingCredentials()) {
                object2 = new Exception("Invocation and received credentials are both null");
                Tr.error(tc, "security.rolebauthz.nocred2", new Object[]{string, object2});
            }
            try {
                if (this.pluggableAuthTable != null && (this.handleAllAuthz() || !contextManager.isInternalServerCredential(credHolder.cred))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling " + this.pluggableAuthTable + " for authorization decision");
                    }
                    bl = this.pluggableAuthTable.isGrantedRole(this.accessContext, string, credHolder.subject);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling default authz engine for authorization decision");
                    }
                    object = this.configurator.getRoleBasedSubjectMap(this.appName);
                    object2 = new HashSet(1);
                    ((HashSet)object2).add(string);
                    if (((RoleBasedSubjectMap)object).isGrantedAnyRole(credHolder.cred, (Set)object2)) {
                        bl = true;
                    } else if (this.isGroupGrantedAnyRole((Set)object2, (RoleBasedSubjectMap)object, credHolder.cred)) {
                        bl = true;
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isCallerInRole", "576", this);
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Unexpected exception caught: ", throwable);
            }
        }
        if (!bl && tc.isDebugEnabled()) {
            object = this.getSecurityName(credHolder.cred);
            object2 = this.getAccessId(credHolder.cred);
            Tr.debug(tc, "SECJ0321E: Role based authorization is caller in role  failed for security name: " + (String)object + " accessID: " + (String)object2 + " and role name: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerInRole", new Boolean(bl));
        }
        return bl;
    }

    private CredHolder getEffectiveCredentials() {
        CredHolder credHolder;
        boolean bl;
        block18: {
            WSCredential wSCredential;
            Subject subject;
            WSCredential wSCredential2;
            WSCredential wSCredential3;
            Subject subject2;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getEffectiveCredentials");
                }
                subject2 = null;
                wSCredential3 = null;
                bl = false;
                Subject subject3 = null;
                wSCredential2 = null;
                subject = null;
                wSCredential = null;
                try {
                    subject3 = contextManager.getInvocationSubject();
                    wSCredential2 = SubjectHelper.getWSCredentialFromSubject(subject3);
                    if (wSCredential2 != null && !wSCredential2.isUnauthenticated()) {
                        subject2 = subject3;
                        wSCredential3 = wSCredential2;
                    }
                    if (wSCredential3 == null && (wSCredential = SubjectHelper.getWSCredentialFromSubject(subject = contextManager.getCallerSubject())) != null && !wSCredential.isUnauthenticated()) {
                        subject2 = subject;
                        wSCredential3 = wSCredential;
                    }
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.getEffectiveCredentials", "653", this);
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Exception getting invocation credential", wSSecurityException);
                }
            }
            if (wSCredential2 == null && wSCredential == null) {
                bl = true;
            }
            if (wSCredential2 != null && wSCredential2.isUnauthenticated() && wSCredential != null && wSCredential.isUnauthenticated()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invocation and received creds are UNAUTHENTICATED!");
                }
                subject2 = subject;
                wSCredential3 = wSCredential;
            }
            if (wSCredential3 != null && !wSCredential3.isUnauthenticated() && wSCredential3.isBasicAuth()) {
                try {
                    wSCredential3 = contextManager.authenticate(wSCredential3);
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl", "689", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during authentication", wSSecurityException);
                    }
                    wSCredential3 = null;
                }
            }
            credHolder = new CredHolder(subject2, wSCredential3, bl);
            if (credHolder.cred == null) {
                try {
                    credHolder.subject = contextManager.createUnauthenticatedSubject();
                    credHolder.cred = contextManager.getUnauthenticatedCredential();
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl", "706", this);
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Exception getting unauthenticated cred", wSSecurityException);
                }
            }
        }
        if ((credHolder.cred.isUnauthenticated() || bl) && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unauthenticated or missing subject/credentials.", new Exception("Unauthenticated or missing subject/credentials."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveCredentials", credHolder);
        }
        return credHolder;
    }

    public boolean isGrantedRole(String[] stringArray, Subject subject) {
        Object object;
        Object object2;
        Exception exception;
        WSCredential wSCredential;
        boolean bl;
        block26: {
            bl = false;
            wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            exception = null;
            if (wSCredential != null && wSCredential.isBasicAuth()) {
                try {
                    wSCredential = contextManager.authenticate(wSCredential);
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl", "742", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during authentication", wSSecurityException);
                    }
                    wSCredential = null;
                }
            }
            if (wSCredential == null) {
                try {
                    subject = contextManager.createUnauthenticatedSubject();
                    wSCredential = contextManager.getUnauthenticatedCredential();
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl", "757", this);
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug(tc, "Exception getting unauthenticated cred", wSSecurityException);
                }
            }
        }
        try {
            int n;
            object2 = new LinkedHashSet<String>();
            if (this.appName.startsWith("admin-authz")) {
                for (n = 0; n < stringArray.length; ++n) {
                    object = AdminAuthorizerFactory.getAdminAuthorizer();
                    if (object != null) {
                        List list = object.getAllParentRoles(stringArray[n]);
                        ((HashSet)object2).add(stringArray[n]);
                        ((AbstractCollection)object2).addAll(list);
                        continue;
                    }
                    ((HashSet)object2).add(stringArray[n]);
                }
            } else {
                for (n = 0; n < stringArray.length; ++n) {
                    ((HashSet)object2).add(stringArray[n]);
                }
            }
            if (this.pluggableAuthTable != null && (this.handleAllAuthz() || !contextManager.isInternalServerCredential(wSCredential))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling " + this.pluggableAuthTable + " for authorization decision");
                }
                stringArray = ((HashSet)object2).toArray(new String[0]);
                bl = this.pluggableAuthTable.isGrantedAnyRole(this.accessContext, stringArray, subject);
            } else {
                RoleBasedSubjectMap roleBasedSubjectMap;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling default authz engine for authorization decision");
                }
                if ((roleBasedSubjectMap = this.configurator.getRoleBasedSubjectMap(this.appName)).isGrantedAnyRole(wSCredential, (Set)object2)) {
                    bl = true;
                } else if (this.isGroupGrantedAnyRole((Set)object2, roleBasedSubjectMap, wSCredential)) {
                    bl = true;
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isGrantedRole", "806", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception caught", throwable);
            }
            Exception exception2 = exception = throwable instanceof Exception ? (Exception)throwable : null;
        }
        if (auditFactory != null && auditFactory.isActive(1, 0) && bl) {
            auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", "", null, null, "WAS", "isGrantedRole", providerName, true, subject, "security.audit.authz.success.audit", new Object[]{stringArray[0]});
        }
        if (auditFactory != null && auditFactory.isActive(1, 4) && !bl) {
            auditFactory.sendAuthzAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", "", exception, null, "WAS", "isGrantedRole", providerName, true, subject, "security.audit.authz.denied.audit", new Object[]{stringArray[0]});
        }
        if (!bl && tc.isDebugEnabled()) {
            object2 = stringArray[stringArray.length - 1];
            String string = this.getSecurityName(wSCredential);
            object = this.getAccessId(wSCredential);
            Tr.debug(tc, "security.rolebauthz.iscallerinrolefail", new Object[]{string, object, object2});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole, result:" + bl);
        }
        return bl;
    }

    private String getAccessId(WSCredential wSCredential) {
        String string;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAccessId", wSCredential);
            }
            string = null;
            try {
                if (wSCredential != null) {
                    string = wSCredential.getAccessId();
                    if (ignoreCase) {
                        string = string.toLowerCase();
                    }
                } else {
                    string = "NO_CRED_NO_ACCESS_ID";
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.getAccessId", "858", this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Unexpected exception getting accessId", generalSecurityException);
            }
        }
        if (string == null) {
            string = "NULL_ACCESS_ID";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessId", string);
        }
        return string;
    }

    private String getSecurityName(WSCredential wSCredential) {
        String string;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSecurityName", wSCredential);
            }
            string = null;
            try {
                if (wSCredential != null) {
                    string = wSCredential.getSecurityName();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.getAccessId", "885", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Unexpected exception getting securityName", generalSecurityException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName", string);
        }
        return string;
    }

    public boolean isGrantedAnyRole(String[] stringArray) {
        Object object;
        Object object2;
        CredHolder credHolder;
        boolean bl;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isGrantedAnyRole", stringArray);
            }
            bl = false;
            if (stringArray == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGrantedAnyRole", new Boolean(bl));
                }
                return bl;
            }
            credHolder = this.getEffectiveCredentials();
            if (credHolder.isThreadMissingCredentials()) {
                object2 = new Exception("Invocation and received credentials are both null");
                Tr.error(tc, "security.rolebauthz.nocred2", new Object[]{stringArray[0], object2});
            }
            try {
                if (this.pluggableAuthTable != null && (this.handleAllAuthz() || !contextManager.isInternalServerCredential(credHolder.cred))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling " + this.pluggableAuthTable + " for authorization decision");
                    }
                    bl = this.pluggableAuthTable.isGrantedAnyRole(this.accessContext, stringArray, credHolder.subject);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling default authz engine for authorization decision");
                    }
                    object = this.configurator.getRoleBasedSubjectMap(this.appName);
                    object2 = new HashSet();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ((HashSet)object2).add(stringArray[i]);
                    }
                    if (((RoleBasedSubjectMap)object).isGrantedAnyRole(credHolder.cred, (Set)object2)) {
                        bl = true;
                    } else if (this.isGroupGrantedAnyRole((Set)object2, (RoleBasedSubjectMap)object, credHolder.cred)) {
                        bl = true;
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isCallerInRole", "531", this);
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug(tc, "Unexpected exception caught: ", throwable);
            }
        }
        if (!bl && tc.isDebugEnabled()) {
            object = this.getSecurityName(credHolder.cred);
            object2 = this.getAccessId(credHolder.cred);
            String string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string = string + ":" + stringArray[i];
            }
            Tr.debug(tc, "SECJ0321E: Role based authorization is caller in role  failed for security name: " + (String)object + " accessID: " + (String)object2 + " and role name: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(bl));
        }
        return bl;
    }

    boolean handleAllAuthz() {
        if (this._alreadyAttempted) {
            return this._handleAllAuthz;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleAllAuthz");
        }
        if (SecurityConfig.isUseRegistryServerId()) {
            this._handleAllAuthz = true;
        } else if (this.isSAFAuthz) {
            this._handleAllAuthz = true;
        } else {
            Properties properties = (Properties)SecurityConfig.getConfig().getValue("security.toplevel.properties");
            String string = (String)properties.get("com.ibm.websphere.security.handleAllAuthorizations");
            if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
                this._handleAllAuthz = true;
            }
        }
        this._alreadyAttempted = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleAllAuthz", new Boolean(this._handleAllAuthz));
        }
        return this._handleAllAuthz;
    }

    private static final class CredHolder {
        WSCredential cred = null;
        Subject subject = null;
        boolean threadMissingCredentials = false;

        CredHolder(Subject subject, WSCredential wSCredential, boolean bl) {
            this.subject = subject;
            this.cred = wSCredential;
            this.threadMissingCredentials = bl;
        }

        public boolean isThreadMissingCredentials() {
            return this.threadMissingCredentials;
        }

        public String toString() {
            return super.toString() + ";cred=" + this.cred + ";subject=" + this.subject + ";threadMissingCredentials=" + this.threadMissingCredentials;
        }
    }
}

