/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorNullImpl;

public class RoleBasedConfiguratorFactory {
    private static TraceComponent tc = Tr.register(RoleBasedConfiguratorFactory.class, null, "com.ibm.ejs.resources.security");
    private static RoleBasedConfigurator configurator = null;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("getRoleBasedConfigurator");

    public static RoleBasedConfigurator getConfigurator(boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + perm.toString());
            }
            securityManager.checkPermission(perm);
        }
        if (configurator == null) {
            try {
                configurator = !bl ? new RoleBasedConfiguratorNullImpl() : (RoleBasedConfigurator)Class.forName("com.ibm.ws.security.role.RoleBasedConfiguratorImpl").newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.role.RoleBasedConfiguratorFactory.getConfigurator", "99");
                Tr.error(tc, "security.role.config.get", new Object[]{exception});
            }
        }
        return configurator;
    }

    public static RoleBasedConfigurator getConfigurator() throws RoleBasedAppException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + perm.toString());
            }
            securityManager.checkPermission(perm);
        }
        if (configurator == null) {
            throw new RoleBasedAppException("RoleBasedConfigurator was not initialized properly");
        }
        return configurator;
    }
}

