/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.rolebasedauthz.AllAuthenticatedUsersExt;
import com.ibm.websphere.models.config.rolebasedauthz.EveryoneExt;
import com.ibm.websphere.models.config.rolebasedauthz.PrimaryAdminExt;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.ServerExt;
import com.ibm.websphere.models.config.rolebasedauthz.SpecialSubjectExt;
import com.ibm.websphere.models.config.rolebasedauthz.SubjectExt;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class RoleBasedSubjectMap {
    private static TraceComponent tc = Tr.register(RoleBasedSubjectMap.class);
    public static final String NO_CRED = "NO_CRED_NO_ACCESS_ID";
    public static final String NULL_ACCESS_ID = "NULL_ACCESS_ID";
    private HashSet[] roles = null;
    private HashMap subjects = new HashMap();
    private HashMap subjectGroups = new HashMap();
    private String name = null;
    private static boolean defaultAccess = true;
    private String serverId = null;
    private String longServerId = null;
    private String adminAccessId = null;
    private static boolean ignoreCase = false;
    private HashMap roleMap = null;
    private static final ContextManager contextManager;

    RoleBasedSubjectMap(String string, List list, String string2, String string3) {
        this.name = string;
        this.serverId = string2;
        this.longServerId = string3;
        int n = list.size();
        this.roleMap = new HashMap(n);
        if (n == 0) {
            return;
        }
        String[] stringArray = new String[n];
        int[] nArray = new int[n - 1];
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2++] = new String(((SecurityRoleExt)iterator.next()).getRoleName());
            Role role2 = new Role();
            this.roleMap.put(stringArray[n2 - 1], role2);
        }
        this.roles = new HashSet[1];
        this.roles[0] = new HashSet(1);
        for (int i = 0; i < n; ++i) {
            this.roles[0].add(stringArray[i]);
        }
    }

    public void addSpecialSubjects(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSpecialSubjects: " + string);
        }
        if (list == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list null");
            }
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SpecialSubjectExt specialSubjectExt = (SpecialSubjectExt)iterator.next();
            if (specialSubjectExt instanceof EveryoneExt) {
                ((Role)this.roleMap.get(string)).everyoneAllowed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added EveryoneExt");
                continue;
            }
            if (specialSubjectExt instanceof AllAuthenticatedUsersExt) {
                ((Role)this.roleMap.get(string)).allAuthenAllowed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added AllAuthenticatedUsersExt");
                continue;
            }
            if (specialSubjectExt instanceof ServerExt) {
                ((Role)this.roleMap.get(string)).serverAllowed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added ServerExt");
                continue;
            }
            if (!(specialSubjectExt instanceof PrimaryAdminExt)) continue;
            ((Role)this.roleMap.get(string)).adminAllowed = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "added PrimaryAdminExt");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSpecialSubjects: " + string);
        }
    }

    public boolean isEveryoneGranted(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted");
        }
        if (set == null || set.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredRoles null, access allowed ? " + defaultAccess);
            }
            return defaultAccess;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Role role2 = (Role)this.roleMap.get(iterator.next());
            if (role2 == null || !role2.everyoneAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "everyone allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted");
        }
        return false;
    }

    public boolean isAllAuthenticatedUsersGranted(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllAuthenticatedUsersGanted");
        }
        if (set == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredRoles null, access allowed? " + defaultAccess);
            }
            return defaultAccess;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Role role2 = (Role)this.roleMap.get(iterator.next());
            if (role2 == null || !role2.allAuthenAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "all authenticated users allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAllAuthenticatedUsersGanted");
        }
        return false;
    }

    public boolean isServerGranted(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerGranted");
        }
        if (set == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredRoles null, access allowed? " + defaultAccess);
            }
            return defaultAccess;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Role role2 = (Role)this.roleMap.get(iterator.next());
            if (role2 == null || !role2.serverAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerGranted");
        }
        return false;
    }

    public boolean isAdminGranted(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAdminGranted");
        }
        if (set == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredRoles null, access allowed? " + defaultAccess);
            }
            return defaultAccess;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Role role2 = (Role)this.roleMap.get(iterator.next());
            if (role2 == null || !role2.adminAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminID allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAdminGranted");
        }
        return false;
    }

    public void addSubjects(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSubjects: " + string);
        }
        if (list == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list null");
            }
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HashSet hashSet;
            SubjectExt subjectExt = (SubjectExt)iterator.next();
            String string2 = subjectExt.getAccessId();
            if (string2 != null && ignoreCase) {
                string2 = string2.toLowerCase();
            }
            if (!this.subjects.containsKey(string2)) {
                hashSet = new HashSet(1);
                hashSet.add(string);
                this.subjects.put(string2, hashSet);
                continue;
            }
            hashSet = (HashSet)this.subjects.get(string2);
            hashSet.add(string);
            this.subjects.put(string2, hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSubjects: " + string);
        }
    }

    public void addSubjectGroups(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSubjectGroups: " + string);
        }
        if (list == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list null");
            }
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HashSet hashSet;
            SubjectExt subjectExt = (SubjectExt)iterator.next();
            String string2 = subjectExt.getAccessId();
            if (string2 != null && ignoreCase) {
                string2 = string2.toLowerCase();
            }
            if (!this.subjectGroups.containsKey(string2)) {
                hashSet = new HashSet(1);
                hashSet.add(string);
                this.subjectGroups.put(string2, hashSet);
                continue;
            }
            hashSet = (HashSet)this.subjectGroups.get(string2);
            hashSet.add(string);
            this.subjectGroups.put(string2, hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSubjectGroups: " + string);
        }
    }

    public void pack() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pack");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pack subjects");
        }
        this.packMap(this.subjects);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pack subjectGroups");
        }
        this.packMap(this.subjectGroups);
        this.roles = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pack");
        }
    }

    private void packMap(HashMap hashMap) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "packMap");
        }
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            HashSet hashSet = (HashSet)hashMap.get(string);
            boolean bl = false;
            for (int i = 0; !bl && i < this.roles.length; ++i) {
                if (!hashSet.equals(this.roles[i])) continue;
                bl = true;
                hashMap.put(string, this.roles[i]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dump hm");
            set = hashMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                Tr.debug(tc, "subjectName: " + string + " roles: " + hashMap.get(string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "packMap");
        }
    }

    private boolean isAdminId(WSCredential wSCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAdminId" + wSCredential);
        }
        try {
            String string;
            if (this.adminAccessId == null) {
                if (wSCredential == null || wSCredential.isBasicAuth() || wSCredential.isUnauthenticated()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isAdminId returning falsesince the WSCredential is null or basicAuth or Unaauthenticated.");
                    }
                    return false;
                }
                string = (String)SecurityConfig.getConfig().getValue("security.primaryAdminId");
                if (string != null) {
                    UserRegistry userRegistry = contextManager.getRegistry(contextManager.getDefaultRealm());
                    this.adminAccessId = userRegistry.getUniqueUserId(string);
                }
            }
            string = wSCredential.getAccessId();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminAccessId: " + this.adminAccessId + " accessId: " + string);
            }
            if (string == null || this.adminAccessId == null) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "isAdminId returning false: accessid is null");
                }
                return false;
            }
            if (ignoreCase) {
                string = string.toLowerCase();
                this.adminAccessId = this.adminAccessId.toLowerCase();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ignoreCase set: adminAccessId: " + this.adminAccessId + " accessId: " + string);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isAdminId returning " + string.equals(this.adminAccessId));
            }
            return string.equals(this.adminAccessId);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.role.RoleBasedSubjectMap.isAdminId", "359", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in isAdminId: ", new Object[]{exception.getMessage()});
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isAdminId returning false");
            }
            return false;
        }
    }

    private boolean isServerId(WSCredential wSCredential) {
        try {
            if (wSCredential != null && wSCredential.isBasicAuth() && !wSCredential.isUnauthenticated()) {
                String string = (String)SecurityConfig.getConfig().getValue("security.serverId");
                String string2 = (String)SecurityConfig.getConfig().getValue("security.serverPasswd");
                String string3 = wSCredential.getSecurityName();
                byte[] byArray = wSCredential.getCredentialToken();
                String string4 = null;
                if (byArray != null) {
                    string4 = StringBytesConversion.getConvertedString(byArray);
                }
                if (byArray == null || string3 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning false, either WSCredential ID or password is null.");
                    }
                    return false;
                }
                if (string.equals(string3) && string2.equals(string4)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Valid BasicAuth server ID.");
                    }
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not valid BasicAuth server ID: " + string3);
                }
                return false;
            }
            if (wSCredential != null && wSCredential.isUnauthenticated()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unauthenticated cred is not server ID.");
                }
                return false;
            }
            if (wSCredential != null) {
                String string;
                String string5 = wSCredential.getAccessId();
                if (string5 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isServerId? false, accessid is null");
                    }
                    return false;
                }
                if (ignoreCase) {
                    string5 = string5.toLowerCase();
                }
                if ((string = (String)SecurityConfig.getConfig().getValue("security.unexpandedServerId")) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking to determine if serverID is from the same cell.");
                    }
                    return this.isServerIdFromCell(wSCredential, string5, this.serverId, this.longServerId);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "accessId: " + string5 + " serverId: " + this.serverId + " longServerId: " + this.longServerId);
                }
                if (!SecurityConfig.isUseRegistryServerId() && contextManager.isInternalServerCredential(wSCredential)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isServerId? - server credential. Returning true");
                    }
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isServerId? " + (string5.equals(this.serverId) || string5.equals(this.longServerId)));
                }
                return string5.equals(this.serverId) || string5.equals(this.longServerId);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSCredential is null, returning false.");
            }
            return false;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.role.RoleBasedSubjectMap.isServerId", "361", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in isServerId: ", new Object[]{exception.getMessage()});
            }
            return false;
        }
    }

    public boolean isServerIdFromCell(WSCredential wSCredential, String string, String string2, String string3) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerIdFromCell", new Object[]{string, string2, string3});
        }
        boolean bl2 = bl = string.equals(string2) || string.equals(string3);
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning true, server ID is from this node.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isServerIdFromCell");
            }
            return true;
        }
        TreeSet treeSet = (TreeSet)SecurityConfig.getConfig().getValue("security.serverNameList");
        String string4 = null;
        try {
            string4 = wSCredential.getSecurityName().toLowerCase();
            int n = string4.indexOf("@");
            if (n != -1) {
                string4 = string4.substring(0, n);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting security name from WSCredential.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.role.RoleBasedSubjectMap.isServerIdFromCell", "404", this);
        }
        if (treeSet != null && (treeSet.contains(string.toLowerCase()) || string4 != null && treeSet.contains(string4))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning true, server ID is from this cell.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isServerIdFromCell");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerIdFromCell (false)");
        }
        return false;
    }

    public boolean isGrantedAnyRole(WSCredential wSCredential, Set set) {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isGrantedAnyRole");
            }
            try {
                if (set == null || set.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isGrantedAnyRole: requiredRoles null, access allowed? " + defaultAccess);
                    }
                    return defaultAccess;
                }
                String string = wSCredential.getAccessId();
                if (ignoreCase) {
                    string = string.toLowerCase();
                }
                if (string != null && !string.equalsIgnoreCase(ContextManagerFactory.getInstance().getUnauthenticatedString()) && !string.equalsIgnoreCase(NO_CRED) && !string.equalsIgnoreCase(NULL_ACCESS_ID) && (this.isAllAuthenticatedUsersGranted(set) || this.isServerGranted(set) && this.isServerId(wSCredential))) {
                    return true;
                }
                if (this.isAdminGranted(set) && this.isAdminId(wSCredential)) {
                    return true;
                }
                Set set2 = (Set)this.subjects.get(string);
                if (set2 == null || set2.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isGrantedAnyRole: grantedRoles null, access denied");
                    }
                    return false;
                }
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    Iterator iterator2 = set.iterator();
                    String string2 = (String)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isGrantedAnyRole: grantedRolesName = " + string2);
                    }
                    while (iterator2.hasNext()) {
                        if (!string2.equals((String)iterator2.next())) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "isGrantedAnyRole: access granted");
                        }
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.role.RoleBasedSubjectMap.isGrantedAnyRole", "467", this);
                if (!tc.isDebugEnabled()) break block15;
                Tr.debug(tc, "Exception in isGrantedAnyRole: ", new Object[]{exception.getMessage()});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isGrantedAnyRole: access denied");
        }
        return false;
    }

    public boolean isGroupGrantedAnyRole(String string, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGroupGrantedAnyRole");
        }
        if (set == null || set.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isGroupGrantedAnyRole: requiredRoles null, access allowed? " + defaultAccess);
            }
            return defaultAccess;
        }
        Set set2 = (Set)this.subjectGroups.get(string);
        if (set2 == null || set2.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isGroupGrantedAnyRole: grantedRoles null, access denied");
            }
            return false;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = set.iterator();
            String string2 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isiGroupGrantedAnyRole: grantedRolesName = " + string2);
            }
            while (iterator2.hasNext()) {
                if (!string2.equals((String)iterator2.next())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isGroupGrantedAnyRole: access granted");
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isGroupGrantedAnyRole: access denied");
        }
        return false;
    }

    protected String getSubjectMapName() {
        return this.name;
    }

    protected HashMap getSubjectMap() {
        return this.subjects;
    }

    protected HashSet[] getSecurityRoles() {
        return this.roles;
    }

    static {
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
        if (bl != null && bl.booleanValue()) {
            ignoreCase = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ignoreCase is set");
            }
        }
        contextManager = ContextManagerFactory.getInstance();
    }

    class Role {
        private boolean everyoneAllowed = false;
        private boolean allAuthenAllowed = false;
        private boolean serverAllowed = false;
        private boolean adminAllowed = false;

        Role() {
        }
    }
}

